/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.apache.spark.storage.BlockInfoManager$;
import org.apache.spark.storage.BlockInfoWrapper;
import org.apache.spark.storage.RDDBlockId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import org.sparkproject.guava.util.concurrent.Striped;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tub!\u0002\u0014(\u0001\u001dz\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b\u0005\u0003A\u0011\u0001\"\u0006\t\u0019\u0003Aa\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0011B&\t\rm\u0003\u0001\u0015!\u0003]\u0011\u00199\u0007\u0001)A\u0005Q\"1\u0011\u0010\u0001Q\u0001\niD\u0001\"a\u0001\u0001A\u0003%\u0011Q\u0001\u0005\t\u0003'\u0001A\u0011A\u0014\u0002\u0016!A\u00111\u0004\u0001\u0005\u0002%\ni\u0002\u0003\u0005\u0002\"\u0001!\t!KA\u0012\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005\"CAI\u0001E\u0005I\u0011AAJ\u0011\u001d\tI\u000b\u0001C\u0001\u0003WC\u0011\"!-\u0001#\u0003%\t!a%\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"A\u0011\u0011\u0018\u0001\u0005\u0002\u001d\nY\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"I\u0011\u0011\u001b\u0001\u0012\u0002\u0013\u0005\u00111\u001b\u0005\b\u0003/\u0004A\u0011AAm\u0011%\t)\u000fAI\u0001\n\u0003\t\u0019\nC\u0004\u0002h\u0002!\t!!;\t\u0011\t\u0015\u0001\u0001\"\u0001(\u0005\u000fAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002\u0003\u0005\u0003\u0016\u0001!\ta\nB\f\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u00030\u0001!\tA!\r\b\u0015\tMr%!A\t\u0002\u001d\u0012)DB\u0005'O\u0005\u0005\t\u0012A\u0014\u00038!1\u0011i\tC\u0001\u0005sA\u0011Ba\u000f$#\u0003%\t!a%\u0003!\tcwnY6J]\u001a|W*\u00198bO\u0016\u0014(B\u0001\u0015*\u0003\u001d\u0019Ho\u001c:bO\u0016T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\n\u0004\u0001A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00028u5\t\u0001H\u0003\u0002:S\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002<q\t9Aj\\4hS:<\u0017a\u0006;sC\u000e\\\u0017N\\4DC\u000eDWMV5tS\nLG.\u001b;z\u0007\u0001\u0001\"!M \n\u0005\u0001\u0013$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r+\u0005C\u0001#\u0001\u001b\u00059\u0003b\u0002\u001f\u0003!\u0003\u0005\rA\u0010\u0002\u000e)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0011\u0005EB\u0015BA%3\u0005\u0011auN\\4\u0002#\tdwnY6J]\u001a|wK]1qa\u0016\u00148\u000f\u0005\u0003M'VCV\"A'\u000b\u00059{\u0015AC2p]\u000e,(O]3oi*\u0011\u0001+U\u0001\u0005kRLGNC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Qk%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011AIV\u0005\u0003/\u001e\u0012qA\u00117pG.LE\r\u0005\u0002E3&\u0011!l\n\u0002\u0011\u00052|7m[%oM><&/\u00199qKJ\f!#\u001b8wSNL'\r\\3S\t\u0012\u0013En\\2lgB\u0019QL\u00193\u000e\u0003yS!a\u00181\u0002\u000f5,H/\u00192mK*\u0011\u0011MM\u0001\u000bG>dG.Z2uS>t\u0017BA2_\u0005\u001dA\u0015m\u001d5TKR\u0004\"\u0001R3\n\u0005\u0019<#A\u0003*E\t\ncwnY6JI\u0006)An\\2lgB\u0019\u0011N\u001d;\u000e\u0003)T!AT6\u000b\u0005Ac'BA7o\u0003\u0019\u0019w.\\7p]*\u0011q\u000e]\u0001\u0007O>|w\r\\3\u000b\u0003E\f1aY8n\u0013\t\u0019(NA\u0004TiJL\u0007/\u001a3\u0011\u0005U<X\"\u0001<\u000b\u0005\u001dl\u0015B\u0001=w\u0005\u0011aunY6\u0002!]\u0014\u0018\u000e^3M_\u000e\\7OQ=UCN\\\u0007\u0003\u0002'Twv\u0004\"\u0001`\u0002\u000e\u0003\u0001\u00012A`@V\u001b\u0005y\u0015bAA\u0001\u001f\n\u00191+\u001a;\u0002\u001fI,\u0017\r\u001a'pG.\u001c()\u001f+bg.\u0004R\u0001T*|\u0003\u000f\u0001R!!\u0003\u0002\u0010Uk!!a\u0003\u000b\u0007\u00055A.A\u0004d_2dWm\u0019;\n\t\u0005E\u00111\u0002\u0002\u0017\u0007>t7-\u001e:sK:$\b*Y:i\u001bVdG/[:fi\u0006I2m\u001c8uC&t7/\u00138wSNL'\r\\3S\t\u0012\u0013En\\2l)\rq\u0014q\u0003\u0005\u0007\u00033I\u0001\u0019\u00013\u0002\u000f\tdwnY6JI\u0006\t\u0012n\u001d*E\t\ncwnY6WSNL'\r\\3\u0015\u0007y\ny\u0002\u0003\u0004\u0002\u001a)\u0001\r\u0001Z\u0001\u0016iJLX*\u0019:l\u00052|7m[!t-&\u001c\u0018N\u00197f)\u0011\t)#a\u000b\u0011\u0007E\n9#C\u0002\u0002*I\u0012A!\u00168ji\"1\u0011\u0011D\u0006A\u0002\u0011\fAB]3hSN$XM\u001d+bg.$B!!\n\u00022!1\u00111\u0007\u0007A\u0002m\fQ\u0002^1tW\u0006#H/Z7qi&#\u0017\u0001F2veJ,g\u000e\u001e+bg.\fE\u000f^3naRLE-F\u0001|\u0003-\t7-];je\u0016dunY6\u0015\r\u0005u\u0012QKA,)\u0011\ty$a\u0013\u0011\u000bE\n\t%!\u0012\n\u0007\u0005\r#G\u0001\u0004PaRLwN\u001c\t\u0004\t\u0006\u001d\u0013bAA%O\tI!\t\\8dW&sgm\u001c\u0005\b\u0003\u001br\u0001\u0019AA(\u0003\u00051\u0007CB\u0019\u0002R\u0005\u0015c(C\u0002\u0002TI\u0012\u0011BR;oGRLwN\\\u0019\t\r\u0005ea\u00021\u0001V\u0011\u0019\tIF\u0004a\u0001}\u0005A!\r\\8dW&tw-A\u0005cY>\u001c7.\u00138g_V!\u0011qLA4)\u0011\t\t'a\"\u0015\t\u0005\r\u0014\u0011\u0010\t\u0005\u0003K\n9\u0007\u0004\u0001\u0005\u000f\u0005%tB1\u0001\u0002l\t\tA+\u0005\u0003\u0002n\u0005M\u0004cA\u0019\u0002p%\u0019\u0011\u0011\u000f\u001a\u0003\u000f9{G\u000f[5oOB\u0019\u0011'!\u001e\n\u0007\u0005]$GA\u0002B]fDq!!\u0014\u0010\u0001\u0004\tY\bE\u00052\u0003{\n)%!!\u0002d%\u0019\u0011q\u0010\u001a\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA;\u0002\u0004&\u0019\u0011Q\u0011<\u0003\u0013\r{g\u000eZ5uS>t\u0007BBA\r\u001f\u0001\u0007Q+\u0001\bm_\u000e\\gi\u001c:SK\u0006$\u0017N\\4\u0015\r\u0005}\u0012QRAH\u0011\u0019\tI\u0002\u0005a\u0001+\"A\u0011\u0011\f\t\u0011\u0002\u0003\u0007a(\u0001\rm_\u000e\\gi\u001c:SK\u0006$\u0017N\\4%I\u00164\u0017-\u001e7uII*\"!!&+\u0007y\n9j\u000b\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016!C;oG\",7m[3e\u0015\r\t\u0019KM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAT\u0003;\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039awnY6G_J<&/\u001b;j]\u001e$b!a\u0010\u0002.\u0006=\u0006BBA\r%\u0001\u0007Q\u000b\u0003\u0005\u0002ZI\u0001\n\u00111\u0001?\u0003aawnY6G_J<&/\u001b;j]\u001e$C-\u001a4bk2$HEM\u0001\u001eCN\u001cXM\u001d;CY>\u001c7.S:M_\u000e\\W\r\u001a$pe^\u0013\u0018\u000e^5oOR!\u0011QIA\\\u0011\u0019\tI\u0002\u0006a\u0001+\u0006\u0019q-\u001a;\u0015\t\u0005}\u0012Q\u0018\u0005\u0007\u00033)\u0002\u0019A+\u0002\u001b\u0011|wO\\4sC\u0012,Gj\\2l)\u0011\t)#a1\t\r\u0005ea\u00031\u0001V\u0003\u0019)h\u000e\\8dWR1\u0011QEAe\u0003\u0017Da!!\u0007\u0018\u0001\u0004)\u0006\"CAg/A\u0005\t\u0019AAh\u0003M!\u0018m]6BiR,W\u000e\u001d;JI>\u0003H/[8o!\u0011\t\u0014\u0011I>\u0002!UtGn\\2lI\u0011,g-Y;mi\u0012\u0012TCAAkU\u0011\ty-a&\u0002-1|7m\u001b(fo\ncwnY6G_J<&/\u001b;j]\u001e$rAPAn\u0003;\f\t\u000f\u0003\u0004\u0002\u001ae\u0001\r!\u0016\u0005\b\u0003?L\u0002\u0019AA#\u00031qWm\u001e\"m_\u000e\\\u0017J\u001c4p\u0011!\t\u0019/\u0007I\u0001\u0002\u0004q\u0014\u0001D6fKB\u0014V-\u00193M_\u000e\\\u0017\u0001\t7pG.tUm\u001e\"m_\u000e\\gi\u001c:Xe&$\u0018N\\4%I\u00164\u0017-\u001e7uIM\naC]3mK\u0006\u001cX-\u00117m\u0019>\u001c7n\u001d$peR\u000b7o\u001b\u000b\u0005\u0003W\u0014\u0019\u0001E\u0003\u0002n\u0006uXK\u0004\u0003\u0002p\u0006eh\u0002BAy\u0003ol!!a=\u000b\u0007\u0005UX(\u0001\u0004=e>|GOP\u0005\u0002g%\u0019\u00111 \u001a\u0002\u000fA\f7m[1hK&!\u0011q B\u0001\u0005\r\u0019V-\u001d\u0006\u0004\u0003w\u0014\u0004BBA\u001a7\u0001\u000710\u0001\thKR$\u0016m]6M_\u000e\\7i\\;oiR!!\u0011\u0002B\b!\r\t$1B\u0005\u0004\u0005\u001b\u0011$aA%oi\"1\u00111\u0007\u000fA\u0002m\fAa]5{KV\u0011!\u0011B\u0001\u0016O\u0016$h*^7cKJ|e-T1q\u000b:$(/[3t+\u00059\u0015aB3oiJLWm]\u000b\u0003\u0005;\u0001b!!<\u0003 \t\r\u0012\u0002\u0002B\u0011\u0005\u0003\u0011\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007c\t\u0015R+!\u0012\n\u0007\t\u001d\"G\u0001\u0004UkBdWMM\u0001\fe\u0016lwN^3CY>\u001c7\u000e\u0006\u0003\u0002&\t5\u0002BBA\rA\u0001\u0007Q+A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002&\u0005\u0001\"\t\\8dW&sgm\\'b]\u0006<WM\u001d\t\u0003\t\u000e\u001a\"a\t\u0019\u0015\u0005\tU\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007")
public class BlockInfoManager
implements Logging {
    private final boolean trackingCacheVisibility;
    private final ConcurrentHashMap<BlockId, BlockInfoWrapper> blockInfoWrappers;
    private final HashSet<RDDBlockId> invisibleRDDBlocks;
    private final Striped<Lock> locks;
    private final ConcurrentHashMap<Object, Set<BlockId>> writeLocksByTask;
    private final ConcurrentHashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$1() {
        return BlockInfoManager$.MODULE$.$lessinit$greater$default$1();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean containsInvisibleRDDBlock(RDDBlockId blockId) {
        boolean bl;
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            bl = this.invisibleRDDBlocks.contains((Object)blockId);
        }
        return bl;
    }

    public boolean isRDDBlockVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            boolean bl;
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                bl = this.blockInfoWrappers.containsKey(blockId) && !this.invisibleRDDBlocks.contains((Object)blockId);
            }
            return bl;
        }
        return true;
    }

    public void tryMarkBlockAsVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                this.invisibleRDDBlocks.remove((Object)blockId);
            }
            return;
        }
    }

    public void registerTask(long taskAttemptId) {
        this.writeLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), Collections.synchronizedSet(new java.util.HashSet()));
        this.readLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), (ConcurrentHashMultiset<BlockId>)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    private Option<BlockInfo> acquireLock(BlockId blockId, boolean blocking, Function1<BlockInfo, Object> f) {
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        while (!done.elem) {
            Object object;
            BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
            if (wrapper == null) {
                done.elem = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = wrapper.withLock((Function2 & Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$acquireLock$1(f, result, done, blocking, info, condition);
                return BoxedUnit.UNIT;
            });
        }
        return (Option)result.elem;
    }

    private <T> T blockInfo(BlockId blockId, Function2<BlockInfo, Condition, T> f) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper == null) {
            throw SparkCoreErrors$.MODULE$.blockDoesNotExistError(blockId);
        }
        return wrapper.withLock(f);
    }

    public Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to acquire read lock for " + blockId);
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForReading$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to acquire write lock for " + blockId);
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForWriting$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        return (BlockInfo)this.blockInfo(blockId, (Function2 & Serializable)(info, x$2) -> {
            if (info.writerTask() != taskAttemptId) {
                throw SparkCoreErrors$.MODULE$.taskHasNotLockedBlockError(this.currentTaskAttemptId(), blockId);
            }
            return info;
        });
    }

    public Option<BlockInfo> get(BlockId blockId) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper != null) {
            return new Some((Object)wrapper.info());
        }
        return None$.MODULE$;
    }

    public void downgradeLock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " downgrading write lock for " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, x$3) -> {
            BlockInfoManager.$anonfun$downgradeLock$2(this, taskAttemptId, blockId, info, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void unlock(BlockId blockId, Option<Object> taskAttemptIdOption) {
        long taskAttemptId = BoxesRunTime.unboxToLong((Object)taskAttemptIdOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " releasing lock for " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$unlock$3(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo, boolean keepReadLock) {
        boolean bl;
        block12: {
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + this.currentTaskAttemptId() + " trying to put " + blockId);
            Lock lock = (Lock)this.locks.get((Object)blockId);
            lock.lock();
            try {
                BlockInfoWrapper wrapper = new BlockInfoWrapper(newBlockInfo, lock);
                do {
                    BlockInfoWrapper previous;
                    BlockInfoWrapper blockInfoWrapper;
                    if (this.trackingCacheVisibility) {
                        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
                        synchronized (hashSet) {
                            BlockInfoWrapper res = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                            if (res == null) {
                                blockId.asRDDId().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)this.invisibleRDDBlocks.add((Object)elem)));
                            }
                            BlockInfoWrapper blockInfoWrapper2 = res;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6, 11] lbl15 : MonitorExitStatement: MONITOREXIT : var7_7
                            blockInfoWrapper = blockInfoWrapper2;
                        }
                    } else {
                        blockInfoWrapper = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                    }
                    if ((previous = blockInfoWrapper) == null) {
                        Option<BlockInfo> result = this.lockForWriting(blockId, false);
                        Predef$.MODULE$.assert(result.isDefined());
                        bl = true;
                    } else {
                        if (keepReadLock) continue;
                        bl = false;
                    }
                    break block12;
                } while (!this.lockForReading(blockId, this.lockForReading$default$2()).isDefined());
                bl = false;
            }
            finally {
                lock.unlock();
            }
        }
        return bl;
    }

    public boolean lockNewBlockForWriting$default$3() {
        return true;
    }

    public Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set writeLocks = (Set)Option$.MODULE$.apply(this.writeLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable)() -> Set.of());
        writeLocks.forEach(blockId -> {
            this.blockInfo((BlockId)blockId, (Function2 & Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$3(taskAttemptId, info, condition);
                return BoxedUnit.UNIT;
            });
            blocksWithReleasedLocks.$plus$eq(blockId);
        });
        AbstractCollection readLocks = (AbstractCollection)Option$.MODULE$.apply(this.readLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable)() -> ImmutableMultiset.of());
        ((Multiset)readLocks).entrySet().forEach(entry -> {
            BlockId blockId = (BlockId)entry.getElement();
            int lockCount = entry.getCount();
            blocksWithReleasedLocks.$plus$eq((Object)blockId);
            this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info, condition);
                return BoxedUnit.UNIT;
            });
        });
        return blocksWithReleasedLocks.toSeq();
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public int size() {
        return this.blockInfoWrappers.size();
    }

    public long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.readLocksByTask).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$6)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.writeLocksByTask).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$7)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.blockInfoWrappers.entrySet().iterator()).asScala().map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), (Object)((BlockInfoWrapper)kv.getValue()).info()));
    }

    public void removeBlock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to remove block " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$removeBlock$2(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.blockInfoWrappers.values().forEach(wrapper -> wrapper.tryLock((Function2<BlockInfo, Condition, BoxedUnit>)(Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$clear$2(info, condition);
            return BoxedUnit.UNIT;
        }));
        this.blockInfoWrappers.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            this.invisibleRDDBlocks.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$acquireLock$1(Function1 f$1, ObjectRef result$1, BooleanRef done$1, boolean blocking$1, BlockInfo info, Condition condition) {
        if (BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)info))) {
            result$1.elem = new Some((Object)info);
            done$1.elem = true;
            return;
        }
        if (!blocking$1) {
            done$1.elem = true;
            return;
        }
        condition.await();
    }

    public static final /* synthetic */ boolean $anonfun$lockForReading$2(BlockInfoManager $this, long taskAttemptId$1, BlockId blockId$1, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER();
            if (!acquire) break block0;
            info.readerCount_$eq(info.readerCount() + 1);
            $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$1)).add((Object)blockId$1);
            $this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId$1 + " acquired read lock for " + blockId$1);
        }
        return acquire;
    }

    public static final /* synthetic */ boolean $anonfun$lockForWriting$2(BlockInfoManager $this, long taskAttemptId$2, BlockId blockId$2, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0;
            if (!acquire) break block0;
            info.writerTask_$eq(taskAttemptId$2);
            $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$2)).add(blockId$2);
            $this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId$2 + " acquired write lock for " + blockId$2);
        }
        return acquire;
    }

    public static final /* synthetic */ void $anonfun$downgradeLock$2(BlockInfoManager $this, long taskAttemptId$4, BlockId blockId$4, BlockInfo info, Condition x$3) {
        Predef$.MODULE$.require(info.writerTask() == taskAttemptId$4, (Function0 & Serializable)() -> "Task " + taskAttemptId$4 + " tried to downgrade a write lock that it does not hold on block " + blockId$4);
        $this.unlock(blockId$4, $this.unlock$default$2());
        Option<BlockInfo> lockOutcome = $this.lockForReading(blockId$4, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public static final /* synthetic */ void $anonfun$unlock$3(BlockInfoManager $this, long taskAttemptId$5, BlockId blockId$5, BlockInfo info, Condition condition) {
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            v0 = BoxesRunTime.boxToBoolean((boolean)$this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5)).remove(blockId$5));
        } else {
            ConcurrentHashMultiset<BlockId> countsForTask = $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            if (countsForTask != null) {
                Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable)() -> "Block " + blockId$5 + " is not locked for reading");
                info.readerCount_$eq(info.readerCount() - 1);
                int newPinCountForTask = countsForTask.remove((Object)blockId$5, 1) - 1;
                Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable)() -> "Task " + taskAttemptId$5 + " release lock on block " + blockId$5 + " more times than it acquired it");
            }
            v0 = BoxedUnit.UNIT;
        }
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$3(long taskAttemptId$6, BlockInfo info, Condition condition) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$6);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info, Condition condition) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
        condition.signalAll();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$6) {
        return ((ConcurrentHashMultiset)x$6._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$7) {
        return ((Set)x$7._2()).size();
    }

    public static final /* synthetic */ void $anonfun$removeBlock$2(BlockInfoManager $this, long taskAttemptId$7, BlockId blockId$7, BlockInfo info, Condition condition) {
        if (info.writerTask() != taskAttemptId$7) {
            throw SparkException$.MODULE$.internalError("Task " + taskAttemptId$7 + " called remove() on block " + blockId$7 + " without a write lock", "STORAGE");
        }
        HashSet<RDDBlockId> hashSet = $this.invisibleRDDBlocks;
        synchronized (hashSet) {
            $this.blockInfoWrappers.remove(blockId$7);
            blockId$7.asRDDId().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)$this.invisibleRDDBlocks.remove((Object)elem)));
        }
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$7)).remove(blockId$7);
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$clear$2(BlockInfo info, Condition condition) {
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public BlockInfoManager(boolean trackingCacheVisibility) {
        this.trackingCacheVisibility = trackingCacheVisibility;
        Logging.$init$((Logging)this);
        this.blockInfoWrappers = new ConcurrentHashMap();
        this.invisibleRDDBlocks = new HashSet();
        this.locks = Striped.lock((int)1024);
        this.writeLocksByTask = new ConcurrentHashMap();
        this.readLocksByTask = new ConcurrentHashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

