/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming.clickstream;

import java.io.PrintWriter;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.apache.spark.examples.streaming.clickstream.PageView;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class PageViewGenerator$ {
    public static final PageViewGenerator$ MODULE$ = new PageViewGenerator$();
    private static final Map<String, Object> pages = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/"), (Object)BoxesRunTime.boxToDouble((double)0.7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/news"), (Object)BoxesRunTime.boxToDouble((double)0.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/contact"), (Object)BoxesRunTime.boxToDouble((double)0.1))}));
    private static final Map<Object, Object> httpStatus = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)200)), (Object)BoxesRunTime.boxToDouble((double)0.95)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)404)), (Object)BoxesRunTime.boxToDouble((double)0.05))}));
    private static final Map<Object, Object> userZipCode = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)94709)), (Object)BoxesRunTime.boxToDouble((double)0.5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)94117)), (Object)BoxesRunTime.boxToDouble((double)0.5))}));
    private static final Map<Object, Object> userID = (Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable)x$1 -> PageViewGenerator$.$anonfun$userID$1(BoxesRunTime.unboxToInt((Object)x$1))));

    public Map<String, Object> pages() {
        return pages;
    }

    public Map<Object, Object> httpStatus() {
        return httpStatus;
    }

    public Map<Object, Object> userZipCode() {
        return userZipCode;
    }

    public Map<Object, Object> userID() {
        return userID;
    }

    public <T> T pickFromDistribution(Map<T, Object> inputMap) {
        Object object;
        Object object2 = new Object();
        try {
            double rand = new Random().nextDouble();
            DoubleRef total = DoubleRef.create((double)0.0);
            inputMap.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PageViewGenerator$.$anonfun$pickFromDistribution$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                PageViewGenerator$.$anonfun$pickFromDistribution$2(total, rand, object2, x$2);
                return BoxedUnit.UNIT;
            });
            object = ((Tuple2)((IterableOps)inputMap.take(1)).head())._1();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return (T)object;
    }

    public String getNextClickEvent() {
        int id = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.userID()));
        String page = this.pickFromDistribution(this.pages());
        int status = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.httpStatus()));
        int zipCode = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.userZipCode()));
        return new PageView(page, status, zipCode, id).toString();
    }

    public void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: PageViewGenerator <port> <viewsPerSecond>");
            System.exit(1);
        }
        int port = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0]));
        float viewsPerSecond = StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(args[1]));
        int sleepDelayMs = (int)(1000.0 / (double)viewsPerSecond);
        ServerSocket listener = new ServerSocket(port);
        Predef$.MODULE$.println((Object)("Listening on port: " + port));
        while (true) {
            Socket socket = listener.accept();
            new Thread(socket, sleepDelayMs){
                private final Socket socket$1;
                private final int sleepDelayMs$1;

                public void run() {
                    Predef$.MODULE$.println((Object)("Got client connected from: " + this.socket$1.getInetAddress()));
                    PrintWriter out = new PrintWriter(this.socket$1.getOutputStream(), true);
                    while (true) {
                        Thread.sleep(this.sleepDelayMs$1);
                        out.write(PageViewGenerator$.MODULE$.getNextClickEvent());
                        out.flush();
                    }
                }
                {
                    this.socket$1 = socket$1;
                    this.sleepDelayMs$1 = sleepDelayMs$1;
                }
            }.start();
        }
    }

    public static final /* synthetic */ boolean $anonfun$pickFromDistribution$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$pickFromDistribution$2(DoubleRef total$1, double rand$1, Object nonLocalReturnKey1$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            Object item = tuple2._1();
            double prob = tuple2._2$mcD$sp();
            total$1.elem += prob;
            if (total$1.elem > rand$1) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, item);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private PageViewGenerator$() {
    }
}

