/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DecisionTreeRunner;
import org.apache.spark.examples.mllib.DecisionTreeRunner$;
import org.apache.spark.examples.mllib.DecisionTreeRunner$ImpurityType$;
import org.apache.spark.examples.mllib.DecisionTreeRunner$Params$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class DecisionTreeRunner$ {
    public static final DecisionTreeRunner$ MODULE$ = new DecisionTreeRunner$();

    public void main(String[] args) {
        DecisionTreeRunner.Params defaultParams = new DecisionTreeRunner.Params(DecisionTreeRunner$Params$.MODULE$.apply$default$1(), DecisionTreeRunner$Params$.MODULE$.apply$default$2(), DecisionTreeRunner$Params$.MODULE$.apply$default$3(), DecisionTreeRunner$Params$.MODULE$.apply$default$4(), DecisionTreeRunner$Params$.MODULE$.apply$default$5(), DecisionTreeRunner$Params$.MODULE$.apply$default$6(), DecisionTreeRunner$Params$.MODULE$.apply$default$7(), DecisionTreeRunner$Params$.MODULE$.apply$default$8(), DecisionTreeRunner$Params$.MODULE$.apply$default$9(), DecisionTreeRunner$Params$.MODULE$.apply$default$10(), DecisionTreeRunner$Params$.MODULE$.apply$default$11(), DecisionTreeRunner$Params$.MODULE$.apply$default$12(), DecisionTreeRunner$Params$.MODULE$.apply$default$13(), DecisionTreeRunner$Params$.MODULE$.apply$default$14(), DecisionTreeRunner$Params$.MODULE$.apply$default$15());
        OptionParser<DecisionTreeRunner.Params> parser = new OptionParser<DecisionTreeRunner.Params>(defaultParams){

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$3(int x, DecisionTreeRunner.Params c) {
                int x$31 = x;
                String x$32 = c.copy$default$1();
                String x$33 = c.copy$default$2();
                String x$34 = c.copy$default$3();
                Enumeration.Value x$35 = c.copy$default$4();
                Enumeration.Value x$36 = c.copy$default$6();
                int x$37 = c.copy$default$7();
                int x$38 = c.copy$default$8();
                double x$39 = c.copy$default$9();
                int x$40 = c.copy$default$10();
                String x$41 = c.copy$default$11();
                double x$42 = c.copy$default$12();
                boolean x$43 = c.copy$default$13();
                Option<String> x$44 = c.copy$default$14();
                int x$45 = c.copy$default$15();
                return c.copy(x$32, x$33, x$34, x$35, x$31, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$4(int x, DecisionTreeRunner.Params c) {
                int x$46 = x;
                String x$47 = c.copy$default$1();
                String x$48 = c.copy$default$2();
                String x$49 = c.copy$default$3();
                Enumeration.Value x$50 = c.copy$default$4();
                int x$51 = c.copy$default$5();
                Enumeration.Value x$52 = c.copy$default$6();
                int x$53 = c.copy$default$8();
                double x$54 = c.copy$default$9();
                int x$55 = c.copy$default$10();
                String x$56 = c.copy$default$11();
                double x$57 = c.copy$default$12();
                boolean x$58 = c.copy$default$13();
                Option<String> x$59 = c.copy$default$14();
                int x$60 = c.copy$default$15();
                return c.copy(x$47, x$48, x$49, x$50, x$51, x$52, x$46, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$5(int x, DecisionTreeRunner.Params c) {
                int x$61 = x;
                String x$62 = c.copy$default$1();
                String x$63 = c.copy$default$2();
                String x$64 = c.copy$default$3();
                Enumeration.Value x$65 = c.copy$default$4();
                int x$66 = c.copy$default$5();
                Enumeration.Value x$67 = c.copy$default$6();
                int x$68 = c.copy$default$7();
                double x$69 = c.copy$default$9();
                int x$70 = c.copy$default$10();
                String x$71 = c.copy$default$11();
                double x$72 = c.copy$default$12();
                boolean x$73 = c.copy$default$13();
                Option<String> x$74 = c.copy$default$14();
                int x$75 = c.copy$default$15();
                return c.copy(x$62, x$63, x$64, x$65, x$66, x$67, x$68, x$61, x$69, x$70, x$71, x$72, x$73, x$74, x$75);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$6(double x, DecisionTreeRunner.Params c) {
                double x$76 = x;
                String x$77 = c.copy$default$1();
                String x$78 = c.copy$default$2();
                String x$79 = c.copy$default$3();
                Enumeration.Value x$80 = c.copy$default$4();
                int x$81 = c.copy$default$5();
                Enumeration.Value x$82 = c.copy$default$6();
                int x$83 = c.copy$default$7();
                int x$84 = c.copy$default$8();
                int x$85 = c.copy$default$10();
                String x$86 = c.copy$default$11();
                double x$87 = c.copy$default$12();
                boolean x$88 = c.copy$default$13();
                Option<String> x$89 = c.copy$default$14();
                int x$90 = c.copy$default$15();
                return c.copy(x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$76, x$85, x$86, x$87, x$88, x$89, x$90);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$7(int x, DecisionTreeRunner.Params c) {
                int x$91 = x;
                String x$92 = c.copy$default$1();
                String x$93 = c.copy$default$2();
                String x$94 = c.copy$default$3();
                Enumeration.Value x$95 = c.copy$default$4();
                int x$96 = c.copy$default$5();
                Enumeration.Value x$97 = c.copy$default$6();
                int x$98 = c.copy$default$7();
                int x$99 = c.copy$default$8();
                double x$100 = c.copy$default$9();
                String x$101 = c.copy$default$11();
                double x$102 = c.copy$default$12();
                boolean x$103 = c.copy$default$13();
                Option<String> x$104 = c.copy$default$14();
                int x$105 = c.copy$default$15();
                return c.copy(x$92, x$93, x$94, x$95, x$96, x$97, x$98, x$99, x$100, x$91, x$101, x$102, x$103, x$104, x$105);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$9(double x, DecisionTreeRunner.Params c) {
                double x$121 = x;
                String x$122 = c.copy$default$1();
                String x$123 = c.copy$default$2();
                String x$124 = c.copy$default$3();
                Enumeration.Value x$125 = c.copy$default$4();
                int x$126 = c.copy$default$5();
                Enumeration.Value x$127 = c.copy$default$6();
                int x$128 = c.copy$default$7();
                int x$129 = c.copy$default$8();
                double x$130 = c.copy$default$9();
                int x$131 = c.copy$default$10();
                String x$132 = c.copy$default$11();
                boolean x$133 = c.copy$default$13();
                Option<String> x$134 = c.copy$default$14();
                int x$135 = c.copy$default$15();
                return c.copy(x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$129, x$130, x$131, x$132, x$121, x$133, x$134, x$135);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$10(boolean x, DecisionTreeRunner.Params c) {
                boolean x$136 = x;
                String x$137 = c.copy$default$1();
                String x$138 = c.copy$default$2();
                String x$139 = c.copy$default$3();
                Enumeration.Value x$140 = c.copy$default$4();
                int x$141 = c.copy$default$5();
                Enumeration.Value x$142 = c.copy$default$6();
                int x$143 = c.copy$default$7();
                int x$144 = c.copy$default$8();
                double x$145 = c.copy$default$9();
                int x$146 = c.copy$default$10();
                String x$147 = c.copy$default$11();
                double x$148 = c.copy$default$12();
                Option<String> x$149 = c.copy$default$14();
                int x$150 = c.copy$default$15();
                return c.copy(x$137, x$138, x$139, x$140, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$148, x$136, x$149, x$150);
            }

            public static final /* synthetic */ DecisionTreeRunner.Params $anonfun$new$12(int x, DecisionTreeRunner.Params c) {
                int x$166 = x;
                String x$167 = c.copy$default$1();
                String x$168 = c.copy$default$2();
                String x$169 = c.copy$default$3();
                Enumeration.Value x$170 = c.copy$default$4();
                int x$171 = c.copy$default$5();
                Enumeration.Value x$172 = c.copy$default$6();
                int x$173 = c.copy$default$7();
                int x$174 = c.copy$default$8();
                double x$175 = c.copy$default$9();
                int x$176 = c.copy$default$10();
                String x$177 = c.copy$default$11();
                double x$178 = c.copy$default$12();
                boolean x$179 = c.copy$default$13();
                Option<String> x$180 = c.copy$default$14();
                return c.copy(x$167, x$168, x$169, x$170, x$171, x$172, x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$180, x$166);
            }
            {
                String string;
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTreeRunner: an example decision tree app."}));
                this.opt("algo", Read$.MODULE$.stringRead()).text("algorithm (" + Algo$.MODULE$.values().mkString(",") + "), default: " + defaultParams$1.algo()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$1 = Algo$.MODULE$.withName(x);
                    String x$2 = c.copy$default$1();
                    String x$3 = c.copy$default$2();
                    String x$4 = c.copy$default$3();
                    int x$5 = c.copy$default$5();
                    Enumeration.Value x$6 = c.copy$default$6();
                    int x$7 = c.copy$default$7();
                    int x$8 = c.copy$default$8();
                    double x$9 = c.copy$default$9();
                    int x$10 = c.copy$default$10();
                    String x$11 = c.copy$default$11();
                    double x$12 = c.copy$default$12();
                    boolean x$13 = c.copy$default$13();
                    Option<String> x$14 = c.copy$default$14();
                    int x$15 = c.copy$default$15();
                    return c.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15);
                });
                this.opt("impurity", Read$.MODULE$.stringRead()).text("impurity type (" + DecisionTreeRunner$ImpurityType$.MODULE$.values().mkString(",") + "), default: " + defaultParams$1.impurity()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$16 = DecisionTreeRunner$ImpurityType$.MODULE$.withName((String)x);
                    String x$17 = c.copy$default$1();
                    String x$18 = c.copy$default$2();
                    String x$19 = c.copy$default$3();
                    Enumeration.Value x$20 = c.copy$default$4();
                    int x$21 = c.copy$default$5();
                    int x$22 = c.copy$default$7();
                    int x$23 = c.copy$default$8();
                    double x$24 = c.copy$default$9();
                    int x$25 = c.copy$default$10();
                    String x$26 = c.copy$default$11();
                    double x$27 = c.copy$default$12();
                    boolean x$28 = c.copy$default$13();
                    Option<String> x$29 = c.copy$default$14();
                    int x$30 = c.copy$default$15();
                    return c.copy(x$17, x$18, x$19, x$20, x$21, x$16, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30);
                });
                this.opt("maxDepth", Read$.MODULE$.intRead()).text("max depth of the tree, default: " + defaultParams$1.maxDepth()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("maxBins", Read$.MODULE$.intRead()).text("max number of bins, default: " + defaultParams$1.maxBins()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$4(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInstancesPerNode", Read$.MODULE$.intRead()).text("min number of instances required at child nodes to create the parent split, default: " + defaultParams$1.minInstancesPerNode()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("minInfoGain", Read$.MODULE$.doubleRead()).text("min info gain required to create a split, default: " + defaultParams$1.minInfoGain()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$6(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("numTrees", Read$.MODULE$.intRead()).text("number of trees (1 = decision tree, 2+ = random forest), default: " + defaultParams$1.numTrees()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("featureSubsetStrategy", Read$.MODULE$.stringRead()).text("feature subset sampling strategy (" + Predef$.MODULE$.wrapRefArray((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ") + "), default: " + defaultParams$1.featureSubsetStrategy()).action((Function2 & Serializable)(x, c) -> {
                    String x$106 = x;
                    String x$107 = c.copy$default$1();
                    String x$108 = c.copy$default$2();
                    String x$109 = c.copy$default$3();
                    Enumeration.Value x$110 = c.copy$default$4();
                    int x$111 = c.copy$default$5();
                    Enumeration.Value x$112 = c.copy$default$6();
                    int x$113 = c.copy$default$7();
                    int x$114 = c.copy$default$8();
                    double x$115 = c.copy$default$9();
                    int x$116 = c.copy$default$10();
                    double x$117 = c.copy$default$12();
                    boolean x$118 = c.copy$default$13();
                    Option<String> x$119 = c.copy$default$14();
                    int x$120 = c.copy$default$15();
                    return c.copy(x$107, x$108, x$109, x$110, x$111, x$112, x$113, x$114, x$115, x$116, x$106, x$117, x$118, x$119, x$120);
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text("fraction of data to hold out for testing.  If given option testInput, this option is ignored. default: " + defaultParams$1.fracTest()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToDouble((Object)x), c));
                this.opt("useNodeIdCache", Read$.MODULE$.booleanRead()).text("whether to use node Id cache during training, default: " + defaultParams$1.useNodeIdCache()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$10(BoxesRunTime.unboxToBoolean((Object)x), c));
                OptionDef optionDef = this.opt("checkpointDir", Read$.MODULE$.stringRead());
                Option<String> option = defaultParams$1.checkpointDir();
                if (option instanceof Some) {
                    String strVal;
                    Some some = (Some)option;
                    string = strVal = (String)some.value();
                } else if (None$.MODULE$.equals(option)) {
                    string = "None";
                } else {
                    throw new MatchError(option);
                }
                optionDef.text("checkpoint directory where intermediate node Id caches will be stored, default: " + string).action((Function2 & Serializable)(x, c) -> {
                    Some x$151 = new Some(x);
                    String x$152 = c.copy$default$1();
                    String x$153 = c.copy$default$2();
                    String x$154 = c.copy$default$3();
                    Enumeration.Value x$155 = c.copy$default$4();
                    int x$156 = c.copy$default$5();
                    Enumeration.Value x$157 = c.copy$default$6();
                    int x$158 = c.copy$default$7();
                    int x$159 = c.copy$default$8();
                    double x$160 = c.copy$default$9();
                    int x$161 = c.copy$default$10();
                    String x$162 = c.copy$default$11();
                    double x$163 = c.copy$default$12();
                    boolean x$164 = c.copy$default$13();
                    int x$165 = c.copy$default$15();
                    return c.copy(x$152, x$153, x$154, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$162, x$163, x$164, (Option<String>)x$151, x$165);
                });
                this.opt("checkpointInterval", Read$.MODULE$.intRead()).text("how often to checkpoint the node Id cache, default: " + defaultParams$1.checkpointInterval()).action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$12(BoxesRunTime.unboxToInt((Object)x), c));
                this.opt("testInput", Read$.MODULE$.stringRead()).text("input path to test dataset.  If given, option fracTest is ignored. default: " + defaultParams$1.testInput()).action((Function2 & Serializable)(x, c) -> {
                    String x$181 = x;
                    String x$182 = c.copy$default$1();
                    String x$183 = c.copy$default$3();
                    Enumeration.Value x$184 = c.copy$default$4();
                    int x$185 = c.copy$default$5();
                    Enumeration.Value x$186 = c.copy$default$6();
                    int x$187 = c.copy$default$7();
                    int x$188 = c.copy$default$8();
                    double x$189 = c.copy$default$9();
                    int x$190 = c.copy$default$10();
                    String x$191 = c.copy$default$11();
                    double x$192 = c.copy$default$12();
                    boolean x$193 = c.copy$default$13();
                    Option<String> x$194 = c.copy$default$14();
                    int x$195 = c.copy$default$15();
                    return c.copy(x$182, x$181, x$183, x$184, x$185, x$186, x$187, x$188, x$189, x$190, x$191, x$192, x$193, x$194, x$195);
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2 & Serializable)(x, c) -> {
                    String x$196 = x;
                    String x$197 = c.copy$default$1();
                    String x$198 = c.copy$default$2();
                    Enumeration.Value x$199 = c.copy$default$4();
                    int x$200 = c.copy$default$5();
                    Enumeration.Value x$201 = c.copy$default$6();
                    int x$202 = c.copy$default$7();
                    int x$203 = c.copy$default$8();
                    double x$204 = c.copy$default$9();
                    int x$205 = c.copy$default$10();
                    String x$206 = c.copy$default$11();
                    double x$207 = c.copy$default$12();
                    boolean x$208 = c.copy$default$13();
                    Option<String> x$209 = c.copy$default$14();
                    int x$210 = c.copy$default$15();
                    return c.copy(x$197, x$198, x$196, x$199, x$200, x$201, x$202, x$203, x$204, x$205, x$206, x$207, x$208, x$209, x$210);
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8(), c.copy$default$9(), c.copy$default$10(), c.copy$default$11(), c.copy$default$12(), c.copy$default$13(), c.copy$default$14(), c.copy$default$15()));
                this.checkConfig((Function1 & Serializable)params -> {
                    block6: {
                        block7: {
                            if (params.fracTest() < 0.0 || params.fracTest() > 1.0) {
                                return this.failure("fracTest " + params.fracTest() + " value incorrect; should be in [0,1].");
                            }
                            Enumeration.Value value = params.algo();
                            Enumeration.Value value2 = Algo$.MODULE$.Classification();
                            if (value != null ? !value.equals(value2) : value2 != null) break block6;
                            Enumeration.Value value3 = params.impurity();
                            Enumeration.Value value4 = DecisionTreeRunner$ImpurityType$.MODULE$.Gini();
                            if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block7;
                            Enumeration.Value value5 = params.impurity();
                            Enumeration.Value value6 = DecisionTreeRunner$ImpurityType$.MODULE$.Entropy();
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block6;
                        }
                        return this.success();
                    }
                    Enumeration.Value value = params.algo();
                    Enumeration.Value value7 = Algo$.MODULE$.Regression();
                    if (!(value != null ? !value.equals(value7) : value7 != null)) {
                        Enumeration.Value value8 = params.impurity();
                        Enumeration.Value value9 = DecisionTreeRunner$ImpurityType$.MODULE$.Variance();
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            return this.success();
                        }
                    }
                    return this.failure("Algo " + params.algo() + " is not compatible with impurity " + params.impurity() + ".");
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$10$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$11(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$12$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$13(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$14(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$15(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$16(org.apache.spark.examples.mllib.DecisionTreeRunner$$anon$1 org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$2(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$3$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$4$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$5$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$6$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$7$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$8(java.lang.String org.apache.spark.examples.mllib.DecisionTreeRunner$Params ), $anonfun$new$9$adapted(java.lang.Object org.apache.spark.examples.mllib.DecisionTreeRunner$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            DecisionTreeRunner.Params params = (DecisionTreeRunner.Params)some.value();
            this.run(params);
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> loadDatasets(SparkContext sc, String input, String dataFormat, String testInput, Enumeration.Value algo, double fracTest) {
        RDD[] rDDArray;
        Tuple3 tuple3;
        String string = dataFormat;
        RDD origExamples = switch (string == null ? 0 : string.hashCode()) {
            case -1103015483 -> {
                if (!"libsvm".equals(string)) throw new MatchError((Object)string);
                yield MLUtils$.MODULE$.loadLibSVMFile(sc, input).cache();
            }
            case 95470367 -> {
                if (!"dense".equals(string)) throw new MatchError((Object)string);
                yield MLUtils$.MODULE$.loadLabeledPoints(sc, input).cache();
            }
            default -> throw new MatchError((Object)string);
        };
        Enumeration.Value value = algo;
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Map classCounts = origExamples.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.label()), (ClassTag)ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            List sortedClasses = (List)classCounts.keys().toList().sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            int numClasses = classCounts.size();
            Set set = classCounts.keySet();
            Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
            scala.collection.immutable.Map classIndexMap = (set == null ? object != null : !set.equals(object)) ? ((IterableOnceOps)sortedClasses.zipWithIndex()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            RDD examples = classIndexMap.isEmpty() ? origExamples : origExamples.map((Function1 & Serializable)lp -> new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)classIndexMap.apply((Object)BoxesRunTime.boxToDouble((double)lp.label()))), lp.features()), ClassTag$.MODULE$.apply(LabeledPoint.class));
            long numExamples = examples.count();
            Predef$.MODULE$.println((Object)("numClasses = " + numClasses + "."));
            Predef$.MODULE$.println((Object)"Per-class example fractions, counts:");
            Predef$.MODULE$.println((Object)"Class\tFrac\tCount");
            sortedClasses.foreach((Function1)(JFunction1.mcVD.sp & Serializable)c -> {
                double frac = (double)BoxesRunTime.unboxToLong((Object)classCounts.apply((Object)BoxesRunTime.boxToDouble((double)c))) / (double)numExamples;
                Predef$.MODULE$.println((Object)(c + "\t" + frac + "\t" + classCounts.apply((Object)BoxesRunTime.boxToDouble((double)c))));
            });
            tuple3 = new Tuple3((Object)examples, (Object)classIndexMap, (Object)BoxesRunTime.boxToInteger((int)numClasses));
        } else {
            Enumeration.Value value4 = Algo$.MODULE$.Regression();
            Enumeration.Value value5 = value;
            if (value4 != null ? !value4.equals(value5) : value5 != null) throw new IllegalArgumentException("Algo " + algo + " not supported.");
            tuple3 = new Tuple3((Object)origExamples, null, (Object)BoxesRunTime.boxToInteger((int)0));
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        RDD examples = (RDD)tuple32._1();
        scala.collection.immutable.Map classIndexMap = (scala.collection.immutable.Map)tuple32._2();
        int numClasses = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)examples, (Object)classIndexMap, (Object)BoxesRunTime.boxToInteger((int)numClasses));
        RDD examples2 = (RDD)tuple33._1();
        scala.collection.immutable.Map classIndexMap2 = (scala.collection.immutable.Map)tuple33._2();
        int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        String string2 = testInput;
        String string3 = "";
        if (string2 == null ? string3 != null : !string2.equals(string3)) {
            int numFeatures = ((LabeledPoint[])examples2.take(1))[0].features().size();
            String string4 = dataFormat;
            RDD origTestExamples = switch (string4 == null ? 0 : string4.hashCode()) {
                case -1103015483 -> {
                    if (!"libsvm".equals(string4)) throw new MatchError((Object)string4);
                    yield MLUtils$.MODULE$.loadLibSVMFile(sc, testInput, numFeatures);
                }
                case 95470367 -> {
                    if (!"dense".equals(string4)) throw new MatchError((Object)string4);
                    yield MLUtils$.MODULE$.loadLabeledPoints(sc, testInput);
                }
                default -> throw new MatchError((Object)string4);
            };
            Enumeration.Value value6 = algo;
            Enumeration.Value value7 = Algo$.MODULE$.Classification();
            Enumeration.Value value8 = value6;
            if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                RDD testExamples = classIndexMap2.isEmpty() ? origTestExamples : origTestExamples.map((Function1 & Serializable)lp -> new LabeledPoint((double)BoxesRunTime.unboxToInt((Object)classIndexMap2.apply((Object)BoxesRunTime.boxToDouble((double)lp.label()))), lp.features()), ClassTag$.MODULE$.apply(LabeledPoint.class));
                rDDArray = (RDD[])((Object[])new RDD[]{examples2, testExamples});
            } else {
                Enumeration.Value value9 = Algo$.MODULE$.Regression();
                Enumeration.Value value10 = value6;
                if (value9 != null ? !value9.equals(value10) : value10 != null) throw new MatchError((Object)value6);
                rDDArray = (RDD[])((Object[])new RDD[]{examples2, origTestExamples});
            }
        } else {
            rDDArray = examples2.randomSplit(new double[]{1.0 - fracTest, fracTest}, examples2.randomSplit$default$2());
        }
        RDD[] splits = rDDArray;
        RDD training = splits[0].cache();
        RDD test = splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)("numTraining = " + numTraining + ", numTest = " + numTest + "."));
        examples2.unpersist(examples2.unpersist$default$1());
        return new Tuple3((Object)training, (Object)test, (Object)BoxesRunTime.boxToInteger((int)numClasses2));
    }

    public void run(DecisionTreeRunner.Params params) {
        Gini$ gini$;
        SparkConf conf = new SparkConf().setAppName("DecisionTreeRunner with " + params);
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)("DecisionTreeRunner with parameters:\n" + params));
        Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> tuple3 = this.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), params.algo(), params.fracTest());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RDD training = (RDD)tuple3._1();
        RDD test = (RDD)tuple3._2();
        int numClasses = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)training, (Object)test, (Object)BoxesRunTime.boxToInteger((int)numClasses));
        RDD training2 = (RDD)tuple32._1();
        RDD test2 = (RDD)tuple32._2();
        int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Enumeration.Value value = params.impurity();
        Enumeration.Value value2 = DecisionTreeRunner$ImpurityType$.MODULE$.Gini();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            gini$ = Gini$.MODULE$;
        } else {
            Enumeration.Value value4 = DecisionTreeRunner$ImpurityType$.MODULE$.Entropy();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                gini$ = Entropy$.MODULE$;
            } else {
                Enumeration.Value value6 = DecisionTreeRunner$ImpurityType$.MODULE$.Variance();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    gini$ = Variance$.MODULE$;
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        Gini$ impurityCalculator = gini$;
        params.checkpointDir().foreach((Function1 & Serializable)directory -> {
            sc.setCheckpointDir(directory);
            return BoxedUnit.UNIT;
        });
        Enumeration.Value x$1 = params.algo();
        Gini$ x$2 = impurityCalculator;
        int x$3 = params.maxDepth();
        int x$4 = params.maxBins();
        int x$5 = numClasses2;
        int x$6 = params.minInstancesPerNode();
        double x$7 = params.minInfoGain();
        boolean x$8 = params.useNodeIdCache();
        int x$9 = params.checkpointInterval();
        Enumeration.Value x$10 = Strategy$.MODULE$.$lessinit$greater$default$6();
        scala.collection.immutable.Map x$11 = Strategy$.MODULE$.$lessinit$greater$default$7();
        int x$12 = Strategy$.MODULE$.$lessinit$greater$default$10();
        double x$13 = Strategy$.MODULE$.$lessinit$greater$default$11();
        double x$14 = Strategy$.MODULE$.$lessinit$greater$default$14();
        boolean x$15 = Strategy$.MODULE$.$lessinit$greater$default$15();
        Strategy strategy = new Strategy(x$1, (Impurity)x$2, x$3, x$5, x$4, x$10, x$11, x$6, x$7, x$12, x$13, x$8, x$9, x$14, x$15);
        if (params.numTrees() == 1) {
            long startTime = System.nanoTime();
            DecisionTreeModel model = DecisionTree$.MODULE$.train(training2, strategy);
            double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
            Predef$.MODULE$.println((Object)("Training time: " + elapsedTime + " seconds"));
            if (model.numNodes() < 20) {
                Predef$.MODULE$.println((Object)model.toDebugString());
            } else {
                Predef$.MODULE$.println((Object)model);
            }
            Enumeration.Value value8 = params.algo();
            Enumeration.Value value9 = Algo$.MODULE$.Classification();
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                double trainAccuracy = new MulticlassMetrics(training2.map((Function1 & Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)("Train accuracy = " + trainAccuracy));
                double testAccuracy = new MulticlassMetrics(test2.map((Function1 & Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)("Test accuracy = " + testAccuracy));
            }
            Enumeration.Value value10 = params.algo();
            Enumeration.Value value11 = Algo$.MODULE$.Regression();
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                double trainMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)training2);
                Predef$.MODULE$.println((Object)("Train mean squared error = " + trainMSE));
                double testMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)test2);
                Predef$.MODULE$.println((Object)("Test mean squared error = " + testMSE));
            }
        } else {
            int randomSeed = Utils$.MODULE$.random().nextInt();
            Enumeration.Value value12 = params.algo();
            Enumeration.Value value13 = Algo$.MODULE$.Classification();
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                long startTime = System.nanoTime();
                RandomForestModel model = RandomForest$.MODULE$.trainClassifier(training2, strategy, params.numTrees(), params.featureSubsetStrategy(), randomSeed);
                double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                Predef$.MODULE$.println((Object)("Training time: " + elapsedTime + " seconds"));
                if (model.totalNumNodes() < 30) {
                    Predef$.MODULE$.println((Object)model.toDebugString());
                } else {
                    Predef$.MODULE$.println((Object)model);
                }
                double trainAccuracy = new MulticlassMetrics(training2.map((Function1 & Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)("Train accuracy = " + trainAccuracy));
                double testAccuracy = new MulticlassMetrics(test2.map((Function1 & Serializable)lp -> new Tuple2.mcDD.sp(model.predict(lp.features()), lp.label()), ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)("Test accuracy = " + testAccuracy));
            }
            Enumeration.Value value14 = params.algo();
            Enumeration.Value value15 = Algo$.MODULE$.Regression();
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                long startTime = System.nanoTime();
                RandomForestModel model = RandomForest$.MODULE$.trainRegressor(training2, strategy, params.numTrees(), params.featureSubsetStrategy(), randomSeed);
                double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                Predef$.MODULE$.println((Object)("Training time: " + elapsedTime + " seconds"));
                if (model.totalNumNodes() < 30) {
                    Predef$.MODULE$.println((Object)model.toDebugString());
                } else {
                    Predef$.MODULE$.println((Object)model);
                }
                double trainMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)training2);
                Predef$.MODULE$.println((Object)("Train mean squared error = " + trainMSE));
                double testMSE = this.meanSquaredError(model, (RDD<LabeledPoint>)test2);
                Predef$.MODULE$.println((Object)("Test mean squared error = " + testMSE));
            }
        }
        sc.stop();
    }

    public double meanSquaredError(RandomForestModel model, RDD<LabeledPoint> data) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1 & Serializable)y -> BoxesRunTime.boxToDouble((double)DecisionTreeRunner$.$anonfun$meanSquaredError$1(model, y)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    public double meanSquaredError(DecisionTreeModel model, RDD<LabeledPoint> data) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1 & Serializable)y -> BoxesRunTime.boxToDouble((double)DecisionTreeRunner$.$anonfun$meanSquaredError$2(model, y)), (ClassTag)ClassTag$.MODULE$.Double())).mean();
    }

    public static final /* synthetic */ double $anonfun$meanSquaredError$1(RandomForestModel model$3, LabeledPoint y) {
        double err = model$3.predict(y.features()) - y.label();
        return err * err;
    }

    public static final /* synthetic */ double $anonfun$meanSquaredError$2(DecisionTreeModel model$4, LabeledPoint y) {
        double err = model$4.predict(y.features()) - y.label();
        return err * err;
    }

    private DecisionTreeRunner$() {
    }
}

