/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.Serializable;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.runtime.BoxedUnit;

public final class MulticlassLogisticRegressionWithElasticNetExample$ {
    public static final MulticlassLogisticRegressionWithElasticNetExample$ MODULE$ = new MulticlassLogisticRegressionWithElasticNetExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MulticlassLogisticRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)("Coefficients: \n" + lrModel.coefficientMatrix()));
        Predef$.MODULE$.println((Object)("Intercepts: \n" + lrModel.interceptVector()));
        LogisticRegressionTrainingSummary trainingSummary = lrModel.summary();
        double[] objectiveHistory = trainingSummary.objectiveHistory();
        Predef$.MODULE$.println((Object)"objectiveHistory:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(objectiveHistory), (Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"False positive rate by label:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(trainingSummary.falsePositiveRateByLabel()))), (Function1 & Serializable)x0$1 -> {
            MulticlassLogisticRegressionWithElasticNetExample$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"True positive rate by label:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(trainingSummary.truePositiveRateByLabel()))), (Function1 & Serializable)x0$2 -> {
            MulticlassLogisticRegressionWithElasticNetExample$.$anonfun$main$3(x0$2);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Precision by label:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(trainingSummary.precisionByLabel()))), (Function1 & Serializable)x0$3 -> {
            MulticlassLogisticRegressionWithElasticNetExample$.$anonfun$main$4(x0$3);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Recall by label:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(trainingSummary.recallByLabel()))), (Function1 & Serializable)x0$4 -> {
            MulticlassLogisticRegressionWithElasticNetExample$.$anonfun$main$5(x0$4);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"F-measure by label:");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(trainingSummary.fMeasureByLabel()))), (Function1 & Serializable)x0$5 -> {
            MulticlassLogisticRegressionWithElasticNetExample$.$anonfun$main$6(x0$5);
            return BoxedUnit.UNIT;
        });
        double accuracy = trainingSummary.accuracy();
        double falsePositiveRate = trainingSummary.weightedFalsePositiveRate();
        double truePositiveRate = trainingSummary.weightedTruePositiveRate();
        double fMeasure = trainingSummary.weightedFMeasure();
        double precision = trainingSummary.weightedPrecision();
        double recall = trainingSummary.weightedRecall();
        Predef$.MODULE$.println((Object)("Accuracy: " + accuracy + "\nFPR: " + falsePositiveRate + "\nTPR: " + truePositiveRate + "\nF-measure: " + fMeasure + "\nPrecision: " + precision + "\nRecall: " + recall));
        spark.stop();
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double rate = tuple2._1$mcD$sp();
            int label = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("label " + label + ": " + rate));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double rate = tuple2._1$mcD$sp();
            int label = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("label " + label + ": " + rate));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            double prec = tuple2._1$mcD$sp();
            int label = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("label " + label + ": " + prec));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$5(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            double rec = tuple2._1$mcD$sp();
            int label = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("label " + label + ": " + rec));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$main$6(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            double f = tuple2._1$mcD$sp();
            int label = tuple2._2$mcI$sp();
            Predef$.MODULE$.println((Object)("label " + label + ": " + f));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private MulticlassLogisticRegressionWithElasticNetExample$() {
    }
}

