/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;

final class ReservoirSize {
    static final int BINS_PER_OCTAVE = 2048;
    private static final double INV_BINS_PER_OCTAVE = 4.8828125E-4;
    private static final double INV_LN_2 = 1.0 / Math.log(2.0);
    private static final int EXPONENT_MASK = 31;
    private static final int EXPONENT_SHIFT = 11;
    private static final int INDEX_MASK = 2047;
    private static final int OUTPUT_MASK = 65535;
    private static final int MAX_ABS_VALUE = 2146959360;
    private static final int MAX_ENC_VALUE = 63487;

    private ReservoirSize() {
    }

    public static short computeSize(int k) {
        if (k < 1 || k > 2146959360) {
            throw new SketchesArgumentException("Can only encode strictly positive sketch sizes less than 2146959360, found: " + k);
        }
        int p = Util.exactLog2OfInt(Util.floorPowerOf2(k), "computeSize: p");
        if (Util.isPowerOf2(k)) {
            return (short)((p & 0x1F) << 11 & 0xFFFF);
        }
        double m = Math.pow(2.0, Math.log(k) * INV_LN_2 - (double)p);
        int i = (int)Math.floor(m * 2048.0) - 2048 + 1;
        if (i == 2048) {
            return (short)((p + 1 & 0x1F) << 11 & 0xFFFF);
        }
        return (short)((p & 0x1F) << 11 | i & 0x7FF & 0xFFFF);
    }

    public static int decodeValue(short encodedSize) {
        int value = encodedSize & 0xFFFF;
        if (value > 63487) {
            throw new SketchesArgumentException("Maximum valid encoded value is " + Integer.toHexString(63487) + ", found: " + value);
        }
        int p = value >>> 11 & 0x1F;
        int i = value & 0x7FF;
        return (int)((double)(1 << p) * ((double)i * 4.8828125E-4 + 1.0));
    }
}

