/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.ChangeNotifyingArrayList;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.CDataNode;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Comment;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.DataNode;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.NodeUtils;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Range;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.parser.Tag;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.select.Elements;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.select.NodeTraversor;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.select.NodeVisitor;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.select.Selector;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class Element
extends Node {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    private static final String BaseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private @Nullable WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    @Nullable Attributes attributes;

    public Element(String tag) {
        this(Tag.valueOf(tag, "http://www.w3.org/1999/xhtml", ParseSettings.preserveCase), "", null);
    }

    public Element(Tag tag, @Nullable String baseUri, @Nullable Attributes attributes) {
        Validate.notNull(tag);
        this.childNodes = EmptyNodes;
        this.attributes = attributes;
        this.tag = tag;
        if (baseUri != null) {
            this.setBaseUri(baseUri);
        }
    }

    public Element(Tag tag, @Nullable String baseUri) {
        this(tag, baseUri, null);
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodes) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, BaseUriKey);
    }

    private static String searchUpForAttribute(Element start, String key) {
        for (Element el = start; el != null; el = el.parent()) {
            if (el.attributes == null || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    @Override
    protected void doSetBaseUri(String baseUri) {
        this.attributes().put(BaseUriKey, baseUri);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    @Override
    public String normalName() {
        return this.tag.normalName();
    }

    public boolean elementIs(String normalName, String namespace) {
        return this.tag.normalName().equals(normalName) && this.tag.namespace().equals(namespace);
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        return this.attributes != null ? this.attributes.getIgnoreCase("id") : "";
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    @Override
    public final @Nullable Element parent() {
        return (Element)this.parentNode;
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    List<Element> childElementsList() {
        ArrayList<Element> children;
        if (this.childNodeSize() == 0) {
            return EmptyChildren;
        }
        if (this.shadowChildrenRef == null || (children = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size = this.childNodes.size();
            children = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children);
        }
        return children;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public Stream<Element> stream() {
        return NodeUtils.stream(this, Element.class);
    }

    private <T> List<T> filterNodes(Class<T> clazz) {
        return this.childNodes.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<TextNode> textNodes() {
        return this.filterNodes(TextNode.class);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Element appendChild(Node child) {
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        child.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    public Element appendChildren(Collection<? extends Node> children) {
        this.insertChildren(-1, children);
        return this;
    }

    public Element insertChildren(int index, Collection<? extends Node> children) {
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = this.childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= currentSize, "Insert position out of bounds.");
        ArrayList<? extends Node> nodes = new ArrayList<Node>(children);
        Node[] nodeArray = nodes.toArray(new Node[0]);
        this.addChildren(index, nodeArray);
        return this;
    }

    public Element appendElement(String tagName) {
        return this.appendElement(tagName, this.tag.namespace());
    }

    public Element appendElement(String tagName, String namespace) {
        Element child = new Element(Tag.valueOf(tagName, namespace, NodeUtils.parser(this).settings()), this.baseUri());
        this.appendChild(child);
        return child;
    }

    @Override
    public Element before(Node node) {
        return (Element)super.before(node);
    }

    @Override
    public Element empty() {
        for (Node child : this.childNodes) {
            child.parentNode = null;
        }
        this.childNodes.clear();
        return this;
    }

    public Elements siblingElements() {
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        for (Element el : elements) {
            if (el == this) continue;
            siblings.add(el);
        }
        return siblings;
    }

    public @Nullable Element nextElementSibling() {
        Node next = this;
        while ((next = next.nextSibling()) != null) {
            if (!(next instanceof Element)) continue;
            return next;
        }
        return null;
    }

    public @Nullable Element previousElementSibling() {
        Node prev = this;
        while ((prev = prev.previousSibling()) != null) {
            if (!(prev instanceof Element)) continue;
            return prev;
        }
        return null;
    }

    public Element firstElementSibling() {
        if (this.parent() != null) {
            return this.parent().firstElementChild();
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().childElementsList());
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public @Nullable Element firstElementChild() {
        for (Node child = this.firstChild(); child != null; child = child.nextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public @Nullable Element lastElementChild() {
        for (Node child = this.lastChild(); child != null; child = child.previousSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public String text() {
        StringBuilder accum2 = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new TextAccumulator(accum2), this);
        return StringUtil.releaseBuilder(accum2).trim();
    }

    public String wholeText() {
        return Element.wholeTextOf(this.nodeStream());
    }

    private static String wholeTextOf(Stream<Node> stream) {
        return stream.map(node -> {
            if (node instanceof TextNode) {
                return ((TextNode)node).getWholeText();
            }
            if (node.nameIs("br")) {
                return "\n";
            }
            return "";
        }).collect(StringUtil.joining(""));
    }

    public String wholeOwnText() {
        return Element.wholeTextOf(this.childNodes.stream());
    }

    public String ownText() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder(sb).trim();
    }

    private void ownText(StringBuilder accum2) {
        for (int i = 0; i < this.childNodeSize(); ++i) {
            Node child = this.childNodes.get(i);
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum2, textNode);
                continue;
            }
            if (!child.nameIs("br") || TextNode.lastCharIsWhitespace(accum2)) continue;
            accum2.append(" ");
        }
    }

    private static void appendNormalisedText(StringBuilder accum2, TextNode textNode) {
        String text2 = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || textNode instanceof CDataNode) {
            accum2.append(text2);
        } else {
            StringUtil.appendNormalisedWhitespace(accum2, text2, TextNode.lastCharIsWhitespace(accum2));
        }
    }

    static boolean preserveWhitespace(@Nullable Node node) {
        if (node instanceof Element) {
            Element el = (Element)node;
            int i = 0;
            do {
                if (el.tag.preserveWhitespace()) {
                    return true;
                }
                el = el.parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    public String data() {
        StringBuilder sb = StringUtil.borrowBuilder();
        this.traverse((childNode, depth) -> {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
            } else if (childNode instanceof Comment) {
                Comment comment = (Comment)childNode;
                sb.append(comment.getData());
            } else if (childNode instanceof CDataNode) {
                CDataNode cDataNode = (CDataNode)childNode;
                sb.append(cDataNode.getWholeText());
            }
        });
        return StringUtil.releaseBuilder(sb);
    }

    public boolean hasClass(String className) {
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && len - start == wantLen) {
            return classAttr.regionMatches(true, start, className, 0, wantLen);
        }
        return false;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    boolean shouldIndent(Document.OutputSettings out) {
        return out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable(out) && !Element.preserveWhitespace(this.parentNode);
    }

    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        if (this.shouldIndent(out)) {
            if (accum2 instanceof StringBuilder) {
                if (((StringBuilder)accum2).length() > 0) {
                    this.indent(accum2, depth, out);
                }
            } else {
                this.indent(accum2, depth, out);
            }
        }
        accum2.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum2, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            if (out.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum2.append('>');
            } else {
                accum2.append(" />");
            }
        } else {
            accum2.append('>');
        }
    }

    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() && !Element.preserveWhitespace(this.parentNode) || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && this.childNodes.get(0) instanceof Element))) {
                this.indent(accum2, depth, out);
            }
            accum2.append("</").append(this.tagName()).append('>');
        }
    }

    public String html() {
        StringBuilder accum2 = StringUtil.borrowBuilder();
        this.html(accum2);
        String html = StringUtil.releaseBuilder(accum2);
        return NodeUtils.outputSettings(this).prettyPrint() ? html.trim() : html;
    }

    @Override
    public <T extends Appendable> T html(T appendable) {
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return appendable;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    @Override
    protected Element doClone(@Nullable Node parent) {
        Element clone = (Element)super.doClone(parent);
        clone.attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.childNodes = new NodeList(clone, this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        return clone;
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        return (Element)super.traverse(nodeVisitor);
    }

    private boolean isFormatAsBlock(Document.OutputSettings out) {
        return this.tag.isBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || out.outline();
    }

    private boolean isInlineable(Document.OutputSettings out) {
        if (!this.tag.isInline()) {
            return false;
        }
        return (this.parent() == null || this.parent().isBlock()) && !this.isEffectivelyFirst() && !out.outline() && !this.nameIs("br");
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        NodeList(Element owner, int initialCapacity) {
            super(initialCapacity);
            this.owner = owner;
        }

        @Override
        public void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }

    private static class TextAccumulator
    implements NodeVisitor {
        private final StringBuilder accum;

        public TextAccumulator(StringBuilder accum2) {
            this.accum = accum2;
        }

        @Override
        public void head(Node node, int depth) {
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                Element.appendNormalisedText(this.accum, textNode);
            } else if (node instanceof Element) {
                Element element = (Element)node;
                if (this.accum.length() > 0 && (element.isBlock() || element.nameIs("br")) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }

        @Override
        public void tail(Node node, int depth) {
            if (node instanceof Element) {
                Element element = (Element)node;
                Node next = node.nextSibling();
                if (element.isBlock() && (next instanceof TextNode || next instanceof Element && !((Element)next).tag.formatAsBlock()) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }
    }
}

