/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.read.streaming;

import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.read.streaming.CompositeReadLimit;
import org.apache.spark.sql.connector.read.streaming.ReadAllAvailable;
import org.apache.spark.sql.connector.read.streaming.ReadMaxBytes;
import org.apache.spark.sql.connector.read.streaming.ReadMaxFiles;
import org.apache.spark.sql.connector.read.streaming.ReadMaxRows;
import org.apache.spark.sql.connector.read.streaming.ReadMinRows;

@Evolving
public interface ReadLimit {
    public static ReadLimit minRows(long rows, long maxTriggerDelayMs) {
        return new ReadMinRows(rows, maxTriggerDelayMs);
    }

    public static ReadLimit maxRows(long rows) {
        return new ReadMaxRows(rows);
    }

    public static ReadLimit maxFiles(int files) {
        return new ReadMaxFiles(files);
    }

    public static ReadLimit maxBytes(long bytes) {
        return new ReadMaxBytes(bytes);
    }

    public static ReadLimit allAvailable() {
        return ReadAllAvailable.INSTANCE;
    }

    public static ReadLimit compositeLimit(ReadLimit[] readLimits) {
        return new CompositeReadLimit(readLimits);
    }
}

