/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")A\u000b\u0001C!+\")q\f\u0001C!!\")\u0001\r\u0001C)C\")q\r\u0001C!Q\")a\u000f\u0001C)o\"9!\u0010AA\u0001\n\u0003Y\bbB?\u0001#\u0003%\tA \u0005\n\u0003'\u0001\u0011\u0011!C!\u0003+A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\tI\u0005AA\u0001\n\u0003\tY\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0013qK\u0004\n\u0003wZ\u0012\u0011!E\u0001\u0003{2\u0001BG\u000e\u0002\u0002#\u0005\u0011q\u0010\u0005\u0007\u0017R!\t!a&\t\u0013\u0005eE#!A\u0005F\u0005m\u0005\"CAO)\u0005\u0005I\u0011QAP\u0011%\t\u0019\u000bFA\u0001\n\u0003\u000b)\u000bC\u0005\u00022R\t\t\u0011\"\u0003\u00024\n!1\u000b[12\u0015\taR$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0010 \u0003!\u0019\u0017\r^1msN$(B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011C\u0002\u0001*[A\u001a\u0014\b\u0005\u0002+W5\t1$\u0003\u0002-7\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002+]%\u0011qf\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011!&M\u0005\u0003em\u0011\u0001\u0005R3gCVdGo\u0015;sS:<\u0007K]8ek\u000eLgnZ#yaJ,7o]5p]B\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t9\u0001K]8ek\u000e$\bC\u0001\u001eC\u001d\tY\u0004I\u0004\u0002=\u007f5\tQH\u0003\u0002?O\u00051AH]8pizJ\u0011AN\u0005\u0003\u0003V\nq\u0001]1dW\u0006<W-\u0003\u0002D\t\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011)N\u0001\u0006G\"LG\u000eZ\u000b\u0002\u000fB\u0011!\u0006S\u0005\u0003\u0013n\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"!\u0014(\u0011\u0005)\u0002\u0001\"B#\u0004\u0001\u00049\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002#B\u0011AGU\u0005\u0003'V\u0012qAQ8pY\u0016\fg.\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0016\t\u0004u]K\u0016B\u0001-E\u0005\r\u0019V-\u001d\t\u00035vk\u0011a\u0017\u0006\u00039~\tQ\u0001^=qKNL!AX.\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\fAB\\;mYN\u000bg-Z#wC2$\"AY3\u0011\u0005Q\u001a\u0017B\u000136\u0005\r\te.\u001f\u0005\u0006M\u001e\u0001\rAY\u0001\u0006S:\u0004X\u000f^\u0001\nI><UM\\\"pI\u0016$2![8u!\tQW.D\u0001l\u0015\ta7$A\u0004d_\u0012,w-\u001a8\n\u00059\\'\u0001C#yaJ\u001cu\u000eZ3\t\u000bAD\u0001\u0019A9\u0002\u0007\r$\b\u0010\u0005\u0002ke&\u00111o\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015)\b\u00021\u0001j\u0003\t)g/\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003\u001bbDQ!_\u0005A\u0002\u001d\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002Ny\"9QI\u0003I\u0001\u0002\u00049\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u007f*\u001aq)!\u0001,\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00046\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\t9AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA\u0001\\1oO*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005m!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,A\u0019A'!\f\n\u0007\u0005=RGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002c\u0003kA\u0011\"a\u000e\u000f\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004E\u0003\u0002@\u0005\u0015#-\u0004\u0002\u0002B)\u0019\u00111I\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!UA'\u0011!\t9\u0004EA\u0001\u0002\u0004\u0011\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0006\u0002T!I\u0011qG\t\u0002\u0002\u0003\u0007\u00111F\u0001\u0007KF,\u0018\r\\:\u0015\u0007E\u000bI\u0006\u0003\u0005\u00028I\t\t\u00111\u0001cQM\u0001\u0011QLA2\u0003K\nI'a\u001b\u0002p\u0005E\u0014QOA<!\rQ\u0013qL\u0005\u0004\u0003CZ\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003O\nqi\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAMD\u0017-\r\u0011iCND\u0007E^1mk\u0016\u0004\u0013m\u001d\u0011bA!,\u0007\u0010I:ue&tw\rI8gAQDW\r\t1fqB\u0014\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QN\u0001b\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001d6MVJT'\u000e45EJ:\u0014-O15GJ\n\u0017M\u0019\u001cgM\u0016,DmN\u00199s\u0019\u001c''\u000f\u001dcsI\u001a'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0014!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA=\u0003)A\u0017m\u001d5`MVt7m]\u0001\u0005'\"\f\u0017\u0007\u0005\u0002+)M)A#!!\u0002\u000eB1\u00111QAE\u000f6k!!!\"\u000b\u0007\u0005\u001dU'A\u0004sk:$\u0018.\\3\n\t\u0005-\u0015Q\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAH\u0003+k!!!%\u000b\t\u0005M\u0015qD\u0001\u0003S>L1aQAI)\t\ti(\u0001\u0005u_N#(/\u001b8h)\t\t9\"A\u0003baBd\u0017\u0010F\u0002N\u0003CCQ!R\fA\u0002\u001d\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002(\u00065\u0006\u0003\u0002\u001b\u0002*\u001eK1!a+6\u0005\u0019y\u0005\u000f^5p]\"A\u0011q\u0016\r\u0002\u0002\u0003\u0007Q*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!.\u0011\t\u0005e\u0011qW\u0005\u0005\u0003s\u000bYB\u0001\u0004PE*,7\r\u001e")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 x$0) {
        return Sha1$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> g) {
        return Sha1$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Sha1> compose(Function1<A$, Expression> g) {
        return Sha1$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "UTF8String.fromString(" + DigestUtils.class.getName() + ".sha1Hex(" + c + "))");
    }

    @Override
    public Sha1 withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

