/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Levenshtein$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str1, str2[, threshold]) - Returns the Levenshtein distance between the two given strings. If threshold is set and distance more than it, return -1.", examples="\n    Examples:\n      > SELECT _FUNC_('kitten', 'sitting');\n       3\n      > SELECT _FUNC_('kitten', 'sitting', 2);\n       -1\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=c\u0001B\u0016-\u0001fB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t+\u0002\u0011\t\u0012)A\u0005u!Aa\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003;\u0011!A\u0006A!f\u0001\n\u0003I\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002.\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000by\u0003A\u0011\u00015\t\u000b-\u0004A\u0011\t7\t\u000bM\u0004A\u0011\t;\t\u000by\u0004A\u0011I@\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011Q\u0002\u0001\u0005R\u0005=\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003K\u0001A\u0011IA\u000f\u0011\u001d\t9\u0003\u0001C!\u0003;Aq!!\u000b\u0001\t\u0003\ni\u0002C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"! \u0001#\u0003%\t!a \t\u0013\u0005U\u0005!%A\u0005\u0002\u0005}\u0004\"CAL\u0001E\u0005I\u0011AAM\u0011%\ti\nAA\u0001\n\u0003\ny\nC\u0005\u00022\u0002\t\t\u0011\"\u0001\u00024\"I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0007\u0004\u0011\u0011!C!\u0003\u000bD\u0011\"a5\u0001\u0003\u0003%\t!!6\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u000f%\u0011)\u0001LA\u0001\u0012\u0003\u00119A\u0002\u0005,Y\u0005\u0005\t\u0012\u0001B\u0005\u0011\u0019q6\u0005\"\u0001\u0003\"!I!1E\u0012\u0002\u0002\u0013\u0015#Q\u0005\u0005\n\u0005O\u0019\u0013\u0011!CA\u0005SA\u0011B!\r$#\u0003%\t!!'\t\u0013\tM2%!A\u0005\u0002\nU\u0002\"\u0003B\"GE\u0005I\u0011AAM\u0011%\u0011)eIA\u0001\n\u0013\u00119EA\u0006MKZ,gn\u001d5uK&t'BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\u0002\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Qd(Q$\u0011\u0005mbT\"\u0001\u0017\n\u0005ub#AC#yaJ,7o]5p]B\u00111hP\u0005\u0003\u00012\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b!J|G-^2u!\tA\u0005K\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011A\nO\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!aT\"\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u001f\u000e\u000bA\u0001\\3giV\t!(A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012A\u0017\t\u0004\u0005nS\u0014B\u0001/D\u0005\u0019y\u0005\u000f^5p]\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\u0011\u0001\u0017MY2\u0011\u0005m\u0002\u0001\"B*\b\u0001\u0004Q\u0004\"\u0002,\b\u0001\u0004Q\u0004b\u0002-\b!\u0003\u0005\rA\u0017\u000b\u0005A\u00164w\rC\u0003T\u0011\u0001\u0007!\bC\u0003W\u0011\u0001\u0007!\bC\u0003Y\u0011\u0001\u0007!\bF\u0002aS*DQaU\u0005A\u0002iBQAV\u0005A\u0002i\n1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003a:\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003e>\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A;\u0011\u0007!3\b0\u0003\u0002x%\n\u00191+Z9\u0011\u0005edX\"\u0001>\u000b\u0005m\u0004\u0014!\u0002;za\u0016\u001c\u0018BA?{\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005dQ&dGM]3o+\t\t\t\u0001E\u0002Imj\n\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u000f\u00012!_A\u0005\u0013\r\tYA\u001f\u0002\t\t\u0006$\u0018\rV=qK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004u\u0005E\u0001bBA\n\u001d\u0001\u0007\u0011QC\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003I\u0003/Q\u0014bAA\r%\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\u00119,H\u000e\\1cY\u0016,\"!a\b\u0011\u0007\t\u000b\t#C\u0002\u0002$\r\u0013qAQ8pY\u0016\fg.\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0002\u0011\u0019|G\u000eZ1cY\u0016\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\fA!\u001a<bYR!\u0011qFA\u001b!\r\u0011\u0015\u0011G\u0005\u0004\u0003g\u0019%aA!os\"I\u0011qG\n\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003w\ti$D\u0001/\u0013\r\tyD\f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011QIA)\u00037\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017b\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u001f\nIE\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\u0019\u0006\u0006a\u0001\u0003+\n1a\u0019;y!\u0011\t9%a\u0016\n\t\u0005e\u0013\u0011\n\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\ti\u0006\u0006a\u0001\u0003\u000b\n!!\u001a<\u0002)\u001d,gnQ8eK^KG\u000f\u001b+ie\u0016\u001c\bn\u001c7e)!\t)%a\u0019\u0002f\u0005\u001d\u0004bBA*+\u0001\u0007\u0011Q\u000b\u0005\b\u0003;*\u0002\u0019AA#\u0011\u0019\tI'\u0006a\u0001u\u0005iA\u000f\u001b:fg\"|G\u000eZ#yaJ\fqcZ3o\u0007>$WmV5uQ>,H\u000f\u00165sKNDw\u000e\u001c3\u0015\r\u0005\u0015\u0013qNA9\u0011\u001d\t\u0019F\u0006a\u0001\u0003+Bq!!\u0018\u0017\u0001\u0004\t)%\u0001\u0003d_BLHc\u00021\u0002x\u0005e\u00141\u0010\u0005\b'^\u0001\n\u00111\u0001;\u0011\u001d1v\u0003%AA\u0002iBq\u0001W\f\u0011\u0002\u0003\u0007!,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005%f\u0001\u001e\u0002\u0004.\u0012\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019*!#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0014\u0016\u00045\u0006\r\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\"B!\u00111UAW\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016\u0001\u00027b]\u001eT!!a+\u0002\t)\fg/Y\u0005\u0005\u0003_\u000b)K\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003k\u00032AQA\\\u0013\r\tIl\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\ty\fC\u0005\u0002Bv\t\t\u00111\u0001\u00026\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a2\u0011\r\u0005%\u0017qZA\u0018\u001b\t\tYMC\u0002\u0002N\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t.a3\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003?\t9\u000eC\u0005\u0002B~\t\t\u00111\u0001\u00020\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\t+!8\t\u0013\u0005\u0005\u0007%!AA\u0002\u0005U\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002 \u0005\r\b\"CAaC\u0005\u0005\t\u0019AA\u0018QM\u0001\u0011q]Aw\u0003_\f\u00190!>\u0002z\u0006m\u0018q B\u0001!\rY\u0014\u0011^\u0005\u0004\u0003Wd#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003c\f\u0011\u0011\t\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:2Y\u0001\u001aHO\u001d\u001a\\Y\u0001\"\bN]3tQ>dG-X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!\u0019\u00164XM\\:ii\u0016Lg\u000e\t3jgR\fgnY3!E\u0016$x/Z3oAQDW\r\t;x_\u0002:\u0017N^3oAM$(/\u001b8hg:\u0002\u0013J\u001a\u0011uQJ,7\u000f[8mI\u0002J7\u000fI:fi\u0002\ng\u000e\u001a\u0011eSN$\u0018M\\2fA5|'/\u001a\u0011uQ\u0006t\u0007%\u001b;-AI,G/\u001e:oA5\nd&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t90A@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ\u0017\u000e\u001e;f]\u001eb\u0003eJ:jiRLgnZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014lSR$XM\\\u0014-A\u001d\u001a\u0018\u000e\u001e;j]\u001e<C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti0A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0003\u0004\u0005a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006YA*\u001a<f]NDG/Z5o!\tY4eE\u0003$\u0005\u0017\u00119\u0002\u0005\u0005\u0003\u000e\tM!H\u000f.a\u001b\t\u0011yAC\u0002\u0003\u0012\r\u000bqA];oi&lW-\u0003\u0003\u0003\u0016\t=!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!\u0011\u0004B\u0010\u001b\t\u0011YB\u0003\u0003\u0003\u001e\u0005%\u0016AA5p\u0013\r\t&1\u0004\u000b\u0003\u0005\u000f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\u000bQ!\u00199qYf$r\u0001\u0019B\u0016\u0005[\u0011y\u0003C\u0003TM\u0001\u0007!\bC\u0003WM\u0001\u0007!\bC\u0004YMA\u0005\t\u0019\u0001.\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00038\t}\u0002\u0003\u0002\"\\\u0005s\u0001bA\u0011B\u001euiR\u0016b\u0001B\u001f\u0007\n1A+\u001e9mKNB\u0001B!\u0011)\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003JA!\u00111\u0015B&\u0013\u0011\u0011i%!*\u0003\r=\u0013'.Z2u\u0001")
public class Levenshtein
extends Expression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<Expression> threshold;

    public static Option<Expression> $lessinit$greater$default$3() {
        return Levenshtein$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(Levenshtein x$0) {
        return Levenshtein$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$3() {
        return Levenshtein$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, Levenshtein> tupled() {
        return Levenshtein$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, Levenshtein>>> curried() {
        return Levenshtein$.MODULE$.curried();
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Option<Expression> threshold() {
        return this.threshold;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().length() > 3 || this.children().length() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression value = (Expression)some.value();
            return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.nullable()));
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.foldable()));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.contextIndependentFoldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Object leftEval = this.left().eval(input);
        if (leftEval == null) {
            return null;
        }
        Object rightEval = this.right().eval(input);
        if (rightEval == null) {
            return null;
        }
        Option thresholdEval = this.threshold().map((Function1 & Serializable)x$31 -> x$31.eval(input));
        Option option = thresholdEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval, BoxesRunTime.unboxToInt((Object)v)));
        }
        return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.genCodeWithThreshold(ctx, ev, (Expression)this.children().apply(2));
        }
        return this.genCodeWithoutThreshold(ctx, ev);
    }

    private ExprCode genCodeWithThreshold(CodegenContext ctx, ExprCode ev, Expression thresholdExpr) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thresholdGen = thresholdExpr.genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ", " + thresholdGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), thresholdGen.code().toString() + ctx.nullSafeExec(thresholdExpr.nullable(), ExprValue$.MODULE$.exprValueToString(thresholdGen.isNull()), "\n                  " + ev.isNull() + " = false;\n                  " + resultCode + "\n                 ")));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code()).$plus(thresholdGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private ExprCode genCodeWithoutThreshold(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), "\n              " + ev.isNull() + " = false;\n              " + resultCode + "\n             "));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Levenshtein copy(Expression left, Expression right, Option<Expression> threshold) {
        return new Levenshtein(left, right, threshold);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Expression> copy$default$3() {
        return this.threshold();
    }

    @Override
    public String productPrefix() {
        return "Levenshtein";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.threshold();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Levenshtein;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "threshold";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Levenshtein)) return false;
        boolean bl = true;
        if (!bl) return false;
        Levenshtein levenshtein = (Levenshtein)x$1;
        Expression expression = this.left();
        Expression expression2 = levenshtein.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = levenshtein.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.threshold();
        Option<Expression> option2 = levenshtein.threshold();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!levenshtein.canEqual(this)) return false;
        return true;
    }

    public Levenshtein(Expression left, Expression right, Option<Expression> threshold) {
        this.left = left;
        this.right = right;
        this.threshold = threshold;
        ExpectsInputTypes.$init$(this);
    }

    public Levenshtein(Expression left, Expression right, Expression threshold) {
        this(left, right, (Option<Expression>)Option$.MODULE$.apply((Object)threshold));
    }

    public Levenshtein(Expression left, Expression right) {
        this(left, right, (Option<Expression>)None$.MODULE$);
    }
}

