/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CurrentTime$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_([precision]) - Returns the current time at the start of query evaluation.\n    All calls of current_time within the same query return the same value.\n\n    _FUNC_ - Returns the current time at the start of query evaluation.\n  ", arguments="\n    Arguments:\n      * precision - An optional integer literal in the range [0..6], indicating how many\n                    fractional digits of seconds to include. If omitted, the default is 6.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       15:49:11.914120\n      > SELECT _FUNC_;\n       15:49:11.914120\n      > SELECT _FUNC_(0);\n       15:49:11\n      > SELECT _FUNC_(3);\n       15:49:11.914\n      > SELECT _FUNC_(1+1);\n       15:49:11.91\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tC\u0002\u0011\t\u0012)A\u0005=\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005p\u0001\tE\t\u0015!\u0003e\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015\u0001\b\u0001\"\u0001v\u0011\u0015\u0001\b\u0001\"\u0001w\u0011\u0015A\b\u0001\"\u0012z\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\f\u0001\t\u0003\n9\u0003C\u0004\u00022\u0001!\t%a\r\t\u0015\u0005\u0005\u0003\u0001#b\u0001\n\u0003\t\u0019\u0005C\u0004\u0002L\u0001!\t%!\u0014\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA3\u0001\u0011E\u0013q\r\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\tI\b\u0001C!\u0003wB\u0011\"a$\u0001\u0003\u0003%\t!!%\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005e\u0005\"CAX\u0001E\u0005I\u0011AAY\u0011%\t)\fAA\u0001\n\u0003\n9\fC\u0005\u0002H\u0002\t\t\u0011\"\u0001\u0002D!I\u0011\u0011\u001a\u0001\u0002\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"!9\u0001\u0003\u0003%\t!a9\t\u0013\u0005\u001d\b!!A\u0005B\u0005%\b\"CAw\u0001\u0005\u0005I\u0011IAx\u000f%\u0011I\"KA\u0001\u0012\u0003\u0011YB\u0002\u0005)S\u0005\u0005\t\u0012\u0001B\u000f\u0011\u0019\u0001h\u0004\"\u0001\u00036!I!q\u0007\u0010\u0002\u0002\u0013\u0015#\u0011\b\u0005\n\u0005wq\u0012\u0011!CA\u0005{A\u0011Ba\u0011\u001f#\u0003%\t!!'\t\u0013\t\u0015c$%A\u0005\u0002\u0005E\u0006\"\u0003B$=\u0005\u0005I\u0011\u0011B%\u0011%\u00119FHI\u0001\n\u0003\tI\nC\u0005\u0003Zy\t\n\u0011\"\u0001\u00022\"I!1\f\u0010\u0002\u0002\u0013%!Q\f\u0002\f\u0007V\u0014(/\u001a8u)&lWM\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'!\u0001qg\u000f B\u000f*\u0003\u0006C\u0001\u001d:\u001b\u0005I\u0013B\u0001\u001e*\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d=\u0013\ti\u0014FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0001hP\u0005\u0003\u0001&\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t&\nqaY8eK\u001e,g.\u0003\u0002G\u0007\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u00029\u0011&\u0011\u0011*\u000b\u0002\u000f)&lW-\u0012=qe\u0016\u001c8/[8o!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u001d\u0001&o\u001c3vGR\u0004\"!U-\u000f\u0005I;fBA*W\u001b\u0005!&BA+6\u0003\u0019a$o\\8u}%\tQ*\u0003\u0002Y\u0019\u00069\u0001/Y2lC\u001e,\u0017B\u0001.\\\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tAF*A\u0003dQ&dG-F\u0001_!\tAt,\u0003\u0002aS\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002IB\u00191*Z4\n\u0005\u0019d%AB(qi&|g\u000e\u0005\u0002iY:\u0011\u0011N\u001b\t\u0003'2K!a\u001b'\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003W2\u000b1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"2A]:u!\tA\u0004\u0001C\u0004]\u000bA\u0005\t\u0019\u00010\t\u000f\t,\u0001\u0013!a\u0001IR\t!\u000f\u0006\u0002so\")Al\u0002a\u0001=\u0006!bn\u001c3f!\u0006$H/\u001a:og&sG/\u001a:oC2$\u0012A\u001f\t\u0004#nl\u0018B\u0001?\\\u0005\r\u0019V-\u001d\t\u0004}\u0006}abA@\u0002\u001a9!\u0011\u0011AA\u000b\u001d\u0011\t\u0019!a\u0005\u000f\t\u0005\u0015\u0011\u0011\u0003\b\u0005\u0003\u000f\tyA\u0004\u0003\u0002\n\u00055abA*\u0002\f%\tA'\u0003\u00023g%\u0011\u0001'M\u0005\u0003]=J!\u0001L\u0017\n\u0007\u0005]1&A\u0003ue\u0016,7/\u0003\u0003\u0002\u001c\u0005u\u0011a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T1!a\u0006,\u0013\u0011\t\t#a\t\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0005\u00037\ti\"\u0001\u0005ok2d\u0017M\u00197f+\t\tI\u0003E\u0002L\u0003WI1!!\fM\u0005\u001d\u0011un\u001c7fC:\f\u0001BZ8mI\u0006\u0014G.Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wY\u0013\u0001C1oC2L8/[:\n\t\u0005}\u0012\u0011\b\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006I\u0001O]3dSNLwN\\\u000b\u0003\u0003\u000b\u00022aSA$\u0013\r\tI\u0005\u0014\u0002\u0004\u0013:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005US&A\u0003usB,7/\u0003\u0003\u0002Z\u0005M#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001h\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\rY\u00141\r\u0005\u0006E>\u0001\raZ\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007y\u000bI\u0007\u0003\u0004\u0002lA\u0001\rAX\u0001\t]\u0016<8\t[5mI\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005E\u0004\u0003B)|\u0003g\u0002B!!\u0015\u0002v%!\u0011qOA*\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0003fm\u0006dG\u0003BA?\u0003\u0007\u00032aSA@\u0013\r\t\t\t\u0014\u0002\u0004\u0003:L\b\"CAC%A\u0005\t\u0019AAD\u0003\u0015Ig\u000e];u!\u0011\tI)a#\u000e\u0003-J1!!$,\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\t\r|\u0007/\u001f\u000b\u0006e\u0006M\u0015Q\u0013\u0005\b9N\u0001\n\u00111\u0001_\u0011\u001d\u00117\u0003%AA\u0002\u0011\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c*\u001aa,!(,\u0005\u0005}\u0005\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!+M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\u000b\u0019KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00024*\u001aA-!(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\fAA[1wC&\u0019Q.!0\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QPAg\u0011%\ty\rGA\u0001\u0002\u0004\t)%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003+\u0004b!a6\u0002^\u0006uTBAAm\u0015\r\tY\u000eT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAp\u00033\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011FAs\u0011%\tyMGA\u0001\u0002\u0004\ti(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA]\u0003WD\u0011\"a4\u001c\u0003\u0003\u0005\r!!\u0012\u0002\r\u0015\fX/\u00197t)\u0011\tI#!=\t\u0013\u0005=G$!AA\u0002\u0005u\u0004f\u0006\u0001\u0002v\u0006m\u0018Q B\u0001\u0005\u0007\u00119A!\u0003\u0003\u000e\t=!1\u0003B\u000b!\rA\u0014q_\u0005\u0004\u0003sL#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\f\u0011\u0011\u001c\u0006!A\u0001\u0002sLR+O\u0007~C3\f\u001d:fG&\u001c\u0018n\u001c8^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aWO\u001d:f]R\u0004C/[7fA\u0005$\b\u0005\u001e5fAM$\u0018M\u001d;!_\u001a\u0004\u0013/^3ss\u0002*g/\u00197vCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003%\u00117mA\r\fG\u000e\\:!_\u001a\u00043-\u001e:sK:$x\f^5nK\u0002:\u0018\u000e\u001e5j]\u0002\"\b.\u001a\u0011tC6,\u0007%];fef\u0004#/\u001a;ve:\u0004C\u000f[3!g\u0006lW\r\t<bYV,gF\u0003\u0006!A\u0001\u0002sLR+O\u0007~\u0003S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043-\u001e:sK:$\b\u0005^5nK\u0002\nG\u000f\t;iK\u0002\u001aH/\u0019:uA=4\u0007%];fef\u0004SM^1mk\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0011)!AAG\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002\u0003O]3dSNLwN\u001c\u0011.A\u0005s\u0007e\u001c9uS>t\u0017\r\u001c\u0011j]R,w-\u001a:!Y&$XM]1mA%t\u0007\u0005\u001e5fAI\fgnZ3!7BrcFN/-A%tG-[2bi&tw\r\t5po\u0002j\u0017M\\=\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011ge\u0006\u001cG/[8oC2\u0004C-[4jiN\u0004sN\u001a\u0011tK\u000e|g\u000eZ:!i>\u0004\u0013N\\2mk\u0012,g\u0006I%gA=l\u0017\u000e\u001e;fI2\u0002C\u000f[3!I\u00164\u0017-\u001e7uA%\u001c\bE\u000e\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0017\t\u0011Q\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'\u000e\u001e5si\n\u0014GL\u001d2iE\u0012\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5iX\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c9J\u0014\u0007N\u00193a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cURD'\u000f\u001e2c9J\u0014\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)c-\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112ki\"\u0014HO\u00192]e\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\tE\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005/\tQ\u0001\u000e\u00182]A\n1bQ;se\u0016tG\u000fV5nKB\u0011\u0001HH\n\u0006=\t}!1\u0006\t\b\u0005C\u00119C\u00183s\u001b\t\u0011\u0019CC\u0002\u0003&1\u000bqA];oi&lW-\u0003\u0003\u0003*\t\r\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!Q\u0006B\u001a\u001b\t\u0011yC\u0003\u0003\u00032\u0005\u0005\u0017AA5p\u0013\rQ&q\u0006\u000b\u0003\u00057\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003s\u000bQ!\u00199qYf$RA\u001dB \u0005\u0003Bq\u0001X\u0011\u0011\u0002\u0003\u0007a\fC\u0004cCA\u0005\t\u0019\u00013\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\nq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YEa\u0015\u0011\t-+'Q\n\t\u0006\u0017\n=c\fZ\u0005\u0004\u0005#b%A\u0002+va2,'\u0007\u0003\u0005\u0003V\u0011\n\t\u00111\u0001s\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0006\u0005\u0003\u0002<\n\u0005\u0014\u0002\u0002B2\u0003{\u0013aa\u00142kK\u000e$\b")
public class CurrentTime
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
CodegenFallback,
TimeExpression,
Serializable {
    private int precision;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<String> $lessinit$greater$default$2() {
        return CurrentTime$.MODULE$.$lessinit$greater$default$2();
    }

    public static Expression $lessinit$greater$default$1() {
        return CurrentTime$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(CurrentTime x$0) {
        return CurrentTime$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$2() {
        return CurrentTime$.MODULE$.apply$default$2();
    }

    public static Expression apply$default$1() {
        return CurrentTime$.MODULE$.apply$default$1();
    }

    public static Function1<Tuple2<Expression, Option<String>>, CurrentTime> tupled() {
        return CurrentTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, CurrentTime>> curried() {
        return CurrentTime$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$TimeExpression$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.CURRENT_LIKE(), (List)Nil$.MODULE$);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean foldable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.child().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("precision")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.child().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.child()))}))));
        }
        Object precisionValue = this.child().eval(this.child().eval$default$1());
        if (precisionValue == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"precision")}))));
        }
        Object object = precisionValue;
        if (object instanceof Number) {
            Number number = (Number)object;
            int p = number.intValue();
            if (p < TimeType$.MODULE$.MIN_PRECISION() || p > TimeType$.MODULE$.MICROS_PRECISION()) {
                return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)Cast$.MODULE$.toSQLId("precision")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("[" + TimeType$.MODULE$.MIN_PRECISION() + ", " + TimeType$.MODULE$.MICROS_PRECISION() + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToInteger((int)p), (DataType)IntegerType$.MODULE$))}))));
            }
        } else {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private int precision$lzycompute() {
        CurrentTime currentTime = this;
        synchronized (currentTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.precision = ((Number)this.child().eval(this.child().eval$default$1())).intValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.precision;
    }

    public int precision() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.precision$lzycompute();
        }
        return this.precision;
    }

    @Override
    public DataType dataType() {
        return new TimeType(this.precision());
    }

    @Override
    public String prettyName() {
        return "current_time";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object eval(InternalRow input) {
        long currentTimeOfDayNanos = DateTimeUtils$.MODULE$.instantToNanosOfDay(Instant.now(), this.zoneId());
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.truncateTimeToPrecision(currentTimeOfDayNanos, this.precision()));
    }

    public CurrentTime copy(Expression child, Option<String> timeZoneId) {
        return new CurrentTime(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "CurrentTime";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CurrentTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CurrentTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        CurrentTime currentTime = (CurrentTime)x$1;
        Expression expression = this.child();
        Expression expression2 = currentTime.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = currentTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!currentTime.canEqual(this)) return false;
        return true;
    }

    public CurrentTime(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
        TimeExpression.$init$(this);
        Statics.releaseFence();
    }

    public CurrentTime() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)TimeType$.MODULE$.MICROS_PRECISION())), (Option<String>)None$.MODULE$);
    }

    public CurrentTime(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

