/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.compat.immutable.LazyList;
import scala.collection.compat.immutable.LazyList$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.BitSet;
import spire.math.prime.BitSet$;
import spire.math.prime.FactorHeap;
import spire.math.prime.SieveSegment;
import spire.math.prime.SieveUtil;
import spire.math.prime.SieveUtil$FastFactors$;
import spire.math.prime.Siever$;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001\u0002\u00180\u0001ZB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005P\u0001\tE\t\u0015!\u0003L\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u001d1\u0006A1A\u0005\u0002]Caa\u0017\u0001!\u0002\u0013A\u0006b\u0002/\u0001\u0001\u0004%\tA\u0013\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u0011\u0019!\u0007\u0001)Q\u0005\u0017\"9Q\r\u0001a\u0001\n\u0003Q\u0005b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\u0007S\u0002\u0001\u000b\u0015B&\t\u000f)\u0004!\u0019!C\u0001W\"11\u000f\u0001Q\u0001\n1Dq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0001\r\u0011\"\u0001|\u0011!y\b\u00011A\u0005\u0002\u0005\u0005\u0001bBA\u0003\u0001\u0001\u0006K\u0001 \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C\u0001\u0003\u0007C\u0011\"!#\u0001#\u0003%\t!a#\t\u0013\u0005\u0005\u0006!%A\u0005\u0002\u0005\r\u0006\"CAT\u0001\u0005\u0005I\u0011IAU\u0011!\tY\fAA\u0001\n\u0003!\u0005\"CA_\u0001\u0005\u0005I\u0011AA`\u0011%\tI\rAA\u0001\n\u0003\nY\rC\u0005\u0002V\u0002\t\t\u0011\"\u0001\u0002X\"I\u0011\u0011\u001d\u0001\u0002\u0002\u0013\u0005\u00131\u001d\u0005\n\u0003K\u0004\u0011\u0011!C!\u0003OD\u0011\"!;\u0001\u0003\u0003%\t%a;\b\u0013\u0005=x&!A\t\u0002\u0005Eh\u0001\u0003\u00180\u0003\u0003E\t!a=\t\rACC\u0011\u0001B\u0001\u0011%\t)\u000fKA\u0001\n\u000b\n9\u000fC\u0005\u0003\u0004!\n\t\u0011\"!\u0003\u0006!I!1\u0002\u0015\u0002\u0002\u0013\u0005%Q\u0002\u0005\n\u0005?A\u0013\u0011!C\u0005\u0005C\u0011aaU5fm\u0016\u0014(B\u0001\u00192\u0003\u0015\u0001(/[7f\u0015\t\u00114'\u0001\u0003nCRD'\"\u0001\u001b\u0002\u000bM\u0004\u0018N]3\u0004\u0001M!\u0001aN\u001fA!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fMB\u0011\u0001HP\u0005\u0003\u007fe\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00029\u0003&\u0011!)\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\nG\",hn[*ju\u0016,\u0012!\u0012\t\u0003q\u0019K!aR\u001d\u0003\u0007%sG/\u0001\u0006dQVt7nU5{K\u0002\naaY;u_\u001a4W#A&\u0011\u00051kU\"A\u0019\n\u00059\u000b$\u0001C*bM\u0016duN\\4\u0002\u000f\r,Ho\u001c4gA\u00051A(\u001b8jiz\"2A\u0015+V!\t\u0019\u0006!D\u00010\u0011\u0015\u0019U\u00011\u0001F\u0011\u0015IU\u00011\u0001L\u0003\r\t'O]\u000b\u00021B\u00111+W\u0005\u00035>\u0012aAQ5u'\u0016$\u0018\u0001B1se\u0002\nQa\u001d;beR\f\u0011b\u001d;beR|F%Z9\u0015\u0005}\u0013\u0007C\u0001\u001da\u0013\t\t\u0017H\u0001\u0003V]&$\bbB2\n\u0003\u0003\u0005\raS\u0001\u0004q\u0012\n\u0014AB:uCJ$\b%A\u0003mS6LG/A\u0005mS6LGo\u0018\u0013fcR\u0011q\f\u001b\u0005\bG2\t\t\u00111\u0001L\u0003\u0019a\u0017.\\5uA\u0005)a-Y:ucV\tA\u000e\u0005\u0002na:\u00111K\\\u0005\u0003_>\n\u0011bU5fm\u0016,F/\u001b7\n\u0005E\u0014(a\u0003$bgR4\u0015m\u0019;peNT!a\\\u0018\u0002\r\u0019\f7\u000f^9!\u0003\u0015\u0019Hn\\<r+\u00051\bCA*x\u0013\tAxF\u0001\u0006GC\u000e$xN\u001d%fCB\faa\u001d7poF\u0004\u0013!B:jKZ,W#\u0001?\u0011\u0005Mk\u0018B\u0001@0\u00051\u0019\u0016.\u001a<f'\u0016<W.\u001a8u\u0003%\u0019\u0018.\u001a<f?\u0012*\u0017\u000fF\u0002`\u0003\u0007AqaY\n\u0002\u0002\u0003\u0007A0\u0001\u0004tS\u00164X\rI\u0001\rY\u0006\u0014x-Z:u\u0005\u0016dwn\u001e\u000b\u0004\u0017\u0006-\u0001BBA\u0007+\u0001\u00071*A\u0001o\u0003\rqG\u000f\u001b\u000b\u0004\u0017\u0006M\u0001bBA\u0007-\u0001\u0007\u0011Q\u0003\t\u0004q\u0005]\u0011bAA\rs\t!Aj\u001c8h\u00035Ig.\u001b;OKb$8+[3wKR\tq,A\u0005oKb$\u0018I\u001a;feR\u00191*a\t\t\r\u00055\u0001\u00041\u0001L\u00035a\u0017M_=MSN$\u0018I\u001a;feR!\u0011\u0011FA\u001f!\u0015\tY#!\u000fL\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C5n[V$\u0018M\u00197f\u0015\u0011\t\u0019$!\u000e\u0002\r\r|W\u000e]1u\u0015\r\t9$O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001e\u0003[\u0011\u0001\u0002T1{s2K7\u000f\u001e\u0005\u0007\u0003\u007fI\u0002\u0019A&\u0002\u0005A\u0004\u0014aC:ue\u0016\fW.\u00114uKJ$B!!\u0012\u0002^A)\u0011qIA,\u0017:!\u0011\u0011JA*\u001d\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(k\u00051AH]8pizJ\u0011AO\u0005\u0004\u0003+J\u0014a\u00029bG.\fw-Z\u0005\u0005\u00033\nYF\u0001\u0004TiJ,\u0017-\u001c\u0006\u0004\u0003+J\u0004BBA 5\u0001\u00071\nK\u0004\u001b\u0003C\n9'a\u001b\u0011\u0007a\n\u0019'C\u0002\u0002fe\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\tI'A\u0015qe\u00164WM\u001d\u0011MCjLH*[:uA\u0005tG\r\t7bufd\u0015n\u001d;BMR,'\u000fI5ogR,\u0017\rZ\u0011\u0003\u0003[\na\u0001\r\u00182o9\u0002\u0014aB1se\u0006L\u0018\t\u001e\u000b\u0007\u0003g\nI(! \u0011\ta\n)hS\u0005\u0004\u0003oJ$!B!se\u0006L\bBBA>7\u0001\u00071*A\u0001q\u0011\u0019\tyh\u0007a\u0001\u000b\u0006!1/\u001b>f\u0003\u0011\u0019w\u000e]=\u0015\u000bI\u000b))a\"\t\u000f\rc\u0002\u0013!a\u0001\u000b\"9\u0011\n\bI\u0001\u0002\u0004Y\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bS3!RAHW\t\t\t\n\u0005\u0003\u0002\u0014\u0006uUBAAK\u0015\u0011\t9*!'\u0002\u0013Ut7\r[3dW\u0016$'bAANs\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0015Q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KS3aSAH\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0016\u0001\u00026bm\u0006LA!!/\u00020\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002B\u0006\u001d\u0007c\u0001\u001d\u0002D&\u0019\u0011QY\u001d\u0003\u0007\u0005s\u0017\u0010C\u0004dC\u0005\u0005\t\u0019A#\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!4\u0011\r\u0005=\u0017\u0011[Aa\u001b\t\t)$\u0003\u0003\u0002T\u0006U\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!7\u0002`B\u0019\u0001(a7\n\u0007\u0005u\u0017HA\u0004C_>dW-\u00198\t\u0011\r\u001c\u0013\u0011!a\u0001\u0003\u0003\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u000b\u0006AAo\\*ue&tw\r\u0006\u0002\u0002,\u00061Q-];bYN$B!!7\u0002n\"A1MJA\u0001\u0002\u0004\t\t-\u0001\u0004TS\u00164XM\u001d\t\u0003'\"\u001aB\u0001KA{\u0001B9\u0011q_A\u007f\u000b.\u0013VBAA}\u0015\r\tY0O\u0001\beVtG/[7f\u0013\u0011\ty0!?\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002r\u0006)\u0011\r\u001d9msR)!Ka\u0002\u0003\n!)1i\u000ba\u0001\u000b\")\u0011j\u000ba\u0001\u0017\u00069QO\\1qa2LH\u0003\u0002B\b\u00057\u0001R\u0001\u000fB\t\u0005+I1Aa\u0005:\u0005\u0019y\u0005\u000f^5p]B)\u0001Ha\u0006F\u0017&\u0019!\u0011D\u001d\u0003\rQ+\b\u000f\\33\u0011!\u0011i\u0002LA\u0001\u0002\u0004\u0011\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0003\u0005\u0003\u0002.\n\u0015\u0012\u0002\u0002B\u0014\u0003_\u0013aa\u00142kK\u000e$\b")
public class Siever
implements Product,
scala.Serializable {
    private final int chunkSize;
    private final SafeLong cutoff;
    private final BitSet arr;
    private SafeLong start;
    private SafeLong limit;
    private final SieveUtil.FastFactors fastq;
    private final FactorHeap slowq;
    private SieveSegment sieve;

    public static Option<Tuple2<Object, SafeLong>> unapply(Siever siever) {
        return Siever$.MODULE$.unapply(siever);
    }

    public static Siever apply(int n, SafeLong safeLong) {
        return Siever$.MODULE$.apply(n, safeLong);
    }

    public static Function1<Tuple2<Object, SafeLong>, Siever> tupled() {
        return Siever$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<SafeLong, Siever>> curried() {
        return Siever$.MODULE$.curried();
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public SafeLong cutoff() {
        return this.cutoff;
    }

    public BitSet arr() {
        return this.arr;
    }

    public SafeLong start() {
        return this.start;
    }

    public void start_$eq(SafeLong x$1) {
        this.start = x$1;
    }

    public SafeLong limit() {
        return this.limit;
    }

    public void limit_$eq(SafeLong x$1) {
        this.limit = x$1;
    }

    public SieveUtil.FastFactors fastq() {
        return this.fastq;
    }

    public FactorHeap slowq() {
        return this.slowq;
    }

    public SieveSegment sieve() {
        return this.sieve;
    }

    public void sieve_$eq(SieveSegment x$1) {
        this.sieve = x$1;
    }

    public SafeLong largestBelow(SafeLong n) {
        if (n.$less((Object)SafeLong$.MODULE$.apply(3L))) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("invalid argument: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)3))) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        SafeLong k = n.$minus(1L);
        SafeLong last = SafeLong$.MODULE$.apply(2L);
        while (true) {
            int i2;
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            if (n.$minus(this.start()).$less((Object)SafeLong$.MODULE$.apply(len))) {
                int goal = n.$minus(this.start()).toInt();
                for (int i3 = 1; i3 < goal; i3 += 2) {
                    if (!primes.apply(i3)) continue;
                    last = this.start().$plus(i3);
                }
                return last;
            }
            for (i2 = len - 1; 1 <= i2 && !primes.apply(i2); i2 -= 2) {
            }
            if (1 <= i2) {
                last = this.start().$plus(i2);
            }
            this.initNextSieve();
            i = 1;
        }
    }

    public SafeLong nth(long n) {
        if (n == 1L) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        long k = n - 1L;
        while (true) {
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            while (i < len) {
                if (primes.apply(i) && --k < 1L) {
                    return this.sieve().start().$plus(i);
                }
                i += 2;
            }
            this.initNextSieve();
            i = 1;
        }
    }

    private void initNextSieve() {
        this.start_$eq(this.start().$plus(this.chunkSize()));
        this.limit_$eq(this.limit().$plus(this.chunkSize()));
        SafeLong csq = this.cutoff().$times$times(2);
        if (this.limit().$greater$eq((Object)csq)) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("too big: %s > %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.limit(), csq, this.cutoff()})));
        }
        this.arr().clear();
        this.sieve_$eq(new SieveSegment(this.start(), this.arr(), this.cutoff()));
        this.sieve().init(this.fastq(), this.slowq());
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong nextAfter(SafeLong n) {
        void var2_2;
        SafeLong nn = this.sieve().nextAfter(n);
        while (BoxesRunTime.equalsNumObject((Number)((Object)nn), (Object)BoxesRunTime.boxToLong((long)-1L))) {
            this.initNextSieve();
            nn = this.sieve().nextAfter(this.start().$minus(1L));
        }
        return var2_2;
    }

    public LazyList<SafeLong> lazyListAfter(SafeLong p0) {
        SafeLong p;
        SafeLong safeLong = p = this.nextAfter(p0);
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$extension(LazyList$.MODULE$.toDeferrer((Function0 & Serializable & scala.Serializable)() -> this.lazyListAfter(p)), (Function0 & Serializable & scala.Serializable)() -> safeLong);
    }

    public Stream<SafeLong> streamAfter(SafeLong p0) {
        SafeLong p;
        SafeLong safeLong = p = this.nextAfter(p0);
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.streamAfter(p)).$hash$colon$colon((Object)safeLong);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] arrayAt(SafeLong p, int size) {
        void var3_3;
        SafeLong[] arr = new SafeLong[size];
        this.loop$1(0, p, arr);
        return var3_3;
    }

    public Siever copy(int chunkSize, SafeLong cutoff) {
        return new Siever(chunkSize, cutoff);
    }

    public int copy$default$1() {
        return this.chunkSize();
    }

    public SafeLong copy$default$2() {
        return this.cutoff();
    }

    public String productPrefix() {
        return "Siever";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.chunkSize());
                break;
            }
            case 1: {
                object = this.cutoff();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Siever;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.chunkSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.cutoff())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Siever)) return false;
        boolean bl = true;
        if (!bl) return false;
        Siever siever = (Siever)x$1;
        if (this.chunkSize() != siever.chunkSize()) return false;
        if (!BoxesRunTime.equalsNumNum((Number)((Object)this.cutoff()), (Number)((Object)siever.cutoff()))) return false;
        if (!siever.canEqual(this)) return false;
        return true;
    }

    private final void loop$1(int i, SafeLong p, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            arr$1[i] = p;
            p = this.nextAfter(p);
            ++i;
        }
    }

    public Siever(int chunkSize, SafeLong cutoff) {
        this.chunkSize = chunkSize;
        this.cutoff = cutoff;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(chunkSize % 480 == 0, (Function0 & Serializable & scala.Serializable)() -> "chunkSize must be a multiple of 480");
        this.arr = BitSet$.MODULE$.alloc(chunkSize);
        this.start = SafeLong$.MODULE$.apply(0L);
        this.limit = this.start().$plus(chunkSize);
        this.fastq = SieveUtil$FastFactors$.MODULE$.empty();
        this.slowq = new FactorHeap();
        this.sieve = new SieveSegment(this.start(), this.arr(), cutoff);
        this.sieve().init(this.fastq(), this.slowq());
    }
}

