/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVInferSchema;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfCsv$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(csv[, options]) - Returns schema in the DDL format of CSV string.", examples="\n    Examples:\n      > SELECT _FUNC_('1,abc');\n       STRUCT<_c0: INT, _c1: STRING>\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005^\u0001\tE\t\u0015!\u0003P\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015q\u0006\u0001\"\u0001d\u0011\u0015q\u0006\u0001\"\u0001f\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0001\b\u0001\"\u0011r\u0011!)\b\u0001#b\u0001\n\u00131\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\f\u0001\t#\n\t\u0004C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011q\b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003/\u0002\u0011\u0013!C\u0001\u00033B\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\t\tAA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0001\u0002\u0014\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011T\u0004\n\u0003{\u0003\u0013\u0011!E\u0001\u0003\u007f3\u0001b\b\u0011\u0002\u0002#\u0005\u0011\u0011\u0019\u0005\u0007=f!\t!a4\t\u0013\u0005E\u0017$!A\u0005F\u0005M\u0007\"CAk3\u0005\u0005I\u0011QAl\u0011%\ti.GA\u0001\n\u0003\u000by\u000eC\u0005\u0002rf\t\t\u0011\"\u0003\u0002t\nY1k\u00195f[\u0006|emQ:w\u0015\t\t#%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0012%\u0003!\u0019\u0017\r^1msN$(BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011C\u0002\u0001/earD\t\u0005\u00020a5\t\u0001%\u0003\u00022A\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00024m5\tAG\u0003\u00026A\u000591m\u001c3fO\u0016t\u0017BA\u001c5\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA\u001d=\u001b\u0005Q$BA\u001e%\u0003\u0019)'O]8sg&\u0011QH\u000f\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n9\u0001K]8ek\u000e$\bCA F\u0013\t1\u0005I\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001J!\ty#*\u0003\u0002LA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u001dy\u0007\u000f^5p]N,\u0012a\u0014\t\u0005!^S&L\u0004\u0002R+B\u0011!\u000bQ\u0007\u0002'*\u0011A\u000bL\u0001\u0007yI|w\u000e\u001e \n\u0005Y\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0002Y3\n\u0019Q*\u00199\u000b\u0005Y\u0003\u0005C\u0001)\\\u0013\ta\u0016L\u0001\u0004TiJLgnZ\u0001\t_B$\u0018n\u001c8tA\u00051A(\u001b8jiz\"2\u0001Y1c!\ty\u0003\u0001C\u0003H\u000b\u0001\u0007\u0011\nC\u0003N\u000b\u0001\u0007q\n\u0006\u0002aI\")qI\u0002a\u0001\u0013R\u0019\u0001MZ4\t\u000b\u001d;\u0001\u0019A%\t\u000b5;\u0001\u0019A%\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u0012\nQ\u0001^=qKNL!a\u001c7\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002eB\u0011qh]\u0005\u0003i\u0002\u0013qAQ8pY\u0016\fg.A\u0002dgZ,\u0012a\u001e\t\u0003qrl\u0011!\u001f\u0006\u0003[jT!a\u001f\u0014\u0002\rUt7/\u00194f\u0013\ti\u0018P\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD#AC@\u0011\u0007}\n\t!C\u0002\u0002\u0004\u0001\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!%\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t\u0019\"!\u0004\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u0011\u0011DA\u0010!\ry\u00141D\u0005\u0004\u0003;\u0001%aA!os\"I\u0011\u0011\u0005\u0007\u0011\u0002\u0003\u0007\u00111E\u0001\u0002mB!\u0011QEA\u0014\u001b\u0005\u0011\u0013bAA\u0015E\tY\u0011J\u001c;fe:\fGNU8x\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u00025\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2\u0001YA\u001a\u0011\u0019\t)D\u0004a\u0001\u0013\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLH#\u00021\u0002<\u0005u\u0002bB$\u0010!\u0003\u0005\r!\u0013\u0005\b\u001b>\u0001\n\u00111\u0001P\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0011+\u0007%\u000b)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t\u0006Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0017+\u0007=\u000b)%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003mC:<'BAA6\u0003\u0011Q\u0017M^1\n\u0007q\u000b)'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002tA\u0019q(!\u001e\n\u0007\u0005]\u0004IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001a\u0005u\u0004\"CA@)\u0005\u0005\t\u0019AA:\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0011\t\u0007\u0003\u000f\u000bi)!\u0007\u000e\u0005\u0005%%bAAF\u0001\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0015\u0011\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002s\u0003+C\u0011\"a \u0017\u0003\u0003\u0005\r!!\u0007\u0002\r\u0015\fX/\u00197t)\r\u0011\u00181\u0014\u0005\n\u0003\u007f:\u0012\u0011!a\u0001\u00033A3\u0003AAP\u0003K\u000b9+a+\u0002.\u0006E\u00161WA\\\u0003s\u00032aLAQ\u0013\r\t\u0019\u000b\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI+\u0001%`\rVs5i\u0018\u0015dgZ\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\be]2iK6\f\u0007%\u001b8!i\",\u0007\u0005\u0012#MA\u0019|'/\\1uA=4\u0007eQ*WAM$(/\u001b8h]\u0005AQ\r_1na2,7/\t\u0002\u00020\u00061&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142Y\u0005\u00147mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM#&+V\"Uy}\u001b\u0007G\u000f\u0011J\u001dRc\u0003eX22u\u0001\u001aFKU%O\u000fzR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003k\u000bQa\r\u00181]A\nQa\u001a:pkB\f#!a/\u0002\u0013\r\u001cho\u00184v]\u000e\u001c\u0018aC*dQ\u0016l\u0017m\u00144DgZ\u0004\"aL\r\u0014\te\t\u0019\r\u0012\t\b\u0003\u000b\fY-S(a\u001b\t\t9MC\u0002\u0002J\u0002\u000bqA];oi&lW-\u0003\u0003\u0002N\u0006\u001d'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qX\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011M\u0001\u0006CB\u0004H.\u001f\u000b\u0006A\u0006e\u00171\u001c\u0005\u0006\u000fr\u0001\r!\u0013\u0005\u0006\u001br\u0001\raT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t/!<\u0011\u000b}\n\u0019/a:\n\u0007\u0005\u0015\bI\u0001\u0004PaRLwN\u001c\t\u0006\u007f\u0005%\u0018jT\u0005\u0004\u0003W\u0004%A\u0002+va2,'\u0007\u0003\u0005\u0002pv\t\t\u00111\u0001a\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002vB!\u00111MA|\u0013\u0011\tI0!\u001a\u0003\r=\u0013'.Z2u\u0001")
public class SchemaOfCsv
extends UnaryExpression
implements CodegenFallback,
QueryErrorsBase,
scala.Serializable {
    private transient UTF8String csv;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfCsv schemaOfCsv) {
        return SchemaOfCsv$.MODULE$.unapply(schemaOfCsv);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfCsv> tupled() {
        return SchemaOfCsv$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfCsv>> curried() {
        return SchemaOfCsv$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private UTF8String csv$lzycompute() {
        SchemaOfCsv schemaOfCsv = this;
        synchronized (schemaOfCsv) {
            if (!this.bitmap$trans$0) {
                this.csv = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = true;
            }
        }
        return this.csv;
    }

    private UTF8String csv() {
        if (!this.bitmap$trans$0) {
            return this.csv$lzycompute();
        }
        return this.csv;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.child().foldable() && this.csv() != null) {
            return super.checkInputDataTypes();
        }
        if (!this.child().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"csv"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.child().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.child()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"csv")}))));
    }

    @Override
    public Object eval(InternalRow v) {
        Map exprOptions = this.options().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lineSep"), (Object)Character.toString('\uffff'))})));
        CSVOptions parsedOptions = new CSVOptions((Map<String, String>)exprOptions, true, "UTC");
        CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
        String[] row = parser.parseLine(this.csv().toString());
        Predef$.MODULE$.assert(row != null, (Function0 & Serializable & scala.Serializable)() -> "Parsed CSV record should not be null.");
        String[] header = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                return new StringBuilder(2).append("_c").append(index).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0 & Serializable & scala.Serializable)() -> NullType$.MODULE$, ClassTag$.MODULE$.apply(DataType.class));
        CSVInferSchema inferSchema = new CSVInferSchema(parsedOptions);
        DataType[] fieldTypes = inferSchema.inferRowType(startType, row);
        StructType st = new StructType(inferSchema.toStructFields(fieldTypes, header));
        return UTF8String.fromString((String)st.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_csv";
    }

    @Override
    public SchemaOfCsv withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfCsv copy(Expression child, Map<String, String> options) {
        return new SchemaOfCsv(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfCsv";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.options();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfCsv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfCsv schemaOfCsv = (SchemaOfCsv)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfCsv.canEqual(this)) return false;
        return true;
    }

    public SchemaOfCsv(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public SchemaOfCsv(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfCsv(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

