/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.TensorLike;
import breeze.linalg.Vector;
import breeze.linalg.any$;
import breeze.linalg.diag$;
import breeze.linalg.max$;
import breeze.linalg.operators.HasOps$;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class InteriorPoint$ {
    public static InteriorPoint$ MODULE$;
    private final double TOLERANCE;

    static {
        new InteriorPoint$();
    }

    public double TOLERANCE() {
        return this.TOLERANCE;
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0, double tol) {
        int m = A.rows();
        int n = A.cols();
        DenseVector<Object> x = DenseVector$.MODULE$.zeros$mDc$sp(n, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        x.$plus$eq(x0, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
        Object object = ((TensorLike)((ImmutableNumericOps)A.$times(x0, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).values().exists((JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0.0) ? x.$colon$eq(this.phase1(A, b, c, x0), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet()) : BoxedUnit.UNIT;
        DenseVector<Object> s = DenseVector$.MODULE$.ones$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
        DenseVector<Object> z = DenseVector$.MODULE$.ones$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
        boolean converged = false;
        double lastGap = Double.POSITIVE_INFINITY;
        while (!converged) {
            try {
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple3 = this.computeAffineScalingDir(A, b, c, x, s, z);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector zAff = (DenseVector)tuple3._1();
                DenseVector xAff = (DenseVector)tuple3._2();
                DenseVector sAff = (DenseVector)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)zAff, (Object)xAff, (Object)sAff);
                Tuple3 tuple33 = tuple32;
                DenseVector zAff2 = (DenseVector)tuple33._1();
                DenseVector xAff2 = (DenseVector)tuple33._2();
                DenseVector sAff2 = (DenseVector)tuple33._3();
                double scaleX = this.lineSearch(s, sAff2);
                double scaleZ = this.lineSearch(z, zAff2);
                double sigma = package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)s.$plus(sAff2.$times(BoxesRunTime.boxToDouble((double)scaleX), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).dot(z.$plus(zAff2.$times(BoxesRunTime.boxToDouble((double)scaleZ), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double()), HasOps$.MODULE$.canDotD())) / BoxesRunTime.unboxToDouble((Object)s.dot(z, HasOps$.MODULE$.canDotD())), 3.0);
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple34 = this.computeCenteringCorrectorDir(A, b, c, x, s, z, sAff2, zAff2, sigma);
                if (tuple34 == null) {
                    throw new MatchError(tuple34);
                }
                DenseVector zCC = (DenseVector)tuple34._1();
                DenseVector xCC = (DenseVector)tuple34._2();
                DenseVector sCC = (DenseVector)tuple34._3();
                Tuple3 tuple35 = new Tuple3((Object)zCC, (Object)xCC, (Object)sCC);
                Tuple3 tuple36 = tuple35;
                DenseVector zCC2 = (DenseVector)tuple36._1();
                DenseVector xCC2 = (DenseVector)tuple36._2();
                DenseVector sCC2 = (DenseVector)tuple36._3();
                DenseVector dz = (DenseVector)zAff2.$plus$eq(zCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                DenseVector dx = (DenseVector)xAff2.$plus$eq(xCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                DenseVector ds = (DenseVector)sAff2.$plus$eq(sCC2, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                double scaleXF = this.lineSearch(s, ds);
                double scaleZF = this.lineSearch(z, dz);
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), dx, x, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), ds, s, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleZF)), dz, z, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                double gap = BoxesRunTime.unboxToDouble((Object)c.dot(x, HasOps$.MODULE$.canDotD())) + BoxesRunTime.unboxToDouble((Object)b.dot(z, HasOps$.MODULE$.canDotD()));
                boolean bl = converged = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(gap)) < tol;
                if (gap > lastGap) {
                    breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(-(0.99 * scaleXF))), dx, x, HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                }
                lastGap = gap;
            }
            catch (MatrixSingularException m2) {
                converged = true;
            }
        }
        return x;
    }

    public double minimize$default$5() {
        return this.TOLERANCE();
    }

    private DenseVector<Object> phase1(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0) {
        DenseVector<Object> r;
        block1: {
            double s = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(((ImmutableNumericOps)A.$times(x0, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))) + 1.0E-7;
            Matrix newA = DenseMatrix$.MODULE$.zeros$mDc$sp(A.rows() + 1, A.cols() + 1, ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero());
            ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows()), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.cols()), HasOps$.MODULE$.canSliceColsAndRows())).$colon$eq(A, HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
            ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows() + 1), BoxesRunTime.boxToInteger((int)A.cols()), HasOps$.MODULE$.canSlicePartOfCol())).$colon$eq(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
            DenseVector<Object> newB = DenseVector$.MODULE$.tabulate$mDc$sp(b.size() + 1, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> i < b.size() ? b.apply$mcD$sp(i) : 0.0, (ClassTag<Object>)ClassTag$.MODULE$.Double());
            DenseVector<Object> newC = DenseVector$.MODULE$.zeros$mDc$sp(c.size() + 1, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
            newC.update$mcD$sp(c.size(), 1.0);
            DenseVector<Object> newX = DenseVector$.MODULE$.tabulate$mDc$sp(x0.size() + 1, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> i < x0.size() ? x0.apply$mcD$sp(i) : s, (ClassTag<Object>)ClassTag$.MODULE$.Double());
            if (BoxesRunTime.unboxToBoolean((Object)any$.MODULE$.apply(((NumericOps)((ImmutableNumericOps)((DenseMatrix)newA).$times(newX, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(newB, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$greater$colon$greater(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_DV_S_eq_BV_comparison_Double_OpGT()), HasOps$.MODULE$.impl_any_BV_eq_Boolean()))) {
                throw new RuntimeException("Problem seems to be infeasible!");
            }
            r = this.minimize((DenseMatrix<Object>)newA, newB, newC, newX, this.minimize$default$5());
            if (!(r.apply$mcD$sp(x0.size()) > 1.0E-8)) break block1;
            Predef$.MODULE$.println((Object)new StringBuilder(34).append("Problem appears to be infeasible: ").append(r.apply$mcD$sp(x0.size())).toString());
        }
        return r.slice$mcD$sp(0, x0.size(), r.slice$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private double lineSearch(DenseVector<Object> x, Vector<Object> dx) {
        void var3_3;
        double alpha = 1.0;
        while (((Vector)x.$plus(dx.$times(BoxesRunTime.boxToDouble((double)alpha), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix()), HasOps$.MODULE$.impl_Op_DV_V_eq_V_Double_OpAdd())).valuesIterator().exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 < 0.0)) {
            alpha *= 0.8;
        }
        return (double)var3_3;
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeAffineScalingDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z) {
        DenseMatrix<Object> XiZ = diag$.MODULE$.apply(z.$div$colon$div(s, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()));
        DenseMatrix<Object> AtXiZ = ((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(XiZ, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector<Object> rx = ((ImmutableNumericOps)((NumericOps)A.$times(x, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$plus(s, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double())).$minus(b, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseVector<Object> rz = ((NumericOps)((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(z, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$plus(c, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double());
        DenseMatrix<Object> mat = AtXiZ.$times(A, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector<Object> dx = mat.$bslash(((ImmutableNumericOps)((ImmutableNumericOps)((ImmutableNumericOps)A.t(HasOps$.MODULE$.canTranspose_DM())).$times(z, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD())).$minus(rz, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double())).$minus(AtXiZ.$times(rx, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        DenseVector<Object> ds = ((ImmutableNumericOps)rx.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$minus(A.$times(dx, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseVector<Object> dz = ((ImmutableNumericOps)z.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar()))).$minus(XiZ.$times(ds, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        return new Tuple3(dz, dx, ds);
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeCenteringCorrectorDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z, DenseVector<Object> dsaff, DenseVector<Object> dzaff, double sigma) {
        int n = A.cols();
        int m = A.rows();
        DenseMatrix<Object> mat = DenseMatrix$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.zeros$mDc$sp(m, m, ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero()), A, DenseMatrix$.MODULE$.eye$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero(), Semiring$.MODULE$.semiringD())}), Predef$.MODULE$.$conforms(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{A.t(HasOps$.MODULE$.canTranspose_DM()), DenseMatrix$.MODULE$.zeros$mDc$sp(n, n + m, ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero())}), Predef$.MODULE$.$conforms(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{diag$.MODULE$.apply(s, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero())), DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero()), diag$.MODULE$.apply(z, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()))}), Predef$.MODULE$.$conforms(), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero())}), HasOps$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        ((NumericOps)diag$.MODULE$.apply(mat, diag$.MODULE$.diagDMDVImpl())).$plus$eq(BoxesRunTime.boxToDouble((double)1.0E-20), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpAdd());
        DenseVector<Object> r = DenseVector$.MODULE$.zeros$mDc$sp(m + n + m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
        r.slice$mcD$sp(m + n, m + n + m, r.slice$default$3()).$minus$eq(((ImmutableNumericOps)dsaff.$times$colon$times(dzaff, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar())).$minus(BoxesRunTime.boxToDouble((double)(sigma / (double)m * BoxesRunTime.unboxToDouble((Object)s.dot(z, HasOps$.MODULE$.canDotD())))), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpSub()), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
        DenseVector<Object> sol = mat.$bslash(r, HasOps$.MODULE$.impl_OpSolveMatrixBy_DMD_DVD_eq_DVD());
        return new Tuple3(sol.slice$mcD$sp(0, m, sol.slice$default$3()), sol.slice$mcD$sp(m, n + m, sol.slice$default$3()), sol.slice$mcD$sp(n + m, n + m + m, sol.slice$default$3()));
    }

    private InteriorPoint$() {
        MODULE$ = this;
        this.TOLERANCE = 1.0E-18;
    }
}

