/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002\u0014(\u0001IB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t-\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003[\u0011!a\u0007A!b\u0001\n\u0003I\u0006\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u000bA\u0004A\u0011A9\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!A\u0011Q\u0006\u0001!\n\u0013\ty\u0003C\u0004\u0002 \u0001!\t!!\u0011\t\u000f\u0005}\u0001\u0001\"\u0001\u0002T!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!a2\u0001\t\u0003\tImB\u0004\u0002R\u001eB\t!a5\u0007\r\u0019:\u0003\u0012AAk\u0011\u0019\u00018\u0003\"\u0001\u0002^\"9\u0011q\\\n\u0005\n\u0005\u0005\bbBAy'\u0011%\u00111\u001f\u0005\b\u0005\u000b\u0019B\u0011\u0002B\u0004\u0011%\u0011)bEI\u0001\n\u0013\u00119\u0002C\u0004\u0003,M!\tE!\f\b\u0011\tU2\u0003#\u0001(\u0005o1\u0001Ba\u000f\u0014\u0011\u00039#Q\b\u0005\u0007an!\tAa\u0010\t\u0013\t\u00053D1A\u0005\n\t\r\u0003\u0002\u0003B%7\u0001\u0006IA!\u0012\t\u0015\t-3D1A\u0005\u0002\u001d\u0012\u0019\u0005\u0003\u0005\u0003Nm\u0001\u000b\u0011\u0002B#\u0011\u001d\tij\u0007C\u0001\u0005\u001fBqAa\u000b\u001c\t\u0003\u00119\u0006C\u0004\u0003^m!IAa\u0018\t\u000f\t\r4\u0004\"\u0003\u0003f!I!\u0011N\n\u0002\u0002\u0013%!1\u000e\u0002\u0019\u001b\u0006$(/\u001b=GC\u000e$xN]5{CRLwN\\'pI\u0016d'B\u0001\u0015*\u00039\u0011XmY8n[\u0016tG-\u0019;j_:T!AK\u0016\u0002\u000b5dG.\u001b2\u000b\u00051j\u0013!B:qCJ\\'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001gez$\t\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y%\nA!\u001e;jY&\u0011ah\u000f\u0002\t'\u00064X-\u00192mKB\u0011A\u0007Q\u0005\u0003\u0003V\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"a\u0011$\u000e\u0003\u0011S!!R\u0016\u0002\u0011%tG/\u001a:oC2L!a\u0012#\u0003\u000f1{wmZ5oO\u0006!!/\u00198l+\u0005Q\u0005C\u0001\u001bL\u0013\taUGA\u0002J]RD3!\u0001(U!\ty%+D\u0001Q\u0015\t\t6&\u0001\u0006b]:|G/\u0019;j_:L!a\u0015)\u0003\u000bMKgnY3\"\u0003U\u000bQ\u0001\r\u00189]A\nQA]1oW\u0002B3A\u0001(U\u00031)8/\u001a:GK\u0006$XO]3t+\u0005Q\u0006cA._A6\tAL\u0003\u0002^W\u0005\u0019!\u000f\u001a3\n\u0005}c&a\u0001*E\tB!A'\u0019&d\u0013\t\u0011WG\u0001\u0004UkBdWM\r\t\u0004i\u00114\u0017BA36\u0005\u0015\t%O]1z!\t!t-\u0003\u0002ik\t1Ai\\;cY\u0016D3a\u0001(U\u00035)8/\u001a:GK\u0006$XO]3tA!\u001aAA\u0014+\u0002\u001fA\u0014x\u000eZ;di\u001a+\u0017\r^;sKND3!\u0002(U\u0003A\u0001(o\u001c3vGR4U-\u0019;ve\u0016\u001c\b\u0005K\u0002\u0007\u001dR\u000ba\u0001P5oSRtD\u0003\u0002:umb\u0004\"a\u001d\u0001\u000e\u0003\u001dBQ\u0001S\u0004A\u0002)C3\u0001\u001e(U\u0011\u0015Av\u00011\u0001[Q\r1h\n\u0016\u0005\u0006Y\u001e\u0001\rA\u0017\u0015\u0004q:#\u0006fA\u0004O)\u0006\u0001b/\u00197jI\u0006$XMR3biV\u0014Xm\u001d\u000b\u0006{\u0006\u0005\u00111\u0004\t\u0003iyL!a`\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007A\u0001\u0019AA\u0003\u0003\u0011q\u0017-\\3\u0011\t\u0005\u001d\u0011Q\u0003\b\u0005\u0003\u0013\t\t\u0002E\u0002\u0002\fUj!!!\u0004\u000b\u0007\u0005=\u0011'\u0001\u0004=e>|GOP\u0005\u0004\u0003')\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0005e!AB*ue&twMC\u0002\u0002\u0014UBa!!\b\t\u0001\u0004Q\u0016\u0001\u00034fCR,(/Z:\u0002\u000fA\u0014X\rZ5diR)a-a\t\u0002(!1\u0011QE\u0005A\u0002)\u000bA!^:fe\"1\u0011\u0011F\u0005A\u0002)\u000bq\u0001\u001d:pIV\u001cG\u000fK\u0002\n\u001dR\u000badY8v]R\f\u0005\u000f\u001d:pq\u0012K7\u000f^5oGR,6/\u001a:Qe>$Wo\u0019;\u0015\t\u0005E\u0012\u0011\b\t\u0007i\u0005\f\u0019$a\r\u0011\u0007Q\n)$C\u0002\u00028U\u0012A\u0001T8oO\"9\u00111\b\u0006A\u0002\u0005u\u0012!D;tKJ\u001c\bK]8ek\u000e$8\u000f\u0005\u0003\\=\u0006}\u0002\u0003\u0002\u001bb\u0015*#B!a\u0011\u0002LA!1LXA#!\r\u0019\u0018qI\u0005\u0004\u0003\u0013:#A\u0002*bi&tw\rC\u0004\u0002<-\u0001\r!!\u0010)\t-q\u0015qJ\u0011\u0003\u0003#\nQ\u0001\r\u0018:]A\"B!!\u0016\u0002fA1\u0011qKA1\u0003\u000bj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0005U\u00064\u0018MC\u0002\u0002`-\n1!\u00199j\u0013\u0011\t\u0019'!\u0017\u0003\u000f)\u000bg/\u0019*E\t\"9\u00111\b\u0007A\u0002\u0005\u001d\u0004\u0003CA,\u0003S\ni'!\u001c\n\t\u0005-\u0014\u0011\f\u0002\f\u0015\u00064\u0018\rU1jeJ#E\t\u0005\u0003\u0002p\u0005]TBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t1\fgn\u001a\u0006\u0003\u00037JA!!\u001f\u0002r\t9\u0011J\u001c;fO\u0016\u0014\b\u0006\u0002\u0007O\u0003{\n#!a \u0002\u000bEr#G\f\u0019\u0002#I,7m\\7nK:$\u0007K]8ek\u000e$8\u000f\u0006\u0004\u0002\u0006\u0006\u001d\u0015\u0011\u0012\t\u0005i\u0011\f)\u0005\u0003\u0004\u0002&5\u0001\rA\u0013\u0005\u0007\u0003\u0017k\u0001\u0019\u0001&\u0002\u00079,X\u000e\u000b\u0003\u000e\u001d\u0006=\u0015EAAI\u0003\u0015\td&\r\u00181\u00039\u0011XmY8n[\u0016tG-V:feN$b!!\"\u0002\u0018\u0006e\u0005BBA\u0015\u001d\u0001\u0007!\n\u0003\u0004\u0002\f:\u0001\rA\u0013\u0015\u0005\u001d9\u000by)\u0001\u0003tCZ,G#B?\u0002\"\u00065\u0006bBAR\u001f\u0001\u0007\u0011QU\u0001\u0003g\u000e\u0004B!a*\u0002*6\t1&C\u0002\u0002,.\u0012Ab\u00159be.\u001cuN\u001c;fqRDq!a,\u0010\u0001\u0004\t)!\u0001\u0003qCRD\u0007\u0006B\bO\u0003g\u000b#!!.\u0002\u000bEr3G\f\u0019\u00023I,7m\\7nK:$\u0007K]8ek\u000e$8OR8s+N,'o\u001d\u000b\u0005\u0003w\u000by\f\u0005\u0003\\=\u0006u\u0006#\u0002\u001bb\u0015\u0006\u0015\u0005BBAF!\u0001\u0007!\n\u000b\u0003\u0011\u001d\u0006\r\u0017EAAc\u0003\u0015\td\u0006\u000e\u00181\u0003e\u0011XmY8n[\u0016tG-V:feN4uN\u001d)s_\u0012,8\r^:\u0015\t\u0005m\u00161\u001a\u0005\u0007\u0003\u0017\u000b\u0002\u0019\u0001&)\tEq\u00151\u0019\u0015\u0004\u00019#\u0016\u0001G'biJL\u0007PR1di>\u0014\u0018N_1uS>tWj\u001c3fYB\u00111oE\n\u0006'M\n9n\u0010\t\u0005u\u0005e'/C\u0002\u0002\\n\u0012a\u0001T8bI\u0016\u0014HCAAj\u0003%\u0011XmY8n[\u0016tG\r\u0006\u0005\u0002d\u0006\u001d\u00181^Ax!\u0011!D-!:\u0011\tQ\n'J\u001a\u0005\u0007\u0003S,\u0002\u0019A2\u0002'I,7m\\7nK:$Gk\u001c$fCR,(/Z:\t\r\u00055X\u00031\u0001[\u0003U\u0011XmY8n[\u0016tG-\u00192mK\u001a+\u0017\r^;sKNDa!a#\u0016\u0001\u0004Q\u0015a\u0004:fG>lW.\u001a8e\r>\u0014\u0018\t\u001c7\u0015\u0015\u0005U\u0018\u0011`A~\u0003\u007f\u0014\u0019\u0001\u0005\u0003\\=\u0006]\b#\u0002\u001bb\u0015\u0006\r\b\"\u0002%\u0017\u0001\u0004Q\u0005BBA\u007f-\u0001\u0007!,A\u0006te\u000e4U-\u0019;ve\u0016\u001c\bB\u0002B\u0001-\u0001\u0007!,A\u0006egR4U-\u0019;ve\u0016\u001c\bBBAF-\u0001\u0007!*\u0001\u0005cY>\u001c7.\u001b4z)\u0019\u0011IAa\u0004\u0003\u0012A!1L\u0018B\u0006!\u0015!\u0014M!\u0004d!\r!DM\u0013\u0005\u0007\u0003;9\u0002\u0019\u0001.\t\u0011\tMq\u0003%AA\u0002)\u000b\u0011B\u00197pG.\u001c\u0016N_3\u0002%\tdwnY6jMf$C-\u001a4bk2$HEM\u000b\u0003\u00053Q3A\u0013B\u000eW\t\u0011i\u0002\u0005\u0003\u0003 \t\u001dRB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\u0013Ut7\r[3dW\u0016$'BA)6\u0013\u0011\u0011IC!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003m_\u0006$G#\u0002:\u00030\tE\u0002bBAR3\u0001\u0007\u0011Q\u0015\u0005\b\u0003_K\u0002\u0019AA\u0003Q\u0011Ib*a-\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\u0007\te2$D\u0001\u0014\u00051\u0019\u0016M^3M_\u0006$g+M01'\tY2\u0007\u0006\u0002\u00038\u0005\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\t\u0015\u0003\u0003BA8\u0005\u000fJA!a\u0006\u0002r\u0005\u0011B\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8!\u00035!\b.[:DY\u0006\u001c8OT1nK\u0006qA\u000f[5t\u00072\f7o\u001d(b[\u0016\u0004C#B?\u0003R\tU\u0003B\u0002B*C\u0001\u0007!/A\u0003n_\u0012,G\u000eC\u0004\u00020\u0006\u0002\r!!\u0002\u0015\u000bI\u0014IFa\u0017\t\u000f\u0005\r&\u00051\u0001\u0002&\"9\u0011q\u0016\u0012A\u0002\u0005\u0015\u0011\u0001C;tKJ\u0004\u0016\r\u001e5\u0015\t\u0005\u0015!\u0011\r\u0005\b\u0003_\u001b\u0003\u0019AA\u0003\u0003-\u0001(o\u001c3vGR\u0004\u0016\r\u001e5\u0015\t\u0005\u0015!q\r\u0005\b\u0003_#\u0003\u0019AA\u0003\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0004\u0003BA8\u0005_JAA!\u001d\u0002r\t1qJ\u00196fGRDCa\u0005(\u00024\"\"!CTAZ\u0001")
public class MatrixFactorizationModel
implements Saveable,
scala.Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(name).append(" feature dimension does not match the rank ").append(this.rank()).append(".").toString());
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append(name).append(" factor does not have a partitioner. ").append("Prediction on individual records could be slow.").toString());
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(name).append(" factor is not cached. Prediction could be slow.").toString());
            return;
        }
    }

    public double predict(int user, int product) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        double[] userVector = (double[])userFeatureSeq.head();
        double[] productVector = (double[])productFeatureSeq.head();
        return BLAS$.MODULE$.nativeBLAS().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2 & Serializable & scala.Serializable)(hllTuple, v) -> {
            ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
            ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
            return hllTuple;
        }, (Function2 & Serializable & scala.Serializable)(h1, h2) -> {
            ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
            ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
            return h1;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long usersCount = tuple2._1$mcJ$sp();
        long productsCount = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount);
        long usersCount2 = sp2._1$mcJ$sp();
        long productsCount2 = sp2._2$mcJ$sp();
        if (usersCount2 < productsCount2) {
            RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            return new Rating(user, product, BLAS$.MODULE$.nativeBLAS().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Rating.class));
        }
        RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap$mcII$sp(), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int product = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    double[] pFeatures = (double[])tuple22._1();
                    int user = tuple22._2$mcI$sp();
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(products, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                int user = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    double[] uFeatures = (double[])tuple22._2();
                    if (tuple23 != null) {
                        int product = tuple23._1$mcI$sp();
                        double[] pFeatures = (double[])tuple23._2();
                        return new Rating(user, product, BLAS$.MODULE$.nativeBLAS().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        Seq userFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user));
        Predef$.MODULE$.require(userFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("userId: ").append(user).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])userFeatureSeq.head(), this.productFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(user, t._1$mcI$sp(), t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        Seq productFeatureSeq = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product));
        Predef$.MODULE$.require(productFeatureSeq.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("productId: ").append(product).append(" not found in the model").toString());
        return (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])productFeatureSeq.head(), this.userFeatures(), num))).map((Function1 & Serializable & scala.Serializable)t -> new Rating(t._1$mcI$sp(), product, t._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int user = tuple2._1$mcI$sp();
                Tuple2[] top = (Tuple2[])tuple2._2();
                Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int product = tuple2._1$mcI$sp();
                        double rating = tuple2._2$mcD$sp();
                        return new Rating(user, product, rating);
                    }
                    throw new MatchError((Object)tuple2);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int product = tuple2._1$mcI$sp();
                Tuple2[] top = (Tuple2[])tuple2._2();
                Rating[] ratings = (Rating[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])top)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        int user = tuple2._1$mcI$sp();
                        double rating = tuple2._2$mcD$sp();
                        return new Rating(user, product, rating);
                    }
                    throw new MatchError((Object)tuple2);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
    }
}

