/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.tinkkey;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.internal.Util;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.tinkkey.KeyAccess;
import com.google.crypto.tink.tinkkey.TinkKey;
import com.google.crypto.tink.tinkkey.internal.ProtoKey;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;

@Immutable
public class KeyHandle {
    private final TinkKey key;
    private final KeyStatusType status;
    private final int id;

    public static KeyHandle createFromKey(TinkKey key, KeyAccess access) throws GeneralSecurityException {
        KeyHandle result = new KeyHandle(key);
        result.checkAccess(access);
        return result;
    }

    public static KeyHandle createFromKey(KeyData keyData, KeyTemplate.OutputPrefixType opt) {
        return new KeyHandle(new ProtoKey(keyData, opt));
    }

    private KeyHandle(TinkKey key) {
        this.key = key;
        this.status = KeyStatusType.ENABLED;
        this.id = Util.randKeyId();
    }

    protected KeyHandle(TinkKey key, KeyStatusType status, int keyId) {
        this.key = key;
        this.status = status;
        this.id = keyId;
    }

    public static KeyHandle generateNew(KeyTemplate keyTemplate) throws GeneralSecurityException {
        ProtoKey protoKey = new ProtoKey(Registry.newKeyData(keyTemplate), keyTemplate.getOutputPrefixType());
        return new KeyHandle(protoKey);
    }

    public boolean hasSecret() {
        return this.key.hasSecret();
    }

    public KeyStatusType getStatus() {
        return this.status;
    }

    public int getId() {
        return this.id;
    }

    public TinkKey getKey(KeyAccess access) throws GeneralSecurityException {
        this.checkAccess(access);
        return this.key;
    }

    public KeyTemplate getKeyTemplate() {
        return this.key.getKeyTemplate();
    }

    private void checkAccess(KeyAccess access) throws GeneralSecurityException {
        if (this.hasSecret() && !access.canAccessSecret()) {
            throw new GeneralSecurityException("No access");
        }
    }

    public static enum KeyStatusType {
        ENABLED,
        DISABLED,
        DESTROYED;

    }
}

