/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.proto.KeyData;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Alpha
public abstract class KeyTypeManager<KeyProtoT extends MessageLite> {
    private final Class<KeyProtoT> clazz;
    private final Map<Class<?>, PrimitiveFactory<?, KeyProtoT>> factories;
    private final Class<?> firstPrimitiveClass;

    @SafeVarargs
    protected KeyTypeManager(Class<KeyProtoT> clazz, PrimitiveFactory<?, KeyProtoT> ... factories) {
        this.clazz = clazz;
        HashMap factoriesMap = new HashMap();
        for (PrimitiveFactory<?, KeyProtoT> factory : factories) {
            if (factoriesMap.containsKey(factory.getPrimitiveClass())) {
                throw new IllegalArgumentException("KeyTypeManager constructed with duplicate factories for primitive " + factory.getPrimitiveClass().getCanonicalName());
            }
            factoriesMap.put(factory.getPrimitiveClass(), factory);
        }
        this.firstPrimitiveClass = factories.length > 0 ? factories[0].getPrimitiveClass() : Void.class;
        this.factories = Collections.unmodifiableMap(factoriesMap);
    }

    public final Class<KeyProtoT> getKeyClass() {
        return this.clazz;
    }

    public abstract String getKeyType();

    public abstract int getVersion();

    public abstract KeyData.KeyMaterialType keyMaterialType();

    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    public abstract KeyProtoT parseKey(ByteString var1) throws InvalidProtocolBufferException;

    public abstract void validateKey(KeyProtoT var1) throws GeneralSecurityException;

    public final <P> P getPrimitive(KeyProtoT key, Class<P> primitiveClass) throws GeneralSecurityException {
        PrimitiveFactory<?, KeyProtoT> factory = this.factories.get(primitiveClass);
        if (factory == null) {
            throw new IllegalArgumentException("Requested primitive class " + primitiveClass.getCanonicalName() + " not supported.");
        }
        return (P)factory.getPrimitive(key);
    }

    public final Set<Class<?>> supportedPrimitives() {
        return this.factories.keySet();
    }

    public final Class<?> firstSupportedPrimitiveClass() {
        return this.firstPrimitiveClass;
    }

    public KeyFactory<?, KeyProtoT> keyFactory() {
        throw new UnsupportedOperationException("Creating keys is not supported.");
    }

    public static abstract class KeyFactory<KeyFormatProtoT extends MessageLite, KeyProtoT extends MessageLite> {
        private final Class<KeyFormatProtoT> clazz;

        public KeyFactory(Class<KeyFormatProtoT> clazz) {
            this.clazz = clazz;
        }

        public final Class<KeyFormatProtoT> getKeyFormatClass() {
            return this.clazz;
        }

        public abstract void validateKeyFormat(KeyFormatProtoT var1) throws GeneralSecurityException;

        public abstract KeyFormatProtoT parseKeyFormat(ByteString var1) throws InvalidProtocolBufferException;

        public abstract KeyProtoT createKey(KeyFormatProtoT var1) throws GeneralSecurityException;

        public KeyProtoT deriveKey(KeyFormatProtoT keyFormat, InputStream pseudoRandomness) throws GeneralSecurityException {
            throw new GeneralSecurityException("deriveKey not implemented for key of type " + this.clazz);
        }

        public Map<String, KeyFormat<KeyFormatProtoT>> keyFormats() throws GeneralSecurityException {
            return Collections.emptyMap();
        }

        protected static void readFully(InputStream input, byte[] output) throws IOException, GeneralSecurityException {
            int read;
            int len = output.length;
            for (int readTotal = 0; readTotal < len; readTotal += read) {
                read = input.read(output, readTotal, len - readTotal);
                if (read != -1) continue;
                throw new GeneralSecurityException("Not enough pseudorandomness provided");
            }
        }

        public static final class KeyFormat<KeyFormatProtoT> {
            public KeyFormatProtoT keyFormat;
            public KeyTemplate.OutputPrefixType outputPrefixType;

            public KeyFormat(KeyFormatProtoT keyFormat, KeyTemplate.OutputPrefixType outputPrefixType) {
                this.keyFormat = keyFormat;
                this.outputPrefixType = outputPrefixType;
            }
        }
    }
}

