/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.nio.ByteOrder;
import org.apache.datasketches.ByteArrayUtil;
import org.apache.datasketches.Family;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;

public class CompactSketch<S extends Summary>
extends Sketch<S> {
    private static final byte serialVersionWithSummaryClassNameUID = 1;
    private static final byte serialVersionUIDLegacy = 2;
    private static final byte serialVersionUID = 3;
    private static final short defaultSeedHash = -27700;
    private long[] hashArr_;
    private S[] summaryArr_;

    CompactSketch(long[] hashArr, S[] summaryArr, long thetaLong, boolean empty) {
        this.hashArr_ = hashArr;
        this.summaryArr_ = summaryArr;
        this.thetaLong_ = thetaLong;
        this.empty_ = empty;
    }

    CompactSketch(Memory mem, SummaryDeserializer<S> deserializer) {
        block14: {
            byte preambleLongs;
            int offset;
            block13: {
                int i;
                boolean hasEntries;
                boolean isThetaIncluded;
                byte flags;
                boolean isBigEndian;
                offset = 0;
                preambleLongs = mem.getByte((long)offset++);
                byte version = mem.getByte((long)offset++);
                byte familyId = mem.getByte((long)offset++);
                SerializerDeserializer.validateFamily(familyId, preambleLongs);
                if (version > 3) {
                    throw new SketchesArgumentException("Unsupported serial version. Expected: 3 or lower, actual: " + version);
                }
                SerializerDeserializer.validateType(mem.getByte((long)offset++), SerializerDeserializer.SketchType.CompactSketch);
                if (version > 2) break block13;
                boolean bl = isBigEndian = ((flags = mem.getByte((long)offset++)) & 1 << FlagsLegacy.IS_BIG_ENDIAN.ordinal()) > 0;
                if (isBigEndian ^ ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
                    throw new SketchesArgumentException("Byte order mismatch");
                }
                this.empty_ = (flags & 1 << FlagsLegacy.IS_EMPTY.ordinal()) > 0;
                boolean bl2 = isThetaIncluded = (flags & 1 << FlagsLegacy.IS_THETA_INCLUDED.ordinal()) > 0;
                if (isThetaIncluded) {
                    this.thetaLong_ = mem.getLong((long)offset);
                    offset += 8;
                } else {
                    this.thetaLong_ = Long.MAX_VALUE;
                }
                boolean bl3 = hasEntries = (flags & 1 << FlagsLegacy.HAS_ENTRIES.ordinal()) > 0;
                if (!hasEntries) break block14;
                byte classNameLength = 0;
                if (version == 1) {
                    classNameLength = mem.getByte((long)offset++);
                }
                int count = mem.getInt((long)offset);
                offset += 4;
                if (version == 1) {
                    offset += classNameLength;
                }
                this.hashArr_ = new long[count];
                for (i = 0; i < count; ++i) {
                    this.hashArr_[i] = mem.getLong((long)offset);
                    offset += 8;
                }
                for (i = 0; i < count; ++i) {
                    offset += this.readSummary(mem, offset, i, count, deserializer);
                }
                break block14;
            }
            int n = ++offset;
            ++offset;
            byte flags = mem.getByte((long)n);
            offset += 2;
            this.empty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
            this.thetaLong_ = Long.MAX_VALUE;
            int count = 0;
            if (!this.empty_) {
                if (preambleLongs == 1) {
                    count = 1;
                } else {
                    count = mem.getInt((long)offset);
                    offset += 4;
                    offset += 4;
                    if (preambleLongs > 2) {
                        this.thetaLong_ = mem.getLong((long)offset);
                        offset += 8;
                    }
                }
            }
            this.hashArr_ = new long[count];
            for (int i = 0; i < count; ++i) {
                this.hashArr_[i] = mem.getLong((long)offset);
                offset += 8;
                offset += this.readSummary(mem, offset, i, count, deserializer);
            }
        }
    }

    private int readSummary(Memory mem, int offset, int i, int count, SummaryDeserializer<S> deserializer) {
        Memory memRegion = mem.region((long)offset, mem.getCapacity() - (long)offset);
        DeserializeResult<S> result = deserializer.heapifySummary(memRegion);
        Summary summary = (Summary)result.getObject();
        Class<?> summaryType = ((Summary)result.getObject()).getClass();
        if (this.summaryArr_ == null) {
            this.summaryArr_ = (Summary[])Array.newInstance(summaryType, count);
        }
        this.summaryArr_[i] = summary;
        return result.getSize();
    }

    @Override
    public CompactSketch<S> compact() {
        return this;
    }

    long[] getHashArr() {
        return this.hashArr_;
    }

    S[] getSummaryArr() {
        return this.summaryArr_;
    }

    @Override
    public int getRetainedEntries() {
        return this.hashArr_ == null ? 0 : this.hashArr_.length;
    }

    @Override
    public int getCountLessThanThetaLong(long thetaLong) {
        return HashOperations.count(this.hashArr_, thetaLong);
    }

    @Override
    public byte[] toByteArray() {
        boolean isSingleItem;
        int count = this.getRetainedEntries();
        boolean bl = isSingleItem = count == 1 && !this.isEstimationMode();
        int preambleLongs = this.isEmpty() || isSingleItem ? 1 : (this.isEstimationMode() ? 3 : 2);
        int summariesSizeBytes = 0;
        byte[][] summariesBytes = new byte[count][];
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                summariesBytes[i] = this.summaryArr_[i].toByteArray();
                summariesSizeBytes += summariesBytes[i].length;
            }
        }
        int sizeBytes = 8 * preambleLongs + 8 * count + summariesSizeBytes;
        byte[] bytes = new byte[sizeBytes];
        int offset = 0;
        bytes[offset++] = (byte)preambleLongs;
        bytes[offset++] = 3;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.CompactSketch.ordinal();
        int n = ++offset;
        bytes[n] = (byte)(1 << Flags.IS_COMPACT.ordinal() | 1 << Flags.IS_READ_ONLY.ordinal() | (this.isEmpty() ? 1 << Flags.IS_EMPTY.ordinal() : 0));
        ByteArrayUtil.putShortLE(bytes, ++offset, (short)-27700);
        offset += 2;
        if (!this.isEmpty() && !isSingleItem) {
            ByteArrayUtil.putIntLE(bytes, offset, count);
            offset += 4;
            offset += 4;
            if (this.isEstimationMode()) {
                ByteArrayUtil.putLongLE(bytes, offset, this.thetaLong_);
                offset += 8;
            }
        }
        for (int i = 0; i < count; ++i) {
            ByteArrayUtil.putLongLE(bytes, offset, this.hashArr_[i]);
            System.arraycopy(summariesBytes[i], 0, bytes, offset += 8, summariesBytes[i].length);
            offset += summariesBytes[i].length;
        }
        return bytes;
    }

    @Override
    public SketchIterator<S> iterator() {
        return new SketchIterator(this.hashArr_, this.summaryArr_);
    }

    private static enum Flags {
        IS_BIG_ENDIAN,
        IS_READ_ONLY,
        IS_EMPTY,
        IS_COMPACT,
        IS_ORDERED;

    }

    private static enum FlagsLegacy {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

