/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.fdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.HashOperations;
import org.apache.datasketches.Util;
import org.apache.datasketches.fdt.FdtSketch;
import org.apache.datasketches.fdt.Group;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummary;

public class PostProcessor {
    private final FdtSketch sketch;
    private final char sep;
    private int groupCount;
    private Group group;
    private boolean mapValid;
    private final int mapArrSize;
    private final long[] hashArr;
    private final String[] priKeyArr;
    private final int[] counterArr;

    public PostProcessor(FdtSketch sketch, Group group, char sep) {
        this.sketch = sketch.copy();
        this.sep = sep;
        int numEntries = sketch.getRetainedEntries();
        this.mapArrSize = Util.ceilingPowerOf2((int)((double)numEntries / 0.75));
        this.hashArr = new long[this.mapArrSize];
        this.priKeyArr = new String[this.mapArrSize];
        this.counterArr = new int[this.mapArrSize];
        this.mapValid = false;
        this.group = group;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public List<Group> getGroupList(int[] priKeyIndices, int numStdDev, int limit) {
        if (!this.mapValid) {
            this.populateMap(priKeyIndices);
        }
        return this.populateList(numStdDev, limit);
    }

    private void populateMap(int[] priKeyIndices) {
        SketchIterator it = this.sketch.iterator();
        Arrays.fill(this.hashArr, 0L);
        Arrays.fill(this.priKeyArr, null);
        Arrays.fill(this.counterArr, 0);
        this.groupCount = 0;
        int lgMapArrSize = Integer.numberOfTrailingZeros(this.mapArrSize);
        while (it.next()) {
            String[] arr = ((ArrayOfStringsSummary)it.getSummary()).getValue();
            String priKey = PostProcessor.getPrimaryKey(arr, priKeyIndices, this.sep);
            long hash = org.apache.datasketches.tuple.Util.stringHash(priKey);
            int index = HashOperations.hashSearchOrInsert(this.hashArr, lgMapArrSize, hash);
            if (index < 0) {
                int idx = -(index + 1);
                this.counterArr[idx] = 1;
                ++this.groupCount;
                this.priKeyArr[idx] = priKey;
                continue;
            }
            int n = index;
            this.counterArr[n] = this.counterArr[n] + 1;
        }
        this.mapValid = true;
    }

    private List<Group> populateList(int numStdDev, int limit) {
        ArrayList<Group> list = new ArrayList<Group>();
        for (int i = 0; i < this.mapArrSize; ++i) {
            if (this.hashArr[i] == 0L) continue;
            String priKey = this.priKeyArr[i];
            int count = this.counterArr[i];
            double est = this.sketch.getEstimate(count);
            double ub = this.sketch.getUpperBound(numStdDev, count);
            double lb = this.sketch.getLowerBound(numStdDev, count);
            double thresh = (double)count / (double)this.sketch.getRetainedEntries();
            double rse = this.sketch.getUpperBound(1, count) / est - 1.0;
            Group gp = new Group();
            gp.init(priKey, count, est, ub, lb, thresh, rse);
            list.add(gp);
        }
        list.sort(null);
        int totLen = list.size();
        List<Group> returnList = limit > 0 && limit < totLen ? list.subList(0, limit) : list;
        return returnList;
    }

    private static String getPrimaryKey(String[] tuple, int[] priKeyIndices, char sep) {
        assert (priKeyIndices.length < tuple.length);
        StringBuilder sb = new StringBuilder();
        int keys = priKeyIndices.length;
        for (int i = 0; i < keys; ++i) {
            int idx = priKeyIndices[i];
            sb.append(tuple[idx]);
            if (i + 1 >= keys) continue;
            sb.append(sep);
        }
        return sb.toString();
    }
}

