/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.ExecutorProcessLost;
import org.apache.spark.scheduler.ExecutorProcessLost$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.ui.DelegatingServletContextHandler;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r]bA\u0002$H\u0003\u0003Y\u0015\u000b\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003X\u0011!Y\u0006A!A!\u0002\u0013a\u0006\"\u00021\u0001\t\u0003\t\u0007bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007g\u0002\u0001\u000b\u0011B4\t\u000fQ\u0004!\u0019!C!k\"1A\u0010\u0001Q\u0001\nYDq! \u0001A\u0002\u0013Ea\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0005\u0002\b!9\u00111\u0003\u0001!B\u0013y\b\"CA\u000b\u0001\t\u0007I\u0011CA\f\u0011!\t)\u000b\u0001Q\u0001\n\u0005e\u0001\"CAT\u0001\u0001\u0007I\u0011CAU\u0011%\t9\f\u0001a\u0001\n#\tI\f\u0003\u0005\u0002>\u0002\u0001\u000b\u0015BAV\u0011%\ty\f\u0001b\u0001\n\u0013\t\t\r\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BAY\u0011%\t)\r\u0001b\u0001\n\u0017\t9\r\u0003\u0005\u0002P\u0002\u0001\u000b\u0011BAe\u0011%\t\t\u000e\u0001b\u0001\n\u0017\t\u0019\u000e\u0003\u0005\u0002`\u0002\u0001\u000b\u0011BAk\u0011%\t\t\u000f\u0001a\u0001\n#\t\u0019\u000fC\u0005\u0002\u0000\u0002\u0001\r\u0011\"\u0005\u0003\u0002!A!Q\u0001\u0001!B\u0013\t)\u000fC\u0005\u0003\b\u0001\u0001\r\u0011\"\u0003\u0003\n!I!1\u0003\u0001A\u0002\u0013%!Q\u0003\u0005\t\u00053\u0001\u0001\u0015)\u0003\u0003\f!I!1\u0004\u0001C\u0002\u0013%!Q\u0004\u0005\t\u0005W\u0001\u0001\u0015!\u0003\u0003 !A!Q\u0006\u0001C\u0002\u0013%Q\u000fC\u0004\u00030\u0001\u0001\u000b\u0011\u0002<\t\u0011\tE\u0002A1A\u0005\nyDqAa\r\u0001A\u0003%q\u0010\u0003\u0005\u00036\u0001\u0011\r\u0011\"\u0003\u007f\u0011\u001d\u00119\u0004\u0001Q\u0001\n}D\u0001B!\u000f\u0001\u0005\u0004%IA \u0005\b\u0005w\u0001\u0001\u0015!\u0003\u0000\u0011\u001d\u0011i\u0004\u0001C\t\u0005\u007fAqA!\u0012\u0001\t#\u00119\u0005C\u0004\u0003J\u0001!\tEa\u0012\t\u000f\t-\u0003\u0001\"\u0011\u0003N!9!\u0011\u000b\u0001\u0005B\tM\u0003\u0002\u0003B+\u0001\u0011\u0005qIa\u0016\t\u000f\tE\u0005\u0001\"\u0011\u0003\u0014\"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002B_\u0001\u0011\u0005#q\u0018\u0005\b\u0005\u0003\u0004A\u0011\tBb\u0011!\u0011)\u000e\u0001C\u0001\u000f\n]\u0007b\u0002Bt\u0001\u0011\u0005#\u0011\u001e\u0005\t\u0005c\u0004A\u0011K%\u0003H!9!1\u001f\u0001\u0005R\tUhABB\u0005\u0001\u0011\u0019Y\u0001\u0003\u0004ai\u0011\u00051Q\u0002\u0005\b\u0003k\"D\u0011IB\t\r\u0019\ti\u0002\u0001\u0005\u0002 !Q\u0011qH\u001c\u0003\u0006\u0004%\t%!\u0011\t\u0015\u0005%sG!A!\u0002\u0013\t\u0019\u0005\u0003\u0004ao\u0011\u0005\u00111\n\u0005\t\u0003\u001f:D\u0011A$\u0002R!9\u0011qK\u001c\u0005B\u0005e\u0003bBA4o\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003k:D\u0011IA<\u00111\t\u0019i\u000eB\u0001\u0002\u0003%\t\u0001AAC\u00119\u00199\u0002\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002B*\u000739\u0001ba\bH\u0011\u0003Y5\u0011\u0005\u0004\b\r\u001eC\taSB\u0012\u0011\u0019\u0001'\t\"\u0001\u0004&!I1q\u0005\"C\u0002\u0013\u00051\u0011\u0006\u0005\t\u0007k\u0011\u0005\u0015!\u0003\u0004,\t!\u0012,\u0019:o'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012T!\u0001S%\u0002\u000f\rdWo\u001d;fe*\u0011!jS\u0001\ng\u000eDW\rZ;mKJT!\u0001T'\u0002\u000bM\u0004\u0018M]6\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\n\u0003\u0001I\u0003\"a\u0015+\u000e\u0003\u001dK!!V$\u0003;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u001c\u0001\u0001\u0005\u0002Y36\t\u0011*\u0003\u0002[\u0013\n\tB+Y:l'\u000eDW\rZ;mKJLU\u000e\u001d7\u0002\u0005M\u001c\u0007CA/_\u001b\u0005Y\u0015BA0L\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019!m\u00193\u0011\u0005M\u0003\u0001\"\u0002&\u0004\u0001\u00049\u0006\"B.\u0004\u0001\u0004a\u0016aB:u_B\u0004X\rZ\u000b\u0002OB\u0011\u0001.]\u0007\u0002S*\u0011!n[\u0001\u0007CR|W.[2\u000b\u00051l\u0017AC2p]\u000e,(O]3oi*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005IL'!D!u_6L7MQ8pY\u0016\fg.\u0001\u0005ti>\u0004\b/\u001a3!\u0003Ii\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT\u0011!_\u0001\u0006g\u000e\fG.Y\u0005\u0003wb\u0014a\u0001R8vE2,\u0017aE7j]J+w-[:uKJ,GMU1uS>\u0004\u0013A\u0006;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:\u0016\u0003}\u00042a^A\u0001\u0013\r\t\u0019\u0001\u001f\u0002\u0004\u0013:$\u0018A\u0007;pi\u0006dW\t\u001f9fGR,G-\u0012=fGV$xN]:`I\u0015\fH\u0003BA\u0005\u0003\u001f\u00012a^A\u0006\u0013\r\ti\u0001\u001f\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0012%\t\t\u00111\u0001\u0000\u0003\rAH%M\u0001\u0018i>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sg\u0002\nQ#_1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tG/\u0006\u0002\u0002\u001aA\u0019\u00111D\u001c\u000e\u0003\u0001\u0011Q#W1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tGoE\u00048\u0003C\t9#a\r\u0011\u0007]\f\u0019#C\u0002\u0002&a\u0014a!\u00118z%\u00164\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u000552*A\u0002sa\u000eLA!!\r\u0002,\t)B\u000b\u001b:fC\u0012\u001c\u0016MZ3Sa\u000e,e\u000e\u001a9pS:$\b\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005e2*\u0001\u0005j]R,'O\\1m\u0013\u0011\ti$a\u000e\u0003\u000f1{wmZ5oO\u00061!\u000f]2F]Z,\"!a\u0011\u0011\t\u0005%\u0012QI\u0005\u0005\u0003\u000f\nYC\u0001\u0004Sa\u000e,eN^\u0001\beB\u001cWI\u001c<!)\u0011\tI\"!\u0014\t\u000f\u0005}\"\b1\u0001\u0002D\u0005\u00012/[4oC2$%/\u001b<feN#x\u000e\u001d\u000b\u0005\u0003\u0013\t\u0019\u0006\u0003\u0004\u0002Vm\u0002\ra`\u0001\tKbLGoQ8eK\u00069!/Z2fSZ,WCAA.!\u001d9\u0018QLA1\u0003\u0013I1!a\u0018y\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007cA<\u0002d%\u0019\u0011Q\r=\u0003\u0007\u0005s\u00170A\bsK\u000e,\u0017N^3B]\u0012\u0014V\r\u001d7z)\u0011\tY&a\u001b\t\u000f\u00055T\b1\u0001\u0002p\u000591m\u001c8uKb$\b\u0003BA\u0015\u0003cJA!a\u001d\u0002,\tq!\u000b]2DC2d7i\u001c8uKb$\u0018AD8o\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u000b\u0005\u0003\u0013\tI\bC\u0004\u0002|y\u0002\r!! \u0002\u001bI,Wn\u001c;f\u0003\u0012$'/Z:t!\u0011\tI#a \n\t\u0005\u0005\u00151\u0006\u0002\u000b%B\u001c\u0017\t\u001a3sKN\u001c\u0018!X8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\u001c\u0007.\u001a3vY\u0016\u0014He\u00197vgR,'\u000fJ-be:\u001c6\r[3ek2,'OQ1dW\u0016tG\r\n\u0013iC:$G.Z#yK\u000e,Ho\u001c:ESN\u001cwN\u001c8fGR,GM\u0012:p[\u0012\u0013\u0018N^3s)\u0019\tI!a\"\u0002\"\"9\u0011\u0011R A\u0002\u0005-\u0015AC3yK\u000e,Ho\u001c:JIB!\u0011QRAN\u001d\u0011\ty)a&\u0011\u0007\u0005E\u00050\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013,\u0002\rq\u0012xn\u001c;?\u0013\r\tI\n_\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0015q\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\u0005\u0010C\u0004\u0002$~\u0002\r!! \u0002%\u0015DXmY;u_J\u0014\u0006oY!eIJ,7o]\u0001\u0017s\u0006\u0014hnU2iK\u0012,H.\u001a:F]\u0012\u0004x.\u001b8uA\u0005Q\u0011-\\#oIB|\u0017N\u001c;\u0016\u0005\u0005-\u0006#B<\u0002.\u0006E\u0016bAAXq\n1q\n\u001d;j_:\u0004B!!\u000b\u00024&!\u0011QWA\u0016\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fa\"Y7F]\u0012\u0004x.\u001b8u?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005m\u0006\"CA\t\u001d\u0005\u0005\t\u0019AAV\u0003-\tW.\u00128ea>Lg\u000e\u001e\u0011\u00021e\f'O\\*dQ\u0016$W\u000f\\3s\u000b:$\u0007o\\5oiJ+g-\u0006\u0002\u00022\u0006I\u00120\u0019:o'\u000eDW\rZ;mKJ,e\u000e\u001a9pS:$(+\u001a4!\u0003)\t7o\u001b+j[\u0016|W\u000f^\u000b\u0003\u0003\u0013\u0004B!!\u000b\u0002L&!\u0011QZA\u0016\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f^\u0001\fCN\\G+[7f_V$\b%A\ntG\",G-\u001e7fe\u0016sG\r]8j]R,5)\u0006\u0002\u0002VB!\u0011q[An\u001b\t\tIN\u0003\u0002mq&!\u0011Q\\Am\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0015g\u000eDW\rZ;mKJ,e\u000e\u001a9pS:$Xi\u0011\u0011\u0002\u000b\u0005\u0004\b/\u00133\u0016\u0005\u0005\u0015\b#B<\u0002.\u0006\u001d\b\u0003BAu\u0003wl!!a;\u000b\t\u00055\u0018q^\u0001\be\u0016\u001cwN\u001d3t\u0015\u0011\t\t0a=\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002v\u0006]\u0018\u0001B=be:T1!!?N\u0003\u0019A\u0017\rZ8pa&!\u0011Q`Av\u00055\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\u0006I\u0011\r\u001d9JI~#S-\u001d\u000b\u0005\u0003\u0013\u0011\u0019\u0001C\u0005\u0002\u0012]\t\t\u00111\u0001\u0002f\u00061\u0011\r\u001d9JI\u0002\n\u0011\"\u0019;uK6\u0004H/\u00133\u0016\u0005\t-\u0001#B<\u0002.\n5\u0001\u0003BAu\u0005\u001fIAA!\u0005\u0002l\n!\u0012\t\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u\u0013\u0012\fQ\"\u0019;uK6\u0004H/\u00133`I\u0015\fH\u0003BA\u0005\u0005/A\u0011\"!\u0005\u001b\u0003\u0003\u0005\rAa\u0003\u0002\u0015\u0005$H/Z7qi&#\u0007%\u0001\ncY>\u001c7.T1oC\u001e,'/T1ti\u0016\u0014XC\u0001B\u0010!\u0011\u0011\tCa\n\u000e\u0005\t\r\"b\u0001B\u0013\u0017\u000691\u000f^8sC\u001e,\u0017\u0002\u0002B\u0015\u0005G\u0011!C\u00117pG.l\u0015M\\1hKJl\u0015m\u001d;fe\u0006\u0019\"\r\\8dW6\u000bg.Y4fe6\u000b7\u000f^3sA\u0005AR.\u001b8NKJ<WM]:UQJ,7\u000f[8mIJ\u000bG/[8\u000235Lg.T3sO\u0016\u00148\u000f\u00165sKNDw\u000e\u001c3SCRLw\u000eI\u0001\u001a[&tW*\u001a:hKJ\u001c8\u000b^1uS\u000e$\u0006N]3tQ>dG-\u0001\u000enS:lUM]4feN\u001cF/\u0019;jGRC'/Z:i_2$\u0007%A\bnCbtU/\\#yK\u000e,Ho\u001c:t\u0003Ai\u0017\r\u001f(v[\u0016CXmY;u_J\u001c\b%\u0001\u0007ok6,\u00050Z2vi>\u00148/A\u0007ok6,\u00050Z2vi>\u00148\u000fI\u0001\u000bE&tG\rV8ZCJtGCBA\u0005\u0005\u0003\u0012\u0019\u0005C\u0004\u0002b\u001a\u0002\r!a:\t\u000f\t\u001da\u00051\u0001\u0003\f\u0005i1\u000f^1si\nKg\u000eZ5oON$\"!!\u0003\u0002\tM$x\u000e]\u0001\u0015CB\u0004H.[2bi&|g.\u0011;uK6\u0004H/\u00133\u0015\u0005\t=\u0003#B<\u0002.\u0006-\u0015!D1qa2L7-\u0019;j_:LE\r\u0006\u0002\u0002\f\u00069\u0002O]3qCJ,'+Z9vKN$X\t_3dkR|'o\u001d\u000b\u0005\u00053\u0012Y\b\u0005\u0003\u0003\\\tUd\u0002\u0002B/\u0005crAAa\u0018\u0003p9!!\u0011\rB7\u001d\u0011\u0011\u0019Ga\u001b\u000f\t\t\u0015$\u0011\u000e\b\u0005\u0003#\u00139'C\u0001Q\u0013\tqu*\u0003\u0002M\u001b&\u0011!jS\u0005\u0003\u0011&K1Aa\u001dH\u0003q\u0019u.\u0019:tK\u001e\u0013\u0018-\u001b8fI\u000ecWo\u001d;fe6+7o]1hKNLAAa\u001e\u0003z\t\u0001\"+Z9vKN$X\t_3dkR|'o\u001d\u0006\u0004\u0005g:\u0005b\u0002B?W\u0001\u0007!qP\u0001\u001ce\u0016\u001cx.\u001e:dKB\u0013xNZ5mKR{Gk\u001c;bY\u0016CXmY:\u0011\u000f\u00055%\u0011\u0011BC\u007f&!!1QAP\u0005\ri\u0015\r\u001d\t\u0005\u0005\u000f\u0013i)\u0004\u0002\u0003\n*\u0019!1R&\u0002\u0011I,7o\\;sG\u0016LAAa$\u0003\n\ny!+Z:pkJ\u001cW\r\u0015:pM&dW-A\fe_J+\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sgR!!Q\u0013BQ!\u0019\t9Na&\u0003\u001c&!!\u0011TAm\u0005\u00191U\u000f^;sKB\u0019qO!(\n\u0007\t}\u0005PA\u0004C_>dW-\u00198\t\u000f\tuD\u00061\u0001\u0003\u0000\u0005yAm\\&jY2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003\u0016\n\u001d\u0006b\u0002BU[\u0001\u0007!1V\u0001\fKb,7-\u001e;pe&#7\u000f\u0005\u0004\u0003.\n]\u00161\u0012\b\u0005\u0005_\u0013\u0019L\u0004\u0003\u0002\u0012\nE\u0016\"A=\n\u0007\tU\u00060A\u0004qC\u000e\\\u0017mZ3\n\t\te&1\u0018\u0002\u0004'\u0016\f(b\u0001B[q\u0006i2/\u001e4gS\u000eLWM\u001c;SKN|WO]2fgJ+w-[:uKJ,G\r\u0006\u0002\u0003\u001c\u0006ir-\u001a;TQV4g\r\\3QkNDW*\u001a:hKJdunY1uS>t7\u000f\u0006\u0004\u0003F\n5'\u0011\u001b\t\u0007\u0005[\u00139La2\u0011\t\t\u0005\"\u0011Z\u0005\u0005\u0005\u0017\u0014\u0019C\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\t\r\t=w\u00061\u0001\u0000\u00035qW/\u001c)beRLG/[8og\"1!1[\u0018A\u0002}\f\u0011C]3t_V\u00148-\u001a)s_\u001aLG.Z%e\u00039\tG\rZ,fEVKe)\u001b7uKJ$\u0002\"!\u0003\u0003Z\nu'1\u001d\u0005\b\u00057\u0004\u0004\u0019AAF\u0003)1\u0017\u000e\u001c;fe:\u000bW.\u001a\u0005\b\u0005?\u0004\u0004\u0019\u0001Bq\u000311\u0017\u000e\u001c;feB\u000b'/Y7t!!\tiI!!\u0002\f\u0006-\u0005b\u0002Bsa\u0001\u0007\u00111R\u0001\naJ|\u00070\u001f\"bg\u0016\fAc\u0019:fCR,GI]5wKJ,e\u000e\u001a9pS:$HC\u0001Bv!\u0011\tYB!<\n\u0007\t=HK\u0001\bEe&4XM]#oIB|\u0017N\u001c;\u0002\u000bI,7/\u001a;\u0002%\r\u0014X-\u0019;f)>\\WM\\'b]\u0006<WM\u001d\u000b\u0003\u0005o\u0004Ra^AW\u0005s\u0004BAa?\u0004\u00065\u0011!Q \u0006\u0005\u0005\u007f\u001c\t!\u0001\u0005tK\u000e,(/\u001b;z\u0015\r\u0019\u0019aS\u0001\u0007I\u0016\u0004Hn\\=\n\t\r\u001d!Q \u0002\u001d\u0011\u0006$wn\u001c9EK2,w-\u0019;j_:$vn[3o\u001b\u0006t\u0017mZ3s\u0005II\u0016M\u001d8Ee&4XM]#oIB|\u0017N\u001c;\u0014\u0007Q\u0012Y\u000f\u0006\u0002\u0004\u0010A\u0019\u00111\u0004\u001b\u0015\t\u0005%11\u0003\u0005\b\u0007+1\u0004\u0019AA?\u0003)\u0011\boY!eIJ,7o]\u0001\u0014gV\u0004XM\u001d\u0013baBd\u0017nY1uS>t\u0017\nZ\u0005\u0005\u0005#\u001aY\"C\u0002\u0004\u001e%\u0013\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0002)e\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\t\u0019&iE\u0002C\u0003C!\"a!\t\u0002\u001b\u0015sE\tU(J\u001dR{f*Q'F+\t\u0019Y\u0003\u0005\u0003\u0004.\rMRBAB\u0018\u0015\r\u0019\td\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u000e=\u0012AD#O\tB{\u0015J\u0014+`\u001d\u0006kU\t\t")
public abstract class YarnSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final TaskSchedulerImpl scheduler;
    private final SparkContext sc;
    private final AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    private final double minRegisteredRatio;
    private int totalExpectedExecutors;
    private final YarnSchedulerEndpoint yarnSchedulerEndpoint;
    private Option<RpcEndpointRef> amEndpoint;
    private final RpcEndpointRef yarnSchedulerEndpointRef;
    private final RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    private final ExecutionContextExecutorService org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC;
    private Option<ApplicationId> appId;
    private Option<ApplicationAttemptId> attemptId;
    private final BlockManagerMaster blockManagerMaster;
    private final double minMergersThresholdRatio;
    private final int minMergersStaticThreshold;
    private final int maxNumExecutors;
    private final int numExecutors;

    public static String ENDPOINT_NAME() {
        return YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public int totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    public void totalExpectedExecutors_$eq(int x$1) {
        this.totalExpectedExecutors = x$1;
    }

    public YarnSchedulerEndpoint yarnSchedulerEndpoint() {
        return this.yarnSchedulerEndpoint;
    }

    public Option<RpcEndpointRef> amEndpoint() {
        return this.amEndpoint;
    }

    public void amEndpoint_$eq(Option<RpcEndpointRef> x$1) {
        this.amEndpoint = x$1;
    }

    private RpcEndpointRef yarnSchedulerEndpointRef() {
        return this.yarnSchedulerEndpointRef;
    }

    public RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    }

    public ExecutionContextExecutorService org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    private Option<ApplicationAttemptId> attemptId() {
        return this.attemptId;
    }

    private void attemptId_$eq(Option<ApplicationAttemptId> x$1) {
        this.attemptId = x$1;
    }

    private BlockManagerMaster blockManagerMaster() {
        return this.blockManagerMaster;
    }

    private double minMergersThresholdRatio() {
        return this.minMergersThresholdRatio;
    }

    private int minMergersStaticThreshold() {
        return this.minMergersStaticThreshold;
    }

    private int maxNumExecutors() {
        return this.maxNumExecutors;
    }

    private int numExecutors() {
        return this.numExecutors;
    }

    public void bindToYarn(ApplicationId appId, Option<ApplicationAttemptId> attemptId) {
        this.appId_$eq((Option<ApplicationId>)new Some((Object)appId));
        this.attemptId_$eq(attemptId);
    }

    public void startBindings() {
        Predef$.MODULE$.require(this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "application ID unset");
    }

    public void stop() {
        try {
            this.requestTotalExecutors(Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty());
            super.stop();
        }
        finally {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().set(true);
        }
    }

    public Option<String> applicationAttemptId() {
        return this.attemptId().map((Function1 & Serializable & scala.Serializable)x$1 -> Integer.toString(x$1.getAttemptId()));
    }

    public String applicationId() {
        return (String)this.appId().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    public CoarseGrainedClusterMessages.RequestExecutors prepareRequestExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        Set excludedNodes = this.scheduler.excludedNodes();
        Map filteredRPHostToLocalTaskCount = (Map)this.rpHostToLocalTaskCount().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int rpid = tuple2._1$mcI$sp();
                Map v = (Map)tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)rpid), v.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerBackend.$anonfun$prepareRequestExecutors$2(excludedNodes, x0$2))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        return new CoarseGrainedClusterMessages.RequestExecutors(resourceProfileToTotalExecs, this.numLocalityAwareTasksPerResourceProfileId(), filteredRPHostToLocalTaskCount, excludedNodes);
    }

    public Future<Object> doRequestTotalExecutors(Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        return this.yarnSchedulerEndpointRef().ask((Object)this.prepareRequestExecutors(resourceProfileToTotalExecs), ClassTag$.MODULE$.Boolean());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return this.yarnSchedulerEndpointRef().ask((Object)new CoarseGrainedClusterMessages.KillExecutors(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.totalExpectedExecutors() * this.minRegisteredRatio();
    }

    public Seq<BlockManagerId> getShufflePushMergerLocations(int numPartitions, int resourceProfileId) {
        int maxExecutors = Utils$.MODULE$.isDynamicAllocationEnabled(this.sc.getConf()) ? this.maxNumExecutors() : this.numExecutors();
        int tasksPerExecutor = this.sc.resourceProfileManager().resourceProfileFromId(resourceProfileId).maxTasksPerExecutor(this.sc.conf());
        int numMergersDesired = package$.MODULE$.min(package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(numPartitions / tasksPerExecutor))), maxExecutors);
        int minMergersNeeded = package$.MODULE$.max(this.minMergersStaticThreshold(), (int)package$.MODULE$.floor((double)numMergersDesired * this.minMergersThresholdRatio()));
        Seq mergerLocations = this.blockManagerMaster().getShufflePushMergerLocations(numMergersDesired, this.scheduler.excludedNodes());
        if (mergerLocations.size() < numMergersDesired && mergerLocations.size() < minMergersNeeded) {
            return (Seq)Nil$.MODULE$;
        }
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("The number of shuffle mergers desired ").append(numMergersDesired).append(" and available locations are ").append(mergerLocations.length()).toString());
        return mergerLocations;
    }

    public void addWebUIFilter(String filterName, Map<String, String> filterParams, String proxyBase) {
        boolean hasFilter;
        Object object = proxyBase != null && new StringOps(Predef$.MODULE$.augmentString(proxyBase)).nonEmpty() ? System.setProperty("spark.ui.proxyBase", proxyBase) : BoxedUnit.UNIT;
        boolean bl = hasFilter = filterName != null && new StringOps(Predef$.MODULE$.augmentString(filterName)).nonEmpty() && filterParams != null && filterParams.nonEmpty();
        if (hasFilter) {
            Seq allFilters = (Seq)((TraversableLike)new .colon.colon((Object)filterName, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.conf().get(UI$.MODULE$.UI_FILTERS()), Seq$.MODULE$.canBuildFrom());
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add WebUI Filter. ").append(filterName).append(", ").append(filterParams).append(", ").append(proxyBase).toString());
            this.scheduler.sc().ui().foreach((Function1 & Serializable & scala.Serializable)ui -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$2(this, filterParams, filterName, allFilters, ui);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new YarnDriverEndpoint(this);
    }

    public void reset() {
        super.reset();
        this.sc.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.reset();
            return BoxedUnit.UNIT;
        });
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.sc.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public static final /* synthetic */ boolean $anonfun$prepareRequestExecutors$2(Set excludedNodes$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String host = (String)tuple2._1();
            return !excludedNodes$1.contains((Object)host);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$4(String filterName$1, Map filterParams$1, DelegatingServletContextHandler h) {
        h.addFilter(filterName$1, filterName$1, filterParams$1);
        h.prependFilterMapping(filterName$1, "/*", EnumSet.allOf(DispatcherType.class));
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$2(YarnSchedulerBackend $this, Map filterParams$1, String filterName$1, Seq allFilters$1, SparkUI ui) {
        SparkUI sparkUI = ui;
        synchronized (sparkUI) {
            filterParams$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return $this.conf().set(new StringBuilder(13).append("spark.").append(filterName$1).append(".param.").append(k).toString(), v);
                }
                throw new MatchError((Object)tuple2);
            });
            $this.conf().set(UI$.MODULE$.UI_FILTERS(), (Object)allFilters$1);
            ui.getDelegatingHandlers().foreach((Function1 & Serializable & scala.Serializable)h -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$4(filterName$1, filterParams$1, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public YarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.scheduler = scheduler;
        this.sc = sc;
        super(scheduler, sc.env().rpcEnv());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped = new AtomicBoolean(false);
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.totalExpectedExecutors = 0;
        this.yarnSchedulerEndpoint = new YarnSchedulerEndpoint(this, this.rpcEnv());
        this.amEndpoint = None$.MODULE$;
        this.yarnSchedulerEndpointRef = this.rpcEnv().setupEndpoint(YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.yarnSchedulerEndpoint());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout = RpcUtils$.MODULE$.askRpcTimeout(sc.conf());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor("yarn-scheduler-endpoint"));
        this.appId = None$.MODULE$;
        this.attemptId = None$.MODULE$;
        this.blockManagerMaster = sc.env().blockManager().master();
        this.minMergersThresholdRatio = BoxesRunTime.unboxToDouble((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MERGER_LOCATIONS_MIN_THRESHOLD_RATIO()));
        this.minMergersStaticThreshold = BoxesRunTime.unboxToInt((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MERGER_LOCATIONS_MIN_STATIC_THRESHOLD()));
        this.maxNumExecutors = BoxesRunTime.unboxToInt((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS()));
        this.numExecutors = BoxesRunTime.unboxToInt((Object)((Option)this.conf().get((ConfigEntry)org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    private class YarnDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                YarnDriverEndpoint.$anonfun$onDisconnected$1(this, rpcAddress, executorId);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer() {
            return (YarnSchedulerBackend)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onDisconnected$1(YarnDriverEndpoint $this, RpcAddress rpcAddress$1, String executorId) {
            if (!$this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                if ($this.disableExecutor(executorId)) {
                    $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().yarnSchedulerEndpoint().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(executorId, rpcAddress$1);
                    return;
                }
                return;
            }
        }

        public YarnDriverEndpoint(YarnSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }

    public class YarnSchedulerEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ YarnSchedulerBackend $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.onStop$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(String executorId, RpcAddress executorRpcAddress) {
            Future future;
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                CoarseGrainedClusterMessages.GetExecutorLossReason lossReasonRequest = new CoarseGrainedClusterMessages.GetExecutorLossReason(executorId);
                future = am.ask((Object)lossReasonRequest, this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout(), ClassTag$.MODULE$.apply(ExecutorLossReason.class)).map((Function1 & Serializable & scala.Serializable)reason -> new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), (ExecutionContext)ThreadUtils$.MODULE$.sameThread()).recover((PartialFunction)new scala.Serializable(this, executorId, executorRpcAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnSchedulerEndpoint $outer;
                    private final String executorId$1;
                    private final RpcAddress executorRpcAddress$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("Attempted to get executor loss reason").append(" for executor id ").append($this.executorId$1).append(" at RPC address ").append($this.executorRpcAddress$1).append(",").append(" but got no response. Marking as agent lost.").toString(), e);
                            return (B1)new CoarseGrainedClusterMessages.RemoveExecutor(this.executorId$1, (ExecutorLossReason)new ExecutorProcessLost(ExecutorProcessLost$.MODULE$.apply$default$1(), ExecutorProcessLost$.MODULE$.apply$default$2(), ExecutorProcessLost$.MODULE$.apply$default$3()));
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        return !option.isEmpty();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executorId$1 = executorId$1;
                        this.executorRpcAddress$1 = executorRpcAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$1 )}, serializedLambda);
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to check for an executor loss reason before the AM has registered!");
                future = Future$.MODULE$.successful((Object)new CoarseGrainedClusterMessages.RemoveExecutor(executorId, (ExecutorLossReason)new ExecutorProcessLost("AM is not yet registered.", ExecutorProcessLost$.MODULE$.apply$default$2(), ExecutorProcessLost$.MODULE$.apply$default$3())));
            } else {
                throw new MatchError(option);
            }
            Future removeExecutorMessage = future;
            removeExecutorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                YarnSchedulerEndpoint.$anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(this, message);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$schedulerEndpointEC());
        }

        public void signalDriverStop(int exitCode) {
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                am.send((Object)new CoarseGrainedClusterMessages.Shutdown(exitCode));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to send shutdown message before the AM has registered!");
                return;
            }
            throw new MatchError(option);
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        CoarseGrainedClusterMessages.RegisterClusterManager registerClusterManager = (CoarseGrainedClusterMessages.RegisterClusterManager)A1;
                        RpcEndpointRef am = registerClusterManager.am();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("ApplicationMaster registered as ").append(am).toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)Option$.MODULE$.apply((Object)am));
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().reset();
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.DecommissionExecutorsOnHost) {
                        CoarseGrainedClusterMessages.DecommissionExecutorsOnHost decommissionExecutorsOnHost = (CoarseGrainedClusterMessages.DecommissionExecutorsOnHost)A1;
                        String hostId = decommissionExecutorsOnHost.host();
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Requesting to decommission host ").append(hostId).append(". Sending to driver").toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)decommissionExecutorsOnHost);
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        String filterName = addWebUIFilter.filterName();
                        Map filterParams = addWebUIFilter.filterParams();
                        String proxyBase = addWebUIFilter.proxyBase();
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().addWebUIFilter(filterName, (Map<String, String>)filterParams, proxyBase);
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        if (!this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting driver to remove executor ").append(executorId).append(" for reason ").append(reason).toString());
                            this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)removeExecutor);
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.MiscellaneousProcessAdded) {
                        CoarseGrainedClusterMessages.MiscellaneousProcessAdded miscellaneousProcessAdded = (CoarseGrainedClusterMessages.MiscellaneousProcessAdded)A1;
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sending the Spark AM info for yarn client mode");
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)miscellaneousProcessAdded);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    if (object instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        return true;
                    }
                    if (object instanceof CoarseGrainedClusterMessages.DecommissionExecutorsOnHost) {
                        return true;
                    }
                    if (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        return true;
                    }
                    if (object instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        return true;
                    }
                    return object instanceof CoarseGrainedClusterMessages.MiscellaneousProcessAdded;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$3(java.lang.String ), $anonfun$applyOrElse$4(java.lang.String org.apache.spark.scheduler.ExecutorLossReason ), $anonfun$applyOrElse$5()}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)requestExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, requestExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.RequestExecutors x2$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    A1 A1 = x1;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                    if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x2$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                    return (B1)function1.apply(x1);
                                }

                                public final boolean isDefinedAt(Try<Object> x1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x1;
                                    if (try_ instanceof Success) {
                                        return true;
                                    }
                                    return try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$6 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        } else {
                            throw new MatchError(option);
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)killExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, killExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.KillExecutors x3$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    A1 A1 = x2;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                    if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x3$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        return (B1)BoxedUnit.UNIT;
                                    }
                                    return (B1)function1.apply(x2);
                                }

                                public final boolean isDefinedAt(Try<Object> x2) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x2;
                                    if (try_ instanceof Success) {
                                        return true;
                                    }
                                    return try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$9 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        } else {
                            throw new MatchError(option);
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentExecutorIdCounter()));
                        return (B1)BoxedUnit.UNIT;
                    }
                    if (CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentDelegationTokens());
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    if (object instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        return true;
                    }
                    if (object instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        return true;
                    }
                    if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(object)) {
                        return true;
                    }
                    return CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(object);
                }

                public /* synthetic */ YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(), $anonfun$applyOrElse$11()}, serializedLambda);
                }
            };
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            if (this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerEndpoint.$anonfun$onDisconnected$2(remoteAddress, x$4)))) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("ApplicationMaster has disassociated: ").append(remoteAddress).toString());
                this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)None$.MODULE$);
                return;
            }
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(YarnSchedulerEndpoint $this, CoarseGrainedClusterMessages.RemoveExecutor message) {
            $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)message);
        }

        public static final /* synthetic */ boolean $anonfun$onDisconnected$2(RpcAddress remoteAddress$1, RpcEndpointRef x$4) {
            RpcAddress rpcAddress = x$4.address();
            RpcAddress rpcAddress2 = remoteAddress$1;
            return !(rpcAddress != null ? !rpcAddress.equals(rpcAddress2) : rpcAddress2 != null);
        }

        public YarnSchedulerEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            Logging.$init$((Logging)this);
        }
    }
}

