/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF0;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class JavaUserDefinedScalar {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("Java Spark SQL UDF scalar example").getOrCreate();
        UserDefinedFunction random = functions.udf((UDF0 & Serializable)() -> Math.random(), (DataType)DataTypes.DoubleType);
        random.asNondeterministic();
        spark.udf().register("random", random);
        spark.sql("SELECT random()").show();
        spark.udf().register("plusOne", (UDF1 & Serializable)x -> x + 1, DataTypes.IntegerType);
        spark.sql("SELECT plusOne(5)").show();
        UserDefinedFunction strLen = functions.udf((UDF2 & Serializable)(s, x) -> s.length() + x, (DataType)DataTypes.IntegerType);
        spark.udf().register("strLen", strLen);
        spark.sql("SELECT strLen('test', 1)").show();
        spark.udf().register("oneArgFilter", (UDF1 & Serializable)x -> x > 5L, DataTypes.BooleanType);
        spark.range(1L, 10L).createOrReplaceTempView("test");
        spark.sql("SELECT * FROM test WHERE oneArgFilter(id)").show();
        spark.stop();
    }
}

