/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;

public class JcrNamespaceMangler {
    private static final String MANGLE_NAMESPACE_IN_SUFFIX = "_";
    private static final String MANGLE_NAMESPACE_IN_PREFIX = "/_";
    private static final Pattern MANGLE_NAMESPACE_IN_PATTERN = Pattern.compile("/_([^_/]+)_");
    private static final String MANGLE_NAMESPACE_OUT_SUFFIX = ":";
    private static final String MANGLE_NAMESPACE_OUT_PREFIX = "/";
    private static final Pattern MANLE_NAMESPACE_OUT_PATTERN = Pattern.compile("/([^:/]+):");

    public String mangleNamespaces(ResourceResolver resolver, Logger logger, String absPath) {
        Session session;
        if (absPath.contains(MANGLE_NAMESPACE_OUT_SUFFIX) && (session = (Session)resolver.adaptTo(Session.class)) != null) {
            Matcher m = MANLE_NAMESPACE_OUT_PATTERN.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String namespace = m.group(1);
                try {
                    session.getNamespaceURI(namespace);
                    String replacement = MANGLE_NAMESPACE_IN_PREFIX + namespace + MANGLE_NAMESPACE_IN_SUFFIX;
                    m.appendReplacement(buf, replacement);
                }
                catch (NamespaceException ne) {
                    logger.debug("mangleNamespaces: '{}' is not a prefix, not mangling", (Object)namespace);
                }
                catch (RepositoryException re) {
                    logger.warn("mangleNamespaces: Problem checking namespace '{}'", (Object)namespace, (Object)re);
                }
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }

    public String unmangleNamespaces(ResourceResolver resolver, Logger logger, String absPath) {
        Session session;
        if (absPath.contains(MANGLE_NAMESPACE_IN_PREFIX) && (session = (Session)resolver.adaptTo(Session.class)) != null) {
            Matcher m = MANGLE_NAMESPACE_IN_PATTERN.matcher(absPath);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String namespace = m.group(1);
                try {
                    session.getNamespaceURI(namespace);
                    String replacement = MANGLE_NAMESPACE_OUT_PREFIX + namespace + MANGLE_NAMESPACE_OUT_SUFFIX;
                    m.appendReplacement(buf, replacement);
                }
                catch (NamespaceException ne) {
                    logger.debug("unmangleNamespaces: '{}' is not a prefix, not unmangling", (Object)namespace);
                }
                catch (RepositoryException re) {
                    logger.warn("unmangleNamespaces: Problem checking namespace '{}'", (Object)namespace, (Object)re);
                }
            }
            m.appendTail(buf);
            absPath = buf.toString();
        }
        return absPath;
    }
}

