/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resource.filter.ResourcePredicates;
import org.apache.sling.resource.filter.impl.ComparisonVisitor;
import org.apache.sling.resource.filter.impl.Context;
import org.apache.sling.resource.filter.impl.DefaultContext;
import org.apache.sling.resource.filter.impl.LogicVisitor;
import org.apache.sling.resource.filter.impl.node.Node;
import org.apache.sling.resource.filter.impl.script.FilterParser;
import org.apache.sling.resource.filter.impl.script.ParseException;
import org.osgi.service.component.annotations.Component;

@Component
public class ResourcePredicateImpl
implements ResourcePredicates {
    @Override
    public Predicate<Resource> parse(String filter) {
        return new ResourcePredicateBuilderImpl().parse(filter);
    }

    @Override
    public Predicate<Resource> parse(String filter, String charEncoding) {
        return new ResourcePredicateBuilderImpl().parse(filter, charEncoding);
    }

    @Override
    public ResourcePredicates.ResourcePredicateBuilder withParameters(Map<String, Object> params) {
        return new ResourcePredicateBuilderImpl().withParameters(params);
    }

    @Override
    public ResourcePredicates.ResourcePredicateBuilder withParameter(String key, Object value) {
        return new ResourcePredicateBuilderImpl().withParameter(key, value);
    }

    @Override
    public ResourcePredicates.ResourcePredicateBuilder usingParameterMap(Map<String, Object> params) {
        return new ResourcePredicateBuilderImpl().usingParameterMap(params);
    }

    public static class ResourcePredicateBuilderImpl
    implements ResourcePredicates.ResourcePredicateBuilder {
        private Context context = new DefaultContext();

        private ResourcePredicateBuilderImpl() {
            new LogicVisitor(this.context);
            new ComparisonVisitor(this.context);
        }

        @Override
        public Predicate<Resource> parse(String filter) {
            try {
                Node rootNode = new FilterParser(new ByteArrayInputStream(filter.getBytes())).parse();
                return rootNode.accept(this.context.getLogicVisitor());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Predicate<Resource> parse(String filter, String charEncoding) {
            try {
                Node rootNode = new FilterParser(new ByteArrayInputStream(filter.getBytes()), charEncoding).parse();
                return rootNode.accept(this.context.getLogicVisitor());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public ResourcePredicates.ResourcePredicateBuilder withParameters(Map<String, Object> params) {
            this.context.addParameters(params);
            return this;
        }

        @Override
        public ResourcePredicates.ResourcePredicateBuilder withParameter(String key, Object value) {
            this.context.addParameter(key, value);
            return this;
        }

        @Override
        public ResourcePredicates.ResourcePredicateBuilder usingParameterMap(Map<String, Object> params) {
            this.context.replaceParameterMap(params);
            return this;
        }
    }
}

