/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.joran;

import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import org.apache.sling.commons.log.logback.OsgiAction;
import org.apache.sling.commons.log.logback.OsgiAppenderRefAction;
import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.joran.ModelHandlerWrapperFactory;
import org.apache.sling.commons.log.logback.internal.joran.OsgiAppenderRefModel;
import org.apache.sling.commons.log.logback.internal.joran.OsgiModel;
import org.apache.sling.commons.log.logback.internal.joran.OsgiModelHandler;
import org.jetbrains.annotations.NotNull;

public class JoranConfiguratorWrapper
extends JoranConfigurator {
    private LogConfigManager logConfigManager;

    public JoranConfiguratorWrapper(@NotNull LogConfigManager manager) {
        this.logConfigManager = manager;
    }

    @Override
    public void buildModelInterpretationContext() {
        super.buildModelInterpretationContext();
        this.logConfigManager.addSubsitutionProperties(this.modelInterpretationContext);
    }

    @Override
    protected void addModelHandlerAssociations(@NotNull DefaultProcessor defaultProcessor) {
        super.addModelHandlerAssociations(defaultProcessor);
        ModelHandlerWrapperFactory factory = new ModelHandlerWrapperFactory(this.logConfigManager);
        defaultProcessor.addHandler(AppenderRefModel.class, factory::makeAppenderRefModelHandlerInstance);
        defaultProcessor.addHandler(OsgiAppenderRefModel.class, factory::makeOsgiAppenderRefModelHandlerInstance);
        defaultProcessor.addHandler(OsgiModel.class, OsgiModelHandler::makeInstance);
    }

    @Override
    public void addElementSelectorAndActionAssociations(RuleStore rs) {
        super.addElementSelectorAndActionAssociations(rs);
        rs.addRule(new ElementSelector("*/configuration/osgi"), OsgiAction::new);
        rs.addRule(new ElementSelector("*/configuration/appender-ref-osgi"), OsgiAppenderRefAction::new);
    }
}

