/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallHookProcessorImpl
implements InstallHookProcessor {
    private static final Logger log = LoggerFactory.getLogger(InstallHookProcessorImpl.class);
    private final TreeMap<String, Hook> hooks = new TreeMap();

    @Override
    public void registerHooks(Archive archive, ClassLoader classLoader) throws PackageException {
        try {
            Archive.Entry root = archive.getRoot();
            root = root.getChild("META-INF");
            if (root == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"META-INF");
                return;
            }
            if ((root = root.getChild("vault")) == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"vault");
                return;
            }
            if ((root = root.getChild("hooks")) == null) {
                log.debug("Archive {} does not have a {} directory.", (Object)archive, (Object)"hooks");
            } else {
                for (Archive.Entry entry : root.getChildren()) {
                    if (!entry.getName().endsWith(".jar")) continue;
                    this.registerHook(archive.getInputSource(entry), classLoader);
                }
            }
            Properties props = archive.getMetaInf().getProperties();
            if (props != null) {
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String name = enumeration.nextElement().toString();
                    if (!name.startsWith("installhook.")) continue;
                    String[] segs = Text.explode(name.substring("installhook.".length()), 46);
                    if (segs.length == 0 || segs.length > 2 || !"class".equals(segs[1])) {
                        throw new PackageException("Invalid installhook property: " + name);
                    }
                    Hook hook = new Hook(segs[0], props.getProperty(name), classLoader);
                    this.initHook(hook);
                }
            }
        }
        catch (IOException e) {
            throw new PackageException("I/O Error while registering hooks", e);
        }
    }

    @Override
    public void registerHook(VaultInputSource input, ClassLoader classLoader) throws IOException, PackageException {
        Path jarFile = Files.createTempFile("vaulthook", ".jar", new FileAttribute[0]);
        Hook hook = new Hook(input.getSystemId(), jarFile, classLoader);
        try (InputStream in = input.getByteStream();){
            Files.copy(in, jarFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                hook.destroy();
            }
            catch (IOException ioeDuringDestroy) {
                e.addSuppressed(ioeDuringDestroy);
            }
            throw e;
        }
        this.initHook(hook);
    }

    private void initHook(Hook hook) throws IOException, PackageException {
        try {
            hook.init();
        }
        catch (IOException | PackageException e) {
            log.error("Error while initializing hook: {}", (Object)e.toString());
            try {
                hook.destroy();
            }
            catch (IOException ioeDuringDestroy) {
                e.addSuppressed(ioeDuringDestroy);
            }
            throw e;
        }
        this.hooks.put(hook.name, hook);
        log.info("Hook {} registered.", (Object)hook.name);
    }

    @Override
    public boolean hasHooks() {
        return !this.hooks.isEmpty();
    }

    @Override
    public boolean execute(InstallContext context) {
        for (Hook hook : this.hooks.values()) {
            try {
                hook.getHook().execute(context);
            }
            catch (Throwable e) {
                if (context.getPhase() == InstallContext.Phase.PREPARE || context.getPhase() == InstallContext.Phase.INSTALLED) {
                    log.warn("Hook {} threw exception. {} aborted.", new Object[]{hook.name, context.getPhase(), e});
                    return false;
                }
                log.warn("Hook {} threw exception. Ignored", (Object)hook.name, (Object)e);
            }
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        Throwable ioException = null;
        for (Hook hook : this.hooks.values()) {
            try {
                hook.destroy();
            }
            catch (IOException e) {
                if (ioException == null) {
                    ioException = new IOException("Error while destroying one or more hooks. Look at suppressed exceptions for details!");
                }
                ioException.addSuppressed(e);
            }
        }
        if (ioException != null) {
            throw ioException;
        }
    }

    private class Hook {
        private final String name;
        private final Path jarFile;
        private ClassLoader parentClassLoader;
        private URLClassLoader urlClassLoader;
        private InstallHook hook;
        private String mainClassName;

        private Hook(String name, String mainClassName, ClassLoader parentClassLoader) {
            this.name = name;
            this.mainClassName = mainClassName;
            this.parentClassLoader = parentClassLoader;
            this.jarFile = null;
        }

        private Hook(String name, Path jarFile, ClassLoader parentClassLoader) {
            this.name = name;
            this.jarFile = jarFile;
            this.parentClassLoader = parentClassLoader;
        }

        private void destroy() throws IOException {
            this.parentClassLoader = null;
            this.hook = null;
            if (this.urlClassLoader != null) {
                this.urlClassLoader.close();
            }
            if (this.jarFile != null) {
                Files.deleteIfExists(this.jarFile);
            }
        }

        private void init() throws IOException, PackageException {
            block19: {
                try {
                    if (this.jarFile != null) {
                        try (JarFile jar = new JarFile(this.jarFile.toFile());){
                            Manifest mf = jar.getManifest();
                            if (mf == null) {
                                throw new PackageException("hook jar file does not have a manifest: " + this.name);
                            }
                            this.mainClassName = mf.getMainAttributes().getValue("Main-Class");
                            if (this.mainClassName == null) {
                                throw new PackageException("hook manifest file does not have a Main-Class entry: " + this.name);
                            }
                        }
                        if (this.parentClassLoader == null) {
                            try {
                                this.urlClassLoader = URLClassLoader.newInstance(new URL[]{this.jarFile.toUri().toURL()}, this.getClass().getClassLoader());
                                this.loadMainClass(this.urlClassLoader);
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.urlClassLoader.close();
                                this.urlClassLoader = URLClassLoader.newInstance(new URL[]{this.jarFile.toUri().toURL()}, Thread.currentThread().getContextClassLoader());
                                this.loadMainClass(this.urlClassLoader);
                            }
                        } else {
                            this.urlClassLoader = URLClassLoader.newInstance(new URL[]{this.jarFile.toUri().toURL()}, this.parentClassLoader);
                            this.loadMainClass(this.urlClassLoader);
                        }
                        break block19;
                    }
                    if (this.parentClassLoader == null) {
                        try {
                            this.loadMainClass(this.getClass().getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.loadMainClass(Thread.currentThread().getContextClassLoader());
                        }
                    } else {
                        this.loadMainClass(this.parentClassLoader);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PackageException("hook's main class " + this.mainClassName + " not found: " + this.name, cnfe);
                }
            }
        }

        private void loadMainClass(ClassLoader classLoader) throws PackageException, ClassNotFoundException {
            log.info("Loading Hook {}: Main-Class = {}", (Object)this.name, (Object)this.mainClassName);
            Class<?> clazz = classLoader.loadClass(this.mainClassName);
            if (!InstallHook.class.isAssignableFrom(clazz)) {
                throw new PackageException("hook's main class " + this.mainClassName + " does not implement the InstallHook interface: " + this.name);
            }
            try {
                this.hook = (InstallHook)clazz.newInstance();
            }
            catch (Exception e) {
                throw new PackageException("hook's main class " + this.mainClassName + " could not be instantiated.", e);
            }
        }

        public InstallHook getHook() {
            return this.hook;
        }
    }
}

