/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.NodeId;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.option.NodeOptions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.Controller;
import org.apache.rocketmq.controller.helper.BrokerLifecycleListener;
import org.apache.rocketmq.controller.impl.JRaftControllerStateMachine;
import org.apache.rocketmq.controller.impl.closure.ControllerClosure;
import org.apache.rocketmq.controller.impl.task.BrokerCloseChannelRequest;
import org.apache.rocketmq.controller.impl.task.CheckNotActiveBrokerRequest;
import org.apache.rocketmq.controller.impl.task.GetBrokerLiveInfoRequest;
import org.apache.rocketmq.controller.impl.task.GetSyncStateDataRequest;
import org.apache.rocketmq.controller.impl.task.RaftBrokerHeartBeatEventRequest;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.admin.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerRequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRaftController
implements Controller {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private final RaftGroupService raftGroupService;
    private Node node;
    private final JRaftControllerStateMachine stateMachine;
    private final ControllerConfig controllerConfig;
    private final List<BrokerLifecycleListener> brokerLifecycleListeners;
    private final Map<PeerId, String> peerIdToAddr;
    private final NettyRemotingServer remotingServer;

    public JRaftController(ControllerConfig controllerConfig, ChannelEventListener channelEventListener) throws IOException {
        this.controllerConfig = controllerConfig;
        this.brokerLifecycleListeners = new ArrayList<BrokerLifecycleListener>();
        NodeOptions nodeOptions = new NodeOptions();
        nodeOptions.setElectionTimeoutMs(controllerConfig.getJraftConfig().getjRaftElectionTimeoutMs());
        nodeOptions.setSnapshotIntervalSecs(controllerConfig.getJraftConfig().getjRaftSnapshotIntervalSecs());
        PeerId serverId = new PeerId();
        if (!serverId.parse(controllerConfig.getJraftConfig().getjRaftServerId())) {
            throw new IllegalArgumentException("Fail to parse serverId:" + controllerConfig.getJraftConfig().getjRaftServerId());
        }
        Configuration initConf = new Configuration();
        if (!initConf.parse(controllerConfig.getJraftConfig().getjRaftInitConf())) {
            throw new IllegalArgumentException("Fail to parse initConf:" + controllerConfig.getJraftConfig().getjRaftInitConf());
        }
        nodeOptions.setInitialConf(initConf);
        FileUtils.forceMkdir((File)new File(controllerConfig.getControllerStorePath()));
        nodeOptions.setLogUri(controllerConfig.getControllerStorePath() + File.separator + "log");
        nodeOptions.setRaftMetaUri(controllerConfig.getControllerStorePath() + File.separator + "raft_meta");
        nodeOptions.setSnapshotUri(controllerConfig.getControllerStorePath() + File.separator + "snapshot");
        this.stateMachine = new JRaftControllerStateMachine(controllerConfig, new NodeId(controllerConfig.getJraftConfig().getjRaftGroupId(), serverId));
        this.stateMachine.registerOnLeaderStart(this::onLeaderStart);
        this.stateMachine.registerOnLeaderStop(this::onLeaderStop);
        nodeOptions.setFsm((StateMachine)this.stateMachine);
        this.raftGroupService = new RaftGroupService(controllerConfig.getJraftConfig().getjRaftGroupId(), serverId, nodeOptions);
        this.peerIdToAddr = new HashMap<PeerId, String>();
        this.initPeerIdMap();
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        nettyServerConfig.setListenPort(Integer.parseInt(this.peerIdToAddr.get(serverId).split(":")[1]));
        this.remotingServer = new NettyRemotingServer(nettyServerConfig, channelEventListener);
    }

    private void initPeerIdMap() {
        String[] peers = this.controllerConfig.getJraftConfig().getjRaftInitConf().split(",");
        String[] rpcAddrs = this.controllerConfig.getJraftConfig().getjRaftControllerRPCAddr().split(",");
        for (int i = 0; i < peers.length; ++i) {
            PeerId peerId = new PeerId();
            if (!peerId.parse(peers[i])) {
                throw new IllegalArgumentException("Fail to parse peerId:" + peers[i]);
            }
            this.peerIdToAddr.put(peerId, rpcAddrs[i]);
        }
    }

    @Override
    public void startup() {
        this.remotingServer.start();
        this.node = this.raftGroupService.start();
        log.info("Controller {} started.", (Object)this.node.getNodeId());
    }

    @Override
    public void shutdown() {
        this.stopScheduling();
        this.raftGroupService.shutdown();
        this.remotingServer.shutdown();
        log.info("Controller {} stopped.", (Object)this.node.getNodeId());
    }

    @Override
    public void startScheduling() {
    }

    @Override
    public void stopScheduling() {
    }

    @Override
    public boolean isLeaderState() {
        return this.node.isLeader();
    }

    private <T extends CommandCustomHeader> CompletableFuture<RemotingCommand> applyToJRaft(RemotingCommand request) {
        if (!this.isLeaderState()) {
            RemotingCommand command = RemotingCommand.createResponseCommand((int)2007, (String)"The controller is not in leader state");
            CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
            future.complete(command);
            log.warn("Apply to none leader controller, controller state is {}", (Object)this.node.getNodeState());
            return future;
        }
        ControllerClosure closure = new ControllerClosure(request);
        Task task = closure.taskWithThisClosure();
        if (task != null) {
            this.node.apply(task);
            return closure.getFuture();
        }
        log.error("Apply task failed, task is null.");
        return CompletableFuture.completedFuture(RemotingCommand.createResponseCommand((int)2015, (String)"Apply task failed, Please see the server log."));
    }

    @Override
    public CompletableFuture<RemotingCommand> alterSyncStateSet(AlterSyncStateSetRequestHeader request, SyncStateSet syncStateSet) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1001, (CommandCustomHeader)request);
        requestCommand.setBody(syncStateSet.encode());
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> electMaster(ElectMasterRequestHeader request) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1002, (CommandCustomHeader)request);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> getNextBrokerId(GetNextBrokerIdRequestHeader request) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1012, (CommandCustomHeader)request);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> applyBrokerId(ApplyBrokerIdRequestHeader request) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1013, (CommandCustomHeader)request);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> registerBroker(RegisterBrokerToControllerRequestHeader request) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1003, (CommandCustomHeader)request);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> getReplicaInfo(GetReplicaInfoRequestHeader request) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1004, (CommandCustomHeader)request);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> getSyncStateData(List<String> brokerNames) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1006, (CommandCustomHeader)new GetSyncStateDataRequest());
        requestCommand.setBody(RemotingSerializable.encode(brokerNames));
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public CompletableFuture<RemotingCommand> cleanBrokerData(CleanControllerBrokerDataRequestHeader requestHeader) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1011, (CommandCustomHeader)requestHeader);
        return this.applyToJRaft(requestCommand);
    }

    @Override
    public void registerBrokerLifecycleListener(BrokerLifecycleListener listener) {
        this.brokerLifecycleListeners.add(listener);
    }

    @Override
    public RemotingCommand getControllerMetadata() {
        List peers = this.node.getOptions().getInitialConf().getPeers();
        StringBuilder sb = new StringBuilder();
        for (PeerId peer : peers) {
            sb.append(this.peerIdToAddr.get(peer)).append(";");
        }
        return RemotingCommand.createResponseCommandWithHeader((int)0, (CommandCustomHeader)new GetMetaDataResponseHeader(this.node.getGroupId(), this.node.getLeaderId() == null ? "" : this.node.getLeaderId().toString(), this.peerIdToAddr.get(this.node.getLeaderId()), this.node.isLeader(), sb.toString()));
    }

    @Override
    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public void onLeaderStart(long term) {
        log.info("Controller start leadership, term: {}.", (Object)term);
    }

    public void onLeaderStop(Status status) {
        log.info("Controller {} stop leadership, status: {}.", (Object)this.node.getNodeId(), (Object)status);
        this.stopScheduling();
    }

    public CompletableFuture<RemotingCommand> getBrokerLiveInfo(GetBrokerLiveInfoRequest requestHeader) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1016, (CommandCustomHeader)requestHeader);
        return this.applyToJRaft(requestCommand);
    }

    public CompletableFuture<RemotingCommand> onBrokerHeartBeat(RaftBrokerHeartBeatEventRequest requestHeader) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1018, (CommandCustomHeader)requestHeader);
        return this.applyToJRaft(requestCommand);
    }

    public CompletableFuture<RemotingCommand> onBrokerCloseChannel(BrokerCloseChannelRequest requestHeader) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1014, (CommandCustomHeader)requestHeader);
        return this.applyToJRaft(requestCommand);
    }

    public CompletableFuture<RemotingCommand> checkNotActiveBroker(CheckNotActiveBrokerRequest requestHeader) {
        RemotingCommand requestCommand = RemotingCommand.createRequestCommand((int)1015, (CommandCustomHeader)requestHeader);
        return this.applyToJRaft(requestCommand);
    }
}

