/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageVersion;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.AppendMessageCallback;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.FlushDiskWatcher;
import org.apache.rocketmq.store.FlushManager;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageExtEncoder;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.MultiDispatch;
import org.apache.rocketmq.store.MultiPathMappedFileQueue;
import org.apache.rocketmq.store.PutMessageContext;
import org.apache.rocketmq.store.PutMessageLock;
import org.apache.rocketmq.store.PutMessageReentrantLock;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageSpinLock;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.SelectMappedFileResult;
import org.apache.rocketmq.store.StoreStatsService;
import org.apache.rocketmq.store.Swappable;
import org.apache.rocketmq.store.TopicQueueLock;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.queue.MultiDispatchUtils;
import org.apache.rocketmq.store.util.LibC;
import org.rocksdb.RocksDBException;
import sun.nio.ch.DirectBuffer;

public class CommitLog
implements Swappable {
    public static final int MESSAGE_MAGIC_CODE = -626843481;
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final int BLANK_MAGIC_CODE = -875286124;
    public static final int CRC32_RESERVED_LEN = "__CRC32#".length() + 1 + 10 + 1;
    protected final MappedFileQueue mappedFileQueue;
    protected final DefaultMessageStore defaultMessageStore;
    private final FlushManager flushManager;
    private final ColdDataCheckService coldDataCheckService;
    private final AppendMessageCallback appendMessageCallback;
    private final ThreadLocal<MessageExtEncoder.PutMessageThreadLocal> putMessageThreadLocal;
    protected volatile long confirmOffset = -1L;
    private volatile long beginTimeInLock = 0L;
    protected final PutMessageLock putMessageLock;
    protected final TopicQueueLock topicQueueLock;
    private volatile Set<String> fullStorePaths = Collections.emptySet();
    private final FlushDiskWatcher flushDiskWatcher;
    protected int commitLogSize;
    private final boolean enabledAppendPropCRC;
    protected final MultiDispatch multiDispatch;

    public CommitLog(DefaultMessageStore messageStore) {
        String storePath = messageStore.getMessageStoreConfig().getStorePathCommitLog();
        this.mappedFileQueue = storePath.contains(MixAll.MULTI_PATH_SPLITTER) ? new MultiPathMappedFileQueue(messageStore.getMessageStoreConfig(), messageStore.getMessageStoreConfig().getMappedFileSizeCommitLog(), messageStore.getAllocateMappedFileService(), this::getFullStorePaths) : new MappedFileQueue(storePath, messageStore.getMessageStoreConfig().getMappedFileSizeCommitLog(), messageStore.getAllocateMappedFileService());
        this.defaultMessageStore = messageStore;
        this.flushManager = new DefaultFlushManager();
        this.coldDataCheckService = new ColdDataCheckService();
        this.appendMessageCallback = new DefaultAppendMessageCallback(this.defaultMessageStore.getMessageStoreConfig());
        this.putMessageThreadLocal = new ThreadLocal<MessageExtEncoder.PutMessageThreadLocal>(){

            @Override
            protected MessageExtEncoder.PutMessageThreadLocal initialValue() {
                return new MessageExtEncoder.PutMessageThreadLocal(CommitLog.this.defaultMessageStore.getMessageStoreConfig());
            }
        };
        this.putMessageLock = messageStore.getMessageStoreConfig().isUseReentrantLockWhenPutMessage() ? new PutMessageReentrantLock() : new PutMessageSpinLock();
        this.flushDiskWatcher = new FlushDiskWatcher();
        this.topicQueueLock = new TopicQueueLock(messageStore.getMessageStoreConfig().getTopicQueueLockNum());
        this.commitLogSize = messageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        this.enabledAppendPropCRC = messageStore.getMessageStoreConfig().isEnabledAppendPropCRC();
        this.multiDispatch = new MultiDispatch(this.defaultMessageStore);
    }

    public void setFullStorePaths(Set<String> fullStorePaths) {
        this.fullStorePaths = fullStorePaths;
    }

    public Set<String> getFullStorePaths() {
        return this.fullStorePaths;
    }

    public long getTotalSize() {
        return this.mappedFileQueue.getTotalFileSize();
    }

    public ThreadLocal<MessageExtEncoder.PutMessageThreadLocal> getPutMessageThreadLocal() {
        return this.putMessageThreadLocal;
    }

    public boolean load() {
        boolean result = this.mappedFileQueue.load();
        if (result && !this.defaultMessageStore.getMessageStoreConfig().isDataReadAheadEnable()) {
            this.scanFileAndSetReadMode(1);
        }
        this.mappedFileQueue.checkSelf();
        log.info("load commit log " + (result ? "OK" : "Failed"));
        return result;
    }

    public void start() {
        this.flushManager.start();
        log.info("start commitLog successfully. storeRoot: {}", (Object)this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
        this.flushDiskWatcher.setDaemon(true);
        this.flushDiskWatcher.start();
        if (this.coldDataCheckService != null) {
            this.coldDataCheckService.start();
        }
    }

    public void shutdown() {
        this.flushManager.shutdown();
        log.info("shutdown commitLog successfully. storeRoot: {}", (Object)this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
        this.flushDiskWatcher.shutdown(true);
        if (this.coldDataCheckService != null) {
            this.coldDataCheckService.shutdown();
        }
    }

    public long flush() {
        this.mappedFileQueue.commit(0);
        this.mappedFileQueue.flush(0);
        return this.mappedFileQueue.getFlushedWhere();
    }

    public long getFlushedWhere() {
        return this.mappedFileQueue.getFlushedWhere();
    }

    public long getMaxOffset() {
        return this.mappedFileQueue.getMaxOffset();
    }

    public long remainHowManyDataToCommit() {
        return this.mappedFileQueue.remainHowManyDataToCommit();
    }

    public long remainHowManyDataToFlush() {
        return this.mappedFileQueue.remainHowManyDataToFlush();
    }

    public int deleteExpiredFile(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately) {
        return this.deleteExpiredFile(expiredTime, deleteFilesInterval, intervalForcibly, cleanImmediately, 0);
    }

    public int deleteExpiredFile(long expiredTime, int deleteFilesInterval, long intervalForcibly, boolean cleanImmediately, int deleteFileBatchMax) {
        return this.mappedFileQueue.deleteExpiredFileByTime(expiredTime, deleteFilesInterval, intervalForcibly, cleanImmediately, deleteFileBatchMax);
    }

    public SelectMappedBufferResult getData(long offset) {
        return this.getData(offset, offset == 0L);
    }

    public SelectMappedBufferResult getData(long offset, boolean returnFirstOnNotFound) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, returnFirstOnNotFound);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            SelectMappedBufferResult result = mappedFile.selectMappedBuffer(pos);
            return result;
        }
        return null;
    }

    public boolean getData(long offset, int size, ByteBuffer byteBuffer) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null) {
            int pos = (int)(offset % (long)mappedFileSize);
            return mappedFile.getData(pos, size, byteBuffer);
        }
        return false;
    }

    public List<SelectMappedBufferResult> getBulkData(long offset, int size) {
        ArrayList<SelectMappedBufferResult> bufferResultList = new ArrayList<SelectMappedBufferResult>();
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        int remainSize = size;
        long startOffset = offset;
        long maxOffset = this.getMaxOffset();
        if (offset + (long)size > maxOffset) {
            remainSize = (int)(maxOffset - offset);
            log.warn("get bulk data size out of range, correct to max offset. offset: {}, size: {}, max: {}", new Object[]{offset, remainSize, maxOffset});
        }
        while (remainSize > 0) {
            MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(startOffset, startOffset == 0L);
            if (mappedFile == null) continue;
            int pos = (int)(startOffset % (long)mappedFileSize);
            int readableSize = mappedFile.getReadPosition() - pos;
            int readSize = Math.min(remainSize, readableSize);
            SelectMappedBufferResult bufferResult = mappedFile.selectMappedBuffer(pos, readSize);
            if (bufferResult == null) break;
            bufferResultList.add(bufferResult);
            remainSize -= readSize;
            startOffset += (long)readSize;
        }
        return bufferResultList;
    }

    public SelectMappedFileResult getFile(long offset) {
        int size;
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null && (size = (int)((long)mappedFile.getReadPosition() - offset % (long)mappedFileSize)) > 0) {
            return new SelectMappedFileResult(size, mappedFile);
        }
        return null;
    }

    public boolean getLastMappedFile(long startOffset) {
        MappedFile lastMappedFile = this.mappedFileQueue.getLastMappedFile(startOffset);
        if (null == lastMappedFile) {
            log.error("getLastMappedFile error. offset:{}", (Object)startOffset);
            return false;
        }
        return true;
    }

    public void recoverNormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        boolean checkCRCOnRecover = this.defaultMessageStore.getMessageStoreConfig().isCheckCRCOnRecover();
        boolean checkDupInfo = this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long lastValidMsgPhyOffset;
            long mappedFileOffset;
            long processOffset;
            block14: {
                int size;
                int index = mappedFiles.size() - 3;
                if (index < 0) {
                    index = 0;
                }
                MappedFile mappedFile = mappedFiles.get(index);
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                lastValidMsgPhyOffset = this.getConfirmOffset();
                boolean doDispatch = false;
                while (true) {
                    DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(byteBuffer, checkCRCOnRecover, checkDupInfo);
                    size = dispatchRequest.getMsgSize();
                    if (dispatchRequest.isSuccess() && size > 0) {
                        lastValidMsgPhyOffset = processOffset + mappedFileOffset;
                        mappedFileOffset += (long)size;
                        this.getMessageStore().onCommitLogDispatch(dispatchRequest, doDispatch, mappedFile, true, false);
                        continue;
                    }
                    if (dispatchRequest.isSuccess() && size == 0) {
                        this.getMessageStore().onCommitLogDispatch(dispatchRequest, doDispatch, mappedFile, true, true);
                        if (++index >= mappedFiles.size()) {
                            log.info("recover last 3 physics file over, last mapped file " + mappedFile.getFileName());
                            break block14;
                        }
                        mappedFile = mappedFiles.get(index);
                        byteBuffer = mappedFile.sliceByteBuffer();
                        processOffset = mappedFile.getFileFromOffset();
                        mappedFileOffset = 0L;
                        log.info("recover next physics file, " + mappedFile.getFileName());
                        continue;
                    }
                    if (!dispatchRequest.isSuccess()) break;
                }
                if (size > 0) {
                    log.warn("found a half message at {}, it will be truncated.", (Object)(processOffset + mappedFileOffset));
                }
                log.info("recover physics file end, " + mappedFile.getFileName());
            }
            processOffset += mappedFileOffset;
            if (this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
                if (this.defaultMessageStore.getConfirmOffset() < this.defaultMessageStore.getMinPhyOffset()) {
                    log.error("confirmOffset {} is less than minPhyOffset {}, correct confirmOffset to minPhyOffset", (Object)this.defaultMessageStore.getConfirmOffset(), (Object)this.defaultMessageStore.getMinPhyOffset());
                    this.defaultMessageStore.setConfirmOffset(this.defaultMessageStore.getMinPhyOffset());
                } else if (this.defaultMessageStore.getConfirmOffset() > processOffset) {
                    log.error("confirmOffset {} is larger than processOffset {}, correct confirmOffset to processOffset", (Object)this.defaultMessageStore.getConfirmOffset(), (Object)processOffset);
                    this.defaultMessageStore.setConfirmOffset(processOffset);
                }
            } else {
                this.setConfirmOffset(lastValidMsgPhyOffset);
            }
            if (maxPhyOffsetOfConsumeQueue >= processOffset) {
                log.warn("maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)processOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(processOffset);
            }
            this.mappedFileQueue.setFlushedWhere(processOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
        } else {
            log.warn("The commitlog files are deleted, and delete the consume queue files");
            this.mappedFileQueue.setFlushedWhere(0L);
            this.mappedFileQueue.setCommittedWhere(0L);
            this.defaultMessageStore.getQueueStore().destroy();
            this.defaultMessageStore.getQueueStore().loadAfterDestroy();
        }
    }

    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean checkDupInfo) {
        return this.checkMessageAndReturnSize(byteBuffer, checkCRC, checkDupInfo, true);
    }

    private void doNothingForDeadCode(Object obj) {
        if (obj != null) {
            log.debug(String.valueOf(obj.hashCode()));
        }
    }

    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean checkDupInfo, boolean readBody) {
        try {
            int readLength;
            int totalSize = byteBuffer.getInt();
            int magicCode = byteBuffer.getInt();
            switch (magicCode) {
                case -626843481: 
                case -626843477: {
                    break;
                }
                case -875286124: {
                    return new DispatchRequest(0, true);
                }
                default: {
                    log.warn("found a illegal magic code 0x" + Integer.toHexString(magicCode));
                    return new DispatchRequest(-1, false);
                }
            }
            MessageVersion messageVersion = MessageVersion.valueOfMagicCode((int)magicCode);
            byte[] bytesContent = new byte[totalSize];
            int bodyCRC = byteBuffer.getInt();
            int queueId = byteBuffer.getInt();
            int flag = byteBuffer.getInt();
            long queueOffset = byteBuffer.getLong();
            long physicOffset = byteBuffer.getLong();
            int sysFlag = byteBuffer.getInt();
            long bornTimeStamp = byteBuffer.getLong();
            ByteBuffer byteBuffer1 = (sysFlag & 0x10) == 0 ? byteBuffer.get(bytesContent, 0, 8) : byteBuffer.get(bytesContent, 0, 20);
            long storeTimestamp = byteBuffer.getLong();
            ByteBuffer byteBuffer2 = (sysFlag & 0x20) == 0 ? byteBuffer.get(bytesContent, 0, 8) : byteBuffer.get(bytesContent, 0, 20);
            int reconsumeTimes = byteBuffer.getInt();
            long preparedTransactionOffset = byteBuffer.getLong();
            int bodyLen = byteBuffer.getInt();
            if (bodyLen > 0) {
                if (readBody) {
                    int crc;
                    byteBuffer.get(bytesContent, 0, bodyLen);
                    if (checkCRC && !this.defaultMessageStore.getMessageStoreConfig().isForceVerifyPropCRC() && (crc = UtilAll.crc32((byte[])bytesContent, (int)0, (int)bodyLen)) != bodyCRC) {
                        log.warn("CRC check failed. bodyCRC={}, currentCRC={}", (Object)crc, (Object)bodyCRC);
                        return new DispatchRequest(-1, false);
                    }
                } else {
                    byteBuffer.position(byteBuffer.position() + bodyLen);
                }
            }
            int topicLen = messageVersion.getTopicLength(byteBuffer);
            byteBuffer.get(bytesContent, 0, topicLen);
            String topic = new String(bytesContent, 0, topicLen, MessageDecoder.CHARSET_UTF8);
            long tagsCode = 0L;
            String keys = "";
            String uniqKey = null;
            short propertiesLength = byteBuffer.getShort();
            Map propertiesMap = null;
            if (propertiesLength > 0) {
                String dupInfo;
                byteBuffer.get(bytesContent, 0, propertiesLength);
                String properties = new String(bytesContent, 0, (int)propertiesLength, MessageDecoder.CHARSET_UTF8);
                propertiesMap = MessageDecoder.string2messageProperties((String)properties);
                keys = (String)propertiesMap.get("KEYS");
                uniqKey = (String)propertiesMap.get("UNIQ_KEY");
                if (checkDupInfo && (null == (dupInfo = (String)propertiesMap.get("DUP_INFO")) || dupInfo.split("_").length != 2)) {
                    log.warn("DupInfo in properties check failed. dupInfo={}", (Object)dupInfo);
                    return new DispatchRequest(-1, false);
                }
                String tags = (String)propertiesMap.get("TAGS");
                if (tags != null && tags.length() > 0) {
                    tagsCode = MessageExtBrokerInner.tagsString2tagsCode((TopicFilterType)MessageExt.parseTopicFilterType((int)sysFlag), (String)tags);
                }
                String t = (String)propertiesMap.get("DELAY");
                if ("SCHEDULE_TOPIC_XXXX".equals(topic) && t != null) {
                    int delayLevel = Integer.parseInt(t);
                    if (delayLevel > this.defaultMessageStore.getMaxDelayLevel()) {
                        delayLevel = this.defaultMessageStore.getMaxDelayLevel();
                    }
                    if (delayLevel > 0) {
                        tagsCode = this.defaultMessageStore.computeDeliverTimestamp(delayLevel, storeTimestamp);
                    }
                }
            }
            if (checkCRC && this.defaultMessageStore.getMessageStoreConfig().isForceVerifyPropCRC()) {
                String crc32Str;
                int expectedCRC = -1;
                if (propertiesMap != null && (crc32Str = (String)propertiesMap.get("__CRC32#")) != null) {
                    expectedCRC = 0;
                    for (int i = crc32Str.length() - 1; i >= 0; --i) {
                        int num = crc32Str.charAt(i) - 48;
                        expectedCRC *= 10;
                        expectedCRC += num;
                    }
                }
                if (expectedCRC > 0) {
                    ByteBuffer tmpBuffer = byteBuffer.duplicate();
                    tmpBuffer.position(tmpBuffer.position() - totalSize);
                    tmpBuffer.limit(tmpBuffer.position() + totalSize - CRC32_RESERVED_LEN);
                    int crc = UtilAll.crc32((ByteBuffer)tmpBuffer);
                    if (crc != expectedCRC) {
                        log.warn("CommitLog#checkAndDispatchMessage: failed to check message CRC, expected CRC={}, actual CRC={}", (Object)bodyCRC, (Object)crc);
                        return new DispatchRequest(-1, false);
                    }
                } else {
                    log.warn("CommitLog#checkAndDispatchMessage: failed to check message CRC, not found CRC in properties");
                    return new DispatchRequest(-1, false);
                }
            }
            if (totalSize != (readLength = MessageExtEncoder.calMsgLength(messageVersion, sysFlag, bodyLen, topicLen, propertiesLength))) {
                this.doNothingForDeadCode(reconsumeTimes);
                this.doNothingForDeadCode(flag);
                this.doNothingForDeadCode(bornTimeStamp);
                this.doNothingForDeadCode(byteBuffer1);
                this.doNothingForDeadCode(byteBuffer2);
                log.error("[BUG]read total count not equals msg total size. totalSize={}, readTotalCount={}, bodyLen={}, topicLen={}, propertiesLength={}", new Object[]{totalSize, readLength, bodyLen, topicLen, propertiesLength});
                return new DispatchRequest(totalSize, false);
            }
            DispatchRequest dispatchRequest = new DispatchRequest(topic, queueId, physicOffset, totalSize, tagsCode, storeTimestamp, queueOffset, keys, uniqKey, sysFlag, preparedTransactionOffset, propertiesMap);
            this.setBatchSizeIfNeeded(propertiesMap, dispatchRequest);
            return dispatchRequest;
        }
        catch (Exception exception) {
            return new DispatchRequest(-1, false);
        }
    }

    private void setBatchSizeIfNeeded(Map<String, String> propertiesMap, DispatchRequest dispatchRequest) {
        if (null != propertiesMap && propertiesMap.containsKey("INNER_NUM") && propertiesMap.containsKey("INNER_BASE")) {
            dispatchRequest.setMsgBaseOffset(Long.parseLong(propertiesMap.get("INNER_BASE")));
            dispatchRequest.setBatchSize(Short.parseShort(propertiesMap.get("INNER_NUM")));
        }
    }

    public long getConfirmOffset() {
        if (this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
            if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE && !this.defaultMessageStore.getRunningFlags().isFenced()) {
                if (((AutoSwitchHAService)this.defaultMessageStore.getHaService()).getLocalSyncStateSet().size() == 1 || !this.defaultMessageStore.getMessageStoreConfig().isAllAckInSyncStateSet()) {
                    return this.defaultMessageStore.getMaxPhyOffset();
                }
                if (this.confirmOffset < 0L) {
                    this.setConfirmOffset(((AutoSwitchHAService)this.defaultMessageStore.getHaService()).computeConfirmOffset());
                    log.info("Init the confirmOffset to {}.", (Object)this.confirmOffset);
                }
            }
            return this.confirmOffset;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
            return this.confirmOffset;
        }
        return this.defaultMessageStore.isSyncDiskFlush() ? this.getFlushedWhere() : this.getMaxOffset();
    }

    public long getConfirmOffsetDirectly() {
        if (this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
            if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE && !this.defaultMessageStore.getRunningFlags().isFenced() && ((AutoSwitchHAService)this.defaultMessageStore.getHaService()).getLocalSyncStateSet().size() == 1) {
                return this.defaultMessageStore.getMaxPhyOffset();
            }
            return this.confirmOffset;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
            return this.confirmOffset;
        }
        return this.getMaxOffset();
    }

    public void setConfirmOffset(long phyOffset) {
        this.confirmOffset = phyOffset;
        this.defaultMessageStore.getStoreCheckpoint().setConfirmPhyOffset(this.confirmOffset);
    }

    public long getLastFileFromOffset() {
        MappedFile lastMappedFile = this.mappedFileQueue.getLastMappedFile();
        if (lastMappedFile != null && lastMappedFile.isAvailable()) {
            return lastMappedFile.getFileFromOffset();
        }
        return -1L;
    }

    public void recoverAbnormally(long maxPhyOffsetOfConsumeQueue) throws RocksDBException {
        boolean checkCRCOnRecover = this.defaultMessageStore.getMessageStoreConfig().isCheckCRCOnRecover();
        boolean checkDupInfo = this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable();
        List<MappedFile> mappedFiles = this.mappedFileQueue.getMappedFiles();
        if (!mappedFiles.isEmpty()) {
            long lastConfirmValidMsgPhyOffset;
            long lastValidMsgPhyOffset;
            long mappedFileOffset;
            long processOffset;
            block15: {
                int size;
                int index;
                MappedFile mappedFile = null;
                for (index = mappedFiles.size() - 1; index >= 0; --index) {
                    mappedFile = mappedFiles.get(index);
                    if (!this.isMappedFileMatchedRecover(mappedFile)) continue;
                    log.info("recover from this mapped file " + mappedFile.getFileName());
                    break;
                }
                if (index < 0) {
                    index = 0;
                    mappedFile = mappedFiles.get(index);
                }
                ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
                processOffset = mappedFile.getFileFromOffset();
                mappedFileOffset = 0L;
                lastValidMsgPhyOffset = processOffset;
                lastConfirmValidMsgPhyOffset = processOffset;
                boolean doDispatch = true;
                while (true) {
                    DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(byteBuffer, checkCRCOnRecover, checkDupInfo);
                    size = dispatchRequest.getMsgSize();
                    if (!dispatchRequest.isSuccess()) break;
                    if (size > 0) {
                        lastValidMsgPhyOffset = processOffset + mappedFileOffset;
                        mappedFileOffset += (long)size;
                        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable() || this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
                            if (dispatchRequest.getCommitLogOffset() + (long)size > this.defaultMessageStore.getCommitLog().getConfirmOffset()) continue;
                            this.getMessageStore().onCommitLogDispatch(dispatchRequest, doDispatch, mappedFile, true, false);
                            lastConfirmValidMsgPhyOffset = dispatchRequest.getCommitLogOffset() + (long)size;
                            continue;
                        }
                        this.getMessageStore().onCommitLogDispatch(dispatchRequest, doDispatch, mappedFile, true, false);
                        continue;
                    }
                    if (size != 0) continue;
                    this.getMessageStore().onCommitLogDispatch(dispatchRequest, doDispatch, mappedFile, true, true);
                    if (++index >= mappedFiles.size()) {
                        log.info("recover physics file over, last mapped file " + mappedFile.getFileName());
                        break block15;
                    }
                    mappedFile = mappedFiles.get(index);
                    byteBuffer = mappedFile.sliceByteBuffer();
                    processOffset = mappedFile.getFileFromOffset();
                    mappedFileOffset = 0L;
                    log.info("recover next physics file, " + mappedFile.getFileName());
                }
                if (size > 0) {
                    log.warn("found a half message at {}, it will be truncated.", (Object)(processOffset + mappedFileOffset));
                }
                log.info("recover physics file end, " + mappedFile.getFileName() + " pos=" + byteBuffer.position());
            }
            this.getMessageStore().finishCommitLogDispatch();
            processOffset += mappedFileOffset;
            if (this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
                if (this.defaultMessageStore.getConfirmOffset() < this.defaultMessageStore.getMinPhyOffset()) {
                    log.error("confirmOffset {} is less than minPhyOffset {}, correct confirmOffset to minPhyOffset", (Object)this.defaultMessageStore.getConfirmOffset(), (Object)this.defaultMessageStore.getMinPhyOffset());
                    this.defaultMessageStore.setConfirmOffset(this.defaultMessageStore.getMinPhyOffset());
                } else if (this.defaultMessageStore.getConfirmOffset() > lastConfirmValidMsgPhyOffset) {
                    log.error("confirmOffset {} is larger than lastConfirmValidMsgPhyOffset {}, correct confirmOffset to lastConfirmValidMsgPhyOffset", (Object)this.defaultMessageStore.getConfirmOffset(), (Object)lastConfirmValidMsgPhyOffset);
                    this.defaultMessageStore.setConfirmOffset(lastConfirmValidMsgPhyOffset);
                }
            } else {
                this.setConfirmOffset(lastValidMsgPhyOffset);
            }
            if (maxPhyOffsetOfConsumeQueue >= processOffset) {
                log.warn("maxPhyOffsetOfConsumeQueue({}) >= processOffset({}), truncate dirty logic files", (Object)maxPhyOffsetOfConsumeQueue, (Object)processOffset);
                this.defaultMessageStore.truncateDirtyLogicFiles(processOffset);
            }
            this.mappedFileQueue.setFlushedWhere(processOffset);
            this.mappedFileQueue.setCommittedWhere(processOffset);
            this.mappedFileQueue.truncateDirtyFiles(processOffset);
        } else {
            log.warn("The commitlog files are deleted, and delete the consume queue files");
            this.mappedFileQueue.setFlushedWhere(0L);
            this.mappedFileQueue.setCommittedWhere(0L);
            this.defaultMessageStore.getQueueStore().destroy();
            this.defaultMessageStore.getQueueStore().loadAfterDestroy();
        }
    }

    public void truncateDirtyFiles(long phyOffset) {
        if (phyOffset <= this.getFlushedWhere()) {
            this.mappedFileQueue.setFlushedWhere(phyOffset);
        }
        if (phyOffset <= this.mappedFileQueue.getCommittedWhere()) {
            this.mappedFileQueue.setCommittedWhere(phyOffset);
        }
        this.mappedFileQueue.truncateDirtyFiles(phyOffset);
        if (this.confirmOffset > phyOffset) {
            this.setConfirmOffset(phyOffset);
        }
    }

    protected void onCommitLogAppend(MessageExtBrokerInner msg, AppendMessageResult result, MappedFile commitLogFile) {
        this.getMessageStore().onCommitLogAppend(msg, result, commitLogFile);
    }

    private boolean isMappedFileMatchedRecover(MappedFile mappedFile) throws RocksDBException {
        ByteBuffer byteBuffer = mappedFile.sliceByteBuffer();
        int magicCode = byteBuffer.getInt(4);
        if (magicCode != -626843481 && magicCode != -626843477) {
            return false;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isEnableRocksDBStore()) {
            long maxPhyOffsetInConsumeQueue = this.defaultMessageStore.getQueueStore().getMaxPhyOffsetInConsumeQueue();
            long phyOffset = byteBuffer.getLong(28);
            if (phyOffset <= maxPhyOffsetInConsumeQueue) {
                log.info("find check. beginPhyOffset: {}, maxPhyOffsetInConsumeQueue: {}", (Object)phyOffset, (Object)maxPhyOffsetInConsumeQueue);
                return true;
            }
        } else {
            int sysFlag = byteBuffer.getInt(36);
            int bornHostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
            int msgStoreTimePos = 48 + bornHostLength;
            long storeTimestamp = byteBuffer.getLong(msgStoreTimePos);
            if (0L == storeTimestamp) {
                return false;
            }
            if (this.defaultMessageStore.getMessageStoreConfig().isMessageIndexEnable() && this.defaultMessageStore.getMessageStoreConfig().isMessageIndexSafe()) {
                if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestampIndex()) {
                    log.info("find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
                    return true;
                }
            } else if (storeTimestamp <= this.defaultMessageStore.getStoreCheckpoint().getMinTimestamp()) {
                log.info("find check timestamp, {} {}", (Object)storeTimestamp, (Object)UtilAll.timeMillisToHumanString((long)storeTimestamp));
                return true;
            }
        }
        return false;
    }

    public boolean resetOffset(long offset) {
        return this.mappedFileQueue.resetOffset(offset);
    }

    public long getBeginTimeInLock() {
        return this.beginTimeInLock;
    }

    public String generateKey(StringBuilder keyBuilder, MessageExt messageExt) {
        keyBuilder.setLength(0);
        keyBuilder.append(messageExt.getTopic());
        keyBuilder.append('-');
        keyBuilder.append(messageExt.getQueueId());
        return keyBuilder.toString();
    }

    public void setMappedFileQueueOffset(long phyOffset) {
        this.mappedFileQueue.setFlushedWhere(phyOffset);
        this.mappedFileQueue.setCommittedWhere(phyOffset);
    }

    public void updateMaxMessageSize(MessageExtEncoder.PutMessageThreadLocal putMessageThreadLocal) {
        int newMaxMessageSize = this.defaultMessageStore.getMessageStoreConfig().getMaxMessageSize();
        if (newMaxMessageSize >= 10 && putMessageThreadLocal.getEncoder().getMaxMessageBodySize() != newMaxMessageSize) {
            putMessageThreadLocal.getEncoder().updateEncoderBufferCapacity(newMaxMessageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        int inSyncReplicas;
        InetSocketAddress storeSocketAddress;
        InetSocketAddress bornSocketAddress;
        if (!this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
            msg.setStoreTimestamp(System.currentTimeMillis());
        }
        msg.setBodyCRC(UtilAll.crc32((byte[])msg.getBody()));
        if (this.enabledAppendPropCRC) {
            msg.deleteProperty("__CRC32#");
        }
        AppendMessageResult result = null;
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        String topic = msg.getTopic();
        msg.setVersion(MessageVersion.MESSAGE_VERSION_V1);
        boolean autoMessageVersionOnTopicLen = this.defaultMessageStore.getMessageStoreConfig().isAutoMessageVersionOnTopicLen();
        if (autoMessageVersionOnTopicLen && topic.length() > 127) {
            msg.setVersion(MessageVersion.MESSAGE_VERSION_V2);
        }
        if ((bornSocketAddress = (InetSocketAddress)msg.getBornHost()).getAddress() instanceof Inet6Address) {
            msg.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)msg.getStoreHost()).getAddress() instanceof Inet6Address) {
            msg.setStoreHostAddressV6Flag();
        }
        MessageExtEncoder.PutMessageThreadLocal putMessageThreadLocal = this.putMessageThreadLocal.get();
        this.updateMaxMessageSize(putMessageThreadLocal);
        String topicQueueKey = this.generateKey(putMessageThreadLocal.getKeyBuilder(), (MessageExt)msg);
        long elapsedTimeInLock = 0L;
        MappedFile unlockMappedFile = null;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        long currOffset = mappedFile == null ? 0L : mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition();
        int needAckNums = this.defaultMessageStore.getMessageStoreConfig().getInSyncReplicas();
        boolean needHandleHA = this.needHandleHA((MessageExt)msg);
        if (needHandleHA && this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
            if (this.defaultMessageStore.getHaService().inSyncReplicasNums(currOffset) < this.defaultMessageStore.getMessageStoreConfig().getMinInSyncReplicas()) {
                return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH, null));
            }
            if (this.defaultMessageStore.getMessageStoreConfig().isAllAckInSyncStateSet()) {
                needAckNums = -1;
            }
        } else if (needHandleHA && this.defaultMessageStore.getBrokerConfig().isEnableSlaveActingMaster() && (needAckNums = this.calcNeedAckNums(inSyncReplicas = Math.min(this.defaultMessageStore.getAliveReplicaNumInGroup(), this.defaultMessageStore.getHaService().inSyncReplicasNums(currOffset)))) > inSyncReplicas) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH, null));
        }
        this.topicQueueLock.lock(topicQueueKey);
        try {
            PutMessageResult encodeResult;
            boolean needAssignOffset = true;
            if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable() && this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE) {
                needAssignOffset = false;
            }
            if (needAssignOffset) {
                this.defaultMessageStore.assignOffset(msg);
            }
            if ((encodeResult = putMessageThreadLocal.getEncoder().encode(msg)) != null) {
                CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(encodeResult);
                return completableFuture;
            }
            msg.setEncodedBuff(putMessageThreadLocal.getEncoder().getEncoderBuffer());
            PutMessageContext putMessageContext = new PutMessageContext(topicQueueKey);
            this.putMessageLock.lock();
            try {
                long beginLockTimestamp;
                this.beginTimeInLock = beginLockTimestamp = this.defaultMessageStore.getSystemClock().now();
                if (!this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
                    msg.setStoreTimestamp(beginLockTimestamp);
                }
                if (null == mappedFile || mappedFile.isFull()) {
                    mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                    if (this.isCloseReadAhead()) {
                        this.setFileReadMode(mappedFile, 1);
                    }
                }
                if (null == mappedFile) {
                    log.error("create mapped file1 error, topic: " + msg.getTopic() + " clientAddr: " + msg.getBornHostString());
                    this.beginTimeInLock = 0L;
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, null));
                    return completableFuture;
                }
                result = mappedFile.appendMessage(msg, this.appendMessageCallback, putMessageContext);
                switch (result.getStatus()) {
                    case PUT_OK: {
                        this.onCommitLogAppend(msg, result, mappedFile);
                        break;
                    }
                    case END_OF_FILE: {
                        this.onCommitLogAppend(msg, result, mappedFile);
                        unlockMappedFile = mappedFile;
                        mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                        if (null == mappedFile) {
                            log.error("create mapped file2 error, topic: " + msg.getTopic() + " clientAddr: " + msg.getBornHostString());
                            this.beginTimeInLock = 0L;
                            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, result));
                            return completableFuture;
                        }
                        if (this.isCloseReadAhead()) {
                            this.setFileReadMode(mappedFile, 1);
                        }
                        if (!AppendMessageStatus.PUT_OK.equals((Object)(result = mappedFile.appendMessage(msg, this.appendMessageCallback, putMessageContext)).getStatus())) break;
                        this.onCommitLogAppend(msg, result, mappedFile);
                        break;
                    }
                    case MESSAGE_SIZE_EXCEEDED: 
                    case PROPERTIES_SIZE_EXCEEDED: {
                        this.beginTimeInLock = 0L;
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, result));
                        return completableFuture;
                    }
                    default: {
                        this.beginTimeInLock = 0L;
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                        return completableFuture;
                    }
                }
                elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - beginLockTimestamp;
                this.beginTimeInLock = 0L;
            }
            finally {
                this.putMessageLock.unlock();
            }
            if (AppendMessageStatus.PUT_OK.equals((Object)result.getStatus())) {
                this.defaultMessageStore.increaseOffset(msg, this.getMessageNum(msg));
            }
        }
        catch (RocksDBException e) {
            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
            return completableFuture;
        }
        finally {
            this.topicQueueLock.unlock(topicQueueKey);
        }
        if (elapsedTimeInLock > 500L) {
            log.warn("[NOTIFYME]putMessage in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, msg.getBody().length, result});
        }
        if (null != unlockMappedFile && this.defaultMessageStore.getMessageStoreConfig().isWarmMapedFileEnable()) {
            this.defaultMessageStore.unlockMappedFile(unlockMappedFile);
        }
        PutMessageResult putMessageResult = new PutMessageResult(PutMessageStatus.PUT_OK, result);
        storeStatsService.getSinglePutMessageTopicTimesTotal(msg.getTopic()).add(result.getMsgNum());
        storeStatsService.getSinglePutMessageTopicSizeTotal(topic).add(result.getWroteBytes());
        return this.handleDiskFlushAndHA(putMessageResult, (MessageExt)msg, needAckNums, needHandleHA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        int inSyncReplicas;
        InetSocketAddress storeSocketAddress;
        messageExtBatch.setStoreTimestamp(System.currentTimeMillis());
        AppendMessageResult result = null;
        StoreStatsService storeStatsService = this.defaultMessageStore.getStoreStatsService();
        int tranType = MessageSysFlag.getTransactionValue((int)messageExtBatch.getSysFlag());
        if (tranType != 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        if (messageExtBatch.getDelayTimeLevel() > 0) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        InetSocketAddress bornSocketAddress = (InetSocketAddress)messageExtBatch.getBornHost();
        if (bornSocketAddress.getAddress() instanceof Inet6Address) {
            messageExtBatch.setBornHostV6Flag();
        }
        if ((storeSocketAddress = (InetSocketAddress)messageExtBatch.getStoreHost()).getAddress() instanceof Inet6Address) {
            messageExtBatch.setStoreHostAddressV6Flag();
        }
        long elapsedTimeInLock = 0L;
        MappedFile unlockMappedFile = null;
        MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile();
        long currOffset = mappedFile == null ? 0L : mappedFile.getFileFromOffset() + (long)mappedFile.getWrotePosition();
        int needAckNums = this.defaultMessageStore.getMessageStoreConfig().getInSyncReplicas();
        boolean needHandleHA = this.needHandleHA((MessageExt)messageExtBatch);
        if (needHandleHA && this.defaultMessageStore.getBrokerConfig().isEnableControllerMode()) {
            if (this.defaultMessageStore.getHaService().inSyncReplicasNums(currOffset) < this.defaultMessageStore.getMessageStoreConfig().getMinInSyncReplicas()) {
                return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH, null));
            }
            if (this.defaultMessageStore.getMessageStoreConfig().isAllAckInSyncStateSet()) {
                needAckNums = -1;
            }
        } else if (needHandleHA && this.defaultMessageStore.getBrokerConfig().isEnableSlaveActingMaster() && (needAckNums = this.calcNeedAckNums(inSyncReplicas = Math.min(this.defaultMessageStore.getAliveReplicaNumInGroup(), this.defaultMessageStore.getHaService().inSyncReplicasNums(currOffset)))) > inSyncReplicas) {
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.IN_SYNC_REPLICAS_NOT_ENOUGH, null));
        }
        messageExtBatch.setVersion(MessageVersion.MESSAGE_VERSION_V1);
        boolean autoMessageVersionOnTopicLen = this.defaultMessageStore.getMessageStoreConfig().isAutoMessageVersionOnTopicLen();
        if (autoMessageVersionOnTopicLen && messageExtBatch.getTopic().length() > 127) {
            messageExtBatch.setVersion(MessageVersion.MESSAGE_VERSION_V2);
        }
        MessageExtEncoder.PutMessageThreadLocal pmThreadLocal = this.putMessageThreadLocal.get();
        this.updateMaxMessageSize(pmThreadLocal);
        MessageExtEncoder batchEncoder = pmThreadLocal.getEncoder();
        String topicQueueKey = this.generateKey(pmThreadLocal.getKeyBuilder(), (MessageExt)messageExtBatch);
        PutMessageContext putMessageContext = new PutMessageContext(topicQueueKey);
        messageExtBatch.setEncodedBuff(batchEncoder.encode(messageExtBatch, putMessageContext));
        this.topicQueueLock.lock(topicQueueKey);
        try {
            this.defaultMessageStore.assignOffset((MessageExtBrokerInner)messageExtBatch);
            this.putMessageLock.lock();
            try {
                long beginLockTimestamp;
                this.beginTimeInLock = beginLockTimestamp = this.defaultMessageStore.getSystemClock().now();
                messageExtBatch.setStoreTimestamp(beginLockTimestamp);
                if (null == mappedFile || mappedFile.isFull()) {
                    mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                    if (this.isCloseReadAhead()) {
                        this.setFileReadMode(mappedFile, 1);
                    }
                }
                if (null == mappedFile) {
                    log.error("Create mapped file1 error, topic: {} clientAddr: {}", (Object)messageExtBatch.getTopic(), (Object)messageExtBatch.getBornHostString());
                    this.beginTimeInLock = 0L;
                    CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, null));
                    return completableFuture;
                }
                result = mappedFile.appendMessages(messageExtBatch, this.appendMessageCallback, putMessageContext);
                switch (result.getStatus()) {
                    case PUT_OK: {
                        break;
                    }
                    case END_OF_FILE: {
                        unlockMappedFile = mappedFile;
                        mappedFile = this.mappedFileQueue.getLastMappedFile(0L);
                        if (null == mappedFile) {
                            log.error("Create mapped file2 error, topic: {} clientAddr: {}", (Object)messageExtBatch.getTopic(), (Object)messageExtBatch.getBornHostString());
                            this.beginTimeInLock = 0L;
                            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.CREATE_MAPPED_FILE_FAILED, result));
                            return completableFuture;
                        }
                        if (this.isCloseReadAhead()) {
                            this.setFileReadMode(mappedFile, 1);
                        }
                        result = mappedFile.appendMessages(messageExtBatch, this.appendMessageCallback, putMessageContext);
                        break;
                    }
                    case MESSAGE_SIZE_EXCEEDED: 
                    case PROPERTIES_SIZE_EXCEEDED: {
                        this.beginTimeInLock = 0L;
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, result));
                        return completableFuture;
                    }
                    default: {
                        this.beginTimeInLock = 0L;
                        CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
                        return completableFuture;
                    }
                }
                elapsedTimeInLock = this.defaultMessageStore.getSystemClock().now() - beginLockTimestamp;
                this.beginTimeInLock = 0L;
            }
            finally {
                this.putMessageLock.unlock();
            }
            if (AppendMessageStatus.PUT_OK.equals((Object)result.getStatus())) {
                this.defaultMessageStore.increaseOffset((MessageExtBrokerInner)messageExtBatch, (short)putMessageContext.getBatchSize());
            }
        }
        catch (RocksDBException e) {
            CompletableFuture<PutMessageResult> completableFuture = CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, result));
            return completableFuture;
        }
        finally {
            this.topicQueueLock.unlock(topicQueueKey);
        }
        if (elapsedTimeInLock > 500L) {
            log.warn("[NOTIFYME]putMessages in lock cost time(ms)={}, bodyLength={} AppendMessageResult={}", new Object[]{elapsedTimeInLock, messageExtBatch.getBody().length, result});
        }
        if (null != unlockMappedFile && this.defaultMessageStore.getMessageStoreConfig().isWarmMapedFileEnable()) {
            this.defaultMessageStore.unlockMappedFile(unlockMappedFile);
        }
        PutMessageResult putMessageResult = new PutMessageResult(PutMessageStatus.PUT_OK, result);
        storeStatsService.getSinglePutMessageTopicTimesTotal(messageExtBatch.getTopic()).add(result.getMsgNum());
        storeStatsService.getSinglePutMessageTopicSizeTotal(messageExtBatch.getTopic()).add(result.getWroteBytes());
        return this.handleDiskFlushAndHA(putMessageResult, (MessageExt)messageExtBatch, needAckNums, needHandleHA);
    }

    private int calcNeedAckNums(int inSyncReplicas) {
        int needAckNums = this.defaultMessageStore.getMessageStoreConfig().getInSyncReplicas();
        if (this.defaultMessageStore.getMessageStoreConfig().isEnableAutoInSyncReplicas()) {
            needAckNums = Math.min(needAckNums, inSyncReplicas);
            needAckNums = Math.max(needAckNums, this.defaultMessageStore.getMessageStoreConfig().getMinInSyncReplicas());
        }
        return needAckNums;
    }

    private boolean needHandleHA(MessageExt messageExt) {
        if (!messageExt.isWaitStoreMsgOK()) {
            return false;
        }
        if (this.defaultMessageStore.getMessageStoreConfig().isDuplicationEnable()) {
            return false;
        }
        return BrokerRole.SYNC_MASTER == this.defaultMessageStore.getMessageStoreConfig().getBrokerRole();
    }

    private CompletableFuture<PutMessageResult> handleDiskFlushAndHA(PutMessageResult putMessageResult, MessageExt messageExt, int needAckNums, boolean needHandleHA) {
        CompletableFuture<PutMessageStatus> flushResultFuture = this.handleDiskFlush(putMessageResult.getAppendMessageResult(), messageExt);
        CompletableFuture<PutMessageStatus> replicaResultFuture = !needHandleHA ? CompletableFuture.completedFuture(PutMessageStatus.PUT_OK) : this.handleHA(putMessageResult.getAppendMessageResult(), putMessageResult, needAckNums);
        return flushResultFuture.thenCombine(replicaResultFuture, (flushStatus, replicaStatus) -> {
            if (flushStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)flushStatus));
            }
            if (replicaStatus != PutMessageStatus.PUT_OK) {
                putMessageResult.setPutMessageStatus((PutMessageStatus)((Object)replicaStatus));
            }
            return putMessageResult;
        });
    }

    private CompletableFuture<PutMessageStatus> handleDiskFlush(AppendMessageResult result, MessageExt messageExt) {
        return this.flushManager.handleDiskFlush(result, messageExt);
    }

    private CompletableFuture<PutMessageStatus> handleHA(AppendMessageResult result, PutMessageResult putMessageResult, int needAckNums) {
        if (needAckNums >= 0 && needAckNums <= 1) {
            return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
        }
        HAService haService = this.defaultMessageStore.getHaService();
        long nextOffset = result.getWroteOffset() + (long)result.getWroteBytes();
        GroupCommitRequest request = new GroupCommitRequest(nextOffset, this.defaultMessageStore.getMessageStoreConfig().getSlaveTimeout(), needAckNums);
        haService.putRequest(request);
        haService.getWaitNotifyObject().wakeupAll();
        return request.future();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long pickupStoreTimestamp(long offset, int size) {
        SelectMappedBufferResult result;
        if (offset >= this.getMinOffset() && offset + (long)size <= this.getMaxOffset() && null != (result = this.getMessage(offset, size))) {
            try {
                int sysFlag = result.getByteBuffer().getInt(36);
                int bornhostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
                int msgStoreTimePos = 48 + bornhostLength;
                long l = result.getByteBuffer().getLong(msgStoreTimePos);
                return l;
            }
            finally {
                result.release();
            }
        }
        return -1L;
    }

    public long getMinOffset() {
        MappedFile mappedFile = this.mappedFileQueue.getFirstMappedFile();
        if (mappedFile != null) {
            if (mappedFile.isAvailable()) {
                return mappedFile.getFileFromOffset();
            }
            return this.rollNextFile(mappedFile.getFileFromOffset());
        }
        return -1L;
    }

    public SelectMappedBufferResult getMessage(long offset, int size) {
        int pos;
        SelectMappedBufferResult selectMappedBufferResult;
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        MappedFile mappedFile = this.mappedFileQueue.findMappedFileByOffset(offset, offset == 0L);
        if (mappedFile != null && null != (selectMappedBufferResult = mappedFile.selectMappedBuffer(pos = (int)(offset % (long)mappedFileSize), size))) {
            selectMappedBufferResult.setInCache(this.coldDataCheckService.isDataInPageCache(offset));
            return selectMappedBufferResult;
        }
        return null;
    }

    public long rollNextFile(long offset) {
        int mappedFileSize = this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog();
        return offset + (long)mappedFileSize - offset % (long)mappedFileSize;
    }

    public void destroy() {
        this.mappedFileQueue.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendData(long startOffset, byte[] data, int dataStart, int dataLength) {
        this.putMessageLock.lock();
        try {
            MappedFile mappedFile = this.mappedFileQueue.getLastMappedFile(startOffset);
            if (null == mappedFile) {
                log.error("appendData getLastMappedFile error  " + startOffset);
                boolean bl = false;
                return bl;
            }
            boolean bl = mappedFile.appendMessage(data, dataStart, dataLength);
            return bl;
        }
        finally {
            this.putMessageLock.unlock();
        }
    }

    public boolean retryDeleteFirstFile(long intervalForcibly) {
        return this.mappedFileQueue.retryDeleteFirstFile(intervalForcibly);
    }

    public void checkSelf() {
        this.mappedFileQueue.checkSelf();
    }

    public long lockTimeMills() {
        long diff = 0L;
        long begin = this.beginTimeInLock;
        if (begin > 0L) {
            diff = this.defaultMessageStore.now() - begin;
        }
        if (diff < 0L) {
            diff = 0L;
        }
        return diff;
    }

    protected short getMessageNum(MessageExtBrokerInner msgInner) {
        short messageNum = 1;
        CQType cqType = this.getCqType(msgInner);
        if ((MessageSysFlag.check((int)msgInner.getSysFlag(), (int)128) || CQType.BatchCQ.equals((Object)cqType)) && msgInner.getProperty("INNER_NUM") != null) {
            messageNum = Short.parseShort(msgInner.getProperty("INNER_NUM"));
            messageNum = messageNum >= 1 ? messageNum : (short)1;
        }
        return messageNum;
    }

    private CQType getCqType(MessageExtBrokerInner msgInner) {
        Optional<TopicConfig> topicConfig = this.defaultMessageStore.getTopicConfig(msgInner.getTopic());
        return QueueTypeUtils.getCQType(topicConfig);
    }

    public int getCommitLogSize() {
        return this.commitLogSize;
    }

    public MappedFileQueue getMappedFileQueue() {
        return this.mappedFileQueue;
    }

    public MessageStore getMessageStore() {
        return this.defaultMessageStore;
    }

    @Override
    public void swapMap(int reserveNum, long forceSwapIntervalMs, long normalSwapIntervalMs) {
        this.getMappedFileQueue().swapMap(reserveNum, forceSwapIntervalMs, normalSwapIntervalMs);
    }

    public boolean isMappedFilesEmpty() {
        return this.mappedFileQueue.isMappedFilesEmpty();
    }

    @Override
    public void cleanSwappedMap(long forceCleanSwapIntervalMs) {
        this.getMappedFileQueue().cleanSwappedMap(forceCleanSwapIntervalMs);
    }

    public FlushManager getFlushManager() {
        return this.flushManager;
    }

    public static boolean isMultiDispatchMsg(MessageStoreConfig messageStoreConfig, MessageExtBrokerInner msg) {
        return StringUtils.isNotBlank((CharSequence)msg.getProperty("INNER_MULTI_DISPATCH")) && MultiDispatchUtils.isNeedHandleMultiDispatch(messageStoreConfig, msg.getTopic());
    }

    private boolean isCloseReadAhead() {
        return !MixAll.isWindows() && !this.defaultMessageStore.getMessageStoreConfig().isDataReadAheadEnable();
    }

    public void scanFileAndSetReadMode(int mode) {
        if (MixAll.isWindows()) {
            log.info("windows os stop scanFileAndSetReadMode");
            return;
        }
        try {
            log.info("scanFileAndSetReadMode mode: {}", (Object)mode);
            this.mappedFileQueue.getMappedFiles().forEach(mappedFile -> this.setFileReadMode((MappedFile)mappedFile, mode));
        }
        catch (Exception e) {
            log.error("scanFileAndSetReadMode exception", (Throwable)e);
        }
    }

    private int setFileReadMode(MappedFile mappedFile, int mode) {
        if (null == mappedFile) {
            log.error("setFileReadMode mappedFile is null");
            return -1;
        }
        long address = ((DirectBuffer)((Object)mappedFile.getMappedByteBuffer())).address();
        int madvise = LibC.INSTANCE.madvise(new Pointer(address), new NativeLong((long)mappedFile.getFileSize()), mode);
        if (madvise != 0) {
            log.error("setFileReadMode error fileName: {}, madvise: {}, mode:{}", new Object[]{mappedFile.getFileName(), madvise, mode});
        }
        return madvise;
    }

    public ColdDataCheckService getColdDataCheckService() {
        return this.coldDataCheckService;
    }

    public class ColdDataCheckService
    extends ServiceThread {
        private final SystemClock systemClock = new SystemClock();
        private final ConcurrentHashMap<String, byte[]> pageCacheMap = new ConcurrentHashMap();
        private int pageSize = -1;
        private int sampleSteps = 32;

        public ColdDataCheckService() {
            this.sampleSteps = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getSampleSteps();
            if (this.sampleSteps <= 0) {
                this.sampleSteps = 32;
            }
            this.initPageSize();
            this.scanFilesInPageCache();
        }

        public String getServiceName() {
            return ColdDataCheckService.class.getSimpleName();
        }

        public void run() {
            log.info("{} service started", (Object)this.getServiceName());
            while (!this.isStopped()) {
                try {
                    if (MixAll.isWindows() || !CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataFlowControlEnable() || !CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataScanEnable()) {
                        this.pageCacheMap.clear();
                        this.waitForRunning(180000L);
                        continue;
                    }
                    this.waitForRunning(CommitLog.this.defaultMessageStore.getMessageStoreConfig().getTimerColdDataCheckIntervalMs());
                    if (this.pageSize < 0) {
                        this.initPageSize();
                    }
                    long beginClockTimestamp = this.systemClock.now();
                    this.scanFilesInPageCache();
                    long costTime = this.systemClock.now() - beginClockTimestamp;
                    log.info("[{}] scanFilesInPageCache-cost {} ms.", (Object)(costTime > 30000L ? "NOTIFYME" : "OK"), (Object)costTime);
                }
                catch (Throwable e) {
                    log.warn(this.getServiceName() + " service has e: {}", e);
                }
            }
            log.info("{} service end", (Object)this.getServiceName());
        }

        public boolean isDataInPageCache(long offset) {
            if (!CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataFlowControlEnable()) {
                return true;
            }
            if (this.pageSize <= 0 || this.sampleSteps <= 0) {
                return true;
            }
            if (!CommitLog.this.defaultMessageStore.checkInColdAreaByCommitOffset(offset, CommitLog.this.getMaxOffset())) {
                return true;
            }
            if (!CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataScanEnable()) {
                return false;
            }
            MappedFile mappedFile = CommitLog.this.mappedFileQueue.findMappedFileByOffset(offset, offset == 0L);
            if (null == mappedFile) {
                return true;
            }
            byte[] bytes = this.pageCacheMap.get(mappedFile.getFileName());
            if (null == bytes) {
                return true;
            }
            int pos = (int)(offset % (long)CommitLog.this.defaultMessageStore.getMessageStoreConfig().getMappedFileSizeCommitLog());
            int realIndex = pos / this.pageSize / this.sampleSteps;
            return bytes.length - 1 >= realIndex && bytes[realIndex] != 0;
        }

        private void scanFilesInPageCache() {
            if (MixAll.isWindows() || !CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataFlowControlEnable() || !CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataScanEnable() || this.pageSize <= 0) {
                return;
            }
            try {
                log.info("pageCacheMap key size: {}", (Object)this.pageCacheMap.size());
                this.clearExpireMappedFile();
                CommitLog.this.mappedFileQueue.getMappedFiles().forEach(mappedFile -> {
                    byte[] pageCacheTable = this.checkFileInPageCache((MappedFile)mappedFile);
                    if (this.sampleSteps > 1) {
                        pageCacheTable = this.sampling(pageCacheTable, this.sampleSteps);
                    }
                    this.pageCacheMap.put(mappedFile.getFileName(), pageCacheTable);
                });
            }
            catch (Exception e) {
                log.error("scanFilesInPageCache exception", (Throwable)e);
            }
        }

        private void clearExpireMappedFile() {
            Set currentFileSet = CommitLog.this.mappedFileQueue.getMappedFiles().stream().map(MappedFile::getFileName).collect(Collectors.toSet());
            this.pageCacheMap.forEach((key, value) -> {
                if (!currentFileSet.contains(key)) {
                    this.pageCacheMap.remove(key);
                    log.info("clearExpireMappedFile fileName: {}, has been clear", key);
                }
            });
        }

        private byte[] sampling(byte[] pageCacheTable, int sampleStep) {
            byte[] sample = new byte[(pageCacheTable.length + sampleStep - 1) / sampleStep];
            int j = 0;
            for (int i = 0; i < pageCacheTable.length && j < sample.length; i += sampleStep) {
                sample[j++] = pageCacheTable[i];
            }
            return sample;
        }

        private byte[] checkFileInPageCache(MappedFile mappedFile) {
            int pageNums;
            byte[] pageCacheRst;
            long fileSize = mappedFile.getFileSize();
            long address = ((DirectBuffer)((Object)mappedFile.getMappedByteBuffer())).address();
            int mincore = LibC.INSTANCE.mincore(new Pointer(address), new NativeLong(fileSize), pageCacheRst = new byte[pageNums = (int)(fileSize + (long)this.pageSize - 1L) / this.pageSize]);
            if (mincore != 0) {
                log.error("checkFileInPageCache call the LibC.INSTANCE.mincore error, fileName: {}, fileSize: {}", (Object)mappedFile.getFileName(), (Object)fileSize);
                for (int i = 0; i < pageNums; ++i) {
                    pageCacheRst[i] = 1;
                }
            }
            return pageCacheRst;
        }

        private void initPageSize() {
            if (this.pageSize < 0 && CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataFlowControlEnable()) {
                try {
                    if (!MixAll.isWindows()) {
                        this.pageSize = LibC.INSTANCE.getpagesize();
                    } else {
                        CommitLog.this.defaultMessageStore.getMessageStoreConfig().setColdDataFlowControlEnable(false);
                        log.info("windows os, coldDataCheckEnable force setting to be false");
                    }
                    log.info("initPageSize pageSize: {}", (Object)this.pageSize);
                }
                catch (Exception e) {
                    CommitLog.this.defaultMessageStore.getMessageStoreConfig().setColdDataFlowControlEnable(false);
                    log.error("initPageSize error, coldDataCheckEnable force setting to be false ", (Throwable)e);
                }
            }
        }

        public boolean isMsgInColdArea(String group, String topic, int queueId, long offset) {
            if (!CommitLog.this.defaultMessageStore.getMessageStoreConfig().isColdDataFlowControlEnable()) {
                return false;
            }
            try {
                ConsumeQueue consumeQueue = (ConsumeQueue)CommitLog.this.defaultMessageStore.findConsumeQueue(topic, queueId);
                if (null == consumeQueue) {
                    return false;
                }
                SelectMappedBufferResult bufferConsumeQueue = consumeQueue.getIndexBuffer(offset);
                if (null == bufferConsumeQueue || null == bufferConsumeQueue.getByteBuffer()) {
                    return false;
                }
                long offsetPy = bufferConsumeQueue.getByteBuffer().getLong();
                return CommitLog.this.defaultMessageStore.checkInColdAreaByCommitOffset(offsetPy, CommitLog.this.getMaxOffset());
            }
            catch (Exception e) {
                log.error("isMsgInColdArea group: {}, topic: {}, queueId: {}, offset: {}", new Object[]{group, topic, queueId, offset, e});
                return false;
            }
        }
    }

    class DefaultFlushManager
    implements FlushManager {
        private final FlushCommitLogService flushCommitLogService;
        private final FlushCommitLogService commitRealTimeService;

        public DefaultFlushManager() {
            this.flushCommitLogService = FlushDiskType.SYNC_FLUSH == CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushDiskType() ? new GroupCommitService() : new FlushRealTimeService();
            this.commitRealTimeService = new CommitRealTimeService();
        }

        @Override
        public void start() {
            this.flushCommitLogService.start();
            if (CommitLog.this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.commitRealTimeService.start();
            }
        }

        @Override
        public void handleDiskFlush(AppendMessageResult result, PutMessageResult putMessageResult, MessageExt messageExt) {
            if (FlushDiskType.SYNC_FLUSH == CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushDiskType()) {
                GroupCommitService service = (GroupCommitService)this.flushCommitLogService;
                if (messageExt.isWaitStoreMsgOK()) {
                    GroupCommitRequest request = new GroupCommitRequest(result.getWroteOffset() + (long)result.getWroteBytes(), CommitLog.this.defaultMessageStore.getMessageStoreConfig().getSyncFlushTimeout());
                    service.putRequest(request);
                    CompletableFuture<PutMessageStatus> flushOkFuture = request.future();
                    PutMessageStatus flushStatus = null;
                    try {
                        flushStatus = flushOkFuture.get(CommitLog.this.defaultMessageStore.getMessageStoreConfig().getSyncFlushTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException exception) {
                        // empty catch block
                    }
                    if (flushStatus != PutMessageStatus.PUT_OK) {
                        log.error("do groupcommit, wait for flush failed, topic: " + messageExt.getTopic() + " tags: " + messageExt.getTags() + " client address: " + messageExt.getBornHostString());
                        putMessageResult.setPutMessageStatus(PutMessageStatus.FLUSH_DISK_TIMEOUT);
                    }
                } else {
                    service.wakeup();
                }
            } else if (!CommitLog.this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.flushCommitLogService.wakeup();
            } else {
                this.commitRealTimeService.wakeup();
            }
        }

        @Override
        public CompletableFuture<PutMessageStatus> handleDiskFlush(AppendMessageResult result, MessageExt messageExt) {
            if (FlushDiskType.SYNC_FLUSH == CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushDiskType()) {
                GroupCommitService service = (GroupCommitService)this.flushCommitLogService;
                if (messageExt.isWaitStoreMsgOK()) {
                    GroupCommitRequest request = new GroupCommitRequest(result.getWroteOffset() + (long)result.getWroteBytes(), CommitLog.this.defaultMessageStore.getMessageStoreConfig().getSyncFlushTimeout());
                    CommitLog.this.flushDiskWatcher.add(request);
                    service.putRequest(request);
                    return request.future();
                }
                service.wakeup();
                return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
            }
            if (!CommitLog.this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.flushCommitLogService.wakeup();
            } else {
                this.commitRealTimeService.wakeup();
            }
            return CompletableFuture.completedFuture(PutMessageStatus.PUT_OK);
        }

        @Override
        public void wakeUpFlush() {
            this.flushCommitLogService.wakeup();
        }

        @Override
        public void wakeUpCommit() {
            this.commitRealTimeService.wakeup();
        }

        @Override
        public void shutdown() {
            if (CommitLog.this.defaultMessageStore.isTransientStorePoolEnable()) {
                this.commitRealTimeService.shutdown();
            }
            this.flushCommitLogService.shutdown();
        }
    }

    class DefaultAppendMessageCallback
    implements AppendMessageCallback {
        private static final int END_FILE_MIN_BLANK_LENGTH = 8;
        private final ByteBuffer msgStoreItemMemory = ByteBuffer.allocate(8);
        private final int crc32ReservedLength;
        private final MessageStoreConfig messageStoreConfig;

        DefaultAppendMessageCallback(MessageStoreConfig messageStoreConfig) {
            this.messageStoreConfig = messageStoreConfig;
            this.crc32ReservedLength = messageStoreConfig.isEnabledAppendPropCRC() ? CRC32_RESERVED_LEN : 0;
        }

        public AppendMessageResult handlePropertiesForLmqMsg(ByteBuffer preEncodeBuffer, MessageExtBrokerInner msgInner) {
            if (msgInner.isEncodeCompleted()) {
                return null;
            }
            CommitLog.this.multiDispatch.wrapMultiDispatch(msgInner);
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
            byte[] propertiesData = msgInner.getPropertiesString() == null ? null : msgInner.getPropertiesString().getBytes(MessageDecoder.CHARSET_UTF8);
            boolean needAppendLastPropertySeparator = CommitLog.this.enabledAppendPropCRC && propertiesData != null && propertiesData.length > 0 && propertiesData[propertiesData.length - 1] != 2;
            int propertiesLength = (propertiesData == null ? 0 : propertiesData.length) + (needAppendLastPropertySeparator ? 1 : 0) + this.crc32ReservedLength;
            if (propertiesLength > Short.MAX_VALUE) {
                log.warn("putMessage message properties length too long. length={}", (Object)propertiesData.length);
                return new AppendMessageResult(AppendMessageStatus.PROPERTIES_SIZE_EXCEEDED);
            }
            int msgLenWithoutProperties = preEncodeBuffer.getInt(0);
            int msgLen = msgLenWithoutProperties + 2 + propertiesLength;
            if (msgLen > this.messageStoreConfig.getMaxMessageSize()) {
                log.warn("message size exceeded, msg total size: " + msgLen + ", maxMessageSize: " + this.messageStoreConfig.getMaxMessageSize());
                return new AppendMessageResult(AppendMessageStatus.MESSAGE_SIZE_EXCEEDED);
            }
            preEncodeBuffer.putInt(0, msgLen);
            preEncodeBuffer.position(msgLenWithoutProperties);
            preEncodeBuffer.putShort((short)propertiesLength);
            if (propertiesLength > this.crc32ReservedLength) {
                preEncodeBuffer.put(propertiesData);
            }
            if (needAppendLastPropertySeparator) {
                preEncodeBuffer.put((byte)2);
            }
            preEncodeBuffer.position(preEncodeBuffer.position() + this.crc32ReservedLength);
            msgInner.setEncodeCompleted(true);
            return null;
        }

        @Override
        public AppendMessageResult doAppend(long fileFromOffset, ByteBuffer byteBuffer, int maxBlank, MessageExtBrokerInner msgInner, PutMessageContext putMessageContext) {
            AppendMessageResult appendMessageResult;
            ByteBuffer preEncodeBuffer = msgInner.getEncodedBuff();
            boolean isMultiDispatchMsg = CommitLog.isMultiDispatchMsg(this.messageStoreConfig, msgInner);
            if (isMultiDispatchMsg && (appendMessageResult = this.handlePropertiesForLmqMsg(preEncodeBuffer, msgInner)) != null) {
                return appendMessageResult;
            }
            int msgLen = preEncodeBuffer.getInt(0);
            preEncodeBuffer.position(0);
            preEncodeBuffer.limit(msgLen);
            long wroteOffset = fileFromOffset + (long)byteBuffer.position();
            Supplier<String> msgIdSupplier = () -> {
                int sysflag = msgInner.getSysFlag();
                int msgIdLen = (sysflag & 0x20) == 0 ? 16 : 28;
                ByteBuffer msgIdBuffer = ByteBuffer.allocate(msgIdLen);
                MessageExt.socketAddress2ByteBuffer((SocketAddress)msgInner.getStoreHost(), (ByteBuffer)msgIdBuffer);
                msgIdBuffer.clear();
                msgIdBuffer.putLong(msgIdLen - 8, wroteOffset);
                return UtilAll.bytes2string((byte[])msgIdBuffer.array());
            };
            Long queueOffset = msgInner.getQueueOffset();
            short messageNum = CommitLog.this.getMessageNum(msgInner);
            int tranType = MessageSysFlag.getTransactionValue((int)msgInner.getSysFlag());
            switch (tranType) {
                case 4: 
                case 12: {
                    queueOffset = 0L;
                    break;
                }
            }
            if (msgLen + 8 > maxBlank) {
                this.msgStoreItemMemory.clear();
                this.msgStoreItemMemory.putInt(maxBlank);
                this.msgStoreItemMemory.putInt(-875286124);
                long beginTimeMills = CommitLog.this.defaultMessageStore.now();
                byteBuffer.put(this.msgStoreItemMemory.array(), 0, 8);
                return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, wroteOffset, maxBlank, msgIdSupplier, msgInner.getStoreTimestamp(), (long)queueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
            }
            int pos = 20;
            preEncodeBuffer.putLong(pos, queueOffset);
            preEncodeBuffer.putLong(pos += 8, fileFromOffset + (long)byteBuffer.position());
            pos += 8;
            int ipLen = (msgInner.getSysFlag() & 0x10) == 0 ? 8 : 20;
            preEncodeBuffer.putLong(pos += 12 + ipLen, msgInner.getStoreTimestamp());
            if (CommitLog.this.enabledAppendPropCRC) {
                int checkSize = msgLen - this.crc32ReservedLength;
                ByteBuffer tmpBuffer = preEncodeBuffer.duplicate();
                tmpBuffer.limit(tmpBuffer.position() + checkSize);
                int crc32 = UtilAll.crc32((ByteBuffer)tmpBuffer);
                tmpBuffer.limit(tmpBuffer.position() + this.crc32ReservedLength);
                MessageDecoder.createCrc32((ByteBuffer)tmpBuffer, (int)crc32);
            }
            long beginTimeMills = CommitLog.this.defaultMessageStore.now();
            CommitLog.this.getMessageStore().getPerfCounter().startTick("WRITE_MEMORY_TIME_MS");
            byteBuffer.put(preEncodeBuffer);
            CommitLog.this.getMessageStore().getPerfCounter().endTick("WRITE_MEMORY_TIME_MS");
            msgInner.setEncodedBuff(null);
            if (isMultiDispatchMsg) {
                CommitLog.this.multiDispatch.updateMultiQueueOffset(msgInner);
            }
            return new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, msgLen, msgIdSupplier, msgInner.getStoreTimestamp(), queueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills, messageNum);
        }

        @Override
        public AppendMessageResult doAppend(long fileFromOffset, ByteBuffer byteBuffer, int maxBlank, MessageExtBatch messageExtBatch, PutMessageContext putMessageContext) {
            byteBuffer.mark();
            long wroteOffset = fileFromOffset + (long)byteBuffer.position();
            Long queueOffset = messageExtBatch.getQueueOffset();
            long beginQueueOffset = queueOffset;
            int totalMsgLen = 0;
            int msgNum = 0;
            long beginTimeMills = CommitLog.this.defaultMessageStore.now();
            ByteBuffer messagesByteBuff = messageExtBatch.getEncodedBuff();
            int sysFlag = messageExtBatch.getSysFlag();
            int bornHostLength = (sysFlag & 0x10) == 0 ? 8 : 20;
            int storeHostLength = (sysFlag & 0x20) == 0 ? 8 : 20;
            Supplier<String> msgIdSupplier = () -> {
                int msgIdLen = storeHostLength + 8;
                int batchCount = putMessageContext.getBatchSize();
                long[] phyPosArray = putMessageContext.getPhyPos();
                ByteBuffer msgIdBuffer = ByteBuffer.allocate(msgIdLen);
                MessageExt.socketAddress2ByteBuffer((SocketAddress)messageExtBatch.getStoreHost(), (ByteBuffer)msgIdBuffer);
                msgIdBuffer.clear();
                StringBuilder buffer = new StringBuilder(batchCount * msgIdLen * 2 + batchCount - 1);
                for (int i = 0; i < phyPosArray.length; ++i) {
                    msgIdBuffer.putLong(msgIdLen - 8, phyPosArray[i]);
                    String msgId = UtilAll.bytes2string((byte[])msgIdBuffer.array());
                    if (i != 0) {
                        buffer.append(',');
                    }
                    buffer.append(msgId);
                }
                return buffer.toString();
            };
            messagesByteBuff.mark();
            int index = 0;
            while (messagesByteBuff.hasRemaining()) {
                int msgPos = messagesByteBuff.position();
                int msgLen = messagesByteBuff.getInt();
                if ((totalMsgLen += msgLen) + 8 > maxBlank) {
                    this.msgStoreItemMemory.clear();
                    this.msgStoreItemMemory.putInt(maxBlank);
                    this.msgStoreItemMemory.putInt(-875286124);
                    messagesByteBuff.reset();
                    byteBuffer.reset();
                    byteBuffer.put(this.msgStoreItemMemory.array(), 0, 8);
                    return new AppendMessageResult(AppendMessageStatus.END_OF_FILE, wroteOffset, maxBlank, msgIdSupplier, messageExtBatch.getStoreTimestamp(), beginQueueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
                }
                int pos = msgPos + 20;
                messagesByteBuff.putLong(pos, queueOffset);
                messagesByteBuff.putLong(pos += 8, wroteOffset + (long)totalMsgLen - (long)msgLen);
                messagesByteBuff.putLong(pos += 20 + bornHostLength, messageExtBatch.getStoreTimestamp());
                if (CommitLog.this.enabledAppendPropCRC) {
                    int checkSize = msgLen - this.crc32ReservedLength;
                    ByteBuffer tmpBuffer = messagesByteBuff.duplicate();
                    tmpBuffer.position(msgPos).limit(msgPos + checkSize);
                    int crc32 = UtilAll.crc32((ByteBuffer)tmpBuffer);
                    messagesByteBuff.position(msgPos + checkSize);
                    MessageDecoder.createCrc32((ByteBuffer)messagesByteBuff, (int)crc32);
                }
                putMessageContext.getPhyPos()[index++] = wroteOffset + (long)totalMsgLen - (long)msgLen;
                Long l = queueOffset;
                Long l2 = queueOffset = Long.valueOf(queueOffset + 1L);
                ++msgNum;
                messagesByteBuff.position(msgPos + msgLen);
            }
            messagesByteBuff.position(0);
            messagesByteBuff.limit(totalMsgLen);
            byteBuffer.put(messagesByteBuff);
            messageExtBatch.setEncodedBuff(null);
            AppendMessageResult result = new AppendMessageResult(AppendMessageStatus.PUT_OK, wroteOffset, totalMsgLen, msgIdSupplier, messageExtBatch.getStoreTimestamp(), beginQueueOffset, CommitLog.this.defaultMessageStore.now() - beginTimeMills);
            result.setMsgNum(msgNum);
            return result;
        }
    }

    class GroupCheckService
    extends FlushCommitLogService {
        private volatile List<GroupCommitRequest> requestsWrite;
        private volatile List<GroupCommitRequest> requestsRead;

        GroupCheckService() {
            this.requestsWrite = new ArrayList<GroupCommitRequest>();
            this.requestsRead = new ArrayList<GroupCommitRequest>();
        }

        public boolean isAsyncRequestsFull() {
            return this.requestsWrite.size() > CommitLog.this.defaultMessageStore.getMessageStoreConfig().getMaxAsyncPutMessageRequests() * 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean putRequest(GroupCommitRequest request) {
            boolean flag;
            List<GroupCommitRequest> list = this.requestsWrite;
            synchronized (list) {
                this.requestsWrite.add(request);
            }
            if (this.hasNotified.compareAndSet(false, true)) {
                this.waitPoint.countDown();
            }
            boolean bl = flag = this.requestsWrite.size() > CommitLog.this.defaultMessageStore.getMessageStoreConfig().getMaxAsyncPutMessageRequests();
            if (flag) {
                log.info("Async requests {} exceeded the threshold {}", (Object)this.requestsWrite.size(), (Object)CommitLog.this.defaultMessageStore.getMessageStoreConfig().getMaxAsyncPutMessageRequests());
            }
            return flag;
        }

        private void swapRequests() {
            List<GroupCommitRequest> tmp = this.requestsWrite;
            this.requestsWrite = this.requestsRead;
            this.requestsRead = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCommit() {
            List<GroupCommitRequest> list = this.requestsRead;
            synchronized (list) {
                if (!this.requestsRead.isEmpty()) {
                    for (GroupCommitRequest req : this.requestsRead) {
                        boolean flushOK = false;
                        for (int i = 0; i < 1000; ++i) {
                            boolean bl = flushOK = CommitLog.this.mappedFileQueue.getFlushedWhere() >= req.getNextOffset();
                            if (flushOK) break;
                            try {
                                Thread.sleep(1L);
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        req.wakeupCustomer(flushOK ? PutMessageStatus.PUT_OK : PutMessageStatus.FLUSH_DISK_TIMEOUT);
                    }
                    long storeTimestamp = CommitLog.this.mappedFileQueue.getStoreTimestamp();
                    if (storeTimestamp > 0L) {
                        CommitLog.this.defaultMessageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimestamp);
                    }
                    this.requestsRead.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(1L);
                    this.doCommit();
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.warn("GroupCommitService Exception, ", (Throwable)e);
            }
            GroupCheckService groupCheckService = this;
            synchronized (groupCheckService) {
                this.swapRequests();
            }
            this.doCommit();
            log.info(this.getServiceName() + " service end");
        }

        protected void onWaitEnd() {
            this.swapRequests();
        }

        public String getServiceName() {
            if (CommitLog.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return CommitLog.this.defaultMessageStore.getBrokerConfig().getIdentifier() + GroupCheckService.class.getSimpleName();
            }
            return GroupCheckService.class.getSimpleName();
        }

        public long getJoinTime() {
            return 300000L;
        }
    }

    class GroupCommitService
    extends FlushCommitLogService {
        private volatile LinkedList<GroupCommitRequest> requestsWrite;
        private volatile LinkedList<GroupCommitRequest> requestsRead;
        private final PutMessageSpinLock lock;

        GroupCommitService() {
            this.requestsWrite = new LinkedList();
            this.requestsRead = new LinkedList();
            this.lock = new PutMessageSpinLock();
        }

        public void putRequest(GroupCommitRequest request) {
            this.lock.lock();
            try {
                this.requestsWrite.add(request);
            }
            finally {
                this.lock.unlock();
            }
            this.wakeup();
        }

        private void swapRequests() {
            this.lock.lock();
            try {
                LinkedList<GroupCommitRequest> tmp = this.requestsWrite;
                this.requestsWrite = this.requestsRead;
                this.requestsRead = tmp;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void doCommit() {
            if (!this.requestsRead.isEmpty()) {
                for (GroupCommitRequest req : this.requestsRead) {
                    boolean flushOK = CommitLog.this.mappedFileQueue.getFlushedWhere() >= req.getNextOffset();
                    for (int i = 0; i < 1000 && !flushOK; ++i) {
                        CommitLog.this.mappedFileQueue.flush(0);
                        boolean bl = flushOK = CommitLog.this.mappedFileQueue.getFlushedWhere() >= req.getNextOffset();
                        if (flushOK) break;
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    req.wakeupCustomer(flushOK ? PutMessageStatus.PUT_OK : PutMessageStatus.FLUSH_DISK_TIMEOUT);
                }
                long storeTimestamp = CommitLog.this.mappedFileQueue.getStoreTimestamp();
                if (storeTimestamp > 0L) {
                    CommitLog.this.defaultMessageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimestamp);
                }
                this.requestsRead = new LinkedList();
            } else {
                CommitLog.this.mappedFileQueue.flush(0);
            }
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(10L);
                    this.doCommit();
                }
                catch (Exception e) {
                    log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.warn("GroupCommitService Exception, ", (Throwable)e);
            }
            this.swapRequests();
            this.doCommit();
            log.info(this.getServiceName() + " service end");
        }

        protected void onWaitEnd() {
            this.swapRequests();
        }

        public String getServiceName() {
            if (CommitLog.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return CommitLog.this.defaultMessageStore.getBrokerConfig().getIdentifier() + GroupCommitService.class.getSimpleName();
            }
            return GroupCommitService.class.getSimpleName();
        }

        public long getJoinTime() {
            return 300000L;
        }
    }

    public static class GroupCommitRequest {
        private final long nextOffset;
        private final CompletableFuture<PutMessageStatus> flushOKFuture = new CompletableFuture();
        private volatile int ackNums = 1;
        private final long deadLine;

        public GroupCommitRequest(long nextOffset, long timeoutMillis) {
            this.nextOffset = nextOffset;
            this.deadLine = System.nanoTime() + timeoutMillis * 1000000L;
        }

        public GroupCommitRequest(long nextOffset, long timeoutMillis, int ackNums) {
            this(nextOffset, timeoutMillis);
            this.ackNums = ackNums;
        }

        public long getNextOffset() {
            return this.nextOffset;
        }

        public int getAckNums() {
            return this.ackNums;
        }

        public long getDeadLine() {
            return this.deadLine;
        }

        public void wakeupCustomer(PutMessageStatus status) {
            this.flushOKFuture.complete(status);
        }

        public CompletableFuture<PutMessageStatus> future() {
            return this.flushOKFuture;
        }
    }

    class FlushRealTimeService
    extends FlushCommitLogService {
        private long lastFlushTimestamp;
        private long printTimes;

        FlushRealTimeService() {
            this.lastFlushTimestamp = 0L;
            this.printTimes = 0L;
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                boolean flushCommitLogTimed = CommitLog.this.defaultMessageStore.getMessageStoreConfig().isFlushCommitLogTimed();
                int interval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushIntervalCommitLog();
                int flushPhysicQueueLeastPages = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushCommitLogLeastPages();
                int flushPhysicQueueThoroughInterval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getFlushCommitLogThoroughInterval();
                boolean printFlushProgress = false;
                long currentTimeMillis = System.currentTimeMillis();
                if (currentTimeMillis >= this.lastFlushTimestamp + (long)flushPhysicQueueThoroughInterval) {
                    this.lastFlushTimestamp = currentTimeMillis;
                    flushPhysicQueueLeastPages = 0;
                    printFlushProgress = this.printTimes++ % 10L == 0L;
                }
                try {
                    if (flushCommitLogTimed) {
                        Thread.sleep(interval);
                    } else {
                        this.waitForRunning(interval);
                    }
                    if (printFlushProgress) {
                        this.printFlushProgress();
                    }
                    long begin = System.currentTimeMillis();
                    CommitLog.this.mappedFileQueue.flush(flushPhysicQueueLeastPages);
                    long storeTimestamp = CommitLog.this.mappedFileQueue.getStoreTimestamp();
                    if (storeTimestamp > 0L) {
                        CommitLog.this.defaultMessageStore.getStoreCheckpoint().setPhysicMsgTimestamp(storeTimestamp);
                    }
                    long past = System.currentTimeMillis() - begin;
                    CommitLog.this.getMessageStore().getPerfCounter().flowOnce("FLUSH_DATA_TIME_MS", (int)past);
                    if (past <= 500L) continue;
                    log.info("Flush data to disk costs {} ms", (Object)past);
                }
                catch (Throwable e) {
                    log.warn(this.getServiceName() + " service has exception. ", e);
                    this.printFlushProgress();
                }
            }
            boolean result = false;
            for (int i = 0; i < 10 && !result; ++i) {
                result = CommitLog.this.mappedFileQueue.flush(0);
                log.info(this.getServiceName() + " service shutdown, retry " + (i + 1) + " times " + (result ? "OK" : "Not OK"));
            }
            this.printFlushProgress();
            log.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (CommitLog.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return CommitLog.this.defaultMessageStore.getBrokerConfig().getIdentifier() + FlushRealTimeService.class.getSimpleName();
            }
            return FlushRealTimeService.class.getSimpleName();
        }

        private void printFlushProgress() {
        }

        public long getJoinTime() {
            return 300000L;
        }
    }

    class CommitRealTimeService
    extends FlushCommitLogService {
        private long lastCommitTimestamp;

        CommitRealTimeService() {
            this.lastCommitTimestamp = 0L;
        }

        public String getServiceName() {
            if (CommitLog.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return CommitLog.this.defaultMessageStore.getBrokerIdentity().getIdentifier() + CommitRealTimeService.class.getSimpleName();
            }
            return CommitRealTimeService.class.getSimpleName();
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                int interval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitIntervalCommitLog();
                int commitDataLeastPages = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitCommitLogLeastPages();
                int commitDataThoroughInterval = CommitLog.this.defaultMessageStore.getMessageStoreConfig().getCommitCommitLogThoroughInterval();
                long begin = System.currentTimeMillis();
                if (begin >= this.lastCommitTimestamp + (long)commitDataThoroughInterval) {
                    this.lastCommitTimestamp = begin;
                    commitDataLeastPages = 0;
                }
                try {
                    boolean result = CommitLog.this.mappedFileQueue.commit(commitDataLeastPages);
                    long end = System.currentTimeMillis();
                    if (!result) {
                        this.lastCommitTimestamp = end;
                        CommitLog.this.flushManager.wakeUpFlush();
                    }
                    CommitLog.this.getMessageStore().getPerfCounter().flowOnce("COMMIT_DATA_TIME_MS", (int)(end - begin));
                    if (end - begin > 500L) {
                        log.info("Commit data to file costs {} ms", (Object)(end - begin));
                    }
                    this.waitForRunning(interval);
                }
                catch (Throwable e) {
                    log.error(this.getServiceName() + " service has exception. ", e);
                }
            }
            boolean result = false;
            for (int i = 0; i < 10 && !result; ++i) {
                result = CommitLog.this.mappedFileQueue.commit(0);
                log.info(this.getServiceName() + " service shutdown, retry " + (i + 1) + " times " + (result ? "OK" : "Not OK"));
            }
            log.info(this.getServiceName() + " service end");
        }
    }

    abstract class FlushCommitLogService
    extends ServiceThread {
        protected static final int RETRY_TIMES_OVER = 10;

        FlushCommitLogService() {
        }
    }
}

