/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.utils.ExceptionUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public abstract class AbstractRemotingActivity
implements NettyRequestProcessor {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final MessagingProcessor messagingProcessor;
    protected static final String BROKER_NAME_FIELD = "bname";
    protected static final String BROKER_NAME_FIELD_FOR_SEND_MESSAGE_V2 = "n";
    private static final Map<ProxyExceptionCode, Integer> PROXY_EXCEPTION_RESPONSE_CODE_MAP = new HashMap<ProxyExceptionCode, Integer>(){
        {
            this.put(ProxyExceptionCode.FORBIDDEN, 16);
            this.put(ProxyExceptionCode.MESSAGE_PROPERTY_CONFLICT_WITH_TYPE, 13);
            this.put(ProxyExceptionCode.INTERNAL_SERVER_ERROR, 1);
            this.put(ProxyExceptionCode.TRANSACTION_DATA_NOT_FOUND, 0);
        }
    };
    protected final RequestPipeline requestPipeline;

    public AbstractRemotingActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        this.requestPipeline = requestPipeline;
        this.messagingProcessor = messagingProcessor;
    }

    protected RemotingCommand request(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context, long timeoutMillis) throws Exception {
        String brokerName;
        if (request.getCode() == 310) {
            if (request.getExtFields().get(BROKER_NAME_FIELD_FOR_SEND_MESSAGE_V2) == null) {
                return RemotingCommand.buildErrorResponse((int)15, (String)"Request doesn't have field bname");
            }
            brokerName = (String)request.getExtFields().get(BROKER_NAME_FIELD_FOR_SEND_MESSAGE_V2);
        } else {
            if (request.getExtFields().get(BROKER_NAME_FIELD) == null) {
                return RemotingCommand.buildErrorResponse((int)15, (String)"Request doesn't have field bname");
            }
            brokerName = (String)request.getExtFields().get(BROKER_NAME_FIELD);
        }
        if (request.isOnewayRPC()) {
            this.messagingProcessor.requestOneway(context, brokerName, request, timeoutMillis);
            return null;
        }
        ((CompletableFuture)this.messagingProcessor.request(context, brokerName, request, timeoutMillis).thenAccept(r -> this.writeResponse(ctx, context, request, (RemotingCommand)r))).exceptionally(t -> {
            this.writeErrResponse(ctx, context, request, (Throwable)t);
            return null;
        });
        return null;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        ProxyContext context = this.createContext();
        try {
            this.requestPipeline.execute(ctx, request, context);
            RemotingCommand response = this.processRequest0(ctx, request, context);
            if (response != null) {
                this.writeResponse(ctx, context, request, response);
            }
            return null;
        }
        catch (Throwable t) {
            this.writeErrResponse(ctx, context, request, t);
            return null;
        }
    }

    public boolean rejectRequest() {
        return false;
    }

    protected abstract RemotingCommand processRequest0(ChannelHandlerContext var1, RemotingCommand var2, ProxyContext var3) throws Exception;

    protected ProxyContext createContext() {
        return ProxyContext.create();
    }

    protected void writeErrResponse(ChannelHandlerContext ctx, ProxyContext context, RemotingCommand request, Throwable t) {
        if ((t = ExceptionUtils.getRealException((Throwable)t)) instanceof ProxyException) {
            ProxyException e = (ProxyException)t;
            this.writeResponse(ctx, context, request, RemotingCommand.createResponseCommand((int)PROXY_EXCEPTION_RESPONSE_CODE_MAP.getOrDefault((Object)e.getCode(), 1), (String)e.getMessage()), t);
        } else if (t instanceof MQClientException) {
            MQClientException e = (MQClientException)t;
            this.writeResponse(ctx, context, request, RemotingCommand.createResponseCommand((int)e.getResponseCode(), (String)e.getErrorMessage()), t);
        } else if (t instanceof MQBrokerException) {
            MQBrokerException e = (MQBrokerException)t;
            this.writeResponse(ctx, context, request, RemotingCommand.createResponseCommand((int)e.getResponseCode(), (String)e.getErrorMessage()), t);
        } else if (t instanceof AclException) {
            this.writeResponse(ctx, context, request, RemotingCommand.createResponseCommand((int)16, (String)t.getMessage()), t);
        } else {
            this.writeResponse(ctx, context, request, RemotingCommand.createResponseCommand((int)1, (String)t.getMessage()), t);
        }
    }

    protected void writeResponse(ChannelHandlerContext ctx, ProxyContext context, RemotingCommand request, RemotingCommand response) {
        this.writeResponse(ctx, context, request, response, null);
    }

    protected void writeResponse(ChannelHandlerContext ctx, ProxyContext context, RemotingCommand request, RemotingCommand response, Throwable t) {
        if (request.isOnewayRPC()) {
            return;
        }
        if (!ctx.channel().isWritable()) {
            return;
        }
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        response.setOpaque(request.getOpaque());
        response.markResponseType();
        response.addExtField("MSG_REGION", config.getRegionId());
        response.addExtField("TRACE_ON", String.valueOf(config.isTraceOn()));
        if (t != null) {
            response.setRemark(t.getMessage());
        }
        ctx.writeAndFlush((Object)response);
    }
}

