/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider.posix;

import com.google.common.base.Stopwatch;
import com.google.common.io.ByteStreams;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.provider.stream.FileSegmentInputStream;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class PosixFileSegment
extends TieredFileSegment {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static final String UNDERLINE = "_";
    private static final String OPERATION_POSIX_READ = "read";
    private static final String OPERATION_POSIX_WRITE = "write";
    private final String fullPath;
    private volatile File file;
    private volatile FileChannel readFileChannel;
    private volatile FileChannel writeFileChannel;

    public PosixFileSegment(TieredMessageStoreConfig storeConfig, FileSegmentType fileType, String filePath, long baseOffset) {
        super(storeConfig, fileType, filePath, baseOffset);
        String basePath = StringUtils.defaultString((String)storeConfig.getTieredStoreFilePath(), (String)StringUtils.appendIfMissing((String)storeConfig.getTieredStoreFilePath(), (CharSequence)File.separator, (CharSequence[])new CharSequence[0]));
        String brokerClusterName = storeConfig.getBrokerClusterName();
        String clusterBasePath = TieredStoreUtil.getHash(brokerClusterName) + UNDERLINE + brokerClusterName;
        this.fullPath = Paths.get(basePath, clusterBasePath, filePath, fileType.toString(), TieredStoreUtil.offset2FileName(baseOffset)).toString();
        logger.info("Constructing Posix FileSegment, filePath: {}", (Object)this.fullPath);
        this.createFile();
    }

    protected AttributesBuilder newAttributesBuilder() {
        return TieredStoreMetricsManager.newAttributesBuilder().put("path", this.filePath).put("file_type", this.fileType.name().toLowerCase());
    }

    @Override
    public String getPath() {
        return this.fullPath;
    }

    @Override
    public long getSize() {
        if (this.exists()) {
            return this.file.length();
        }
        return -1L;
    }

    @Override
    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile() {
        if (this.file == null) {
            PosixFileSegment posixFileSegment = this;
            synchronized (posixFileSegment) {
                if (this.file == null) {
                    File file = new File(this.fullPath);
                    try {
                        File dir = file.getParentFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        file.createNewFile();
                        this.readFileChannel = new RandomAccessFile(file, "r").getChannel();
                        this.writeFileChannel = new RandomAccessFile(file, "rwd").getChannel();
                        this.file = file;
                    }
                    catch (Exception e) {
                        logger.error("PosixFileSegment#createFile: create file {} failed: ", (Object)this.filePath, (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void destroyFile() {
        try {
            if (this.readFileChannel != null && this.readFileChannel.isOpen()) {
                this.readFileChannel.close();
            }
            if (this.writeFileChannel != null && this.writeFileChannel.isOpen()) {
                this.writeFileChannel.close();
            }
            logger.info("Destroy Posix FileSegment, filePath: {}", (Object)this.fullPath);
        }
        catch (IOException e) {
            logger.error("Destroy Posix FileSegment failed, filePath: {}", (Object)this.fullPath, (Object)e);
        }
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    @Override
    public CompletableFuture<ByteBuffer> read0(long position, int length) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        AttributesBuilder attributesBuilder = this.newAttributesBuilder().put("operation", OPERATION_POSIX_READ);
        CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        try {
            this.readFileChannel.position(position);
            this.readFileChannel.read(byteBuffer);
            byteBuffer.flip();
            byteBuffer.limit(length);
            attributesBuilder.put("success", true);
            long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
            Attributes metricsAttributes = this.newAttributesBuilder().put("operation", OPERATION_POSIX_READ).build();
            int downloadedBytes = byteBuffer.remaining();
            TieredStoreMetricsManager.downloadBytes.record((long)downloadedBytes, metricsAttributes);
            future.complete(byteBuffer);
        }
        catch (IOException e) {
            long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            attributesBuilder.put("success", false);
            TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
            logger.error("PosixFileSegment#read0: read file {} failed: position: {}, length: {}", new Object[]{this.filePath, position, length, e});
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Boolean> commit0(FileSegmentInputStream inputStream, long position, int length, boolean append) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        AttributesBuilder attributesBuilder = this.newAttributesBuilder().put("operation", OPERATION_POSIX_WRITE);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            TieredStoreExecutor.commitExecutor.execute(() -> {
                try {
                    byte[] byteArray = ByteStreams.toByteArray((InputStream)inputStream);
                    if (byteArray.length != length) {
                        logger.error("PosixFileSegment#commit0: append file {} failed: real data size: {}, is not equal to length: {}", new Object[]{this.filePath, byteArray.length, length});
                        future.complete(false);
                        return;
                    }
                    this.writeFileChannel.position(position);
                    ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                    while (buffer.hasRemaining()) {
                        this.writeFileChannel.write(buffer);
                    }
                    attributesBuilder.put("success", true);
                    long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                    TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
                    Attributes metricsAttributes = this.newAttributesBuilder().put("operation", OPERATION_POSIX_WRITE).build();
                    TieredStoreMetricsManager.uploadBytes.record((long)length, metricsAttributes);
                    future.complete(true);
                }
                catch (Exception e) {
                    long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                    attributesBuilder.put("success", false);
                    TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
                    logger.error("PosixFileSegment#commit0: append file {} failed: position: {}, length: {}", new Object[]{this.filePath, position, length, e});
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            attributesBuilder.put("success", false);
            TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
            future.completeExceptionally(e);
        }
        return future;
    }
}

