/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.rpc;

import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.protocol.header.GetEarliestMsgStoretimeResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.SearchOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicConfigAndQueueMapping;
import org.apache.rocketmq.remoting.rpc.ClientMetadata;
import org.apache.rocketmq.remoting.rpc.RpcClient;
import org.apache.rocketmq.remoting.rpc.RpcClientHook;
import org.apache.rocketmq.remoting.rpc.RpcClientUtils;
import org.apache.rocketmq.remoting.rpc.RpcException;
import org.apache.rocketmq.remoting.rpc.RpcRequest;
import org.apache.rocketmq.remoting.rpc.RpcResponse;

public class RpcClientImpl
implements RpcClient {
    private ClientMetadata clientMetadata;
    private RemotingClient remotingClient;
    private List<RpcClientHook> clientHookList = new ArrayList<RpcClientHook>();

    public RpcClientImpl(ClientMetadata clientMetadata, RemotingClient remotingClient) {
        this.clientMetadata = clientMetadata;
        this.remotingClient = remotingClient;
    }

    public void registerHook(RpcClientHook hook) {
        this.clientHookList.add(hook);
    }

    @Override
    public Future<RpcResponse> invoke(MessageQueue mq, RpcRequest request, long timeoutMs) throws RpcException {
        String bname = this.clientMetadata.getBrokerNameFromMessageQueue(mq);
        request.getHeader().setBrokerName(bname);
        return this.invoke(request, timeoutMs);
    }

    public Promise<RpcResponse> createResponseFuture() {
        return ImmediateEventExecutor.INSTANCE.newPromise();
    }

    @Override
    public Future<RpcResponse> invoke(RpcRequest request, long timeoutMs) throws RpcException {
        if (this.clientHookList.size() > 0) {
            for (RpcClientHook rpcClientHook : this.clientHookList) {
                RpcResponse response = rpcClientHook.beforeRequest(request);
                if (response == null) continue;
                return this.createResponseFuture().setSuccess((Object)response);
            }
        }
        String addr = this.getBrokerAddrByNameOrException(request.getHeader().bname);
        Promise<RpcResponse> rpcResponsePromise = null;
        try {
            switch (request.getCode()) {
                case 11: {
                    rpcResponsePromise = this.handlePullMessage(addr, request, timeoutMs);
                    break;
                }
                case 31: {
                    rpcResponsePromise = this.handleGetMinOffset(addr, request, timeoutMs);
                    break;
                }
                case 30: {
                    rpcResponsePromise = this.handleGetMaxOffset(addr, request, timeoutMs);
                    break;
                }
                case 29: {
                    rpcResponsePromise = this.handleSearchOffset(addr, request, timeoutMs);
                    break;
                }
                case 32: {
                    rpcResponsePromise = this.handleGetEarliestMsgStoretime(addr, request, timeoutMs);
                    break;
                }
                case 14: {
                    rpcResponsePromise = this.handleQueryConsumerOffset(addr, request, timeoutMs);
                    break;
                }
                case 15: {
                    rpcResponsePromise = this.handleUpdateConsumerOffset(addr, request, timeoutMs);
                    break;
                }
                case 202: {
                    rpcResponsePromise = this.handleCommonBodyRequest(addr, request, timeoutMs, TopicStatsTable.class);
                    break;
                }
                case 351: {
                    rpcResponsePromise = this.handleCommonBodyRequest(addr, request, timeoutMs, TopicConfigAndQueueMapping.class);
                    break;
                }
                default: {
                    throw new RpcException(3, "Unknown request code " + request.getCode());
                }
            }
        }
        catch (RpcException rpcException) {
            throw rpcException;
        }
        catch (Exception e) {
            throw new RpcException(-1000, "error from remoting layer", e);
        }
        return rpcResponsePromise;
    }

    private String getBrokerAddrByNameOrException(String bname) throws RpcException {
        String addr = this.clientMetadata.findMasterBrokerAddr(bname);
        if (addr == null) {
            throw new RpcException(1, "cannot find addr for broker " + bname);
        }
        return addr;
    }

    private void processFailedResponse(String addr, RemotingCommand requestCommand, ResponseFuture responseFuture, Promise<RpcResponse> rpcResponsePromise) {
        RemotingCommand responseCommand = responseFuture.getResponseCommand();
        if (responseCommand != null) {
            return;
        }
        int errorCode = -1000;
        String errorMessage = null;
        if (!responseFuture.isSendRequestOK()) {
            errorCode = -1004;
            errorMessage = "send request failed to " + addr + ". Request: " + requestCommand;
        } else if (responseFuture.isTimeout()) {
            errorCode = -1006;
            errorMessage = "wait response from " + addr + " timeout :" + responseFuture.getTimeoutMillis() + "ms. Request: " + requestCommand;
        } else {
            errorMessage = "unknown reason. addr: " + addr + ", timeoutMillis: " + responseFuture.getTimeoutMillis() + ". Request: " + requestCommand;
        }
        rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(errorCode, errorMessage)));
    }

    public Promise<RpcResponse> handlePullMessage(final String addr, RpcRequest rpcRequest, final long timeoutMillis) throws Exception {
        final RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        final Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        InvokeCallback callback = new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
            }

            @Override
            public void operationSucceed(RemotingCommand response) {
                try {
                    switch (response.getCode()) {
                        case 0: 
                        case 19: 
                        case 20: 
                        case 21: {
                            PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.decodeCommandCustomHeader(PullMessageResponseHeader.class);
                            rpcResponsePromise.setSuccess((Object)new RpcResponse(response.getCode(), responseHeader, response.getBody()));
                        }
                    }
                    RpcResponse rpcResponse = new RpcResponse(new RpcException(response.getCode(), "unexpected remote response code"));
                    rpcResponsePromise.setSuccess((Object)rpcResponse);
                }
                catch (Exception e) {
                    String errorMessage = "process failed. addr: " + addr + ", timeoutMillis: " + timeoutMillis + ". Request: " + requestCommand;
                    RpcResponse rpcResponse = new RpcResponse(new RpcException(-1000, errorMessage, e));
                    rpcResponsePromise.setSuccess((Object)rpcResponse);
                }
            }

            @Override
            public void operationFail(Throwable throwable) {
                String errorMessage = "process failed. addr: " + addr + ". Request: " + requestCommand;
                RpcResponse rpcResponse = new RpcResponse(new RpcException(-1000, errorMessage, throwable));
                rpcResponsePromise.setSuccess((Object)rpcResponse);
            }
        };
        this.remotingClient.invokeAsync(addr, requestCommand, timeoutMillis, callback);
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleSearchOffset(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)responseCommand.decodeCommandCustomHeader(SearchOffsetResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleQueryConsumerOffset(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)responseCommand.decodeCommandCustomHeader(QueryConsumerOffsetResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            case 22: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), null, null));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleUpdateConsumerOffset(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                UpdateConsumerOffsetResponseHeader responseHeader = (UpdateConsumerOffsetResponseHeader)responseCommand.decodeCommandCustomHeader(UpdateConsumerOffsetResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleCommonBodyRequest(String addr, RpcRequest rpcRequest, long timeoutMillis, Class bodyClass) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(0, null, RemotingSerializable.decode(responseCommand.getBody(), bodyClass)));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleGetMinOffset(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)responseCommand.decodeCommandCustomHeader(GetMinOffsetResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleGetMaxOffset(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)responseCommand.decodeCommandCustomHeader(GetMaxOffsetResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }

    public Promise<RpcResponse> handleGetEarliestMsgStoretime(String addr, RpcRequest rpcRequest, long timeoutMillis) throws Exception {
        Promise<RpcResponse> rpcResponsePromise = this.createResponseFuture();
        RemotingCommand requestCommand = RpcClientUtils.createCommandForRpcRequest(rpcRequest);
        RemotingCommand responseCommand = this.remotingClient.invokeSync(addr, requestCommand, timeoutMillis);
        assert (responseCommand != null);
        switch (responseCommand.getCode()) {
            case 0: {
                GetEarliestMsgStoretimeResponseHeader responseHeader = (GetEarliestMsgStoretimeResponseHeader)responseCommand.decodeCommandCustomHeader(GetEarliestMsgStoretimeResponseHeader.class);
                rpcResponsePromise.setSuccess((Object)new RpcResponse(responseCommand.getCode(), responseHeader, responseCommand.getBody()));
                break;
            }
            default: {
                rpcResponsePromise.setSuccess((Object)new RpcResponse(new RpcException(responseCommand.getCode(), "unknown remote error")));
            }
        }
        return rpcResponsePromise;
    }
}

