/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.EpochEntry;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetMetaDataResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerResponseHeader;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.ha.autoswitch.BrokerMetadata;
import org.apache.rocketmq.store.ha.autoswitch.TempBrokerMetadata;

public class ReplicasManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final int RETRY_INTERVAL_SECOND = 5;
    private final ScheduledExecutorService scheduledService;
    private final ExecutorService executorService;
    private final ExecutorService scanExecutor;
    private final BrokerController brokerController;
    private final AutoSwitchHAService haService;
    private final BrokerConfig brokerConfig;
    private final String brokerAddress;
    private final BrokerOuterAPI brokerOuterAPI;
    private List<String> controllerAddresses;
    private final ConcurrentMap<String, Boolean> availableControllerAddresses;
    private volatile String controllerLeaderAddress = "";
    private volatile State state = State.INITIAL;
    private volatile RegisterState registerState = RegisterState.INITIAL;
    private ScheduledFuture<?> checkSyncStateSetTaskFuture;
    private ScheduledFuture<?> slaveSyncFuture;
    private Long brokerControllerId;
    private Long masterBrokerId;
    private BrokerMetadata brokerMetadata;
    private TempBrokerMetadata tempBrokerMetadata;
    private Set<Long> syncStateSet;
    private int syncStateSetEpoch = 0;
    private String masterAddress = "";
    private int masterEpoch = 0;
    private long lastSyncTimeMs = System.currentTimeMillis();
    private Random random = new Random();

    public ReplicasManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerOuterAPI = brokerController.getBrokerOuterAPI();
        this.scheduledService = ThreadUtils.newScheduledThreadPool((int)3, (ThreadFactory)new ThreadFactoryImpl("ReplicasManager_ScheduledService_", brokerController.getBrokerIdentity()));
        this.executorService = ThreadUtils.newThreadPoolExecutor((int)3, (ThreadFactory)new ThreadFactoryImpl("ReplicasManager_ExecutorService_", brokerController.getBrokerIdentity()));
        this.scanExecutor = ThreadUtils.newThreadPoolExecutor((int)4, (int)10, (long)60L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(32), (ThreadFactory)new ThreadFactoryImpl("ReplicasManager_scan_thread_", brokerController.getBrokerIdentity()));
        this.haService = (AutoSwitchHAService)brokerController.getMessageStore().getHaService();
        this.brokerConfig = brokerController.getBrokerConfig();
        this.availableControllerAddresses = new ConcurrentHashMap<String, Boolean>();
        this.syncStateSet = new HashSet<Long>();
        this.brokerAddress = brokerController.getBrokerAddr();
        this.brokerMetadata = new BrokerMetadata(this.brokerController.getMessageStoreConfig().getStorePathBrokerIdentity());
        this.tempBrokerMetadata = new TempBrokerMetadata(this.brokerController.getMessageStoreConfig().getStorePathBrokerIdentity() + "-temp");
    }

    public void start() {
        this.state = State.INITIAL;
        this.updateControllerAddr();
        this.scanAvailableControllerAddresses();
        this.scheduledService.scheduleAtFixedRate(this::updateControllerAddr, 120000L, 120000L, TimeUnit.MILLISECONDS);
        this.scheduledService.scheduleAtFixedRate(this::scanAvailableControllerAddresses, 3000L, 3000L, TimeUnit.MILLISECONDS);
        if (!this.startBasicService()) {
            LOGGER.error("Failed to start replicasManager");
            this.executorService.submit(() -> {
                int retryTimes = 0;
                do {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOGGER.warn("Failed to start replicasManager, retry times:{}, current state:{}, try it again", (Object)(++retryTimes), (Object)this.state);
                } while (!this.startBasicService());
                LOGGER.info("Start replicasManager success, retry times:{}", (Object)retryTimes);
            });
        }
    }

    private boolean startBasicService() {
        if (this.state == State.SHUTDOWN) {
            return false;
        }
        if (this.state == State.INITIAL) {
            if (this.schedulingSyncControllerMetadata()) {
                this.state = State.FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE;
                LOGGER.info("First time sync controller metadata success, change state to: {}", (Object)this.state);
            } else {
                return false;
            }
        }
        if (this.state == State.FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE) {
            for (int retryTimes = 0; retryTimes < 5; ++retryTimes) {
                if (this.register()) {
                    this.state = State.REGISTER_TO_CONTROLLER_DONE;
                    LOGGER.info("First time register broker success, change state to: {}", (Object)this.state);
                    break;
                }
                try {
                    Thread.sleep(this.random.nextInt(1000));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.state != State.REGISTER_TO_CONTROLLER_DONE) {
                LOGGER.error("Register to broker failed 5 times");
                return false;
            }
        }
        if (this.state == State.REGISTER_TO_CONTROLLER_DONE) {
            this.sendHeartbeatToController();
            if (this.masterBrokerId != null || this.brokerElect()) {
                LOGGER.info("Master in this broker set is elected, masterBrokerId: {}, masterBrokerAddr: {}", (Object)this.masterBrokerId, (Object)this.masterAddress);
                this.state = State.RUNNING;
                this.setFenced(false);
                LOGGER.info("All register process has been done, change state to: {}", (Object)this.state);
            } else {
                return false;
            }
        }
        this.schedulingSyncBrokerMetadata();
        this.haService.registerSyncStateSetChangedListener(this::doReportSyncStateSetChanged);
        return true;
    }

    public void shutdown() {
        this.state = State.SHUTDOWN;
        this.registerState = RegisterState.INITIAL;
        this.executorService.shutdownNow();
        this.scheduledService.shutdownNow();
        this.scanExecutor.shutdownNow();
    }

    public synchronized void changeBrokerRole(Long newMasterBrokerId, String newMasterAddress, Integer newMasterEpoch, Integer syncStateSetEpoch, Set<Long> syncStateSet) {
        if (newMasterBrokerId != null && newMasterEpoch > this.masterEpoch) {
            if (newMasterBrokerId.equals(this.brokerControllerId)) {
                this.changeToMaster(newMasterEpoch, syncStateSetEpoch, syncStateSet);
            } else {
                this.changeToSlave(newMasterAddress, newMasterEpoch, newMasterBrokerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToMaster(int newMasterEpoch, int syncStateSetEpoch, Set<Long> syncStateSet) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newMasterEpoch > this.masterEpoch) {
                LOGGER.info("Begin to change to master, brokerName:{}, replicas:{}, new Epoch:{}", new Object[]{this.brokerConfig.getBrokerName(), this.brokerAddress, newMasterEpoch});
                this.masterEpoch = newMasterEpoch;
                if (this.masterBrokerId != null && this.masterBrokerId.equals(this.brokerControllerId) && this.brokerController.getBrokerConfig().getBrokerId() == 0L) {
                    HashSet<Long> newSyncStateSet = new HashSet<Long>(syncStateSet);
                    this.changeSyncStateSet(newSyncStateSet, syncStateSetEpoch);
                    this.haService.changeToMasterWhenLastRoleIsMaster(newMasterEpoch);
                    this.brokerController.getTopicConfigManager().getDataVersion().nextVersion((long)newMasterEpoch);
                    this.executorService.submit(this::checkSyncStateSetAndDoReport);
                    this.registerBrokerWhenRoleChange();
                    return;
                }
                HashSet<Long> newSyncStateSet = new HashSet<Long>(syncStateSet);
                this.changeSyncStateSet(newSyncStateSet, syncStateSetEpoch);
                this.handleSlaveSynchronize(BrokerRole.SYNC_MASTER);
                this.haService.changeToMaster(newMasterEpoch);
                this.brokerController.getBrokerConfig().setBrokerId(0L);
                this.brokerController.getMessageStoreConfig().setBrokerRole(BrokerRole.SYNC_MASTER);
                this.brokerController.changeSpecialServiceStatus(true);
                this.masterAddress = this.brokerAddress;
                this.masterBrokerId = this.brokerControllerId;
                this.schedulingCheckSyncStateSet();
                this.brokerController.getTopicConfigManager().getDataVersion().nextVersion((long)newMasterEpoch);
                this.executorService.submit(this::checkSyncStateSetAndDoReport);
                this.registerBrokerWhenRoleChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeToSlave(String newMasterAddress, int newMasterEpoch, Long newMasterBrokerId) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newMasterEpoch > this.masterEpoch) {
                LOGGER.info("Begin to change to slave, brokerName={}, brokerId={}, newMasterBrokerId={}, newMasterAddress={}, newMasterEpoch={}", new Object[]{this.brokerConfig.getBrokerName(), this.brokerControllerId, newMasterBrokerId, newMasterAddress, newMasterEpoch});
                this.masterEpoch = newMasterEpoch;
                if (newMasterBrokerId.equals(this.masterBrokerId)) {
                    this.haService.changeToSlaveWhenMasterNotChange(newMasterAddress, newMasterEpoch);
                    this.brokerController.getTopicConfigManager().getDataVersion().nextVersion((long)newMasterEpoch);
                    this.registerBrokerWhenRoleChange();
                    return;
                }
                this.stopCheckSyncStateSet();
                this.brokerController.getMessageStoreConfig().setBrokerRole(BrokerRole.SLAVE);
                this.brokerController.changeSpecialServiceStatus(false);
                this.brokerConfig.setBrokerId(this.brokerControllerId.longValue());
                this.masterAddress = newMasterAddress;
                this.masterBrokerId = newMasterBrokerId;
                this.handleSlaveSynchronize(BrokerRole.SLAVE);
                this.haService.changeToSlave(newMasterAddress, newMasterEpoch, this.brokerControllerId);
                this.brokerController.getTopicConfigManager().getDataVersion().nextVersion((long)newMasterEpoch);
                this.registerBrokerWhenRoleChange();
            }
        }
    }

    public void registerBrokerWhenRoleChange() {
        this.executorService.submit(() -> {
            try {
                this.brokerController.registerBrokerAll(true, false, this.brokerController.getBrokerConfig().isForceRegister());
            }
            catch (Throwable e) {
                LOGGER.error("Error happen when register broker to name-srv, Failed to change broker to {}", (Object)this.brokerController.getMessageStoreConfig().getBrokerRole(), (Object)e);
                return;
            }
            LOGGER.info("Change broker [id:{}][address:{}] to {}, newMasterBrokerId:{}, newMasterAddress:{}, newMasterEpoch:{}, syncStateSetEpoch:{}", new Object[]{this.brokerControllerId, this.brokerAddress, this.brokerController.getMessageStoreConfig().getBrokerRole(), this.masterBrokerId, this.masterAddress, this.masterEpoch, this.syncStateSetEpoch});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSyncStateSet(Set<Long> newSyncStateSet, int newSyncStateSetEpoch) {
        ReplicasManager replicasManager = this;
        synchronized (replicasManager) {
            if (newSyncStateSetEpoch > this.syncStateSetEpoch) {
                LOGGER.info("SyncStateSet changed from {} to {}", this.syncStateSet, newSyncStateSet);
                this.syncStateSetEpoch = newSyncStateSetEpoch;
                this.syncStateSet = new HashSet<Long>(newSyncStateSet);
                this.haService.setSyncStateSet(newSyncStateSet);
            }
        }
    }

    private void handleSlaveSynchronize(BrokerRole role) {
        if (role == BrokerRole.SLAVE) {
            if (this.slaveSyncFuture != null) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(this.masterAddress);
            this.slaveSyncFuture = this.brokerController.getScheduledExecutorService().scheduleAtFixedRate(() -> {
                try {
                    if (System.currentTimeMillis() - this.lastSyncTimeMs > 10000L) {
                        this.brokerController.getSlaveSynchronize().syncAll();
                        this.lastSyncTimeMs = System.currentTimeMillis();
                    }
                    this.brokerController.getSlaveSynchronize().syncTimerCheckPoint();
                }
                catch (Throwable e) {
                    LOGGER.error("ScheduledTask SlaveSynchronize syncAll error.", e);
                }
            }, 3000L, 3000L, TimeUnit.MILLISECONDS);
        } else {
            if (this.slaveSyncFuture != null) {
                this.slaveSyncFuture.cancel(false);
            }
            this.brokerController.getSlaveSynchronize().setMasterAddr(null);
        }
    }

    private boolean brokerElect() {
        try {
            Pair<ElectMasterResponseHeader, Set<Long>> tryElectResponsePair = this.brokerOuterAPI.brokerElect(this.controllerLeaderAddress, this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.brokerControllerId);
            ElectMasterResponseHeader tryElectResponse = (ElectMasterResponseHeader)tryElectResponsePair.getObject1();
            Set syncStateSet = (Set)tryElectResponsePair.getObject2();
            String masterAddress = tryElectResponse.getMasterAddress();
            Long masterBrokerId = tryElectResponse.getMasterBrokerId();
            if (StringUtils.isEmpty((CharSequence)masterAddress) || masterBrokerId == null) {
                LOGGER.warn("Now no master in broker set");
                return false;
            }
            if (masterBrokerId.equals(this.brokerControllerId)) {
                this.changeToMaster(tryElectResponse.getMasterEpoch(), tryElectResponse.getSyncStateSetEpoch(), syncStateSet);
            } else {
                this.changeToSlave(masterAddress, tryElectResponse.getMasterEpoch(), tryElectResponse.getMasterBrokerId());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to try elect", (Throwable)e);
            return false;
        }
    }

    public void sendHeartbeatToController() {
        List<String> controllerAddresses = this.getAvailableControllerAddresses();
        for (String controllerAddress : controllerAddresses) {
            if (!StringUtils.isNotEmpty((CharSequence)controllerAddress)) continue;
            this.brokerOuterAPI.sendHeartbeatToController(controllerAddress, this.brokerConfig.getBrokerClusterName(), this.brokerAddress, this.brokerConfig.getBrokerName(), this.brokerControllerId, this.brokerConfig.getSendHeartbeatTimeoutMillis(), this.brokerConfig.isInBrokerContainer(), this.getLastEpoch(), this.brokerController.getMessageStore().getMaxPhyOffset(), this.brokerController.getMessageStore().getConfirmOffset(), this.brokerConfig.getControllerHeartBeatTimeoutMills(), this.brokerConfig.getBrokerElectionPriority());
        }
    }

    private boolean register() {
        try {
            this.confirmNowRegisteringState();
            LOGGER.info("Confirm now register state: {}", (Object)this.registerState);
            if (!this.checkMetadataValid()) {
                LOGGER.error("Check and find that metadata/tempMetadata invalid, you can modify the broker config to make them valid");
                return false;
            }
            if (this.registerState == RegisterState.INITIAL) {
                Long nextBrokerId = this.getNextBrokerId();
                if (nextBrokerId == null || !this.createTempMetadataFile(nextBrokerId)) {
                    LOGGER.error("Failed to create temp metadata file, nextBrokerId: {}", (Object)nextBrokerId);
                    return false;
                }
                this.registerState = RegisterState.CREATE_TEMP_METADATA_FILE_DONE;
                LOGGER.info("Register state change to {}, temp metadata: {}", (Object)this.registerState, (Object)this.tempBrokerMetadata);
            }
            if (this.registerState == RegisterState.CREATE_TEMP_METADATA_FILE_DONE) {
                if (!this.applyBrokerId()) {
                    this.tempBrokerMetadata.clear();
                    this.registerState = RegisterState.INITIAL;
                    LOGGER.info("Register state change to: {}", (Object)this.registerState);
                    return false;
                }
                if (!this.createMetadataFileAndDeleteTemp()) {
                    LOGGER.error("Failed to create metadata file and delete temp metadata file, temp metadata: {}", (Object)this.tempBrokerMetadata);
                    return false;
                }
                this.registerState = RegisterState.CREATE_METADATA_FILE_DONE;
                LOGGER.info("Register state change to: {}, metadata: {}", (Object)this.registerState, (Object)this.brokerMetadata);
            }
            if (this.registerState == RegisterState.CREATE_METADATA_FILE_DONE) {
                if (!this.registerBrokerToController()) {
                    LOGGER.error("Failed to register broker to controller");
                    return false;
                }
                this.registerState = RegisterState.REGISTERED;
                LOGGER.info("Register state change to: {}, masterBrokerId: {}, masterBrokerAddr: {}", new Object[]{this.registerState, this.masterBrokerId, this.masterAddress});
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to register broker to controller", (Throwable)e);
            return false;
        }
    }

    private Long getNextBrokerId() {
        try {
            GetNextBrokerIdResponseHeader nextBrokerIdResp = this.brokerOuterAPI.getNextBrokerId(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.controllerLeaderAddress);
            return nextBrokerIdResp.getNextBrokerId();
        }
        catch (Exception e) {
            LOGGER.error("fail to get next broker id from controller", (Throwable)e);
            return null;
        }
    }

    private boolean createTempMetadataFile(Long brokerId) {
        String registerCheckCode = this.brokerAddress + ";" + System.currentTimeMillis();
        try {
            this.tempBrokerMetadata.updateAndPersist(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), brokerId, registerCheckCode);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("update and persist temp broker metadata file failed", (Throwable)e);
            this.tempBrokerMetadata.clear();
            return false;
        }
    }

    private boolean applyBrokerId() {
        try {
            ApplyBrokerIdResponseHeader response = this.brokerOuterAPI.applyBrokerId(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.tempBrokerMetadata.getBrokerId(), this.tempBrokerMetadata.getRegisterCheckCode(), this.controllerLeaderAddress);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to apply broker id: {}", (Object)e, (Object)this.tempBrokerMetadata.getBrokerId());
            return false;
        }
    }

    private boolean createMetadataFileAndDeleteTemp() {
        try {
            this.brokerMetadata.updateAndPersist(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.tempBrokerMetadata.getBrokerId());
            this.tempBrokerMetadata.clear();
            this.brokerControllerId = this.brokerMetadata.getBrokerId();
            this.haService.setLocalBrokerId(this.brokerControllerId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to create metadata file", (Throwable)e);
            this.brokerMetadata.clear();
            return false;
        }
    }

    private boolean registerBrokerToController() {
        try {
            Pair<RegisterBrokerToControllerResponseHeader, Set<Long>> responsePair = this.brokerOuterAPI.registerBrokerToController(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.brokerControllerId, this.brokerAddress, this.controllerLeaderAddress);
            if (responsePair == null) {
                return false;
            }
            RegisterBrokerToControllerResponseHeader response = (RegisterBrokerToControllerResponseHeader)responsePair.getObject1();
            Set syncStateSet = (Set)responsePair.getObject2();
            Long masterBrokerId = response.getMasterBrokerId();
            String masterAddress = response.getMasterAddress();
            if (masterBrokerId == null) {
                return true;
            }
            if (this.brokerControllerId.equals(masterBrokerId)) {
                this.changeToMaster(response.getMasterEpoch(), response.getSyncStateSetEpoch(), syncStateSet);
            } else {
                this.changeToSlave(masterAddress, response.getMasterEpoch(), masterBrokerId);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("fail to send registerBrokerToController request to controller", (Throwable)e);
            return false;
        }
    }

    private void confirmNowRegisteringState() {
        try {
            this.brokerMetadata.readFromFile();
        }
        catch (Exception e) {
            LOGGER.error("Read metadata file failed", (Throwable)e);
        }
        if (this.brokerMetadata.isLoaded()) {
            this.registerState = RegisterState.CREATE_METADATA_FILE_DONE;
            this.brokerControllerId = this.brokerMetadata.getBrokerId();
            this.haService.setLocalBrokerId(this.brokerControllerId);
            return;
        }
        try {
            this.tempBrokerMetadata.readFromFile();
        }
        catch (Exception e) {
            LOGGER.error("Read temp metadata file failed", (Throwable)e);
        }
        if (this.tempBrokerMetadata.isLoaded()) {
            this.registerState = RegisterState.CREATE_TEMP_METADATA_FILE_DONE;
        }
    }

    private boolean checkMetadataValid() {
        if (this.registerState == RegisterState.CREATE_TEMP_METADATA_FILE_DONE) {
            if (this.tempBrokerMetadata.getClusterName() == null || !this.tempBrokerMetadata.getClusterName().equals(this.brokerConfig.getBrokerClusterName())) {
                LOGGER.error("The clusterName: {} in broker temp metadata is different from the clusterName: {} in broker config", (Object)this.tempBrokerMetadata.getClusterName(), (Object)this.brokerConfig.getBrokerClusterName());
                return false;
            }
            if (this.tempBrokerMetadata.getBrokerName() == null || !this.tempBrokerMetadata.getBrokerName().equals(this.brokerConfig.getBrokerName())) {
                LOGGER.error("The brokerName: {} in broker temp metadata is different from the brokerName: {} in broker config", (Object)this.tempBrokerMetadata.getBrokerName(), (Object)this.brokerConfig.getBrokerName());
                return false;
            }
        }
        if (this.registerState == RegisterState.CREATE_METADATA_FILE_DONE) {
            if (this.brokerMetadata.getClusterName() == null || !this.brokerMetadata.getClusterName().equals(this.brokerConfig.getBrokerClusterName())) {
                LOGGER.error("The clusterName: {} in broker metadata is different from the clusterName: {} in broker config", (Object)this.brokerMetadata.getClusterName(), (Object)this.brokerConfig.getBrokerClusterName());
                return false;
            }
            if (this.brokerMetadata.getBrokerName() == null || !this.brokerMetadata.getBrokerName().equals(this.brokerConfig.getBrokerName())) {
                LOGGER.error("The brokerName: {} in broker metadata is different from the brokerName: {} in broker config", (Object)this.brokerMetadata.getBrokerName(), (Object)this.brokerConfig.getBrokerName());
                return false;
            }
        }
        return true;
    }

    private void schedulingSyncBrokerMetadata() {
        this.scheduledService.scheduleAtFixedRate(() -> {
            try {
                Pair<GetReplicaInfoResponseHeader, SyncStateSet> result = this.brokerOuterAPI.getReplicaInfo(this.controllerLeaderAddress, this.brokerConfig.getBrokerName());
                GetReplicaInfoResponseHeader info = (GetReplicaInfoResponseHeader)result.getObject1();
                SyncStateSet syncStateSet = (SyncStateSet)result.getObject2();
                String newMasterAddress = info.getMasterAddress();
                int newMasterEpoch = info.getMasterEpoch();
                Long masterBrokerId = info.getMasterBrokerId();
                ReplicasManager replicasManager = this;
                synchronized (replicasManager) {
                    if (newMasterEpoch > this.masterEpoch) {
                        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{newMasterAddress}) && masterBrokerId != null) {
                            if (masterBrokerId.equals(this.brokerControllerId)) {
                                this.changeToMaster(newMasterEpoch, syncStateSet.getSyncStateSetEpoch(), syncStateSet.getSyncStateSet());
                            } else {
                                this.changeToSlave(newMasterAddress, newMasterEpoch, masterBrokerId);
                            }
                        } else {
                            this.brokerElect();
                        }
                    } else if (newMasterEpoch == this.masterEpoch && this.isMasterState()) {
                        this.changeSyncStateSet(syncStateSet.getSyncStateSet(), syncStateSet.getSyncStateSetEpoch());
                    }
                }
            }
            catch (MQBrokerException exception) {
                LOGGER.warn("Error happen when get broker {}'s metadata", (Object)this.brokerConfig.getBrokerName(), (Object)exception);
                if (exception.getResponseCode() == 2008) {
                    try {
                        this.registerBrokerToController();
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error happen when get broker {}'s metadata", (Object)this.brokerConfig.getBrokerName(), (Object)e);
            }
        }, 3000L, this.brokerConfig.getSyncBrokerMetadataPeriod(), TimeUnit.MILLISECONDS);
    }

    private boolean schedulingSyncControllerMetadata() {
        for (int tryTimes = 0; tryTimes < 3; ++tryTimes) {
            boolean flag = this.updateControllerMetadata();
            if (flag) {
                this.scheduledService.scheduleAtFixedRate(this::updateControllerMetadata, 3000L, this.brokerConfig.getSyncControllerMetadataPeriod(), TimeUnit.MILLISECONDS);
                return true;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.error("Failed to init controller metadata, maybe the controllers in {} is not available", this.controllerAddresses);
        return false;
    }

    private boolean updateControllerMetadata() {
        for (String address : this.availableControllerAddresses.keySet()) {
            try {
                GetMetaDataResponseHeader responseHeader = this.brokerOuterAPI.getControllerMetaData(address);
                if (responseHeader == null || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{responseHeader.getControllerLeaderAddress()})) continue;
                this.controllerLeaderAddress = responseHeader.getControllerLeaderAddress();
                LOGGER.info("Update controller leader address to {}", (Object)this.controllerLeaderAddress);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to update controller metadata", (Throwable)e);
            }
        }
        return false;
    }

    private void schedulingCheckSyncStateSet() {
        if (this.checkSyncStateSetTaskFuture != null) {
            this.checkSyncStateSetTaskFuture.cancel(false);
        }
        this.checkSyncStateSetTaskFuture = this.scheduledService.scheduleAtFixedRate(this::checkSyncStateSetAndDoReport, 3000L, this.brokerConfig.getCheckSyncStateSetPeriod(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSyncStateSetAndDoReport() {
        try {
            Set newSyncStateSet = this.haService.maybeShrinkSyncStateSet();
            newSyncStateSet.add(this.brokerControllerId);
            ReplicasManager replicasManager = this;
            synchronized (replicasManager) {
                if (this.syncStateSet != null && this.syncStateSet.size() == newSyncStateSet.size() && this.syncStateSet.containsAll(newSyncStateSet)) {
                    return;
                }
            }
            this.doReportSyncStateSetChanged(newSyncStateSet);
        }
        catch (Exception e) {
            LOGGER.error("Check syncStateSet error", (Throwable)e);
        }
    }

    private void doReportSyncStateSetChanged(Set<Long> newSyncStateSet) {
        try {
            SyncStateSet result = this.brokerOuterAPI.alterSyncStateSet(this.controllerLeaderAddress, this.brokerConfig.getBrokerName(), this.brokerControllerId, this.masterEpoch, newSyncStateSet, this.syncStateSetEpoch);
            if (result != null) {
                this.changeSyncStateSet(result.getSyncStateSet(), result.getSyncStateSetEpoch());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error happen when change SyncStateSet, broker:{}, masterAddress:{}, masterEpoch:{}, oldSyncStateSet:{}, newSyncStateSet:{}, syncStateSetEpoch:{}", new Object[]{this.brokerConfig.getBrokerName(), this.masterAddress, this.masterEpoch, this.syncStateSet, newSyncStateSet, this.syncStateSetEpoch, e});
        }
    }

    private void stopCheckSyncStateSet() {
        if (this.checkSyncStateSetTaskFuture != null) {
            this.checkSyncStateSetTaskFuture.cancel(false);
        }
    }

    private void scanAvailableControllerAddresses() {
        if (this.controllerAddresses == null) {
            LOGGER.warn("scanAvailableControllerAddresses addresses of controller is null!");
            return;
        }
        for (String address : this.availableControllerAddresses.keySet()) {
            if (this.controllerAddresses.contains(address)) continue;
            LOGGER.warn("scanAvailableControllerAddresses remove invalid address {}", (Object)address);
            this.availableControllerAddresses.remove(address);
        }
        for (String address : this.controllerAddresses) {
            this.scanExecutor.submit(() -> {
                if (this.brokerOuterAPI.checkAddressReachable(address)) {
                    this.availableControllerAddresses.putIfAbsent(address, true);
                } else {
                    Boolean value = (Boolean)this.availableControllerAddresses.remove(address);
                    if (value != null) {
                        LOGGER.warn("scanAvailableControllerAddresses remove unconnected address {}", (Object)address);
                    }
                }
            });
        }
    }

    private void updateControllerAddr() {
        if (this.brokerConfig.isFetchControllerAddrByDnsLookup()) {
            this.controllerAddresses = this.brokerOuterAPI.dnsLookupAddressByDomain(this.brokerConfig.getControllerAddr());
        } else {
            String controllerPaths = this.brokerConfig.getControllerAddr();
            String[] controllers = controllerPaths.split(";");
            assert (controllers.length > 0);
            this.controllerAddresses = Arrays.asList(controllers);
        }
    }

    public int getLastEpoch() {
        return this.haService.getLastEpoch();
    }

    public BrokerRole getBrokerRole() {
        return this.brokerController.getMessageStoreConfig().getBrokerRole();
    }

    public boolean isMasterState() {
        return this.getBrokerRole() == BrokerRole.SYNC_MASTER;
    }

    public SyncStateSet getSyncStateSet() {
        return new SyncStateSet(this.syncStateSet, this.syncStateSetEpoch);
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public int getMasterEpoch() {
        return this.masterEpoch;
    }

    public List<String> getControllerAddresses() {
        return this.controllerAddresses;
    }

    public List<EpochEntry> getEpochEntries() {
        return this.haService.getEpochEntries();
    }

    public List<String> getAvailableControllerAddresses() {
        return new ArrayList<String>(this.availableControllerAddresses.keySet());
    }

    public Long getBrokerControllerId() {
        return this.brokerControllerId;
    }

    public RegisterState getRegisterState() {
        return this.registerState;
    }

    public State getState() {
        return this.state;
    }

    public BrokerMetadata getBrokerMetadata() {
        return this.brokerMetadata;
    }

    public TempBrokerMetadata getTempBrokerMetadata() {
        return this.tempBrokerMetadata;
    }

    public void setFenced(boolean fenced) {
        this.brokerController.setIsolated(fenced);
        this.brokerController.getMessageStore().getRunningFlags().makeFenced(fenced);
    }

    static enum RegisterState {
        INITIAL,
        CREATE_TEMP_METADATA_FILE_DONE,
        CREATE_METADATA_FILE_DONE,
        REGISTERED;

    }

    static enum State {
        INITIAL,
        FIRST_TIME_SYNC_CONTROLLER_METADATA_DONE,
        REGISTER_TO_CONTROLLER_DONE,
        RUNNING,
        SHUTDOWN;

    }
}

