/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.CompactionOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.FlushOptions;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.Priority;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.Status;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public abstract class AbstractRocksDBStorage {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final String SPACE = " | ";
    protected String dbPath;
    protected boolean readOnly;
    protected RocksDB db;
    protected DBOptions options;
    protected WriteOptions writeOptions;
    protected WriteOptions ableWalWriteOptions;
    protected ReadOptions readOptions;
    protected ReadOptions totalOrderReadOptions;
    protected CompactionOptions compactionOptions;
    protected CompactRangeOptions compactRangeOptions;
    protected ColumnFamilyHandle defaultCFHandle;
    protected final List<ColumnFamilyOptions> cfOptions = new ArrayList<ColumnFamilyOptions>();
    protected volatile boolean loaded;
    private volatile boolean closed;
    private final Semaphore reloadPermit = new Semaphore(1);
    private final ScheduledExecutorService reloadScheduler = ThreadUtils.newScheduledThreadPool(1, new ThreadFactoryImpl("RocksDBStorageReloadService_"));
    private final ThreadPoolExecutor manualCompactionThread = (ThreadPoolExecutor)ThreadUtils.newThreadPoolExecutor(1, 1, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadFactoryImpl("RocksDBManualCompactionService_"), new ThreadPoolExecutor.DiscardOldestPolicy());

    public boolean hold() {
        if (!this.loaded || this.db == null || this.closed) {
            LOGGER.error("hold rocksdb Failed. {}", (Object)this.dbPath);
            return false;
        }
        return true;
    }

    public void release() {
    }

    protected void put(ColumnFamilyHandle cfHandle, WriteOptions writeOptions, byte[] keyBytes, int keyLen, byte[] valueBytes, int valueLen) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            this.db.put(cfHandle, writeOptions, keyBytes, 0, keyLen, valueBytes, 0, valueLen);
        }
        catch (RocksDBException e) {
            this.scheduleReloadRocksdb(e);
            LOGGER.error("put Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected void put(ColumnFamilyHandle cfHandle, WriteOptions writeOptions, ByteBuffer keyBB, ByteBuffer valueBB) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            this.db.put(cfHandle, writeOptions, keyBB, valueBB);
        }
        catch (RocksDBException e) {
            this.scheduleReloadRocksdb(e);
            LOGGER.error("put Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected void batchPut(WriteOptions writeOptions, WriteBatch batch) throws RocksDBException {
        try {
            this.db.write(writeOptions, batch);
        }
        catch (RocksDBException e) {
            this.scheduleReloadRocksdb(e);
            LOGGER.error("batchPut Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            batch.clear();
        }
    }

    protected byte[] get(ColumnFamilyHandle cfHandle, ReadOptions readOptions, byte[] keyBytes) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            byte[] byArray = this.db.get(cfHandle, readOptions, keyBytes);
            return byArray;
        }
        catch (RocksDBException e) {
            LOGGER.error("get Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected boolean get(ColumnFamilyHandle cfHandle, ReadOptions readOptions, ByteBuffer keyBB, ByteBuffer valueBB) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            boolean bl = this.db.get(cfHandle, readOptions, keyBB, valueBB) != -1;
            return bl;
        }
        catch (RocksDBException e) {
            LOGGER.error("get Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected List<byte[]> multiGet(ReadOptions readOptions, List<ColumnFamilyHandle> columnFamilyHandleList, List<byte[]> keys) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            List list = this.db.multiGetAsList(readOptions, columnFamilyHandleList, keys);
            return list;
        }
        catch (RocksDBException e) {
            LOGGER.error("multiGet Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected void delete(ColumnFamilyHandle cfHandle, WriteOptions writeOptions, byte[] keyBytes) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            this.db.delete(cfHandle, writeOptions, keyBytes);
        }
        catch (RocksDBException e) {
            LOGGER.error("delete Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected void delete(ColumnFamilyHandle cfHandle, WriteOptions writeOptions, ByteBuffer keyBB) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            this.db.delete(cfHandle, writeOptions, keyBB);
        }
        catch (RocksDBException e) {
            LOGGER.error("delete Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected WrappedRocksIterator newIterator(ColumnFamilyHandle cfHandle, ReadOptions readOptions) {
        return new WrappedRocksIterator(this.db.newIterator(cfHandle, readOptions));
    }

    protected void rangeDelete(ColumnFamilyHandle cfHandle, WriteOptions writeOptions, byte[] startKey, byte[] endKey) throws RocksDBException {
        if (!this.hold()) {
            throw new IllegalStateException("rocksDB:" + this + " is not ready");
        }
        try {
            this.db.deleteRange(cfHandle, writeOptions, startKey, endKey);
        }
        catch (RocksDBException e) {
            this.scheduleReloadRocksdb(e);
            LOGGER.error("rangeDelete Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
            throw e;
        }
        finally {
            this.release();
        }
    }

    protected void manualCompactionDefaultCfMaxLevel(CompactionOptions compactionOptions) throws Exception {
        ColumnFamilyHandle defaultCFHandle = this.defaultCFHandle;
        byte[] defaultCFName = defaultCFHandle.getName();
        List fileMetaDataList = this.db.getLiveFilesMetaData();
        if (fileMetaDataList == null || fileMetaDataList.isEmpty()) {
            return;
        }
        ArrayList defaultLiveFileDataList = Lists.newArrayList();
        ArrayList inputFileNames = Lists.newArrayList();
        int maxLevel = 0;
        for (LiveFileMetaData fileMetaData : fileMetaDataList) {
            if (this.compareTo(fileMetaData.columnFamilyName(), defaultCFName) != 0) continue;
            defaultLiveFileDataList.add(fileMetaData);
            if (fileMetaData.level() <= maxLevel) continue;
            maxLevel = fileMetaData.level();
        }
        if (maxLevel == 0) {
            LOGGER.info("manualCompactionDefaultCfFiles skip level 0.");
            return;
        }
        for (LiveFileMetaData fileMetaData : defaultLiveFileDataList) {
            if (fileMetaData.level() != maxLevel || fileMetaData.beingCompacted()) continue;
            inputFileNames.add(fileMetaData.path() + fileMetaData.fileName());
        }
        if (!inputFileNames.isEmpty()) {
            List outputLists = this.db.compactFiles(compactionOptions, defaultCFHandle, (List)inputFileNames, maxLevel, -1, null);
            LOGGER.info("manualCompactionDefaultCfFiles OK. src: {}, dst: {}", (Object)inputFileNames, (Object)outputLists);
        } else {
            LOGGER.info("manualCompactionDefaultCfFiles Empty.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manualCompactionDefaultCfRange(CompactRangeOptions compactRangeOptions) {
        if (!this.hold()) {
            return;
        }
        long s1 = System.currentTimeMillis();
        boolean result = true;
        try {
            LOGGER.info("manualCompaction Start. {}", (Object)this.dbPath);
            this.db.compactRange(this.defaultCFHandle, null, null, compactRangeOptions);
            this.release();
        }
        catch (RocksDBException e) {
            try {
                result = false;
                this.scheduleReloadRocksdb(e);
                LOGGER.error("manualCompaction Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
                this.release();
            }
            catch (Throwable throwable) {
                this.release();
                LOGGER.info("manualCompaction End. {}, rt: {}(ms), result: {}", new Object[]{this.dbPath, System.currentTimeMillis() - s1, result});
                throw throwable;
            }
            LOGGER.info("manualCompaction End. {}, rt: {}(ms), result: {}", new Object[]{this.dbPath, System.currentTimeMillis() - s1, result});
        }
        LOGGER.info("manualCompaction End. {}, rt: {}(ms), result: {}", new Object[]{this.dbPath, System.currentTimeMillis() - s1, result});
    }

    protected void manualCompaction(long minPhyOffset, final CompactRangeOptions compactRangeOptions) {
        this.manualCompactionThread.submit(new Runnable(){

            @Override
            public void run() {
                AbstractRocksDBStorage.this.manualCompactionDefaultCfRange(compactRangeOptions);
            }
        });
    }

    protected void open(List<ColumnFamilyDescriptor> cfDescriptors, List<ColumnFamilyHandle> cfHandles) throws RocksDBException {
        this.db = this.readOnly ? RocksDB.openReadOnly((DBOptions)this.options, (String)this.dbPath, cfDescriptors, cfHandles) : RocksDB.open((DBOptions)this.options, (String)this.dbPath, cfDescriptors, cfHandles);
        this.db.getEnv().setBackgroundThreads(8, Priority.HIGH);
        this.db.getEnv().setBackgroundThreads(8, Priority.LOW);
        if (this.db == null) {
            throw new RocksDBException("open rocksdb null");
        }
    }

    protected abstract boolean postLoad();

    public synchronized boolean start() {
        if (this.loaded) {
            return true;
        }
        if (this.postLoad()) {
            this.loaded = true;
            LOGGER.info("start OK. {}", (Object)this.dbPath);
            this.closed = false;
            return true;
        }
        return false;
    }

    protected abstract void preShutdown();

    public synchronized boolean shutdown() {
        try {
            if (!this.loaded) {
                return true;
            }
            FlushOptions flushOptions = new FlushOptions();
            flushOptions.setWaitForFlush(true);
            try {
                this.flush(flushOptions);
            }
            finally {
                flushOptions.close();
            }
            this.db.cancelAllBackgroundWork(true);
            this.db.pauseBackgroundWork();
            this.preShutdown();
            this.defaultCFHandle.close();
            for (ColumnFamilyOptions opt : this.cfOptions) {
                opt.close();
            }
            if (this.writeOptions != null) {
                this.writeOptions.close();
            }
            if (this.ableWalWriteOptions != null) {
                this.ableWalWriteOptions.close();
            }
            if (this.readOptions != null) {
                this.readOptions.close();
            }
            if (this.totalOrderReadOptions != null) {
                this.totalOrderReadOptions.close();
            }
            if (this.options != null) {
                this.options.close();
            }
            if (this.db != null && !this.readOnly) {
                this.db.syncWal();
            }
            if (this.db != null) {
                this.db.closeE();
            }
            this.cfOptions.clear();
            this.db = null;
            this.readOptions = null;
            this.totalOrderReadOptions = null;
            this.writeOptions = null;
            this.ableWalWriteOptions = null;
            this.options = null;
            this.loaded = false;
            LOGGER.info("shutdown OK. {}", (Object)this.dbPath);
        }
        catch (Exception e) {
            LOGGER.error("shutdown Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    public void flush(FlushOptions flushOptions) {
        if (!this.loaded || this.readOnly || this.closed) {
            return;
        }
        try {
            if (this.db != null) {
                this.db.flush(flushOptions);
            }
        }
        catch (RocksDBException e) {
            this.scheduleReloadRocksdb(e);
            LOGGER.error("flush Failed. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(e));
        }
    }

    public Statistics getStatistics() {
        return this.options.statistics();
    }

    public ColumnFamilyHandle getDefaultCFHandle() {
        return this.defaultCFHandle;
    }

    public List<LiveFileMetaData> getCompactionStatus() {
        if (!this.hold()) {
            return null;
        }
        try {
            List list = this.db.getLiveFilesMetaData();
            return list;
        }
        finally {
            this.release();
        }
    }

    private void scheduleReloadRocksdb(RocksDBException rocksDBException) {
        if (rocksDBException == null || rocksDBException.getStatus() == null) {
            return;
        }
        Status status = rocksDBException.getStatus();
        Status.Code code = status.getCode();
        if (Status.Code.Aborted == code || Status.Code.Corruption == code || Status.Code.Undefined == code) {
            LOGGER.error("scheduleReloadRocksdb. {}, {}", (Object)this.dbPath, (Object)this.getStatusError(rocksDBException));
            this.scheduleReloadRocksdb0();
        }
    }

    private void scheduleReloadRocksdb0() {
        if (!this.reloadPermit.tryAcquire()) {
            return;
        }
        this.closed = true;
        this.reloadScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                boolean result = true;
                try {
                    AbstractRocksDBStorage.this.reloadRocksdb();
                }
                catch (Exception e) {
                    result = false;
                }
                finally {
                    AbstractRocksDBStorage.this.reloadPermit.release();
                }
                if (!result) {
                    LOGGER.info("reload rocksdb Retry. {}", (Object)AbstractRocksDBStorage.this.dbPath);
                    AbstractRocksDBStorage.this.scheduleReloadRocksdb0();
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private void reloadRocksdb() throws Exception {
        LOGGER.info("reload rocksdb Start. {}", (Object)this.dbPath);
        if (!this.shutdown() || !this.start()) {
            LOGGER.error("reload rocksdb Failed. {}", (Object)this.dbPath);
            throw new Exception("reload rocksdb Error");
        }
        LOGGER.info("reload rocksdb OK. {}", (Object)this.dbPath);
    }

    public void flushWAL() throws RocksDBException {
        this.db.flushWal(true);
    }

    private String getStatusError(RocksDBException e) {
        if (e == null || e.getStatus() == null) {
            return "null";
        }
        Status status = e.getStatus();
        StringBuilder sb = new StringBuilder(64);
        sb.append("code: ");
        if (status.getCode() != null) {
            sb.append(status.getCode().name());
        } else {
            sb.append("null");
        }
        sb.append(", ").append("subCode: ");
        if (status.getSubCode() != null) {
            sb.append(status.getSubCode().name());
        } else {
            sb.append("null");
        }
        sb.append(", ").append("state: ").append(status.getState());
        return sb.toString();
    }

    public void statRocksdb(Logger logger) {
        try {
            List<LiveFileMetaData> liveFileMetaDataList = this.getCompactionStatus();
            if (liveFileMetaDataList == null || liveFileMetaDataList.isEmpty()) {
                return;
            }
            HashMap map = Maps.newHashMap();
            for (LiveFileMetaData liveFileMetaData : liveFileMetaDataList) {
                StringBuilder sb = (StringBuilder)map.get(liveFileMetaData.level());
                if (sb == null) {
                    sb = new StringBuilder(256);
                    map.put(liveFileMetaData.level(), sb);
                }
                sb.append(new String(liveFileMetaData.columnFamilyName(), CHARSET_UTF8)).append(SPACE).append(liveFileMetaData.fileName()).append(SPACE).append("s: ").append(liveFileMetaData.size()).append(SPACE).append("a: ").append(liveFileMetaData.numEntries()).append(SPACE).append("r: ").append(liveFileMetaData.numReadsSampled()).append(SPACE).append("d: ").append(liveFileMetaData.numDeletions()).append(SPACE).append(liveFileMetaData.beingCompacted()).append("\n");
            }
            for (Map.Entry entry : map.entrySet()) {
                logger.info("level: {}\n{}", entry.getKey(), (Object)((StringBuilder)entry.getValue()).toString());
            }
            String blockCacheMemUsage = this.db.getProperty("rocksdb.block-cache-usage");
            String string = this.db.getProperty("rocksdb.estimate-table-readers-mem");
            String memTableMemUsage = this.db.getProperty("rocksdb.cur-size-all-mem-tables");
            String blocksPinnedByIteratorMemUsage = this.db.getProperty("rocksdb.block-cache-pinned-usage");
            logger.info("MemUsage. blockCache: {}, indexesAndFilterBlock: {}, memtable: {}, blocksPinnedByIterator: {}", new Object[]{blockCacheMemUsage, string, memTableMemUsage, blocksPinnedByIteratorMemUsage});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int compareTo(byte[] v1, byte[] v2) {
        int len1 = v1.length;
        int len2 = v2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = v1[k];
            byte c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    static {
        RocksDB.loadLibrary();
    }

    protected class WrappedRocksIterator {
        private final RocksIterator iterator;

        public WrappedRocksIterator(RocksIterator iterator) {
            this.iterator = iterator;
        }

        public byte[] key() {
            return this.iterator.key();
        }

        public byte[] value() {
            return this.iterator.value();
        }

        public void next() {
            this.iterator.next();
        }

        public void prev() {
            this.iterator.prev();
        }

        public void seek(byte[] target) {
            this.iterator.seek(target);
        }

        public void seekForPrev(byte[] target) {
            this.iterator.seekForPrev(target);
        }

        public void seekToFirst() {
            this.iterator.seekToFirst();
        }

        public boolean isValid() {
            return this.iterator.isValid();
        }

        public void close() {
            this.iterator.close();
        }
    }
}

