/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider;

import java.lang.reflect.Constructor;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.provider.TieredFileSegment;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class FileSegmentAllocator {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private final TieredMessageStoreConfig storeConfig;
    private final Constructor<? extends TieredFileSegment> fileSegmentConstructor;

    public FileSegmentAllocator(TieredMessageStoreConfig storeConfig) throws ClassNotFoundException, NoSuchMethodException {
        this.storeConfig = storeConfig;
        Class<TieredFileSegment> clazz = Class.forName(storeConfig.getTieredBackendServiceProvider()).asSubclass(TieredFileSegment.class);
        this.fileSegmentConstructor = clazz.getConstructor(TieredMessageStoreConfig.class, FileSegmentType.class, String.class, Long.TYPE);
    }

    public TieredMessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public TieredMetadataStore getMetadataStore() {
        return TieredStoreUtil.getMetadataStore(this.storeConfig);
    }

    public TieredFileSegment createSegment(FileSegmentType fileType, String filePath, long baseOffset) {
        switch (fileType) {
            case COMMIT_LOG: {
                return this.createCommitLogFileSegment(filePath, baseOffset);
            }
            case CONSUME_QUEUE: {
                return this.createConsumeQueueFileSegment(filePath, baseOffset);
            }
            case INDEX: {
                return this.createIndexFileSegment(filePath, baseOffset);
            }
        }
        return null;
    }

    public TieredFileSegment createCommitLogFileSegment(String filePath, long baseOffset) {
        TieredFileSegment segment = null;
        try {
            segment = this.fileSegmentConstructor.newInstance(new Object[]{this.storeConfig, FileSegmentType.COMMIT_LOG, filePath, baseOffset});
        }
        catch (Exception e) {
            log.error("create file segment of commitlog failed, filePath: {}, baseOffset: {}", new Object[]{filePath, baseOffset, e});
        }
        return segment;
    }

    public TieredFileSegment createConsumeQueueFileSegment(String filePath, long baseOffset) {
        TieredFileSegment segment = null;
        try {
            segment = this.fileSegmentConstructor.newInstance(new Object[]{this.storeConfig, FileSegmentType.CONSUME_QUEUE, filePath, baseOffset});
        }
        catch (Exception e) {
            log.error("create file segment of commitlog failed, filePath: {}, baseOffset: {}", new Object[]{filePath, baseOffset, e});
        }
        return segment;
    }

    public TieredFileSegment createIndexFileSegment(String filePath, long baseOffset) {
        TieredFileSegment segment = null;
        try {
            segment = this.fileSegmentConstructor.newInstance(new Object[]{this.storeConfig, FileSegmentType.INDEX, filePath, baseOffset});
        }
        catch (Exception e) {
            log.error("create file segment of commitlog failed, filePath: {}, baseOffset: {}", new Object[]{filePath, baseOffset, e});
        }
        return segment;
    }
}

