/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.common;

import apache.rocketmq.v2.Broker;
import apache.rocketmq.v2.DeadLetterQueue;
import apache.rocketmq.v2.Digest;
import apache.rocketmq.v2.DigestType;
import apache.rocketmq.v2.Encoding;
import apache.rocketmq.v2.FilterType;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.MessageQueue;
import apache.rocketmq.v2.MessageType;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SystemProperties;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.BinaryUtil;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;

public class GrpcConverter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected static final Object INSTANCE_CREATE_LOCK = new Object();
    protected static volatile GrpcConverter instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GrpcConverter getInstance() {
        if (instance == null) {
            Object object = INSTANCE_CREATE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new GrpcConverter();
                }
            }
        }
        return instance;
    }

    public String wrapResourceWithNamespace(Resource resource) {
        return NamespaceUtil.wrapNamespace((String)resource.getResourceNamespace(), (String)resource.getName());
    }

    public MessageQueue buildMessageQueue(MessageExt messageExt, String brokerName) {
        Broker broker = Broker.getDefaultInstance();
        if (!StringUtils.isEmpty((CharSequence)brokerName)) {
            broker = Broker.newBuilder().setName(brokerName).setId(0).build();
        }
        return MessageQueue.newBuilder().setId(messageExt.getQueueId()).setTopic(Resource.newBuilder().setName(NamespaceUtil.withoutNamespace((String)messageExt.getTopic())).setResourceNamespace(NamespaceUtil.getNamespaceFromResource((String)messageExt.getTopic())).build()).setBroker(broker).build();
    }

    public String buildExpressionType(FilterType filterType) {
        switch (filterType) {
            case SQL: {
                return "SQL92";
            }
        }
        return "TAG";
    }

    public Message buildMessage(MessageExt messageExt) {
        Map<String, String> userProperties = this.buildUserAttributes(messageExt);
        SystemProperties systemProperties = this.buildSystemProperties(messageExt);
        Resource topic = this.buildResource(messageExt.getTopic());
        return Message.newBuilder().setTopic(topic).putAllUserProperties(userProperties).setSystemProperties(systemProperties).setBody(ByteString.copyFrom((byte[])messageExt.getBody())).build();
    }

    protected Map<String, String> buildUserAttributes(MessageExt messageExt) {
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        Map properties = messageExt.getProperties();
        for (Map.Entry property : properties.entrySet()) {
            if (MessageConst.STRING_HASH_SET.contains(property.getKey())) continue;
            userAttributes.put((String)property.getKey(), (String)property.getValue());
        }
        return userAttributes;
    }

    protected SystemProperties buildSystemProperties(MessageExt messageExt) {
        String handle;
        String uniqKey;
        String keys;
        SystemProperties.Builder systemPropertiesBuilder = SystemProperties.newBuilder();
        String tag = messageExt.getUserProperty("TAGS");
        if (tag != null) {
            systemPropertiesBuilder.setTag(tag);
        }
        if ((keys = messageExt.getKeys()) != null) {
            String[] keysArray = keys.split(" ");
            systemPropertiesBuilder.addAllKeys(Arrays.asList(keysArray));
        }
        if ((uniqKey = messageExt.getProperty("UNIQ_KEY")) != null) {
            systemPropertiesBuilder.setMessageId(uniqKey);
        }
        String md5Result = BinaryUtil.generateMd5((byte[])messageExt.getBody());
        Digest digest = Digest.newBuilder().setType(DigestType.MD5).setChecksum(md5Result).build();
        systemPropertiesBuilder.setBodyDigest(digest);
        if ((messageExt.getSysFlag() & 1) == 1) {
            systemPropertiesBuilder.setBodyEncoding(Encoding.GZIP);
        } else {
            systemPropertiesBuilder.setBodyEncoding(Encoding.IDENTITY);
        }
        String isTrans = messageExt.getProperty("TRAN_MSG");
        String isTransValue = "true";
        if (isTransValue.equals(isTrans)) {
            systemPropertiesBuilder.setMessageType(MessageType.TRANSACTION);
        } else if (messageExt.getProperty("DELAY") != null || messageExt.getProperty("TIMER_DELIVER_MS") != null || messageExt.getProperty("TIMER_DELAY_SEC") != null) {
            systemPropertiesBuilder.setMessageType(MessageType.DELAY);
        } else if (messageExt.getProperty("__SHARDINGKEY") != null) {
            systemPropertiesBuilder.setMessageType(MessageType.FIFO);
        } else {
            systemPropertiesBuilder.setMessageType(MessageType.NORMAL);
        }
        long bornTimestamp = messageExt.getBornTimestamp();
        systemPropertiesBuilder.setBornTimestamp(Timestamps.fromMillis((long)bornTimestamp));
        String bornHostString = messageExt.getProperty("__BORNHOST");
        if (StringUtils.isBlank((CharSequence)bornHostString)) {
            bornHostString = messageExt.getBornHostString();
        }
        if (StringUtils.isNotBlank((CharSequence)bornHostString)) {
            systemPropertiesBuilder.setBornHost(bornHostString);
        }
        long storeTimestamp = messageExt.getStoreTimestamp();
        systemPropertiesBuilder.setStoreTimestamp(Timestamps.fromMillis((long)storeTimestamp));
        SocketAddress storeHost = messageExt.getStoreHost();
        if (storeHost != null) {
            systemPropertiesBuilder.setStoreHost(NetworkUtil.socketAddress2String((SocketAddress)storeHost));
        }
        if (messageExt.getProperty("TIMER_DELAY_SEC") != null) {
            long delayMs = TimeUnit.SECONDS.toMillis(Long.parseLong(messageExt.getProperty("TIMER_DELAY_SEC")));
            long deliverMs = System.currentTimeMillis() + delayMs;
            systemPropertiesBuilder.setDeliveryTimestamp(Timestamps.fromMillis((long)deliverMs));
        } else {
            String deliverMsString = messageExt.getProperty("TIMER_DELIVER_MS");
            if (deliverMsString != null) {
                long deliverMs = Long.parseLong(deliverMsString);
                systemPropertiesBuilder.setDeliveryTimestamp(Timestamps.fromMillis((long)deliverMs));
            }
        }
        String shardingKey = messageExt.getProperty("__SHARDINGKEY");
        if (shardingKey != null) {
            systemPropertiesBuilder.setMessageGroup(shardingKey);
        }
        if ((handle = messageExt.getProperty("POP_CK")) != null) {
            systemPropertiesBuilder.setReceiptHandle(handle);
        }
        systemPropertiesBuilder.setQueueId(messageExt.getQueueId());
        systemPropertiesBuilder.setQueueOffset(messageExt.getQueueOffset());
        systemPropertiesBuilder.setDeliveryAttempt(messageExt.getReconsumeTimes() + 1);
        String traceContext = messageExt.getProperty("TRACE_CONTEXT");
        if (traceContext != null) {
            systemPropertiesBuilder.setTraceContext(traceContext);
        }
        String dlqOriginTopic = messageExt.getProperty("DLQ_ORIGIN_TOPIC");
        String dlqOriginMessageId = messageExt.getProperty("DLQ_ORIGIN_MESSAGE_ID");
        if (dlqOriginTopic != null && dlqOriginMessageId != null) {
            DeadLetterQueue dlq = DeadLetterQueue.newBuilder().setTopic(dlqOriginTopic).setMessageId(dlqOriginMessageId).build();
            systemPropertiesBuilder.setDeadLetterQueue(dlq);
        }
        return systemPropertiesBuilder.build();
    }

    public Resource buildResource(String resourceNameWithNamespace) {
        return Resource.newBuilder().setResourceNamespace(NamespaceUtil.getNamespaceFromResource((String)resourceNameWithNamespace)).setName(NamespaceUtil.withoutNamespace((String)resourceNameWithNamespace)).build();
    }
}

