/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.rocketmq.common.MixAll;

public class SessionCredentials {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String ACCESS_KEY = "AccessKey";
    public static final String SECRET_KEY = "SecretKey";
    public static final String SIGNATURE = "Signature";
    public static final String SECURITY_TOKEN = "SecurityToken";
    public static final String KEY_FILE = System.getProperty("rocketmq.client.keyFile", System.getProperty("user.home") + File.separator + "key");
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String signature;

    public SessionCredentials() {
        Properties prop;
        String keyContent = null;
        try {
            keyContent = MixAll.file2String((String)KEY_FILE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (keyContent != null && (prop = MixAll.string2Properties((String)keyContent)) != null) {
            this.updateContent(prop);
        }
    }

    public SessionCredentials(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public SessionCredentials(String accessKey, String secretKey, String securityToken) {
        this(accessKey, secretKey);
        this.securityToken = securityToken;
    }

    public void updateContent(Properties prop) {
        String value = prop.getProperty(ACCESS_KEY);
        if (value != null) {
            this.accessKey = value.trim();
        }
        if ((value = prop.getProperty(SECRET_KEY)) != null) {
            this.secretKey = value.trim();
        }
        if ((value = prop.getProperty(SECURITY_TOKEN)) != null) {
            this.securityToken = value.trim();
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        result = 31 * result + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)obj;
        if (this.accessKey == null ? other.accessKey != null : !this.accessKey.equals(other.accessKey)) {
            return false;
        }
        if (this.secretKey == null ? other.secretKey != null : !this.secretKey.equals(other.secretKey)) {
            return false;
        }
        if (this.signature == null) {
            return other.signature == null;
        }
        return this.signature.equals(other.signature);
    }

    public String toString() {
        return "SessionCredentials [accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", signature=" + this.signature + ", SecurityToken=" + this.securityToken + "]";
    }
}

