/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PDInterfaceAdjust extends PnIoCm_Block implements Message {

  // Accessors for discriminator values.
  public PnIoCm_BlockType getBlockType() {
    return PnIoCm_BlockType.PD_INTERFACE_ADJUST;
  }

  // Constant values.
  public static final Integer PADFIELD = 0x0000;
  public static final Integer MULTIPLEINTERFACEMODERESERVED2 = 0x0000;
  public static final Short MULTIPLEINTERFACEMODERESERVED1 = 0x0000;

  // Properties.
  protected final short blockVersionHigh;
  protected final short blockVersionLow;
  protected final MultipleInterfaceModeNameOfDevice multipleInterfaceModeNameOfDevice;

  public PDInterfaceAdjust(
      short blockVersionHigh,
      short blockVersionLow,
      MultipleInterfaceModeNameOfDevice multipleInterfaceModeNameOfDevice) {
    super();
    this.blockVersionHigh = blockVersionHigh;
    this.blockVersionLow = blockVersionLow;
    this.multipleInterfaceModeNameOfDevice = multipleInterfaceModeNameOfDevice;
  }

  public short getBlockVersionHigh() {
    return blockVersionHigh;
  }

  public short getBlockVersionLow() {
    return blockVersionLow;
  }

  public MultipleInterfaceModeNameOfDevice getMultipleInterfaceModeNameOfDevice() {
    return multipleInterfaceModeNameOfDevice;
  }

  public int getPadField() {
    return PADFIELD;
  }

  public int getMultipleInterfaceModeReserved2() {
    return MULTIPLEINTERFACEMODERESERVED2;
  }

  public short getMultipleInterfaceModeReserved1() {
    return MULTIPLEINTERFACEMODERESERVED1;
  }

  @Override
  protected void serializePnIoCm_BlockChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PDInterfaceAdjust");

    // Implicit Field (blockLength) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int blockLength = (int) ((getLengthInBytes()) - (4));
    writeImplicitField(
        "blockLength",
        blockLength,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (blockVersionHigh)
    writeSimpleField(
        "blockVersionHigh",
        blockVersionHigh,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (blockVersionLow)
    writeSimpleField(
        "blockVersionLow",
        blockVersionLow,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (padField)
    writeConstField(
        "padField",
        PADFIELD,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (multipleInterfaceModeReserved2)
    writeConstField(
        "multipleInterfaceModeReserved2",
        MULTIPLEINTERFACEMODERESERVED2,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (multipleInterfaceModeReserved1)
    writeConstField(
        "multipleInterfaceModeReserved1",
        MULTIPLEINTERFACEMODERESERVED1,
        writeUnsignedShort(writeBuffer, 15),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (multipleInterfaceModeNameOfDevice)
    writeSimpleEnumField(
        "multipleInterfaceModeNameOfDevice",
        "MultipleInterfaceModeNameOfDevice",
        multipleInterfaceModeNameOfDevice,
        writeEnum(
            MultipleInterfaceModeNameOfDevice::getValue,
            MultipleInterfaceModeNameOfDevice::name,
            writeBoolean(writeBuffer)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PDInterfaceAdjust");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PDInterfaceAdjust _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (blockLength)
    lengthInBits += 16;

    // Simple field (blockVersionHigh)
    lengthInBits += 8;

    // Simple field (blockVersionLow)
    lengthInBits += 8;

    // Const Field (padField)
    lengthInBits += 16;

    // Const Field (multipleInterfaceModeReserved2)
    lengthInBits += 16;

    // Const Field (multipleInterfaceModeReserved1)
    lengthInBits += 15;

    // Simple field (multipleInterfaceModeNameOfDevice)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static PnIoCm_BlockBuilder staticParsePnIoCm_BlockBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PDInterfaceAdjust");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int blockLength =
        readImplicitField(
            "blockLength",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short blockVersionHigh =
        readSimpleField(
            "blockVersionHigh",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short blockVersionLow =
        readSimpleField(
            "blockVersionLow",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int padField =
        readConstField(
            "padField",
            readUnsignedInt(readBuffer, 16),
            PDInterfaceAdjust.PADFIELD,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int multipleInterfaceModeReserved2 =
        readConstField(
            "multipleInterfaceModeReserved2",
            readUnsignedInt(readBuffer, 16),
            PDInterfaceAdjust.MULTIPLEINTERFACEMODERESERVED2,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short multipleInterfaceModeReserved1 =
        readConstField(
            "multipleInterfaceModeReserved1",
            readUnsignedShort(readBuffer, 15),
            PDInterfaceAdjust.MULTIPLEINTERFACEMODERESERVED1,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    MultipleInterfaceModeNameOfDevice multipleInterfaceModeNameOfDevice =
        readEnumField(
            "multipleInterfaceModeNameOfDevice",
            "MultipleInterfaceModeNameOfDevice",
            readEnum(MultipleInterfaceModeNameOfDevice::enumForValue, readBoolean(readBuffer)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PDInterfaceAdjust");
    // Create the instance
    return new PDInterfaceAdjustBuilderImpl(
        blockVersionHigh, blockVersionLow, multipleInterfaceModeNameOfDevice);
  }

  public static class PDInterfaceAdjustBuilderImpl implements PnIoCm_Block.PnIoCm_BlockBuilder {
    private final short blockVersionHigh;
    private final short blockVersionLow;
    private final MultipleInterfaceModeNameOfDevice multipleInterfaceModeNameOfDevice;

    public PDInterfaceAdjustBuilderImpl(
        short blockVersionHigh,
        short blockVersionLow,
        MultipleInterfaceModeNameOfDevice multipleInterfaceModeNameOfDevice) {
      this.blockVersionHigh = blockVersionHigh;
      this.blockVersionLow = blockVersionLow;
      this.multipleInterfaceModeNameOfDevice = multipleInterfaceModeNameOfDevice;
    }

    public PDInterfaceAdjust build() {
      PDInterfaceAdjust pDInterfaceAdjust =
          new PDInterfaceAdjust(
              blockVersionHigh, blockVersionLow, multipleInterfaceModeNameOfDevice);
      return pDInterfaceAdjust;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PDInterfaceAdjust)) {
      return false;
    }
    PDInterfaceAdjust that = (PDInterfaceAdjust) o;
    return (getBlockVersionHigh() == that.getBlockVersionHigh())
        && (getBlockVersionLow() == that.getBlockVersionLow())
        && (getMultipleInterfaceModeNameOfDevice() == that.getMultipleInterfaceModeNameOfDevice())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getBlockVersionHigh(),
        getBlockVersionLow(),
        getMultipleInterfaceModeNameOfDevice());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
