/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum Mid {
  ApplicationCommunicationStart((long) 1L),
  ApplicationCommunicationStartAcknowledge((long) 2L),
  ApplicationCommunicationStop((long) 3L),
  ApplicationCommandError((long) 4L),
  ApplicationCommandAccepted((long) 5L),
  ApplicationGenericDataRequest((long) 6L),
  Reserved((long) 7L),
  ApplicationGenericSubscription((long) 8L),
  ApplicationGenericUnsubscribe((long) 9L),
  ParameterSetIdUploadRequest((long) 10L),
  ParameterSetIdUploadReply((long) 11L),
  ParameterSetDataUploadRequest((long) 12L),
  ParameterSetDataUploadReply((long) 13L),
  ParameterSetSelectedSubscribe((long) 14L),
  ParameterSetSelected((long) 15L),
  ParameterSetSelectedAcknowledge((long) 16L),
  ParameterSetSelectedUnsubscribe((long) 17L),
  SelectParameterSet((long) 18L),
  SetParameterSetBatchSize((long) 19L),
  ResetParameterSetBatchCounter((long) 20L),
  LockAtBatchDoneSubscribe((long) 21L),
  LockAtBatchDoneUpload((long) 22L),
  LockAtBatchDoneUploadAcknowledge((long) 23L),
  LockAtBatchDoneUnsubscribe((long) 24L),
  ReservedForFord((long) 25L),
  JobIdUploadRequest((long) 30L),
  JobIdUploadReply((long) 31L),
  JobDataUploadRequest((long) 32L),
  JobDataUploadReply((long) 33L),
  JobInfoSubscribe((long) 34L),
  JobInfo((long) 35L),
  JobInfoAcknowledge((long) 36L),
  JobInfoUnsubscribe((long) 37L),
  SelectJob((long) 38L),
  JobRestart((long) 39L),
  ToolDataUploadRequest((long) 40L),
  ToolDataUploadReply((long) 41L),
  DisableTool((long) 42L),
  EnableTool((long) 43L),
  DisconnectToolRequest((long) 44L),
  SetCalibrationValueRequest((long) 45L),
  SetPrimaryToolRequest((long) 46L),
  PairingHandling((long) 47L),
  PairingStatus((long) 48L),
  PairingStatusAcknowledge((long) 49L),
  VehicleIdNumberDownloadRequest((long) 50L),
  VehicleIdNumberSubscribe((long) 51L),
  VehicleIdNumber((long) 52L),
  VehicleIdNumberAcknowledge((long) 53L),
  VehicleIdNumberUnsubscribe((long) 54L),
  LastTighteningResultDataSubscribe((long) 60L),
  LastTighteningResultData((long) 61L),
  LastTighteningResultDataAcknowledge((long) 62L),
  LastTighteningResultDataUnsubscribe((long) 63L),
  OldTighteningResultUploadRequest((long) 64L),
  OldTighteningResultUploadReply((long) 65L),
  AlarmSubscribe((long) 70L),
  Alarm((long) 71L),
  AlarmAcknowledge((long) 72L),
  AlarmUnsubscribe((long) 73L),
  AlarmAcknowledgedOnController((long) 74L),
  AlarmAcknowledgedOnControllerAcknowledge((long) 75L),
  AlarmStatus((long) 76L),
  AlarmStatusAcknowledge((long) 77L),
  AcknowledgeAlarmRemotelyOnController((long) 78L),
  ReadTimeUploadRequest((long) 80L),
  ReadTimeUploadReply((long) 81L),
  SetTime((long) 82L),
  MultiSpindleStatusSubscribe((long) 90L),
  MultiSpindleStatus((long) 91L),
  MultiSpindleStatusAcknowledge((long) 92L),
  MultiSpindleStatusUnsubscribe((long) 93L),
  MultiSpindleResultSubscribe((long) 100L),
  MultiSpindleResult((long) 101L),
  MultiSpindleResultAcknowledge((long) 102L),
  MultiSpindleResultUnsubscribe((long) 103L),
  LastPowerMacsTighteningResultDataSubscribe((long) 105L),
  LastPowerMacsTighteningResultStationData((long) 106L),
  LastPowerMacsTighteningResultBoltData((long) 107L),
  LastPowerMacsTighteningResultDataAcknowledge((long) 108L),
  LastPowerMacsTighteningResultDataUnsubscribe((long) 109L),
  DisplayUserTextOnCompact((long) 110L),
  DisplayUserTextOnGraph((long) 111L),
  FlashGreenLightOnTool((long) 113L),
  JobLineControlInfoSubscribe((long) 120L),
  JobLineControlStarted((long) 121L),
  JobLineControlAlert1((long) 122L),
  JobLineControlAlert2((long) 123L),
  JobLineControlDone((long) 124L),
  JobLineControlInfoAcknowledge((long) 125L),
  JobLineControlUnsubscribe((long) 126L),
  AbortJob((long) 127L),
  JobBatchIncrement((long) 128L),
  JobBatchDecrement((long) 129L),
  JobOff((long) 130L),
  SetJobLineControlStart((long) 131L),
  SetJobLineControlAlert1((long) 132L),
  SetJobLineControlAlert2((long) 133L),
  ExecuteDynamicJobRequest((long) 140L),
  IdentifierDownloadRequest((long) 150L),
  MultipleIdentifiersWorkOrderSubscribe((long) 151L),
  MultipleIdentifiersWorkOrder((long) 152L),
  MultipleIdentifiersWorkOrderAcknowledge((long) 153L),
  MultipleIdentifiersWorkOrderUnsubscribe((long) 154L),
  BypassIdentifier((long) 155L),
  ResetLatestIdentifier((long) 156L),
  ResetAllIdentifiers((long) 157L),
  SetExternalControlledRelays((long) 200L),
  StatusExternalMonitoredInputsSubscribe((long) 210L),
  StatusExternalMonitoredInputs((long) 211L),
  StatusExternalMonitoredInputsAcknowledge((long) 212L),
  StatusExternalMonitoredInputsUnsubscribe((long) 213L),
  IoDeviceStatusRequest((long) 214L),
  IoDeviceStatusReply((long) 215L),
  RelayFunctionSubscribe((long) 216L),
  RelayFunction((long) 217L),
  RelayFunctionAcknowledge((long) 218L),
  RelayFunctionUnsubscribe((long) 219L),
  DigitalInputFunctionSubscribe((long) 220L),
  DigitalInputFunction((long) 221L),
  DigitalInputFunctionAcknowledge((long) 222L),
  DigitalInputFunctionUnsubscribe((long) 223L),
  SetDigitalInputFunction((long) 224L),
  ResetDigitalInputFunction((long) 225L),
  UserDataDownload((long) 240L),
  UserDataSubscribe((long) 241L),
  UserData((long) 242L),
  UserDataAcknowledge((long) 243L),
  UserDataUnsubscribe((long) 244L),
  UserDataDownloadWithOffset((long) 245L),
  SelectorSocketInfoSubscribe((long) 250L),
  SelectorSocketInfo((long) 251L),
  SelectorSocketInfoAcknowledge((long) 252L),
  SelectorSocketInfoUnsubscribe((long) 253L),
  SelectorControlGreenLights((long) 254L),
  SelectorControlRedLights((long) 255L),
  ToolTagIdRequest((long) 260L),
  ToolTagIdSubscribe((long) 261L),
  ToolTagId((long) 262L),
  ToolTagIdAcknowledge((long) 263L),
  ToolTagIdUnsubscribe((long) 264L),
  ControllerRebootRequest((long) 270L),
  HistogramUploadRequest((long) 300L),
  HistogramUploadReply((long) 301L),
  AutomaticManualModeSubscribe((long) 400L),
  AutomaticManualMode((long) 401L),
  AutomaticManualModeAcknowledge((long) 402L),
  AutomaticManualModeUnsubscribe((long) 403L),
  AutoDisableSettingsRequest((long) 410L),
  AutoDisableSettingsReply((long) 411L),
  OpenProtocolCommandsDisabledSubscribe((long) 420L),
  OpenProtocolCommandsDisabled((long) 421L),
  OpenProtocolCommandsDisabledAcknowledge((long) 422L),
  OpenProtocolCommandsDisabledUnsubscribe((long) 423L),
  MotorTuningResultDataSubscribe((long) 500L),
  MotorTuningResultData((long) 501L),
  MotorTuningResultDataAcknowledge((long) 502L),
  MotorTuningResultDataUnsubscribe((long) 503L),
  MotorTuningRequest((long) 504L),
  TighteningDataDownloadStatusForRadioTools((long) 700L),
  ResultTracesCurve((long) 900L),
  ResultTracesCurvePlotData((long) 901L),
  LastOperationResultOverallData((long) 1201L),
  LastOperationResultObjectData((long) 1202L),
  LastOperationResultDataAcknowledge((long) 1203L),
  DeviceCommand((long) 2100L),
  ProgramDataDownload((long) 2500L),
  ProgramDataUploadReply((long) 2501L),
  PasswordRequest((long) 2502L),
  PasswordReply((long) 2503L),
  ProgramPsetSelectionInDynamicJob((long) 2504L),
  DynamicPsetSelection((long) 2505L),
  ModeIdUploadRequest((long) 2600L),
  ModeIdUploadReply((long) 2601L),
  ModeDataUploadRequest((long) 2602L),
  ModeDataUploadReply((long) 2603L),
  ModeSelected((long) 2604L),
  ModeSelectedAcknowledge((long) 2605L),
  SelectMode((long) 2606L),
  AudiEmergencyStatusSubscribe((long) 8000L),
  AudiEmergencyStatus((long) 8001L),
  AudiEmergencyStatusAcknowledge((long) 8002L),
  AudiEmergencyStatusUnsubscribe((long) 8003L),
  LinkLevelPositiveAcknowledge((long) 9997L),
  LinkLevelNegativeAcknowledge((long) 9998L),
  KeepAliveOpenProtocolCommunication((long) 9999L);
  private static final Map<Long, Mid> map;

  static {
    map = new HashMap<>();
    for (Mid value : Mid.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  Mid(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static Mid enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
