/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonStatusMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 19318;
  }

  // Properties.
  protected final PascalString messageId;
  protected final PascalString messageType;
  protected final PascalString publisherId;
  protected final long timestamp;
  protected final boolean isCyclic;
  protected final PubSubState status;
  protected final long nextReportTime;

  public JsonStatusMessage(
      PascalString messageId,
      PascalString messageType,
      PascalString publisherId,
      long timestamp,
      boolean isCyclic,
      PubSubState status,
      long nextReportTime) {
    super();
    this.messageId = messageId;
    this.messageType = messageType;
    this.publisherId = publisherId;
    this.timestamp = timestamp;
    this.isCyclic = isCyclic;
    this.status = status;
    this.nextReportTime = nextReportTime;
  }

  public PascalString getMessageId() {
    return messageId;
  }

  public PascalString getMessageType() {
    return messageType;
  }

  public PascalString getPublisherId() {
    return publisherId;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public boolean getIsCyclic() {
    return isCyclic;
  }

  public PubSubState getStatus() {
    return status;
  }

  public long getNextReportTime() {
    return nextReportTime;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonStatusMessage");

    // Simple Field (messageId)
    writeSimpleField("messageId", messageId, writeComplex(writeBuffer));

    // Simple Field (messageType)
    writeSimpleField("messageType", messageType, writeComplex(writeBuffer));

    // Simple Field (publisherId)
    writeSimpleField("publisherId", publisherId, writeComplex(writeBuffer));

    // Simple Field (timestamp)
    writeSimpleField("timestamp", timestamp, writeSignedLong(writeBuffer, 64));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (isCyclic)
    writeSimpleField("isCyclic", isCyclic, writeBoolean(writeBuffer));

    // Simple Field (status)
    writeSimpleEnumField(
        "status",
        "PubSubState",
        status,
        writeEnum(PubSubState::getValue, PubSubState::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (nextReportTime)
    writeSimpleField("nextReportTime", nextReportTime, writeSignedLong(writeBuffer, 64));

    writeBuffer.popContext("JsonStatusMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonStatusMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (messageId)
    lengthInBits += messageId.getLengthInBits();

    // Simple field (messageType)
    lengthInBits += messageType.getLengthInBits();

    // Simple field (publisherId)
    lengthInBits += publisherId.getLengthInBits();

    // Simple field (timestamp)
    lengthInBits += 64;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (isCyclic)
    lengthInBits += 1;

    // Simple field (status)
    lengthInBits += 32;

    // Simple field (nextReportTime)
    lengthInBits += 64;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonStatusMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString messageId =
        readSimpleField(
            "messageId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString messageType =
        readSimpleField(
            "messageType", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalString publisherId =
        readSimpleField(
            "publisherId", readComplex(() -> PascalString.staticParse(readBuffer), readBuffer));

    long timestamp = readSimpleField("timestamp", readSignedLong(readBuffer, 64));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean isCyclic = readSimpleField("isCyclic", readBoolean(readBuffer));

    PubSubState status =
        readEnumField(
            "status",
            "PubSubState",
            readEnum(PubSubState::enumForValue, readUnsignedLong(readBuffer, 32)));

    long nextReportTime = readSimpleField("nextReportTime", readSignedLong(readBuffer, 64));

    readBuffer.closeContext("JsonStatusMessage");
    // Create the instance
    return new JsonStatusMessageBuilderImpl(
        messageId, messageType, publisherId, timestamp, isCyclic, status, nextReportTime);
  }

  public static class JsonStatusMessageBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString messageId;
    private final PascalString messageType;
    private final PascalString publisherId;
    private final long timestamp;
    private final boolean isCyclic;
    private final PubSubState status;
    private final long nextReportTime;

    public JsonStatusMessageBuilderImpl(
        PascalString messageId,
        PascalString messageType,
        PascalString publisherId,
        long timestamp,
        boolean isCyclic,
        PubSubState status,
        long nextReportTime) {
      this.messageId = messageId;
      this.messageType = messageType;
      this.publisherId = publisherId;
      this.timestamp = timestamp;
      this.isCyclic = isCyclic;
      this.status = status;
      this.nextReportTime = nextReportTime;
    }

    public JsonStatusMessage build() {
      JsonStatusMessage jsonStatusMessage =
          new JsonStatusMessage(
              messageId, messageType, publisherId, timestamp, isCyclic, status, nextReportTime);
      return jsonStatusMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonStatusMessage)) {
      return false;
    }
    JsonStatusMessage that = (JsonStatusMessage) o;
    return (getMessageId() == that.getMessageId())
        && (getMessageType() == that.getMessageType())
        && (getPublisherId() == that.getPublisherId())
        && (getTimestamp() == that.getTimestamp())
        && (getIsCyclic() == that.getIsCyclic())
        && (getStatus() == that.getStatus())
        && (getNextReportTime() == that.getNextReportTime())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getMessageId(),
        getMessageType(),
        getPublisherId(),
        getTimestamp(),
        getIsCyclic(),
        getStatus(),
        getNextReportTime());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
