/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum AccessControlCommandType {
  CLOSE_ACCESS_POINT((byte) 0x00, (short) 0),
  LOCK_ACCESS_POINT((byte) 0x01, (short) 0),
  ACCESS_POINT_LEFT_OPEN((byte) 0x02, (short) 0),
  ACCESS_POINT_FORCED_OPEN((byte) 0x03, (short) 0),
  ACCESS_POINT_CLOSED((byte) 0x04, (short) 0),
  REQUEST_TO_EXIT((byte) 0x05, (short) 0),
  VALID_ACCESS((byte) 0x06, (short) 2),
  INVALID_ACCESS((byte) 0x07, (short) 2);
  private static final Map<Byte, AccessControlCommandType> map;

  static {
    map = new HashMap<>();
    for (AccessControlCommandType value : AccessControlCommandType.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final short numberOfArguments;

  AccessControlCommandType(byte value, short numberOfArguments) {
    this.value = value;
    this.numberOfArguments = numberOfArguments;
  }

  public byte getValue() {
    return value;
  }

  public short getNumberOfArguments() {
    return numberOfArguments;
  }

  public static AccessControlCommandType firstEnumForFieldNumberOfArguments(short fieldValue) {
    for (AccessControlCommandType _val : AccessControlCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<AccessControlCommandType> enumsForFieldNumberOfArguments(short fieldValue) {
    List<AccessControlCommandType> _values = new ArrayList<>();
    for (AccessControlCommandType _val : AccessControlCommandType.values()) {
      if (_val.getNumberOfArguments() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static AccessControlCommandType enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
