/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableLog is an enum
type OpcuaNodeIdServicesVariableLog int32

type IOpcuaNodeIdServicesVariableLog interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_InputArguments  OpcuaNodeIdServicesVariableLog = 19354
	OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_OutputArguments OpcuaNodeIdServicesVariableLog = 19355
	OpcuaNodeIdServicesVariableLog_LogObjectType_MaxRecords                 OpcuaNodeIdServicesVariableLog = 19356
	OpcuaNodeIdServicesVariableLog_LogObjectType_MaxStorageDuration         OpcuaNodeIdServicesVariableLog = 19357
	OpcuaNodeIdServicesVariableLog_LogObjectType_MinimumSeverity            OpcuaNodeIdServicesVariableLog = 19744
	OpcuaNodeIdServicesVariableLog_LogRecordMask_OptionSetValues            OpcuaNodeIdServicesVariableLog = 19750
)

var OpcuaNodeIdServicesVariableLogValues []OpcuaNodeIdServicesVariableLog

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableLogValues = []OpcuaNodeIdServicesVariableLog{
		OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_InputArguments,
		OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_OutputArguments,
		OpcuaNodeIdServicesVariableLog_LogObjectType_MaxRecords,
		OpcuaNodeIdServicesVariableLog_LogObjectType_MaxStorageDuration,
		OpcuaNodeIdServicesVariableLog_LogObjectType_MinimumSeverity,
		OpcuaNodeIdServicesVariableLog_LogRecordMask_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariableLogByValue(value int32) (enum OpcuaNodeIdServicesVariableLog, ok bool) {
	switch value {
	case 19354:
		return OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_InputArguments, true
	case 19355:
		return OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_OutputArguments, true
	case 19356:
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MaxRecords, true
	case 19357:
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MaxStorageDuration, true
	case 19744:
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MinimumSeverity, true
	case 19750:
		return OpcuaNodeIdServicesVariableLog_LogRecordMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLogByName(value string) (enum OpcuaNodeIdServicesVariableLog, ok bool) {
	switch value {
	case "LogObjectType_GetRecords_InputArguments":
		return OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_InputArguments, true
	case "LogObjectType_GetRecords_OutputArguments":
		return OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_OutputArguments, true
	case "LogObjectType_MaxRecords":
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MaxRecords, true
	case "LogObjectType_MaxStorageDuration":
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MaxStorageDuration, true
	case "LogObjectType_MinimumSeverity":
		return OpcuaNodeIdServicesVariableLog_LogObjectType_MinimumSeverity, true
	case "LogRecordMask_OptionSetValues":
		return OpcuaNodeIdServicesVariableLog_LogRecordMask_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLogKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableLogValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableLog(structType any) OpcuaNodeIdServicesVariableLog {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableLog {
		if sOpcuaNodeIdServicesVariableLog, ok := typ.(OpcuaNodeIdServicesVariableLog); ok {
			return sOpcuaNodeIdServicesVariableLog
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableLog) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableLog) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableLogParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableLog, error) {
	return OpcuaNodeIdServicesVariableLogParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableLogParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableLog, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableLog", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableLog")
	}
	if enum, ok := OpcuaNodeIdServicesVariableLogByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableLog")
		return OpcuaNodeIdServicesVariableLog(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableLog) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableLog) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableLog", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableLog) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableLog) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_InputArguments:
		return "LogObjectType_GetRecords_InputArguments"
	case OpcuaNodeIdServicesVariableLog_LogObjectType_GetRecords_OutputArguments:
		return "LogObjectType_GetRecords_OutputArguments"
	case OpcuaNodeIdServicesVariableLog_LogObjectType_MaxRecords:
		return "LogObjectType_MaxRecords"
	case OpcuaNodeIdServicesVariableLog_LogObjectType_MaxStorageDuration:
		return "LogObjectType_MaxStorageDuration"
	case OpcuaNodeIdServicesVariableLog_LogObjectType_MinimumSeverity:
		return "LogObjectType_MinimumSeverity"
	case OpcuaNodeIdServicesVariableLog_LogRecordMask_OptionSetValues:
		return "LogRecordMask_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableLog) String() string {
	return e.PLC4XEnumName()
}
