/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMinimumOnTime is the corresponding interface of BACnetConstructedDataMinimumOnTime
type BACnetConstructedDataMinimumOnTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetMinimumOnTime returns MinimumOnTime (property field)
	GetMinimumOnTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataMinimumOnTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMinimumOnTime()
	// CreateBuilder creates a BACnetConstructedDataMinimumOnTimeBuilder
	CreateBACnetConstructedDataMinimumOnTimeBuilder() BACnetConstructedDataMinimumOnTimeBuilder
}

// _BACnetConstructedDataMinimumOnTime is the data-structure of this message
type _BACnetConstructedDataMinimumOnTime struct {
	BACnetConstructedDataContract
	MinimumOnTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataMinimumOnTime = (*_BACnetConstructedDataMinimumOnTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMinimumOnTime)(nil)

// NewBACnetConstructedDataMinimumOnTime factory function for _BACnetConstructedDataMinimumOnTime
func NewBACnetConstructedDataMinimumOnTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, minimumOnTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMinimumOnTime {
	if minimumOnTime == nil {
		panic("minimumOnTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataMinimumOnTime must not be nil")
	}
	_result := &_BACnetConstructedDataMinimumOnTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		MinimumOnTime:                 minimumOnTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMinimumOnTimeBuilder is a builder for BACnetConstructedDataMinimumOnTime
type BACnetConstructedDataMinimumOnTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(minimumOnTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMinimumOnTimeBuilder
	// WithMinimumOnTime adds MinimumOnTime (property field)
	WithMinimumOnTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMinimumOnTimeBuilder
	// WithMinimumOnTimeBuilder adds MinimumOnTime (property field) which is build by the builder
	WithMinimumOnTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMinimumOnTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMinimumOnTime or returns an error if something is wrong
	Build() (BACnetConstructedDataMinimumOnTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMinimumOnTime
}

// NewBACnetConstructedDataMinimumOnTimeBuilder() creates a BACnetConstructedDataMinimumOnTimeBuilder
func NewBACnetConstructedDataMinimumOnTimeBuilder() BACnetConstructedDataMinimumOnTimeBuilder {
	return &_BACnetConstructedDataMinimumOnTimeBuilder{_BACnetConstructedDataMinimumOnTime: new(_BACnetConstructedDataMinimumOnTime)}
}

type _BACnetConstructedDataMinimumOnTimeBuilder struct {
	*_BACnetConstructedDataMinimumOnTime

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataMinimumOnTimeBuilder) = (*_BACnetConstructedDataMinimumOnTimeBuilder)(nil)

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMinimumOnTime
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) WithMandatoryFields(minimumOnTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMinimumOnTimeBuilder {
	return b.WithMinimumOnTime(minimumOnTime)
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) WithMinimumOnTime(minimumOnTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataMinimumOnTimeBuilder {
	b.MinimumOnTime = minimumOnTime
	return b
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) WithMinimumOnTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataMinimumOnTimeBuilder {
	builder := builderSupplier(b.MinimumOnTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.MinimumOnTime, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) Build() (BACnetConstructedDataMinimumOnTime, error) {
	if b.MinimumOnTime == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'minimumOnTime' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataMinimumOnTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) MustBuild() BACnetConstructedDataMinimumOnTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMinimumOnTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMinimumOnTimeBuilder().(*_BACnetConstructedDataMinimumOnTimeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataMinimumOnTimeBuilder creates a BACnetConstructedDataMinimumOnTimeBuilder
func (b *_BACnetConstructedDataMinimumOnTime) CreateBACnetConstructedDataMinimumOnTimeBuilder() BACnetConstructedDataMinimumOnTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataMinimumOnTimeBuilder()
	}
	return &_BACnetConstructedDataMinimumOnTimeBuilder{_BACnetConstructedDataMinimumOnTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMinimumOnTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMinimumOnTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MINIMUM_ON_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMinimumOnTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMinimumOnTime) GetMinimumOnTime() BACnetApplicationTagUnsignedInteger {
	return m.MinimumOnTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMinimumOnTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetMinimumOnTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMinimumOnTime(structType any) BACnetConstructedDataMinimumOnTime {
	if casted, ok := structType.(BACnetConstructedDataMinimumOnTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMinimumOnTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMinimumOnTime) GetTypeName() string {
	return "BACnetConstructedDataMinimumOnTime"
}

func (m *_BACnetConstructedDataMinimumOnTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (minimumOnTime)
	lengthInBits += m.MinimumOnTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMinimumOnTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMinimumOnTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMinimumOnTime BACnetConstructedDataMinimumOnTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMinimumOnTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMinimumOnTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	minimumOnTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "minimumOnTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minimumOnTime' field"))
	}
	m.MinimumOnTime = minimumOnTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), minimumOnTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMinimumOnTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMinimumOnTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMinimumOnTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMinimumOnTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMinimumOnTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMinimumOnTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "minimumOnTime", m.GetMinimumOnTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'minimumOnTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMinimumOnTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMinimumOnTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMinimumOnTime) IsBACnetConstructedDataMinimumOnTime() {}

func (m *_BACnetConstructedDataMinimumOnTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMinimumOnTime) deepCopy() *_BACnetConstructedDataMinimumOnTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMinimumOnTimeCopy := &_BACnetConstructedDataMinimumOnTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.MinimumOnTime),
	}
	_BACnetConstructedDataMinimumOnTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMinimumOnTimeCopy
}

func (m *_BACnetConstructedDataMinimumOnTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
