/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAllowGroupDelayInhibit is the corresponding interface of BACnetConstructedDataAllowGroupDelayInhibit
type BACnetConstructedDataAllowGroupDelayInhibit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAllowGroupDelayInhibit returns AllowGroupDelayInhibit (property field)
	GetAllowGroupDelayInhibit() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataAllowGroupDelayInhibit is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAllowGroupDelayInhibit()
	// CreateBuilder creates a BACnetConstructedDataAllowGroupDelayInhibitBuilder
	CreateBACnetConstructedDataAllowGroupDelayInhibitBuilder() BACnetConstructedDataAllowGroupDelayInhibitBuilder
}

// _BACnetConstructedDataAllowGroupDelayInhibit is the data-structure of this message
type _BACnetConstructedDataAllowGroupDelayInhibit struct {
	BACnetConstructedDataContract
	AllowGroupDelayInhibit BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataAllowGroupDelayInhibit = (*_BACnetConstructedDataAllowGroupDelayInhibit)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAllowGroupDelayInhibit)(nil)

// NewBACnetConstructedDataAllowGroupDelayInhibit factory function for _BACnetConstructedDataAllowGroupDelayInhibit
func NewBACnetConstructedDataAllowGroupDelayInhibit(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, allowGroupDelayInhibit BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAllowGroupDelayInhibit {
	if allowGroupDelayInhibit == nil {
		panic("allowGroupDelayInhibit of type BACnetApplicationTagBoolean for BACnetConstructedDataAllowGroupDelayInhibit must not be nil")
	}
	_result := &_BACnetConstructedDataAllowGroupDelayInhibit{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AllowGroupDelayInhibit:        allowGroupDelayInhibit,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAllowGroupDelayInhibitBuilder is a builder for BACnetConstructedDataAllowGroupDelayInhibit
type BACnetConstructedDataAllowGroupDelayInhibitBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(allowGroupDelayInhibit BACnetApplicationTagBoolean) BACnetConstructedDataAllowGroupDelayInhibitBuilder
	// WithAllowGroupDelayInhibit adds AllowGroupDelayInhibit (property field)
	WithAllowGroupDelayInhibit(BACnetApplicationTagBoolean) BACnetConstructedDataAllowGroupDelayInhibitBuilder
	// WithAllowGroupDelayInhibitBuilder adds AllowGroupDelayInhibit (property field) which is build by the builder
	WithAllowGroupDelayInhibitBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataAllowGroupDelayInhibitBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAllowGroupDelayInhibit or returns an error if something is wrong
	Build() (BACnetConstructedDataAllowGroupDelayInhibit, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAllowGroupDelayInhibit
}

// NewBACnetConstructedDataAllowGroupDelayInhibitBuilder() creates a BACnetConstructedDataAllowGroupDelayInhibitBuilder
func NewBACnetConstructedDataAllowGroupDelayInhibitBuilder() BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	return &_BACnetConstructedDataAllowGroupDelayInhibitBuilder{_BACnetConstructedDataAllowGroupDelayInhibit: new(_BACnetConstructedDataAllowGroupDelayInhibit)}
}

type _BACnetConstructedDataAllowGroupDelayInhibitBuilder struct {
	*_BACnetConstructedDataAllowGroupDelayInhibit

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataAllowGroupDelayInhibitBuilder) = (*_BACnetConstructedDataAllowGroupDelayInhibitBuilder)(nil)

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAllowGroupDelayInhibit
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) WithMandatoryFields(allowGroupDelayInhibit BACnetApplicationTagBoolean) BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	return b.WithAllowGroupDelayInhibit(allowGroupDelayInhibit)
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) WithAllowGroupDelayInhibit(allowGroupDelayInhibit BACnetApplicationTagBoolean) BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	b.AllowGroupDelayInhibit = allowGroupDelayInhibit
	return b
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) WithAllowGroupDelayInhibitBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	builder := builderSupplier(b.AllowGroupDelayInhibit.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.AllowGroupDelayInhibit, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) Build() (BACnetConstructedDataAllowGroupDelayInhibit, error) {
	if b.AllowGroupDelayInhibit == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'allowGroupDelayInhibit' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataAllowGroupDelayInhibit.deepCopy(), nil
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) MustBuild() BACnetConstructedDataAllowGroupDelayInhibit {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAllowGroupDelayInhibitBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAllowGroupDelayInhibitBuilder().(*_BACnetConstructedDataAllowGroupDelayInhibitBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataAllowGroupDelayInhibitBuilder creates a BACnetConstructedDataAllowGroupDelayInhibitBuilder
func (b *_BACnetConstructedDataAllowGroupDelayInhibit) CreateBACnetConstructedDataAllowGroupDelayInhibitBuilder() BACnetConstructedDataAllowGroupDelayInhibitBuilder {
	if b == nil {
		return NewBACnetConstructedDataAllowGroupDelayInhibitBuilder()
	}
	return &_BACnetConstructedDataAllowGroupDelayInhibitBuilder{_BACnetConstructedDataAllowGroupDelayInhibit: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALLOW_GROUP_DELAY_INHIBIT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetAllowGroupDelayInhibit() BACnetApplicationTagBoolean {
	return m.AllowGroupDelayInhibit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetAllowGroupDelayInhibit())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAllowGroupDelayInhibit(structType any) BACnetConstructedDataAllowGroupDelayInhibit {
	if casted, ok := structType.(BACnetConstructedDataAllowGroupDelayInhibit); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAllowGroupDelayInhibit); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetTypeName() string {
	return "BACnetConstructedDataAllowGroupDelayInhibit"
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (allowGroupDelayInhibit)
	lengthInBits += m.AllowGroupDelayInhibit.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAllowGroupDelayInhibit BACnetConstructedDataAllowGroupDelayInhibit, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAllowGroupDelayInhibit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAllowGroupDelayInhibit")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	allowGroupDelayInhibit, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "allowGroupDelayInhibit", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'allowGroupDelayInhibit' field"))
	}
	m.AllowGroupDelayInhibit = allowGroupDelayInhibit

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), allowGroupDelayInhibit)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAllowGroupDelayInhibit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAllowGroupDelayInhibit")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAllowGroupDelayInhibit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAllowGroupDelayInhibit")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "allowGroupDelayInhibit", m.GetAllowGroupDelayInhibit(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'allowGroupDelayInhibit' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAllowGroupDelayInhibit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAllowGroupDelayInhibit")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) IsBACnetConstructedDataAllowGroupDelayInhibit() {
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) deepCopy() *_BACnetConstructedDataAllowGroupDelayInhibit {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAllowGroupDelayInhibitCopy := &_BACnetConstructedDataAllowGroupDelayInhibit{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.AllowGroupDelayInhibit),
	}
	_BACnetConstructedDataAllowGroupDelayInhibitCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAllowGroupDelayInhibitCopy
}

func (m *_BACnetConstructedDataAllowGroupDelayInhibit) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
