/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetApplicationTagDate is the corresponding interface of BACnetApplicationTagDate
type BACnetApplicationTagDate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetApplicationTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadDate
	// IsBACnetApplicationTagDate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetApplicationTagDate()
	// CreateBuilder creates a BACnetApplicationTagDateBuilder
	CreateBACnetApplicationTagDateBuilder() BACnetApplicationTagDateBuilder
}

// _BACnetApplicationTagDate is the data-structure of this message
type _BACnetApplicationTagDate struct {
	BACnetApplicationTagContract
	Payload BACnetTagPayloadDate
}

var _ BACnetApplicationTagDate = (*_BACnetApplicationTagDate)(nil)
var _ BACnetApplicationTagRequirements = (*_BACnetApplicationTagDate)(nil)

// NewBACnetApplicationTagDate factory function for _BACnetApplicationTagDate
func NewBACnetApplicationTagDate(header BACnetTagHeader, payload BACnetTagPayloadDate) *_BACnetApplicationTagDate {
	if payload == nil {
		panic("payload of type BACnetTagPayloadDate for BACnetApplicationTagDate must not be nil")
	}
	_result := &_BACnetApplicationTagDate{
		BACnetApplicationTagContract: NewBACnetApplicationTag(header),
		Payload:                      payload,
	}
	_result.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetApplicationTagDateBuilder is a builder for BACnetApplicationTagDate
type BACnetApplicationTagDateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadDate) BACnetApplicationTagDateBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadDate) BACnetApplicationTagDateBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadDateBuilder) BACnetTagPayloadDateBuilder) BACnetApplicationTagDateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetApplicationTagBuilder
	// Build builds the BACnetApplicationTagDate or returns an error if something is wrong
	Build() (BACnetApplicationTagDate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetApplicationTagDate
}

// NewBACnetApplicationTagDateBuilder() creates a BACnetApplicationTagDateBuilder
func NewBACnetApplicationTagDateBuilder() BACnetApplicationTagDateBuilder {
	return &_BACnetApplicationTagDateBuilder{_BACnetApplicationTagDate: new(_BACnetApplicationTagDate)}
}

type _BACnetApplicationTagDateBuilder struct {
	*_BACnetApplicationTagDate

	parentBuilder *_BACnetApplicationTagBuilder

	collectedErr []error
}

var _ (BACnetApplicationTagDateBuilder) = (*_BACnetApplicationTagDateBuilder)(nil)

func (b *_BACnetApplicationTagDateBuilder) setParent(contract BACnetApplicationTagContract) {
	b.BACnetApplicationTagContract = contract
	contract.(*_BACnetApplicationTag)._SubType = b._BACnetApplicationTagDate
}

func (b *_BACnetApplicationTagDateBuilder) WithMandatoryFields(payload BACnetTagPayloadDate) BACnetApplicationTagDateBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetApplicationTagDateBuilder) WithPayload(payload BACnetTagPayloadDate) BACnetApplicationTagDateBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetApplicationTagDateBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadDateBuilder) BACnetTagPayloadDateBuilder) BACnetApplicationTagDateBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadDateBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagPayloadDateBuilder failed"))
	}
	return b
}

func (b *_BACnetApplicationTagDateBuilder) Build() (BACnetApplicationTagDate, error) {
	if b.Payload == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'payload' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetApplicationTagDate.deepCopy(), nil
}

func (b *_BACnetApplicationTagDateBuilder) MustBuild() BACnetApplicationTagDate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetApplicationTagDateBuilder) Done() BACnetApplicationTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetApplicationTagBuilder().(*_BACnetApplicationTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetApplicationTagDateBuilder) buildForBACnetApplicationTag() (BACnetApplicationTag, error) {
	return b.Build()
}

func (b *_BACnetApplicationTagDateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetApplicationTagDateBuilder().(*_BACnetApplicationTagDateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetApplicationTagDateBuilder creates a BACnetApplicationTagDateBuilder
func (b *_BACnetApplicationTagDate) CreateBACnetApplicationTagDateBuilder() BACnetApplicationTagDateBuilder {
	if b == nil {
		return NewBACnetApplicationTagDateBuilder()
	}
	return &_BACnetApplicationTagDateBuilder{_BACnetApplicationTagDate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetApplicationTagDate) GetParent() BACnetApplicationTagContract {
	return m.BACnetApplicationTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetApplicationTagDate) GetPayload() BACnetTagPayloadDate {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetApplicationTagDate(structType any) BACnetApplicationTagDate {
	if casted, ok := structType.(BACnetApplicationTagDate); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetApplicationTagDate); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetApplicationTagDate) GetTypeName() string {
	return "BACnetApplicationTagDate"
}

func (m *_BACnetApplicationTagDate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetApplicationTagContract.(*_BACnetApplicationTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetApplicationTagDate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetApplicationTagDate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetApplicationTag) (__bACnetApplicationTagDate BACnetApplicationTagDate, err error) {
	m.BACnetApplicationTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetApplicationTagDate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetApplicationTagDate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadDate](ctx, "payload", ReadComplex[BACnetTagPayloadDate](BACnetTagPayloadDateParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	if closeErr := readBuffer.CloseContext("BACnetApplicationTagDate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetApplicationTagDate")
	}

	return m, nil
}

func (m *_BACnetApplicationTagDate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetApplicationTagDate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetApplicationTagDate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetApplicationTagDate")
		}

		if err := WriteSimpleField[BACnetTagPayloadDate](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadDate](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("BACnetApplicationTagDate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetApplicationTagDate")
		}
		return nil
	}
	return m.BACnetApplicationTagContract.(*_BACnetApplicationTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetApplicationTagDate) IsBACnetApplicationTagDate() {}

func (m *_BACnetApplicationTagDate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetApplicationTagDate) deepCopy() *_BACnetApplicationTagDate {
	if m == nil {
		return nil
	}
	_BACnetApplicationTagDateCopy := &_BACnetApplicationTagDate{
		m.BACnetApplicationTagContract.(*_BACnetApplicationTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadDate](m.Payload),
	}
	_BACnetApplicationTagDateCopy.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = m
	return _BACnetApplicationTagDateCopy
}

func (m *_BACnetApplicationTagDate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
