/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CIPEncapsulationConnectionResponse is the corresponding interface of CIPEncapsulationConnectionResponse
type CIPEncapsulationConnectionResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CIPEncapsulationPacket
	// IsCIPEncapsulationConnectionResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCIPEncapsulationConnectionResponse()
	// CreateBuilder creates a CIPEncapsulationConnectionResponseBuilder
	CreateCIPEncapsulationConnectionResponseBuilder() CIPEncapsulationConnectionResponseBuilder
}

// _CIPEncapsulationConnectionResponse is the data-structure of this message
type _CIPEncapsulationConnectionResponse struct {
	CIPEncapsulationPacketContract
}

var _ CIPEncapsulationConnectionResponse = (*_CIPEncapsulationConnectionResponse)(nil)
var _ CIPEncapsulationPacketRequirements = (*_CIPEncapsulationConnectionResponse)(nil)

// NewCIPEncapsulationConnectionResponse factory function for _CIPEncapsulationConnectionResponse
func NewCIPEncapsulationConnectionResponse(sessionHandle uint32, status uint32, senderContext []uint8, options uint32) *_CIPEncapsulationConnectionResponse {
	_result := &_CIPEncapsulationConnectionResponse{
		CIPEncapsulationPacketContract: NewCIPEncapsulationPacket(sessionHandle, status, senderContext, options),
	}
	_result.CIPEncapsulationPacketContract.(*_CIPEncapsulationPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CIPEncapsulationConnectionResponseBuilder is a builder for CIPEncapsulationConnectionResponse
type CIPEncapsulationConnectionResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() CIPEncapsulationConnectionResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CIPEncapsulationPacketBuilder
	// Build builds the CIPEncapsulationConnectionResponse or returns an error if something is wrong
	Build() (CIPEncapsulationConnectionResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CIPEncapsulationConnectionResponse
}

// NewCIPEncapsulationConnectionResponseBuilder() creates a CIPEncapsulationConnectionResponseBuilder
func NewCIPEncapsulationConnectionResponseBuilder() CIPEncapsulationConnectionResponseBuilder {
	return &_CIPEncapsulationConnectionResponseBuilder{_CIPEncapsulationConnectionResponse: new(_CIPEncapsulationConnectionResponse)}
}

type _CIPEncapsulationConnectionResponseBuilder struct {
	*_CIPEncapsulationConnectionResponse

	parentBuilder *_CIPEncapsulationPacketBuilder

	collectedErr []error
}

var _ (CIPEncapsulationConnectionResponseBuilder) = (*_CIPEncapsulationConnectionResponseBuilder)(nil)

func (b *_CIPEncapsulationConnectionResponseBuilder) setParent(contract CIPEncapsulationPacketContract) {
	b.CIPEncapsulationPacketContract = contract
	contract.(*_CIPEncapsulationPacket)._SubType = b._CIPEncapsulationConnectionResponse
}

func (b *_CIPEncapsulationConnectionResponseBuilder) WithMandatoryFields() CIPEncapsulationConnectionResponseBuilder {
	return b
}

func (b *_CIPEncapsulationConnectionResponseBuilder) Build() (CIPEncapsulationConnectionResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CIPEncapsulationConnectionResponse.deepCopy(), nil
}

func (b *_CIPEncapsulationConnectionResponseBuilder) MustBuild() CIPEncapsulationConnectionResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CIPEncapsulationConnectionResponseBuilder) Done() CIPEncapsulationPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCIPEncapsulationPacketBuilder().(*_CIPEncapsulationPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_CIPEncapsulationConnectionResponseBuilder) buildForCIPEncapsulationPacket() (CIPEncapsulationPacket, error) {
	return b.Build()
}

func (b *_CIPEncapsulationConnectionResponseBuilder) DeepCopy() any {
	_copy := b.CreateCIPEncapsulationConnectionResponseBuilder().(*_CIPEncapsulationConnectionResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCIPEncapsulationConnectionResponseBuilder creates a CIPEncapsulationConnectionResponseBuilder
func (b *_CIPEncapsulationConnectionResponse) CreateCIPEncapsulationConnectionResponseBuilder() CIPEncapsulationConnectionResponseBuilder {
	if b == nil {
		return NewCIPEncapsulationConnectionResponseBuilder()
	}
	return &_CIPEncapsulationConnectionResponseBuilder{_CIPEncapsulationConnectionResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CIPEncapsulationConnectionResponse) GetCommandType() uint16 {
	return 0x0201
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CIPEncapsulationConnectionResponse) GetParent() CIPEncapsulationPacketContract {
	return m.CIPEncapsulationPacketContract
}

// Deprecated: use the interface for direct cast
func CastCIPEncapsulationConnectionResponse(structType any) CIPEncapsulationConnectionResponse {
	if casted, ok := structType.(CIPEncapsulationConnectionResponse); ok {
		return casted
	}
	if casted, ok := structType.(*CIPEncapsulationConnectionResponse); ok {
		return *casted
	}
	return nil
}

func (m *_CIPEncapsulationConnectionResponse) GetTypeName() string {
	return "CIPEncapsulationConnectionResponse"
}

func (m *_CIPEncapsulationConnectionResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CIPEncapsulationPacketContract.(*_CIPEncapsulationPacket).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_CIPEncapsulationConnectionResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CIPEncapsulationConnectionResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CIPEncapsulationPacket) (__cIPEncapsulationConnectionResponse CIPEncapsulationConnectionResponse, err error) {
	m.CIPEncapsulationPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CIPEncapsulationConnectionResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CIPEncapsulationConnectionResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("CIPEncapsulationConnectionResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CIPEncapsulationConnectionResponse")
	}

	return m, nil
}

func (m *_CIPEncapsulationConnectionResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CIPEncapsulationConnectionResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CIPEncapsulationConnectionResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CIPEncapsulationConnectionResponse")
		}

		if popErr := writeBuffer.PopContext("CIPEncapsulationConnectionResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CIPEncapsulationConnectionResponse")
		}
		return nil
	}
	return m.CIPEncapsulationPacketContract.(*_CIPEncapsulationPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CIPEncapsulationConnectionResponse) IsCIPEncapsulationConnectionResponse() {}

func (m *_CIPEncapsulationConnectionResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CIPEncapsulationConnectionResponse) deepCopy() *_CIPEncapsulationConnectionResponse {
	if m == nil {
		return nil
	}
	_CIPEncapsulationConnectionResponseCopy := &_CIPEncapsulationConnectionResponse{
		m.CIPEncapsulationPacketContract.(*_CIPEncapsulationPacket).deepCopy(),
	}
	_CIPEncapsulationConnectionResponseCopy.CIPEncapsulationPacketContract.(*_CIPEncapsulationPacket)._SubType = m
	return _CIPEncapsulationConnectionResponseCopy
}

func (m *_CIPEncapsulationConnectionResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
