/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.xobject.XObjectValidator;

public abstract class AbstractXObjValidator
implements XObjectValidator {
    protected COSStream xobject = null;
    protected PreflightContext context = null;

    public AbstractXObjValidator(PreflightContext context, COSStream xobj) {
        this.xobject = xobj;
        this.context = context;
    }

    protected void checkSMask() {
        COSBase smask = this.xobject.getDictionaryObject(COSName.SMASK);
        if (smask != null && !COSName.NONE.equals((Object)smask)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.2.2", "Soft Mask must be null or None [" + this.xobject.toString() + "]"));
        }
    }

    protected void checkOPI() {
        if (this.xobject.getItem(COSName.getPDFName((String)"OPI")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'OPI' Key"));
        }
    }

    protected void checkReferenceXObject() {
        if (this.xobject.getItem("Ref") != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "No reference XObject allowed in PDF/A"));
        }
    }

    protected void checkPostscriptXObject() {
        COSName subtype = this.xobject.getCOSName(COSName.SUBTYPE);
        if (COSName.PS.equals((Object)subtype)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "No Postscript XObject allowed in PDF/A"));
        } else if (this.xobject.getItem(COSName.getPDFName((String)"Subtype2")) != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "No Postscript XObject allowed in PDF/A (Subtype2)"));
        }
    }

    protected abstract void checkMandatoryFields();

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryFields();
        this.checkOPI();
        this.checkSMask();
        this.checkReferenceXObject();
        this.checkPostscriptXObject();
    }
}

