/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.apache.taglibs.standard.lang.jstl.ArithmeticOperator;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.EqualityOperator;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.PrimitiveObjects;
import org.apache.taglibs.standard.lang.jstl.RelationalOperator;

public class Coercions {
    public static Object coerce(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pClass == String.class) {
            return Coercions.coerceToString(pValue, pLogger);
        }
        if (Coercions.isPrimitiveNumberClass(pClass)) {
            return Coercions.coerceToPrimitiveNumber(pValue, pClass, pLogger);
        }
        if (pClass == Character.class || pClass == Character.TYPE) {
            return Coercions.coerceToCharacter(pValue, pLogger);
        }
        if (pClass == Boolean.class || pClass == Boolean.TYPE) {
            return Coercions.coerceToBoolean(pValue, pLogger);
        }
        return Coercions.coerceToObject(pValue, pClass, pLogger);
    }

    static boolean isPrimitiveNumberClass(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE || pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE;
    }

    public static String coerceToString(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.TOSTRING_EXCEPTION, exc, (Object)pValue.getClass().getName());
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object pValue, Class pClass, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Coercions.coerceToPrimitiveNumber(0L, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return Coercions.coerceToPrimitiveNumber((short)val, pClass);
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.BOOLEAN_TO_NUMBER, pValue, (Object)pClass.getName());
            }
            return Coercions.coerceToPrimitiveNumber(0L, pClass);
        }
        if (pValue.getClass() == pClass) {
            return (Number)pValue;
        }
        if (pValue instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)pValue, pClass);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, (Object)pClass.getName());
                }
                return Coercions.coerceToPrimitiveNumber(0L, pClass);
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), (Object)pClass.getName());
        }
        return Coercions.coerceToPrimitiveNumber(0L, pClass);
    }

    public static Integer coerceToInteger(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)pValue).charValue());
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.BOOLEAN_TO_NUMBER, pValue, (Object)Integer.class.getName());
            }
            return PrimitiveObjects.getInteger((Boolean)pValue != false ? 1 : 0);
        }
        if (pValue instanceof Integer) {
            return (Integer)pValue;
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)pValue).intValue());
        }
        if (pValue instanceof String) {
            try {
                return Integer.valueOf((String)pValue);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingWarning()) {
                    pLogger.logWarning(Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, (Object)Integer.class.getName());
                }
                return null;
            }
        }
        if (pLogger.isLoggingWarning()) {
            pLogger.logWarning(Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), (Object)Integer.class.getName());
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong((long)pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return PrimitiveObjects.getByte(pValue.byteValue());
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return PrimitiveObjects.getShort(pValue.shortValue());
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return PrimitiveObjects.getInteger(pValue.intValue());
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return PrimitiveObjects.getLong(pValue.longValue());
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return PrimitiveObjects.getFloat(pValue.floatValue());
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return PrimitiveObjects.getDouble(pValue.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return Byte.valueOf(pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return Short.valueOf(pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return Integer.valueOf(pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return Long.valueOf(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return Float.valueOf(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return Double.valueOf(pValue);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Character) {
            return (Character)pValue;
        }
        if (pValue instanceof Boolean) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.BOOLEAN_TO_CHARACTER, pValue);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)pValue).shortValue());
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return PrimitiveObjects.getCharacter(str.charAt(0));
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_CHARACTER, pValue.getClass().getName());
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object pValue, Logger pLogger) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.STRING_TO_BOOLEAN, exc, (Object)((String)pValue));
                }
                return Boolean.FALSE;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_BOOLEAN, pValue.getClass().getName());
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object pValue, Class<?> pClass, Logger pLogger) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pClass.isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            PropertyEditor pe = PropertyEditorManager.findEditor(pClass);
            if (pe == null) {
                if ("".equals(str)) {
                    return null;
                }
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.NO_PROPERTY_EDITOR, str, (Object)pClass.getName());
                }
                return null;
            }
            try {
                pe.setAsText(str);
                return pe.getValue();
            }
            catch (IllegalArgumentException exc) {
                if ("".equals(str)) {
                    return null;
                }
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.PROPERTY_EDITOR_ERROR, exc, pValue, (Object)pClass.getName());
                }
                return null;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.COERCE_TO_OBJECT, pValue.getClass().getName(), (Object)pClass.getName());
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object pLeft, Object pRight, ArithmeticOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, pOperator.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pLeft) || Coercions.isFloatingPointString(pRight)) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getDouble(pOperator.apply(left, right, pLogger));
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
        return PrimitiveObjects.getLong(pOperator.apply(left, right, pLogger));
    }

    public static Object applyRelationalOperator(Object pLeft, Object pRight, RelationalOperator pOperator, Logger pLogger) throws ELException {
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right, pLogger));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
            long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right, pLogger));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left, right, pLogger));
        }
        if (pLeft instanceof Comparable) {
            try {
                int result = ((Comparable)pLeft).compareTo(pRight);
                return PrimitiveObjects.getBoolean(pOperator.apply(result, -result, pLogger));
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.COMPARABLE_ERROR, exc, (Object)pLeft.getClass().getName(), (Object)(pRight == null ? "null" : pRight.getClass().getName()), (Object)pOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (pRight instanceof Comparable) {
            try {
                int result = ((Comparable)pRight).compareTo(pLeft);
                return PrimitiveObjects.getBoolean(pOperator.apply(-result, result, pLogger));
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.COMPARABLE_ERROR, exc, (Object)pRight.getClass().getName(), (Object)(pLeft == null ? "null" : pLeft.getClass().getName()), (Object)pOperator.getOperatorSymbol());
                }
                return Boolean.FALSE;
            }
        }
        if (pLogger.isLoggingError()) {
            pLogger.logError(Constants.ARITH_OP_BAD_TYPE, pOperator.getOperatorSymbol(), (Object)pLeft.getClass().getName(), (Object)pRight.getClass().getName());
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object pLeft, Object pRight, EqualityOperator pOperator, Logger pLogger) throws ELException {
        if (pLeft == pRight) {
            return PrimitiveObjects.getBoolean(pOperator.apply(true, pLogger));
        }
        if (pLeft == null || pRight == null) {
            return PrimitiveObjects.getBoolean(pOperator.apply(false, pLogger));
        }
        if (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointType(pRight)) {
            double right;
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue()), pLogger));
        }
        if (Coercions.isIntegerType(pLeft) || Coercions.isIntegerType(pRight)) {
            long right;
            long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue()), pLogger));
        }
        if (pLeft instanceof Boolean || pRight instanceof Boolean) {
            boolean right;
            boolean left = Coercions.coerceToBoolean(pLeft, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left == (right = Coercions.coerceToBoolean(pRight, pLogger).booleanValue()), pLogger));
        }
        if (pLeft instanceof String || pRight instanceof String) {
            String left = Coercions.coerceToString(pLeft, pLogger);
            String right = Coercions.coerceToString(pRight, pLogger);
            return PrimitiveObjects.getBoolean(pOperator.apply(left.equals(right), pLogger));
        }
        try {
            return PrimitiveObjects.getBoolean(pOperator.apply(pLeft.equals(pRight), pLogger));
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ERROR_IN_EQUALS, exc, (Object)pLeft.getClass().getName(), (Object)pRight.getClass().getName(), (Object)pOperator.getOperatorSymbol());
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && Coercions.isFloatingPointType(pObject.getClass());
    }

    public static boolean isFloatingPointType(Class pClass) {
        return pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch != '.' && ch != 'e' && ch != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object pObject) {
        return pObject != null && Coercions.isIntegerType(pObject.getClass());
    }

    public static boolean isIntegerType(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Character.class || pClass == Character.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE;
    }
}

