/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crtcore;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.utils.async.ByteBufferStoringSubscriber;

@SdkProtectedApi
public final class CrtRequestBodyAdapter
implements HttpRequestBodyStream {
    private static final int BUFFER_SIZE = 0x400000;
    private final Publisher<ByteBuffer> requestPublisher;
    private final long contentLength;
    private ByteBufferStoringSubscriber requestBodySubscriber;

    public CrtRequestBodyAdapter(Publisher<ByteBuffer> requestPublisher, long contentLength) {
        this.requestPublisher = requestPublisher;
        this.contentLength = contentLength;
        this.requestBodySubscriber = new ByteBufferStoringSubscriber(0x400000L);
    }

    public boolean sendRequestBody(ByteBuffer bodyBytesOut) {
        return this.requestBodySubscriber.transferTo(bodyBytesOut) == ByteBufferStoringSubscriber.TransferResult.END_OF_STREAM;
    }

    public boolean resetPosition() {
        this.requestBodySubscriber = new ByteBufferStoringSubscriber(0x400000L);
        this.requestPublisher.subscribe((Subscriber)this.requestBodySubscriber);
        return true;
    }

    public long getLength() {
        return this.contentLength;
    }
}

