/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderUsage;
import org.apache.nifi.registry.security.authentication.UsernamePasswordAuthenticationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicAuthIdentityProvider
implements IdentityProvider {
    public static final String AUTHORIZATION = "Authorization";
    public static final String BASIC = "Basic ";
    private static final Logger logger = LoggerFactory.getLogger(BasicAuthIdentityProvider.class);
    private static final IdentityProviderUsage usage = new IdentityProviderUsage(){

        @Override
        public String getText() {
            return "The user credentials must be passed in standard HTTP Basic Auth format. That is: 'Authorization: Basic <credentials>', where <credentials> is the base64 encoded value of '<username>:<password>'.";
        }

        @Override
        public IdentityProviderUsage.AuthType getAuthType() {
            return IdentityProviderUsage.AuthType.BASIC;
        }
    };

    @Override
    public IdentityProviderUsage getUsageInstructions() {
        return usage;
    }

    @Override
    public AuthenticationRequest extractCredentials(HttpServletRequest servletRequest) {
        UsernamePasswordAuthenticationRequest authenticationRequest;
        if (servletRequest == null) {
            logger.debug("Cannot extract user credentials from null servletRequest");
            return null;
        }
        if (!servletRequest.isSecure()) {
            return null;
        }
        String authorization = servletRequest.getHeader(AUTHORIZATION);
        if (authorization == null || !authorization.startsWith(BASIC)) {
            logger.debug("HTTP Basic Auth credentials not present. Not attempting to extract credentials for authentication.");
            return null;
        }
        try {
            String base64Credentials = authorization.substring(BASIC.length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            String[] credentialParts = credentials.split(":", 2);
            String username = credentialParts[0];
            String password = credentialParts[1];
            authenticationRequest = new UsernamePasswordAuthenticationRequest(username, password);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            logger.info("Failed to extract user identity credentials.");
            logger.debug("", (Throwable)e);
            return null;
        }
        return authenticationRequest;
    }

    @Override
    public boolean supports(Class<? extends AuthenticationRequest> authenticationRequestClazz) {
        return UsernamePasswordAuthenticationRequest.class.isAssignableFrom(authenticationRequestClazz);
    }
}

