/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * RevertCommitPanel.java
 *
 * Created on May 25, 2011, 2:28:01 PM
 */
package org.netbeans.modules.git.ui.revert;

import org.netbeans.modules.git.ui.repository.RevisionDialog;

/**
 *
 * @author ondra
 */
public class RevertCommitPanel extends javax.swing.JPanel {
    private final RevisionDialog revisionPanel;

    /** Creates new form RevertCommitPanel */
    public RevertCommitPanel (RevisionDialog revisionPanel) {
        this.revisionPanel = revisionPanel;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        org.netbeans.modules.git.ui.repository.RevisionDialog revisionDialog1 = revisionPanel;
        jScrollPane1 = new javax.swing.JScrollPane();
        lblCommitMessage = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(RevertCommitPanel.class, "RevertCommitPanel.jLabel1.text")); // NOI18N

        cbCommit.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(cbCommit, org.openide.util.NbBundle.getMessage(RevertCommitPanel.class, "RevertCommitPanel.cbCommit.text")); // NOI18N
        cbCommit.setToolTipText(org.openide.util.NbBundle.getMessage(RevertCommitPanel.class, "RevertCommitPanel.cbCommit.TTtext")); // NOI18N

        txtCommitMessage.setColumns(20);
        txtCommitMessage.setLineWrap(true);
        txtCommitMessage.setRows(5);
        txtCommitMessage.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtCommitMessage);

        lblMessageWarning.setIcon(org.openide.util.ImageUtilities.loadImageIcon("/org/netbeans/modules/git/resources/icons/info.png", false)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(lblMessageWarning, org.openide.util.NbBundle.getMessage(RevertCommitPanel.class, "RevertCommitPanel.lblMessageWarning.text")); // NOI18N

        lblCommitMessage.setLabelFor(txtCommitMessage);
        org.openide.awt.Mnemonics.setLocalizedText(lblCommitMessage, org.openide.util.NbBundle.getMessage(RevertCommitPanel.class, "RevertCommitPanel.lblCommitMessage.text")); // NOI18N

        javax.swing.GroupLayout commitMessagePanelLayout = new javax.swing.GroupLayout(commitMessagePanel);
        commitMessagePanel.setLayout(commitMessagePanelLayout);
        commitMessagePanelLayout.setHorizontalGroup(
            commitMessagePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commitMessagePanelLayout.createSequentialGroup()
                .addGroup(commitMessagePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblCommitMessage)
                    .addComponent(lblMessageWarning))
                .addContainerGap(24, Short.MAX_VALUE))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 429, Short.MAX_VALUE)
        );
        commitMessagePanelLayout.setVerticalGroup(
            commitMessagePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(commitMessagePanelLayout.createSequentialGroup()
                .addComponent(lblCommitMessage)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblMessageWarning)
                .addGap(0, 0, 0))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(cbCommit)
                            .addComponent(revisionDialog1, javax.swing.GroupLayout.DEFAULT_SIZE, 431, Short.MAX_VALUE))
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(commitMessagePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(14, 14, 14))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(revisionDialog1, javax.swing.GroupLayout.DEFAULT_SIZE, 202, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbCommit)
                .addGap(4, 4, 4)
                .addComponent(commitMessagePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JCheckBox cbCommit = new javax.swing.JCheckBox();
    final javax.swing.JPanel commitMessagePanel = new javax.swing.JPanel();
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblCommitMessage;
    final javax.swing.JLabel lblMessageWarning = new javax.swing.JLabel();
    final javax.swing.JTextArea txtCommitMessage = new javax.swing.JTextArea();
    // End of variables declaration//GEN-END:variables
}
