/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.PathElements;
import org.openide.filesystems.RefreshRequest;
import org.openide.util.Enumerations;
import org.openide.util.NbCollections;

public abstract class AbstractFileSystem
extends FileSystem {
    private static final long serialVersionUID = -3345098214331282438L;
    private static transient PathElements lastEnum;
    private transient AbstractFileObject root;
    private transient RefreshRequest refresher;
    protected List list;
    protected Change change;
    protected Transfer transfer;
    protected Info info;
    protected Attr attr;

    @Override
    public void refresh(boolean expected) {
        for (FileObject fileObject : NbCollections.iterable(this.getAbstractRoot().existingSubFiles(true))) {
            fileObject.refresh(expected);
        }
    }

    @Override
    public abstract String getDisplayName();

    @Override
    public FileObject getRoot() {
        return this.getAbstractRoot();
    }

    @Override
    public FileObject findResource(String name) {
        if (name.length() == 0) {
            return this.getAbstractRoot();
        }
        PathElements local = lastEnum;
        if (local == null || !local.getOriginalName().equals(name)) {
            lastEnum = local = new PathElements(name);
        }
        return this.getAbstractRoot().find(local.getEnumeration());
    }

    protected <T extends FileObject> Reference<T> createReference(T fo) {
        return new WeakReference<T>(fo);
    }

    protected final Reference<? extends FileObject> findReference(String resourceName) {
        if (resourceName.length() == 0) {
            return null;
        }
        Enumeration<String> tok = NbCollections.checkedEnumerationByFilter(new StringTokenizer(resourceName, "/"), String.class, true);
        return this.getAbstractRoot().findRefIfExists(tok);
    }

    boolean isEnabledRefreshFolder() {
        return this.refresher != null;
    }

    protected final synchronized void setRefreshTime(int ms) {
        if (this.refresher != null) {
            this.refresher.stop();
        }
        this.refresher = ms <= 0 || System.getProperty("netbeans.debug.heap") != null ? null : new RefreshRequest(this, ms);
    }

    protected final int getRefreshTime() {
        RefreshRequest r = this.refresher;
        return r == null ? 0 : r.getRefreshTime();
    }

    final synchronized AbstractFileObject refreshRootImpl() {
        if (this.root != null) {
            this.root.validFlag = false;
        }
        this.root = this.createFileObject(null, "");
        return this.root;
    }

    protected final FileObject refreshRoot() {
        return this.refreshRootImpl();
    }

    protected final void refreshResource(String name, boolean expected) {
        AbstractFileObject fo = (AbstractFileObject)this.findResourceIfExists(name);
        if (fo != null) {
            fo.refresh(null, null, true, expected);
        }
    }

    protected final Enumeration<? extends FileObject> existingFileObjects(FileObject fo) {
        return this.existingFileObjects((AbstractFolder)fo);
    }

    final Enumeration<? extends FileObject> existingFileObjects(AbstractFolder fo) {
        WeakReference<AbstractFolder> ref = new WeakReference<AbstractFolder>(fo);
        Enumeration<WeakReference<AbstractFolder>> singleEn = Enumerations.singleton(ref);
        class OnlyValidAndDeep
        implements Enumerations.Processor<Reference<AbstractFolder>, FileObject> {
            OnlyValidAndDeep() {
            }

            @Override
            public FileObject process(Reference<AbstractFolder> obj, Collection<Reference<AbstractFolder>> toAdd) {
                AbstractFolder file = obj.get();
                if (file != null) {
                    AbstractFolder[] arr = file.subfiles();
                    for (int i = 0; i < arr.length; ++i) {
                        toAdd.add(new WeakReference<AbstractFolder>(arr[i]));
                    }
                    return file.isValid() ? file : null;
                }
                return null;
            }
        }
        return Enumerations.removeNulls(Enumerations.queue(singleEn, new OnlyValidAndDeep()));
    }

    boolean isLastModifiedCacheEnabled() {
        return true;
    }

    private FileObject findResourceIfExists(String name) {
        if (name.length() == 0) {
            return this.getAbstractRoot();
        }
        Enumeration<String> tok = NbCollections.checkedEnumerationByFilter(new StringTokenizer(name, "/"), String.class, true);
        return this.getAbstractRoot().findIfExists(tok);
    }

    AbstractFileObject createFileObject(AbstractFileObject parent, String name) {
        return new AbstractFileObject(this, parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final AbstractFileObject getAbstractRoot() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            if (this.root == null) {
                return this.refreshRootImpl();
            }
        }
        return this.root;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("change", this.change);
        fields.put("info", this.info);
        fields.put("attr", this.attr);
        fields.put("list", this.list);
        fields.put("transfer", this.transfer);
        oos.writeFields();
        oos.writeInt(this.getRefreshTime());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = ois.readFields();
        Object o1 = AbstractFileSystem.readImpl("change", fields);
        Object o2 = AbstractFileSystem.readImpl("info", fields);
        Object o3 = AbstractFileSystem.readImpl("attr", fields);
        Object o4 = AbstractFileSystem.readImpl("list", fields);
        Object o5 = AbstractFileSystem.readImpl("transfer", fields);
        this.change = (Change)o1;
        this.info = (Info)o2;
        this.attr = (Attr)o3;
        this.list = (List)o4;
        this.transfer = (Transfer)o5;
        this.setRefreshTime(ois.readInt());
    }

    static Object readImpl(String name, ObjectInputStream.GetField fields) throws ClassNotFoundException, IOException {
        Object o = fields.get(name, null);
        if (o instanceof LocalFileSystem) {
            return new LocalFileSystem.Impl((LocalFileSystem)o);
        }
        if (o instanceof JarFileSystem) {
            return new JarFileSystem.Impl((JarFileSystem)o);
        }
        return o;
    }

    protected boolean checkVirtual(String name) {
        return false;
    }

    protected boolean canWrite(String name) {
        AbstractFileObject afo = (AbstractFileObject)this.findResource(name);
        return afo != null ? afo.superCanWrite() : false;
    }

    protected boolean canRead(String name) {
        AbstractFileObject afo = (AbstractFileObject)this.findResource(name);
        return afo != null ? afo.superCanRead() : false;
    }

    protected void markImportant(String name, boolean important) {
        if (!important && this.info != null) {
            this.info.markUnimportant(name);
        }
    }

    public static interface Change
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -5841597109944924596L;

        public void createFolder(String var1) throws IOException;

        public void createData(String var1) throws IOException;

        public void rename(String var1, String var2) throws IOException;

        public void delete(String var1) throws IOException;
    }

    public static interface Info
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -2438286177948307985L;

        public Date lastModified(String var1);

        public boolean folder(String var1);

        public boolean readOnly(String var1);

        public String mimeType(String var1);

        public long size(String var1);

        public InputStream inputStream(String var1) throws FileNotFoundException;

        public OutputStream outputStream(String var1) throws IOException;

        public void lock(String var1) throws IOException;

        public void unlock(String var1);

        public void markUnimportant(String var1);
    }

    public static interface Attr
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = 5978845941846736946L;

        public Object readAttribute(String var1, String var2);

        public void writeAttribute(String var1, String var2, Object var3) throws IOException;

        public Enumeration<String> attributes(String var1);

        public void renameAttributes(String var1, String var2);

        public void deleteAttributes(String var1);
    }

    public static interface List
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -6242105832891012528L;

        public String[] children(String var1);
    }

    public static interface Transfer
    extends Serializable {
        @Deprecated
        public static final long serialVersionUID = -8945397853892302838L;

        public boolean move(String var1, Transfer var2, String var3) throws IOException;

        public boolean copy(String var1, Transfer var2, String var3) throws IOException;
    }

    public static interface SymlinkInfo
    extends Serializable {
        public boolean isSymbolicLink(String var1) throws IOException;

        public String readSymbolicLink(String var1) throws IOException;

        public String getCanonicalName(String var1) throws IOException;
    }
}

