/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.ImportTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.base.imports.UnusedImports;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.FixDuplicateImportStmts;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class JavaFixAllImports {
    public static final String NOT_VALID_IMPORT_HTML = System.getProperty(JavaFixAllImports.class.getName() + ".invalid_import_html", "");
    private static final String PREFS_KEY = JavaFixAllImports.class.getName();
    private static final String KEY_REMOVE_UNUSED_IMPORTS = "removeUnusedImports";
    private static final JavaFixAllImports INSTANCE = new JavaFixAllImports();
    private static final RequestProcessor WORKER = new RequestProcessor(JavaFixAllImports.class.getName(), 1);

    public static JavaFixAllImports getDefault() {
        return INSTANCE;
    }

    private JavaFixAllImports() {
    }

    public void fixAllImports(FileObject fo, final JTextComponent target) {
        final AtomicBoolean cancel = new AtomicBoolean();
        final JavaSource javaSource = JavaSource.forFileObject(fo);
        final AtomicReference id = new AtomicReference();
        final Task<WorkingCopy> task = new Task<WorkingCopy>(){

            @Override
            public void run(WorkingCopy wc) {
                try {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    ImportData data = JavaFixAllImports.computeImports(wc);
                    if (cancel.get()) {
                        return;
                    }
                    if (data.shouldShowImportsPanel) {
                        if (!cancel.get()) {
                            id.set(data);
                        }
                    } else {
                        Preferences prefs = NbPreferences.forModule(JavaFixAllImports.class).node(PREFS_KEY);
                        boolean removeUnusedImports = prefs.getBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, true);
                        JavaFixAllImports.performFixImports(wc, data, data.defaults, removeUnusedImports);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        };
        if (javaSource == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaFixAllImports.class, "MSG_CannotFixImports"));
        } else {
            ProgressUtils.runOffEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModificationResult mr = javaSource.runModificationTask(task);
                        GeneratorUtils.guardedCommit(target, mr);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                }
            }, "Fix All Imports", cancel, false);
            if (id.get() != null && !cancel.get()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JavaFixAllImports.showFixImportsDialog(javaSource, target, (ImportData)id.get());
                    }
                });
            }
        }
    }

    private static List<TreePathHandle> getImportsFromSamePackage(WorkingCopy wc) {
        ImportVisitor v = new ImportVisitor(wc);
        v.scan(wc.getCompilationUnit(), null);
        return v.getImports();
    }

    private static void performFixImports(WorkingCopy wc, ImportData data, CandidateDescription[] selections, boolean removeUnusedImports) throws IOException {
        HashSet<Element> toImport = new HashSet<Element>();
        HashMap<Name, Element> useFQNsFor = new HashMap<Name, Element>();
        CodeStyle cs = CodeStyle.getDefault(wc.getDocument());
        for (CandidateDescription cd : selections) {
            Element el;
            Element element = el = cd.toImport != null ? cd.toImport.resolve(wc) : null;
            if (el == null) continue;
            if (cs.useFQNs()) {
                useFQNsFor.put(el.getSimpleName(), el);
                continue;
            }
            toImport.add(el);
        }
        CompilationUnitTree cut = wc.getCompilationUnit();
        if (!toImport.isEmpty()) {
            cut = GeneratorUtilities.get(wc).addImports(cut, toImport);
        }
        if (!useFQNsFor.isEmpty()) {
            new TreeVisitorImpl(wc, useFQNsFor).scan(cut, null);
        }
        boolean someImportsWereRemoved = false;
        if (removeUnusedImports) {
            List<TreePathHandle> unusedImports = UnusedImports.computeUnusedImports(wc);
            unusedImports.addAll(JavaFixAllImports.getImportsFromSamePackage(wc));
            someImportsWereRemoved = !unusedImports.isEmpty();
            for (TreePathHandle handle : unusedImports) {
                TreePath path = handle.resolve(wc);
                assert (path != null);
                cut = wc.getTreeMaker().removeCompUnitImport(cut, (ImportTree)path.getLeaf());
            }
        }
        wc.rewrite(wc.getCompilationUnit(), cut);
        if (!data.shouldShowImportsPanel) {
            String statusText;
            if (toImport.isEmpty() && useFQNsFor.isEmpty() && !someImportsWereRemoved) {
                Toolkit.getDefaultToolkit().beep();
                statusText = NbBundle.getMessage(JavaFixAllImports.class, "MSG_NothingToFix");
            } else {
                statusText = toImport.isEmpty() && someImportsWereRemoved ? NbBundle.getMessage(JavaFixAllImports.class, "MSG_UnusedImportsRemoved") : NbBundle.getMessage(JavaFixAllImports.class, "MSG_ImportsFixed");
            }
            StatusDisplayer.getDefault().setStatusText(statusText);
        }
    }

    private static ImportData computeImports(CompilationInfo info) {
        ComputeImports imps = new ComputeImports(info);
        ComputeImports.Pair<Map<String, List<Element>>, Map<String, List<Element>>> candidates = imps.computeCandidates();
        Map filteredCandidates = (Map)candidates.a;
        Map notFilteredCandidates = (Map)candidates.b;
        int size = notFilteredCandidates.size();
        ImportData data = new ImportData(size);
        ReferencesCount referencesCount = ReferencesCount.get(info.getClasspathInfo());
        int index = 0;
        boolean shouldShowImportsPanel = false;
        Iterator iterator = notFilteredCandidates.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            data.simpleNames[index] = key = (String)iterator.next();
            List unfilteredVars = (List)notFilteredCandidates.get(key);
            List filteredVars = (List)filteredCandidates.get(key);
            shouldShowImportsPanel |= unfilteredVars.size() > 1;
            if (!unfilteredVars.isEmpty()) {
                int level;
                Icon icon;
                Object displayName;
                boolean staticImports = true;
                for (Element e : unfilteredVars) {
                    if (!e.getKind().isClass() && !e.getKind().isInterface()) continue;
                    staticImports = false;
                }
                shouldShowImportsPanel |= staticImports;
                data.variants[index] = new CandidateDescription[staticImports ? unfilteredVars.size() + 1 : unfilteredVars.size()];
                int i = -1;
                int minImportanceLevel = Integer.MAX_VALUE;
                for (Element e : filteredVars) {
                    displayName = imps.displayNameForImport(e);
                    icon = ElementIcons.getElementIcon(e.getKind(), e.getModifiers());
                    data.variants[index][++i] = new CandidateDescription((String)displayName, icon, ElementHandle.create(e));
                    level = Utilities.getImportanceLevel(info, referencesCount, e);
                    if (level >= minImportanceLevel) continue;
                    data.defaults[index] = data.variants[index][i];
                    minImportanceLevel = level;
                }
                if (data.defaults[index] != null) {
                    minImportanceLevel = Integer.MIN_VALUE;
                }
                for (Element e : unfilteredVars) {
                    if (filteredVars.contains(e)) continue;
                    displayName = NOT_VALID_IMPORT_HTML + imps.displayNameForImport(e);
                    icon = ElementIcons.getElementIcon(e.getKind(), e.getModifiers());
                    data.variants[index][++i] = new CandidateDescription((String)displayName, icon, ElementHandle.create(e));
                    level = Utilities.getImportanceLevel(info, referencesCount, e);
                    if (level >= minImportanceLevel) continue;
                    data.defaults[index] = data.variants[index][i];
                    minImportanceLevel = level;
                }
                if (staticImports) {
                    data.variants[index][++i] = new CandidateDescription(NbBundle.getMessage(JavaFixAllImports.class, "FixDupImportStmts_DoNotImport"), ImageUtilities.loadImageIcon("org/netbeans/modules/java/editor/resources/error-glyph.gif", false), null);
                }
            } else {
                data.variants[index] = new CandidateDescription[1];
                data.variants[index][0] = new CandidateDescription(NbBundle.getMessage(JavaFixAllImports.class, "FixDupImportStmts_CannotResolve"), ImageUtilities.loadImageIcon("org/netbeans/modules/java/editor/resources/error-glyph.gif", false), null);
                data.defaults[index] = data.variants[index][0];
            }
            ++index;
        }
        data.shouldShowImportsPanel = shouldShowImportsPanel;
        return data;
    }

    private static void showFixImportsDialog(final JavaSource js, final JTextComponent target, final ImportData data) {
        final Preferences prefs = NbPreferences.forModule(JavaFixAllImports.class).node(PREFS_KEY);
        final FixDuplicateImportStmts panel = new FixDuplicateImportStmts();
        panel.initPanel(data, prefs.getBoolean(KEY_REMOVE_UNUSED_IMPORTS, true));
        final JButton ok = new JButton("OK");
        final JButton cancel = new JButton("Cancel");
        final AtomicBoolean stop = new AtomicBoolean();
        DialogDescriptor dd = new DialogDescriptor(panel, NbBundle.getMessage(JavaFixAllImports.class, "FixDupImportStmts_Title"), true, new Object[]{ok, cancel}, ok, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, true);
        final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok.setEnabled(false);
                final CandidateDescription[] selections = panel.getSelections();
                final boolean removeUnusedImports = panel.getRemoveUnusedImports();
                WORKER.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult mr = js.runModificationTask(new Task<WorkingCopy>(){

                                @Override
                                public void run(WorkingCopy wc) throws Exception {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            cancel.setEnabled(false);
                                            ((JDialog)d).setDefaultCloseOperation(0);
                                        }
                                    });
                                    wc.toPhase(JavaSource.Phase.RESOLVED);
                                    if (stop.get()) {
                                        return;
                                    }
                                    JavaFixAllImports.performFixImports(wc, data, selections, removeUnusedImports);
                                }
                            });
                            GeneratorUtils.guardedCommit(target, mr);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace(ex);
                        }
                        prefs.putBoolean(JavaFixAllImports.KEY_REMOVE_UNUSED_IMPORTS, removeUnusedImports);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                d.setVisible(false);
                            }
                        });
                    }
                });
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stop.set(true);
                d.setVisible(false);
            }
        });
        d.setVisible(true);
        d.dispose();
    }

    private static class ImportVisitor
    extends ErrorAwareTreePathScanner {
        private CompilationInfo info;
        private String currentPackage;
        private List<TreePathHandle> imports;

        private ImportVisitor(CompilationInfo info) {
            this.info = info;
            ExpressionTree pkg = info.getCompilationUnit().getPackageName();
            this.currentPackage = pkg != null ? pkg.toString() : "";
            this.imports = new ArrayList<TreePathHandle>();
        }

        @Override
        public Object visitImport(ImportTree node, Object d) {
            ExpressionTree exp;
            if (node.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT && (exp = ((MemberSelectTree)node.getQualifiedIdentifier()).getExpression()).toString().equals(this.currentPackage)) {
                this.imports.add(TreePathHandle.create(this.getCurrentPath(), this.info));
            }
            super.visitImport(node, null);
            return null;
        }

        List<TreePathHandle> getImports() {
            return this.imports;
        }
    }

    static final class CandidateDescription {
        public final String displayName;
        public final Icon icon;
        public final ElementHandle<Element> toImport;

        public CandidateDescription(String displayName, Icon icon, ElementHandle<Element> toImport) {
            this.displayName = displayName;
            this.icon = icon;
            this.toImport = toImport;
        }
    }

    private static class TreeVisitorImpl
    extends CancellableTreePathScanner<Void, Void> {
        private WorkingCopy wc;
        private Map<Name, Element> name2Element;

        public TreeVisitorImpl(WorkingCopy wc, Map<Name, Element> name2Element) {
            this.wc = wc;
            this.name2Element = name2Element;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            TypeMirror type;
            Void ret = (Void)super.visitIdentifier(node, p);
            final Element el = this.wc.getTrees().getElement(this.getCurrentPath());
            if (el != null && (el.getKind().isClass() || el.getKind().isInterface() || el.getKind() == ElementKind.PACKAGE) && (type = el.asType()) != null) {
                if (type.getKind() == TypeKind.ERROR) {
                    Element e;
                    boolean allowImport = true;
                    if (this.getCurrentPath().getParentPath() != null) {
                        if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                            AssignmentTree at = (AssignmentTree)this.getCurrentPath().getParentPath().getLeaf();
                            allowImport = at.getVariable() != node;
                        } else if (this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                            for (Scope s = this.wc.getTrees().getScope(this.getCurrentPath()); s != null; s = s.getEnclosingScope()) {
                                allowImport &= !this.wc.getElementUtilities().getLocalMembersAndVars(s, new ElementUtilities.ElementAcceptor(){

                                    @Override
                                    public boolean accept(Element e, TypeMirror type) {
                                        return e.getSimpleName().contentEquals(el.getSimpleName());
                                    }
                                }).iterator().hasNext();
                            }
                        }
                    }
                    if (allowImport && (e = this.name2Element.get(node.getName())) != null) {
                        this.wc.rewrite(node, this.wc.getTreeMaker().QualIdent(e));
                    }
                } else if (type.getKind() == TypeKind.PACKAGE) {
                    Element e;
                    String s = ((PackageElement)el).getQualifiedName().toString();
                    if (this.wc.getElements().getPackageElement(s) == null && (e = this.name2Element.get(node.getName())) != null) {
                        this.wc.rewrite(node, this.wc.getTreeMaker().QualIdent(e));
                    }
                }
            }
            return ret;
        }
    }

    static final class ImportData {
        public final String[] simpleNames;
        public final CandidateDescription[][] variants;
        public final CandidateDescription[] defaults;
        public boolean shouldShowImportsPanel;

        public ImportData(int size) {
            this.simpleNames = new String[size];
            this.variants = new CandidateDescription[size][];
            this.defaults = new CandidateDescription[size];
        }
    }
}

